<style>
<!--
table.content {
	width: 80%;
}

table.content td {
	color : #333333;
	font-size: 11px;
	width: 50%;
}
-->
</style>
<h1 class="sectionname">phpBB :: Diagnostics</h1>
<br />
<span class="smallgrey">In order for phpBB to function correctly it needs to be able to access or write to certain directories. If you see "Unwriteable" you need to change the
permissions on the directory to allow phpBB to write to it.</span>

<table class="content">
<?php
writableCell( 'administrator/components/com_forum' );
writableCell( 'components/com_forum' );
if(file_exists( $mosConfig_absolute_path . '/components/com_forum/files')){
  writableCell( 'components/com_forum/files' );
}
if(file_exists( $mosConfig_absolute_path . '/components/com_forum/images/avatars')){
  writableCell( 'components/com_forum/images/avatars' );
}
?>
</table>
<br /><br />
<span class="smallgrey">Other settings that are relevant.</span>

<table class="content">
<tr>
	<td>
	zlib compression support
	</td>
	<td align="left">
	<?php echo extension_loaded('zlib') ? '<b><font color="green">Available</font></b>' : '<b><font color="red">Unavailable</font></b>';?>
	</td>
</tr>
<tr>
	<td class="item">
	Safe Mode:
	</td>
	<td>
	<?php
	if ( get_php_setting('safe_mode') == 'OFF' ) {
		?>
		<font color="green"><b>
		<?php
	} else {
		?>
		<font color="red"><b>
		<?php
	}
	echo get_php_setting('safe_mode');	?>
	</b></font>
	<td>
</tr>
<tr>
	<td class="item">
	Set_time_limit:
	</td>
	<td>
	<?php
	if ( function_exists("set_time_limit") ) {
		?>
		<font color="green"><b>Available</b></font>
		<?php
	} else {
		?>
		<font color="red"><b>Unavailable</b></font>
		<?php
	}
	?>
	<td>
</tr>
<tr>
	<td class="item">
	ini_set:
	</td>
	<td>
	<?php
	if ( function_exists("ini_set") ) {
		?>
		<font color="green"><b>Available</b></font>
		<?php
	} else {
		?>
		<font color="red"><b>Unavailable</b></font>
		<?php
	}
	?>
	<td>
</tr>
<tr>
	<td class="item">
	Mambo version:
	</td>
	<td>
	<?php
	if ( in_array(getMamboVersion(), array("4.5.1", "4.5.2", "4.5.2.1", "4.5.2.2", "4.5.2.3")) ) {
		?>
		<font color="green"><b><?php echo getMamboVersion(); ?></b></font>
		<?php
	} else {
		?>
		<font color="red"><b><?php echo getMamboVersion(); ?></b></font>
		<?php
	}
	?>
	<td>
</tr>
<tr>
	<td class="item">
	phpBB component version:
	</td>
	<td>
	<?php
	include($mosConfig_absolute_path . '/components/com_forum/extension.inc');
  echo $version;
	?>
	<td>
</tr>
<tr>
	<td class="item">
	phpBB 2.0.x tables exist:
	</td>
	<td>
	<?php
	if ( table_exists("phpbb_users") ) { //phpbb_users can only be in phpBB default, component doesn't have these tables
		?>
		<font color="green"><b>Yes</b></font>, upgrade from phpBB default possible
		<?php
	} else {
		?>
		<font color="red"><b>No</b></font>, upgrade from phpBB default not possible
		<?php
	}
	?>
	<td>
</tr>
</table>

<?php

function get_php_setting($val) {
	$r =  (ini_get($val) == '1' ? 1 : 0);
	return $r ? 'ON' : 'OFF';
}
function writableCell( $folder ) {
  global $mosConfig_absolute_path;
	echo '<tr>';
	echo '<td class="item">' . $folder . '/</td>';
	echo '<td align="left">';
	echo is_writable( $mosConfig_absolute_path . "/$folder" ) ? '<b><font color="green">Writeable</font></b>' : '<b><font color="red">Unwriteable</font></b>' . '</td>';
	echo '</tr>';
}
function getMamboVersion(){
  global $version;
  
  $v = substr($version, 6);
  $endpos = strpos($v, " Stable");
  $v = substr($v, 0, $endpos);
  $v = ltrim(rtrim($v));
  
  return $v;
}

function table_exists($tablename){
  global $database;
  
  $query = "SELECT * FROM " . $tablename . " LIMIT 0,1";
  mysql_query($query);
  if(mysql_errno() == 0){
    return true;
  }
  else{
    return false;
  }
}
?>