<?php
/*---------------------------------------------------------------------------*\
  Titre            : Approbation
  Date de creation : 27.06.2006

  Fichier          :
    /administrator/components/com_approbation/admin.approbation.php

  But              : Entree de l'administration du composant.
  Auteur           : Olivier WENGER
  Version          : 1.0
\*---------------------------------------------------------------------------*/

// Pas d'acces direct
defined( '_VALID_MOS' ) or die( 'Restricted access' );

// Instanciation des librairies
require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$approbation = new approbation( $database, $mainframe );

/*---------------------------------------------------------------------------*\
  Selection de la routine de traitement de l'action demandee
\*---------------------------------------------------------------------------*/

switch ( $task )
  {
    // Suppression d'utilisateurs
    case 'remove':  
      deleteUsers( $approbation );
      break;
    // Approbation d'utilisateurs
    case 'approve':
      approveUsers( $approbation );
      break;
  }

// Affichage de la liste des utilisateurs
listUsers( $approbation, $option );

/*---------------------------------------------------------------------------*\
  Gestion des utilisateurs
\*---------------------------------------------------------------------------*/

//-----------------------------------------------------
// Affichage de la liste des utilisateurs
function listUsers( &$approbation, $option )
  {
    global $database;

    $usersApprobation = new usersApprobation( $database );
    // Limite de la liste
    $approbation->getListLimit( $limit, $offset );
    // Generation des elements de navigation
    $pageNav = new mosPageNav( $usersApprobation->countUsers(), $offset, $limit );
    // Chargement de la liste des categories
    if ( !$usersApprobation->getUsersList( $rows, $pageNav->limit, $pageNav->limitstart ) )
      {
        HTML_approbation::putMessage( $usersApprobation->getError() );
        return false;
      }
    // Affichage
    HTML_approbation::listUsers( $approbation, $rows, $pageNav );

    return true;
  }

//-----------------------------------------------------
// Suppression d'un ou plusieurs utilisateur(s)
function deleteUsers( &$approbation )
  {
    global $database, $mainframe;

    // Verification de la selection
    $cid = $approbation->getListIdSelected();
    if ( count( $cid ) < 1 )
      {
        HTML_approbation::putMessage( $approbation->getText( 'NO_SELECTION' ) );
        return false;
      }
 
    $usersApprobation = new usersApprobation( $database );
    // Recuperation de la liste des utilisateurs concernes
    if ( !$usersApprobation->getUsersList( $users, 0, 0, $cid ) )
      {
        HTML_approbation::putMessage( $usersApprobation->getError() );
        return false;
      }
    // Suppression des utilisateurs
    if ( !$usersApprobation->deleteUsers( $cid ) )
      {
        HTML_approbation::putMessage( $usersApprobation->getError() );
        return false;
      }
    // Information des utilisateurs concernes
    if ( !$approbation->getSender( $sender ) )
      {
        HTML_approbation::putMessage( $approbation->getError() );
        return false;
      }
    $subject = sprintf( $approbation->getText( 'USEND_DECISION_SUB' ),
                        $mainframe->getCfg( 'sitename' ) );
    $message = sprintf( $approbation->getText( 'USEND_DELETED' ),
                        $mainframe->getCfg( 'sitename' ) );
    $subject = html_entity_decode( $subject, ENT_QUOTES );
    $message = html_entity_decode( $message, ENT_QUOTES );
    foreach ( $users as $user )
      mosMail( $sender->email, $sender->name, $user->email, $subject, $message );

    return true;
  }

//-----------------------------------------------------
// Approbation d'un ou plusieurs utilisateurs
function approveUsers( &$approbation )
  {
    global $database, $mainframe;

    // Verification de la selection
    $cid = $approbation->getListIdSelected();
    if ( count( $cid ) < 1 )
      {
        HTML_approbation::putMessage( $approbation->getText( 'NO_SELECTION' ) );
        return false;
      }
    $usersApprobation = new usersApprobation( $database );
    // Recuperation de la liste des utilisateurs concernes
    if ( !$usersApprobation->getUsersList( $users, 0, 0, $cid ) )
      {
        HTML_approbation::putMessage( $usersApprobation->getError() );
        return false;
      }
    // Approbation des utilisateurs
    if ( !$usersApprobation->approveUsers( $cid ) )
      {
        HTML_approbation::putMessage( $usersApprobation->getError() );
        return false;
      }
    // Information des utilisateurs concernes
    if ( !$approbation->getSender( $sender ) )
      {
        HTML_approbation::putMessage( $approbation->getError() );
        return false;
      }
    $subject = sprintf( $approbation->getText( 'USEND_DECISION_SUB' ),
                        $mainframe->getCfg( 'sitename' ) );
    $message = sprintf( $approbation->getText( 'USEND_APPROVED' ),
                        $mainframe->getCfg( 'sitename' ),
                        $mainframe->getCfg( 'live_site' ) );
    $subject = html_entity_decode( $subject, ENT_QUOTES );
    $message = html_entity_decode( $message, ENT_QUOTES );
    foreach ( $users as $user )
      mosMail( $sender->email, $sender->name, $user->email, $subject, $message );

    return true;
  }

//-----------------------------------------------------------------------------
?>
