<?php
/*---------------------------------------------------------------------------*\
  Titre            : Approbation
  Date de creation : 27.06.2006

  Fichier          :
    /administrator/components/com_approbation/admin.approbation.html.php

  But              : Routines d'affichage des taches du composant.
  Auteur           : Olivier WENGER
  Version          : 1.0
\*---------------------------------------------------------------------------*/

// Pas d'acces direct
defined( '_VALID_MOS' ) or die( 'Restricted access' );

class HTML_approbation
  {
    /*-----------------------------------------------------------------------*\
      Affichage d'un message
    \*-----------------------------------------------------------------------*/
    function putMessage( $message )
      {
?>
		<div class="message">
		<?php echo $message; ?>
		</div>
<?php
      }

    /*-----------------------------------------------------------------------*\
      Affichage de la liste des utilisateurs
    \*-----------------------------------------------------------------------*/
    function listUsers( &$approbation, &$users, &$pageNav )
      {
?>
		<form action="index2.php?option=com_approbation" method="post" name="adminForm">
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="hidemainmenu" value="0" />
		<table class="adminheading">
		<tr>
			<th class="user">
			<?php echo $approbation->getText( 'APPROBATION_MANAGER' ); ?>
			</th>
		</tr>
		</table>

		<table class="adminlist">
		<tr>
			<th width="5">
			<?php echo $approbation->getText( 'POS' ); ?>
			</th>
			<th width="5">
			<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $users ); ?>);" />
			</th>
			<th class="title">
			<?php echo $approbation->getText( 'NAME' ); ?>
			</th>
			<th>
			<?php echo $approbation->getText( 'EMAIL' ); ?>
			</th>
			<th width="5%">
			<?php echo $approbation->getText( 'VALIDATED' ); ?>
			</th>
			<th width="2%">
			<?php echo $approbation->getText( 'ID' ); ?>
			</th>
		</tr>
<?php
        $classSuffixe = 0;
        for ( $i=0, $n=count( $users ); $i < $n; $i++ )
          {
            $row = &$users[$i];
?>
		<tr class="<?php echo 'row' . $classSuffixe; ?>">
			<td>
			<?php echo $pageNav->rowNumber( $i ); ?>
			</td>
			<td align="center">
			<?php echo mosCommonHTML::CheckedOutProcessing( $row, $i ); ?>
			</td>
			<td>
				<a href="index2.php?option=com_users&amp;task=editA&amp;hidemainmenu=1&amp;id=<?php echo $row->id; ?>" title="<?php echo $approbation->getText( 'EDIT_USER' ); ?>">
				<?php echo htmlspecialchars( $row->name, ENT_QUOTES ); ?>
				</a>
			</td>
			<td>
				<a href="mailto:<?php echo htmlspecialchars( $row->email, ENT_QUOTES ); ?>" title="<?php echo $approbation->getText( 'USER_EMAIL' ); ?>">
				<?php echo htmlspecialchars( $row->email, ENT_QUOTES ); ?>
				</a>
			</td>
			<td align="center">
<?php
            if ( $row->activation )
              {
                $img	= 'publish_x.png';
                $alt	= $approbation->getText( 'NO' );
              }
            else
              {
                $img	= 'tick.png';
                $alt	= $approbation->getText( 'YES' );
              }
?>
		  	<img src="images/<?php echo $img; ?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />
			</td>
			<td align="center">
			<?php echo $row->id; ?>
			</td>
		</tr>
<?php
            // Inversion du suffixe de classe 
            $classSuffixe = 1 - $classSuffixe;
          }
?>
		</table>
		<?php echo $pageNav->getListFooter(); ?>
		</form>
<?php
      }
  }

//-----------------------------------------------------------------------------
?>
