<?php
/*---------------------------------------------------------------------------*\
  Titre            : Approbation
  Date de creation : 01.07.2006

  Fichier          :
    /components/com_approbation/approbation.php
 
  But              : Redefinition des fonctions du composant com_registration.
  Auteur           : Olivier WENGER
  Version          : 1.0.1
\*---------------------------------------------------------------------------*/

// Pas d'acces direct
defined( '_VALID_MOS' ) or die( 'Restricted access' );

// Connexion du cote frontend autorise ?
global $mosConfig_frontend_login;
if ( $mosConfig_frontend_login != NULL && ($mosConfig_frontend_login === 0 || $mosConfig_frontend_login === '0')) {
	echo _NOT_AUTH;
	return;
}

// Instanciation des librairies
require_once( $mainframe->getPath( 'front_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$approbation = new approbation( $database, $mainframe );

/*---------------------------------------------------------------------------*\
  Selection de la routine de traitement de l'action demandee
\*---------------------------------------------------------------------------*/
switch( $task ) {
	case 'saveRegistration':
		saveRegistration( $approbation );
		break;

	case 'activate':
		activate( $approbation, $option );
		break;

	// Retour sur le composant com_registration
	default:
		$_Itemid = $Itemid ? '&Itemid=' . $Itemid : '';
		mosRedirect( 'index.php?option=com_registration&task=' . $task . $_Itemid );
}

/*---------------------------------------------------------------------------*\
  Enregistrement d'un utilisateur
\*---------------------------------------------------------------------------*/
function saveRegistration( &$approbation ) {
	global $database, $acl;
	global $mosConfig_sitename, $mosConfig_live_site, $mosConfig_useractivation, $mosConfig_allowUserRegistration;
	global $mosConfig_mailfrom, $mosConfig_fromname, $mosConfig_mailfrom, $mosConfig_fromname;

	if ( $mosConfig_allowUserRegistration == 0 ) {
		mosNotAuth();
		return;
	}

	// simple spoof check security
	josSpoofCheck();	
	
	$row = new mosUser( $database );

	if (!$row->bind( $_POST, 'usertype' )) {
		mosErrorAlert( $row->getError() );
	}

	mosMakeHtmlSafe($row);

	$row->id	= 0;
	$row->usertype	= '';
	$row->gid	= $acl->get_group_id( 'Registered', 'ARO' );
	$row->block	= '1';

	if ( $mosConfig_useractivation == 1 )
		$row->activation = md5( mosMakePassword() );

	if (!$row->check()) {
		echo "<script> alert('".html_entity_decode($row->getError())."'); window.history.go(-1); </script>\n";
		exit();
	}

	$pwd 			= $row->password;
	$row->password 		= md5( $row->password );
	$row->registerDate 	= date( 'Y-m-d H:i:s' );

	if (!$row->store()) {
		echo "<script> alert('".html_entity_decode($row->getError())."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();

	$name 		= $row->name;
	$email 		= $row->email;
	$username 	= $row->username;

	$subject 	= sprintf ( $approbation->getText( 'SEND_SUB' ), $name, $mosConfig_sitename);

	
	if ($mosConfig_useractivation == 1){
		$message = sprintf ( $approbation->getText( 'USEND_MSG_ACTIVATE'), $name, $mosConfig_sitename, $mosConfig_live_site.'/index.php?option=com_registration&task=activate&activation='.$row->activation, $mosConfig_live_site, $username, $pwd);
	} else {
		$message = sprintf ( $approbation->getText( 'USEND_MSG' ), $name, $mosConfig_sitename, $mosConfig_live_site, $username, $pwd);
	}

	$subject = html_entity_decode($subject, ENT_QUOTES);
	$message = html_entity_decode($message, ENT_QUOTES);
	
	// check if Global Config `mailfrom` and `fromname` values exist
	if ($mosConfig_mailfrom != '' && $mosConfig_fromname != '') {
		$adminName2 	= $mosConfig_fromname;
		$adminEmail2 	= $mosConfig_mailfrom;
	} else {
	// use email address and name of first superadmin for use in email sent to user
		$query = "SELECT name, email"
		. "\n FROM #__users"
		. "\n WHERE LOWER( usertype ) = 'superadministrator'"
		. "\n OR LOWER( usertype ) = 'super administrator'"
		;
		$database->setQuery( $query );
		$rows	= $database->loadObjectList();
		$row2	= $rows[0];
		
		$adminName2 	= $row2->name;
		$adminEmail2 	= $row2->email;
	}

	// Send email to user
	mosMail($adminEmail2, $adminName2, $email, $subject, $message);

	// Send notification to all administrators
	$subject2 = sprintf ( $approbation->getText( 'SEND_SUB' ), $name, $mosConfig_sitename);
	$message2 = sprintf ( $approbation->getText( 'ASEND_MSG' ), $mosConfig_sitename, $row->name, $email, $username);
	$subject2 = html_entity_decode($subject2, ENT_QUOTES);
	$message2 = html_entity_decode($message2, ENT_QUOTES);

	// get email addresses of all admins and superadmins set to recieve system emails
	$query = "SELECT email, sendEmail"
	. "\n FROM #__users"
	. "\n WHERE ( gid = 24 OR gid = 25 )"
	. "\n AND sendEmail = 1"
	. "\n AND block = 0"
	;
	$database->setQuery( $query );
	$admins = $database->loadObjectList();
	
	foreach ( $admins as $admin ) {
		// send email to admin & super admin set to recieve system emails
		mosMail($adminEmail2, $adminName2, $admin->email, $subject2, $message2);
	}
		
	if ( $mosConfig_useractivation == 1 ) {
		HTML_Approbation::message( $approbation->getText( 'REG_COMPLETE_TITLE' ),
			array( $approbation->getText( 'REG_COMPLETE' ),
			       $approbation->getText( 'REG_COMPLETE_ACTIVATE' ) ) );
	} else {
		HTML_Approbation::message( $approbation->getText( 'REG_COMPLETE_TITLE' ),
		       	array( $approbation->getText( 'REG_COMPLETE' ) ) );
	}
}

/*---------------------------------------------------------------------------*\
  Activation d'un utilisateur
\*---------------------------------------------------------------------------*/
function activate( &$approbation, $option ) {
	global $database, $my;
	global $mosConfig_useractivation, $mosConfig_allowUserRegistration;

	if($my->id) {
		// They're already logged in, so redirect them to the home page
		mosRedirect( 'index.php' );
	}
		

	if ($mosConfig_allowUserRegistration == '0' || $mosConfig_useractivation == '0') {
		mosNotAuth();
		return;
	}

	$activation = mosGetParam( $_REQUEST, 'activation', '' );
	$activation = $database->getEscaped( $activation );

	if (empty( $activation )) {
		HTML_Approbation::message( $approbation->getText( 'REG_ACTIVATE_NOT_FOUND_TITLE' ),
			array( $approbation->getText( 'REG_ACTIVATE_NOT_FOUND' ) ) );
		return;
	}

	$query = "SELECT id"
	. "\n FROM #__users"
	. "\n WHERE activation = '$activation'"
	. "\n AND block = 1"
	;
	$database->setQuery( $query );
	$result = $database->loadResult();

	if ($result) {
		$query = "UPDATE #__users"
		. "\n SET activation = ''"
		. "\n WHERE activation = '$activation'"
		. "\n AND block = 1"
		;
		$database->setQuery( $query );
		if (!$database->query()) {
			echo 'SQL error' . $database->stderr(true);
		}
		HTML_Approbation::message( $approbation->getText( 'REG_ACTIVATE_COMPLETE_TITLE' ),
			array( $approbation->getText( 'REG_ACTIVATE_COMPLETE' ) ) );
	} else {
		HTML_Approbation::message( $approbation->getText( 'REG_ACTIVATE_NOT_FOUND_TITLE' ),
			array( $approbation->getText( 'REG_ACTIVATE_NOT_FOUND' ) ) );
	}
}

//-----------------------------------------------------------------------------
?>
