<?php
/*---------------------------------------------------------------------------*\
  Titre            : Approbation
  Date de creation : 27.06.2006

  Fichier          :
    /components/com_approbation/approbation.class.php
 
  But              : Declaration des classes necessaires au composant.
  Auteur           : Olivier WENGER
  Version          : 1.0.1
\*---------------------------------------------------------------------------*/

// Pas d'acces direct
defined( '_VALID_MOS' ) or die( 'Restricted access' );

/*---------------------------------------------------------------------------*\
  Attributs et methodes generales
\*---------------------------------------------------------------------------*/
class approbation
  {
    var $_db    = null;
    var $_error = null;
    var $_text  = array();
    var $_debug = 0;

    //-----------------------------------------------------
    // Initialisation de l'objet
    function approbation( &$database, &$mainframe, $debug=0 )
    {
        $this->_db    = $database;
        $this->_debug = intval( $debug );
        $languageFile = $mainframe->getPath( 'front' );
        $languageFile = substr( $languageFile, 0, strrpos( $languageFile, '/' ) )
        . '/language/' . $mainframe->getCfg( 'lang' ) . '.php'
        ;
        if ( file_exists( $languageFile  ) )
          {      
            include( $languageFile );
            $this->_text = $text;
          }
      }

    //-----------------------------------------------------
    // Recuperation des erreurs
    function getError()
      {
        return $this->_error;
      }

    //-----------------------------------------------------
    // Recuperation d'un texte
    function getText( $name )
      {
        $text = $this->_text[$name];
        // Absent ?
        if ( !$text )
          {
            $text = $name;
            if ( $this->_debug )
              $text = '??' . $text . '??';
          }
        // Present et en mode debug ?
        elseif ( $this->_debug )
          $text = '*' . $text . '*';
        // Fin
        return $text;
      }

    //-----------------------------------------------------
    // Recuperation de la liste des id selectionnes
    function getListIdSelected()
      {
        $lid = array();
        $cid = mosGetParam( $_REQUEST, 'cid', null );
        if ( is_array( $cid ) )
          {
            foreach ($cid as $id)
              $lid[] = intval( $id );
          }
        return $lid;
      }

    //-----------------------------------------------------
    // Recuperation de la limite d'une liste
    function getListLimit( &$limit, &$offset )
      {
        global $mainframe, $option;
        require_once( $mainframe->getCfg( 'absolute_path' ) . '/administrator/includes/pageNavigation.php' );
        $limit  = intval( $mainframe->getUserStateFromRequest( 'viewlistlimit', 'limit', $mainframe->getCfg( 'list_limit' ) ) );
        $offset = intval( $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 ) );
      }

    //-----------------------------------------------------
    // Recuperation du nom et de l'adresse courriel de l'expediteur
    function getSender( &$sender )
      {
        global $mainframe;
        // Utilisation des parametres de configuration du site ?
        if ( $mainframe->getCfg( 'mailfrom' ) && $mainframe->getCfg( 'fromname' ) )
          {
            $sender        = new stdClass();
            $sender->name  = $mainframe->getCfg( 'fromname' );
            $sender->email = $mainframe->getCfg( 'mailfrom' );
          }
        // Utilisation du premier super-administrateur !
        else
          {
            $query = 'SELECT name, email'
            . "\n FROM #__users"
            . "\n WHERE gid = 25"
            . "\n ORDER BY id"
            ;
            $this->_db->setQuery( $query, 0, 1 );
            if ( !$this->_db->loadObject( $sender ) );
              {
                $this->_error = $this->_db->getErrorMsg();
                return false;
              }
          }
        return true; 
      }    
  }

/*---------------------------------------------------------------------------*\
  Attributs et methodes de traitement des utilisateurs
\*---------------------------------------------------------------------------*/
class usersApprobation
  {
    var $_db    = null;
    var $_error = null;

    //-----------------------------------------------------
    // Initialisation de l'objet
    function usersApprobation( &$db )
      {
        $this->_db = $db;
      }

    //-----------------------------------------------------
    // Recuperation des erreurs
    function getError()
      {
        return $this->_error;
      }

    //-----------------------------------------------------
    // Retourne le nombre d'utilisateurs
    function countUsers()
      {
        $query = 'SELECT count(*) FROM #__users'
        . "\n WHERE block = 1 AND lastvisitDate = '" . $this->_db->_nullDate .'\''
        ;
        $this->_db->setQuery( $query );
        return $this->_db->loadResult();
      }

    //-----------------------------------------------------
    // Chargement de la liste des utilisateurs
    function getUsersList( &$rows, $limit=0, $offset=0, $id=null )
      {
        $query = 'SELECT id, name, email, activation FROM #__users'
        . "\n WHERE block = 1 AND lastvisitDate = '" . $this->_db->_nullDate .'\''
        ;
        // Liste partielle
        if ( is_array( $id ) )
          $query .= "\n AND id IN (" . implode( ',', $id ) . ')';
        // Execution de la requete
        $this->_db->setQuery( $query, $offset, $limit );
        $rows = $this->_db->loadObjectList();
        if ( $this->_db->getErrorNum() )
          {
            $this->_error = $this->_db->getErrorMsg();
            return false;
          }
        else
          return true;
      }

    //-----------------------------------------------------
    // Suppression d'un ou plusieurs utilisateurs
    function deleteUsers( &$id )
      {
        $query = 'DELETE FROM #__users'
        . "\n WHERE block = 1 AND lastvisitDate = '" . $this->_db->_nullDate .'\''
        . "\n AND id IN (" . implode( ',', $id ) . ')'
        ;
        $this->_db->setQuery( $query );
        if ( !$this->_db->query() )
          {
            $this->_error = $this->_db->getErrorMsg();
            return false;
          }
        else
          return true;
      }

    //-----------------------------------------------------
    // Approbation d'un ou plusieurs utilisateurs
    function approveUsers( &$id )
      {
        $query = 'UPDATE #__users SET block = 0, activation = \'\''
        . "\n WHERE block = 1 AND lastvisitDate = '" . $this->_db->_nullDate .'\''
        . "\n AND id IN (" . implode( ',', $id ) . ')'
        ;
        $this->_db->setQuery( $query );
        if ( !$this->_db->query() )
          {
            $this->_error = $this->_db->getErrorMsg();
            return false;
          }
        else
          return true;
      }
  }

//-----------------------------------------------------------------------------
?>
