<?php
/**
* FileName: mod_remositorynewest.php
* Date: 25 August 2005
* License: GNU General Public License
* Script Version #: 3.20b
* ReMOSitory Version #: 3.20 or above
* MOS Version #: 4.5 or above
* Script TimeStamp: "25/08/2005 22:01"
* Author: Martin Brampton - martin@remository.com (http://www.remository.com)
* Copyright: Martin Brampton 2005
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

global $mosConfig_sef, $mosConfig_absolute_path, $mosConfig_absolute_path, $my;

require_once ($mosConfig_absolute_path.'/components/com_remository/remository.utilities.php');

// Find out $Itemid
$base_url = 'index.php?option=com_remository';        	// Base URL string
if (!$mosConfig_sef) $base_url .= '&Itemid='.getItemID('com_remository');
$base_url .= '&func=fileinfo&id=';

/*********************Configuration*********************/
// Set to '1' to Show the Description, set to 0 to not show it
$showsmall = remositoryUtilities::remos_get_module_parm($params,'showsmall',0);
// Max number of entries to show
$max = remositoryUtilities::remos_get_module_parm($params,'max',5 );
// Max number of description characters
$maxchars = remositoryUtilities::remos_get_module_parm($params,'maxchars',100);
// Date format for display
$date_format = remositoryUtilities::remos_get_module_parm($params,'dateformat','M.d');
// Category from which to select files
$category = remositoryUtilities::remos_get_module_parm($params,'category', 0);

$max = max($max,1);
$maxchars = max($maxchars,20);
/*******************************************************/

include('components/com_remository/com_remository_settings.php');

function newestFiles ($category, $max) {
	global $database, $See_Files_no_download;
	$sql = 'SELECT f.id, filetitle, autoshort, description, smalldesc, filedate, icon from #__downloads_files AS f';
	if ($category) $sql .= ', #__downloads_structure AS s';
	$sql .= ' WHERE f.published=1';
	$sql .= remositoryUtilities::visibilitySQL();
	if ($category) $sql .= " AND f.containerid=s.item AND s.container=$category";
	$sql .= " ORDER BY f.filedate DESC LIMIT $max";
	$database->setQuery($sql);
	$files = $database->loadObjectList();
	if ($files) return $files;
	else return array();
}


$tabclass_arr=explode(",",$tabclass);

// Newest 5 Downloads
$newdownloads = newestFiles ($category, $max);
if ($category AND count($newdownloads)==0) $newdownloads = newestFiles (0, $max);

$content = remositoryUtilities::remos_module_CSS ();
$tabcnt = 0;

foreach ($newdownloads as $newdownload) {
	$sdesc = '';
	if ($showsmall) {
		if (($newdownload->description<>'') AND ($newdownload->autoshort)) $sdesc.='<br/>'.strip_tags($newdownload->description);
		elseif ($newdownload->smalldesc<>'') $sdesc.='<br/>'.strip_tags($newdownload->smalldesc);
		if (strlen($sdesc)>$maxchars) $sdesc=substr($sdesc,0,$maxchars-3).'...';
	}
	$curicon='';
	if ($newdownload->icon <> '') $curicon=$newdownload->icon;
	else $curicon='generic.png';
	$url = sefRelToAbs($base_url.$newdownload->id);
	$class = $tabclass_arr[$tabcnt];
	$content .= "<tr class='$class'><td width='20%' valign='middle' class='number'>".date($date_format, strtotime($newdownload->filedate));
	$content .= "<br/><img src='components/com_remository/images/calendar.gif' border='0' width='16' height='16' alt='Downloads' align='middle'/></td><td width='80%'><a href='$url'>";
	$content .= "<img src='$mosConfig_live_site/components/com_remository/images/file_icons/$curicon' align='middle' border='0' width='16' height='16' alt='File'/>";
	$content .= $newdownload->filetitle."</a>$sdesc</td></tr>\n";
	if ($tabcnt == 1){
	$tabcnt = 0;
	} else {
	$tabcnt++;
	}
}
$content .= "</table>\n";

?>
