<?php
// $Id: mod_newsflash_scroller.php,v 2.00 2004/09/13 20:56:34 DJesus Exp $
/**
* NewsFlash Scroller Module
* @for Mambo Open Source v4.5.1
* @Copyright (C) 2004 TEG Design - www.tegdesign.ch
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 2.00 $
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// Loading the Content Class code
require_once( $mainframe->getPath( 'front_html', 'com_content') );

$content = "";   // clear previous content

global $my, $mosConfig_shownoauth, $mosConfig_offset;

$access = !$mosConfig_shownoauth;

$now = date( "Y-m-d H:i:s", time()+$mosConfig_offset*60*60 );

// ID name Randomizer to avoid conflict in case of multiple modules (module duplication for multiple NewsFlash)
srand ((double) microtime() * 1000000);
$IDrdm = rand( 1, 999999 );
$IDname = "NFRow".$IDrdm;

// Get Mameters...
$catid    = intval( $params->get( 'catid' ) );         // Category to display
$style    = $params->get( 'style' );                   // Display mode (random,horiz,vert,flash)
$sorting   = $params->get( 'sorting' );                  // Display mode (0:sorted,1:random)
$image    = $params->get( 'image' );                   // 1:Yes / 0:No
$readmore = $params->get( 'readmore' );                // 1:Yes / 0:No
$items    = intval( $params->get( 'items' ) );         // No of items to display : 0:all
$delay    = intval( $params->get( 'delay' ) );         // Delay : 1000 = 1 seconds
$height   = intval( $params->get( 'height' ) );        // Height : 200px
$borders  = intval( $params->get( 'borders' ) );       // borders: 1
$padding  = intval( $params->get( 'padding' ) );       // padding: 2
$spacing  = intval( $params->get( 'spacing' ) );       // spacing: 0
$bgcolor  = $params->get( 'bgcolor' );                 // back ground color: #F0F0F0
$moduleclass_sfx = $params->get( 'moduleclass_sfx' );

// Content's Intro only and Hide some content features (author, dates, etc)
$params->set( 'intro_only', 1 );
$params->set( 'hide_author', 1 );
$params->set( 'hide_createdate', 0 );
$params->set( 'hide_modifydate', 1 );

if ( $items ) {
    $limit = "LIMIT ". $items;
} else {
    $limit = "";
}

if ( $sorting ) {
    $sorted = "ORDER BY rand()";
} else {
    $sorted = "";
}

$Query = "SELECT a.id"
."\n FROM #__content AS a"
."\n INNER JOIN #__categories AS b ON b.id = a.catid"
."\n WHERE a.state = 1"
."\n AND a.access <= ". $my->gid .""
."\n AND (a.publish_up = '0000-00-00 00:00:00' OR a.publish_up <= '". $now ."') "
."\n AND (a.publish_down = '0000-00-00 00:00:00' OR a.publish_down >= '". $now ."')"
."\n AND catid='". $catid ."' "
."\n ". $sorted
."\n ". $limit
;

$database->setQuery( $Query );

$rows = $database->loadResultArray();

$row = new mosContent( $database );

$numrows = count( $rows );



function NFDisplay ($ID ,$IDview, &$p1, &$p2, $p3, $p4, $p5 ) {
  global $IDname;
    echo "\n<DIV";
    echo " id=\"".$IDname.$ID."\"";
    echo " style=\"";
    echo ($IDview) ? 'display: visible; visibility: visible;' : 'display: none; visibility: hidden;';
    echo "\"";
    echo " onmouseover=\"NFstopScroller();\"";
    echo " onmouseout=\"NFstartScroller();\"";
    echo '>'."\n";

    HTML_content::show( $p1, $p2, $p3, $p4, $p5 );

    echo '</DIV>'."\n";
}

echo "\n<!-- ### Module NewsFlash Scroller v2.0 ### -->\n";

echo "\n<table class=\"moduletable" . $moduleclass_sfx . "\"";
if ($height)  { echo " height=\"".$height."\""; }
echo " border=\"".$borders."\"";
echo " cellpadding=\"".$padding."\"";
echo " cellspacing=\"".$spacing."\"";
if ($bgcolor) { echo " bgcolor=\"".$bgcolor."\""; }
echo ">\n";

echo "<tr valign=\"TOP\">\n";

switch ($style) {
  case 'horiz':
     foreach ($rows as $id) {
         $row->load( $id );
         $row->text = $row->introtext;
         echo '<td>';
         HTML_content::show( $row, $params, $access, 0, 'com_content' );
         echo "</td>\n";
     }
     break;

  case 'vert':
     foreach ($rows as $id) {
         echo "<td>\n";
         $row->load( $id );
         $row->text = $row->introtext;
         HTML_content::show( $row, $params, $access, 0, 'com_content' );
         echo "</td>";
         echo "</tr><tr valign=\"TOP\">\n";
     }
     break;

  case 'flash':
     $ii = 0;
     echo "<td>\n";
     foreach ($rows as $id) {
         $row->load( $id );
         $row->text = $row->introtext;

         NFDisplay($IDname.$ii, ($ii < 1), $row, $params, $access, 0, 'com_content' );

         $ii++;
     }
     echo "</td>";
     break;

  default:
     echo "<td>\n";
     if ($numrows > 0) {
        srand ((double) microtime() * 1000000);
        $flashnum = $rows[rand( 0, $numrows-1 )];
     } else {
        $flashnum = 0;
     }
    $row->load( $flashnum );
    $row->text = $row->introtext;

    HTML_content::show( $row, $params, $access, 0, 'com_content' );

    echo "</td>";
    break;
}

echo "</tr></table>\n";

if ($numrows > 1 && $style == 'flash') {   // more than 1 news to display and flash mode => activate scroller, otherwise just display current News...

$txt = "
<SCRIPT LANGUAGE='javascript'>

  // ----------------------------------------
  var NFtimerID = null;
  var NFscrollerRunning = false;
  var NFid = 0;
  var NFtotal = " .$numrows. ";
  var NFblock = 1;
  var NFdelay = " .$delay. ";
  var NFname = '".$IDname."';

  var ns4=(navigator.appName=='Netscape' && parseInt(navigator.appVersion)==4);
  var ns6=(document.getElementById)? true:false;
  var ie4=(document.all)? true:false;

  // ----------------------------------------
  function NFshowObject(obj){
    if (ns6) {
      obj.style.display='block';
      obj.style.visibility='visible';
    }
    else if (ie4) obj.visibility='visible';
    else if (ns4) obj.visibility='show';
  }

  // ----------------------------------------
  function NFhideObject(obj){
    if (ns6) {
      obj.style.display='none';
      obj.style.visibility='hidden';
    }
    else if (ie4)obj.visibility='hidden';
    else if (ns4)obj.visibility='hide';
  }

  // ----------------------------------------
  function NFnextblock(id,block,total) {
    if (total % block > 0) {
        totmax = (Math.floor(total/block)+1)*block;
    } else {
        totmax = total;
    }
    id = (id < totmax-block) ? id+block : totmax-(id+block);   // Circular chain : next to last = first
    return id;
  }

  // ----------------------------------------
  function NFprevblock(id,block,total) {
    if (total % block > 0) {
        totmax = (Math.floor(total / block) +1) * block;
    } else {
        totmax = total;
    }
    id = (id < block) ? totmax-block+id : id-block;   // Circular chain : previous to first = last
    return id;
  }

  // ----------------------------------------
  function NFshowBlock() {
      for (i=NFid; i < NFid + NFblock; i++) {
        p = NFprevblock(i,NFblock,NFtotal);
        if (p < NFtotal) {
           NFhideObject(document.getElementById(NFname + p));
        }  // Hide Object
        if (i < NFtotal) {
           NFshowObject(document.getElementById(NFname + i));
        }  // Show Object
      }
      n = NFnextblock(NFid,NFblock,NFtotal);
      NFid = n;                                            // Set next object
      NFstartScroller();
  }

  // ----------------------------------------
  function NFstopScroller(){
    if (NFscrollerRunning) {      // Stop the scroller
       clearTimeout(NFtimerID);
    }
    NFscrollerRunning = false;    // Scroller stopped
  }

  // ----------------------------------------
  function NFstartScroller() {
    if (!NFscrollerRunning) {
       if (document.getElementById) {   // DOM Compatible ?
         NFscrollerRunning = true;      // Scroller started
         NFtimerID = setTimeout('NFshowBlock()', NFdelay);   // Wait for a while before to display next object
       }
    } else {
         NFtimerID = setTimeout('NFshowBlock()', NFdelay);   // Wait for a while before to display next object
    }
  }

  // ----------------------------------------
  function NFloadScroller() {
    NFstopScroller();                // Make sure the scroller is stopped
    NFshowBlock();
  }

  // Start scroller
  // ----------------------------------------
  NFloadScroller();

</SCRIPT>\n\n";

echo $txt;

}

echo "\n<!-- ### END : Module NewsFlash Scroller v2.0 ### -->\n\n";

?>





