<?php
/*****************************************************************************
/  Module - Infinity (MyGosu) Menus 2005/04/25
/  Version  1-0-6
/  Copyright Guy Thomas [brudinie]   
/  brudinie@yahoo.co.uk
/  @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
/
/  Javascript Drop Down & Tree Menu Systems by Cezary Tomczak (Mygosu) (modded by Guy Thomas)
/  Mygosu: - http://gosu.pl/dhtml/mygosumenu.html
*****************************************************************************/


defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class mygosu_menus {
/*==========================================================================*/
/*                              START OF CLASS                              */
/*==========================================================================*/
	var $menuUNID;
	var $DDownPositioning;
	var $DDownHorizMinWidth;
	var $DDownOverlapLeft;
	var $cssRoot;
		
	function mygosu_menus( &$params){
		/**
		/* Function Desc- Code to be called on instantiation of class
		/* - Gives menu unique id so that multiple menus can be used
		/* - Sets up some basic variables
		*/
		$this->menuUNID="infinity_menu_".rand(1,100); // create unique id for menu (mod april 19th 2005)
	
		/**
		/* following properties only apply to drop down menu
		*/
		$this->DDownPositioning= $params->get('positioning'); 
		$this->DDownHorizMinWidth= $params->get('horiz_min_width');
		if ($this->DDownHorizMinWidth=="") {$this->DDownHorizMinWidth=0;}		
		$this->DDownOverlapLeft= $params->get('overlap_left');
		if ($this->DDownOverlapLeft=="") {$this->DDownOverlapLeft=0;}
		$this->DDownOverlapLeft=0-$this->DDownOverlapLeft; // turn in to negative number

		/**
		/* Load style sheets
		*/
		$cssFileFound=$this->LoadStyleSheet ($params);

		/**
		/* Set css root from parameter if successfull css load ELSE set default
		*/
		if ($cssFileFound){
			$this->cssRoot = $params->get('css_root_class');		
		} else {
			$this->cssRoot = "default";
		}

	}

	function module_begin( &$params ) { 
		/**
		/* Function Desc- Module start comments
		*/
		echo "\n <!--(c) Infinity Menus For Mambo - Guy Thomas 2005 ". $params->get( 'website' ) ." -->";
		echo "\n\n <!-- START OF MODULE '". $params->get( 'module_name' ) ."'   -->";
		echo "\n";
	}


	function mygosu_menu_items ( $database, $mygid, &$params, $parentID, $level, $cssRepeatNum) {
		/**
		/* Function Desc- loads mygosu menu items (calls recursively)
		*/

		if (!$parentID){$parentID=0;} // necessary for root sections
		if (!$level){$level=0;} // necessary for root sections	
		$query = "SELECT * FROM #__menu "
		. "\n WHERE menutype = '". $params->get( 'menu' ) ."' "
		. "\n AND access <= $mygid "
		. "\n AND published = '1' "
		. "\n AND parent = '$parentID'"
		. "\n ORDER BY '". $params->get( 'order' ) ."' ASC ";
		$menuType = $params->get('menu_type');		
		$cssNumMenus = $params->get('css_num_menus'); // max number of css repeat val
		if ($cssRepeatNum == 0 || $cssRepeatNum>$cssNumMenus){
			$cssRepeatNum=1;
		}
		if ($level==0) {$itemClass="parentItem";} else {$itemClass="subItem_$cssRepeatNum";} // class for menu item
		$database->setQuery( $query );
		$menus = $database->loadObjectList( ); 		
		$treeWidth = $params->get('tree_width');
		$treeHeight = $params->get('tree_height');
		$numRows=0;
		$levTabs=str_repeat("\t", $level);
		$imgPath = $GLOBALS['mosConfig_live_site'] .'/images/M_images/';	
		
		foreach ( $menus as $row ) {
			// MambelFish Support - Converts menu items if necessary
			$numRows++;
			if ($mosConfig_mbf_content) {
				$row 	= MambelFish::translate( $row, 'menu', $GLOBALS['$mosConfig_lang']);
			}
			$name 	= htmlentities ($row->name, ENT_QUOTES); // remove ilegal characters
			$link 	= $row->link ? $row->link : NULL;
			$currentID = $row->id;
			
			/**
			/* Does this menu item have sub menu items?
			*/			
			$subMenus=mygosu_menus::checkSubMenus ($currentID, $mygid, $params, $database);
			$treeItemClass = $subMenus ? "folder" : "doc";
			if ($row->type=="separator"){ $treeItemClass="separator"; } //makes seperator dissappear for tree menu
			
			/**
			* Adds Itemid if link is not a url
			*/
			if ( $row->type != 'url' ) {
				$link .= '&Itemid='. $row->id;
			}
			
			/**
			* Controls the page the link will be opened in
			*/
			if ( $row->browserNav ) {
					$target = "'_blank'";
			} else {
					$target = "'_self'";
			}			
				
			if ($numRows==1){
				//open menu
				if ($menuType=="tree"){
					// create tree
					if ($level==0){						
						$this->StartMenu_Tree($this->cssRoot, $treeWidth, $treeHeight);
					}
					
				} else {					
					if ($level==0){					
						// create drop down menu table
						$this->StartMenu_DropDown ($this->cssRoot);
												
						// Remmed out code below is for next version which will also enable some groovy CSS menus to function
						// $csshoverpath="".$params->get( 'LSPath' )."/css/csshover.htc"."";
						// echo("<style>body {behavior:url(".$csshoverpath.");}</style>");
						
					} else {
						// create div section
						$this->NewSection_DropDown ($levTabs);
					}
				}
			}
			
			if ($menuType=="tree"){
				//create tree menu item
				$this->NewItem_Tree($levTabs, $treeItemClass, $target, $link, $row);
			} else {
				//create drop down menu item
				$this->NewItem_DropDown($level, $params, $row, $subMenus, $imgPath, $name, $levTabs, $cssRepeatNum, $itemClass, $target, $link);
			}			
			
			$this->mygosu_menu_items ( $database, $mygid, &$params, $currentID, $level+2, $cssRepeatNum+1); // recurrsive call
			if ($menuType=="tree"){
				echo ("\n\t\t\t".$levTabs."</div>\n"); // close list after recurrsive call to get subsections				
			}
			else if ($level==0 && $this->DDownPositioning=="horizontal") {
				echo ("\t\t</td>\n");
			}
		}
		if ($numRows>0){
			if ($menuType=="tree"){
				if ($level==0){
					echo ("\n\t\t\t</div>");	
					echo ("\n\t\t</div>");			
					echo ("\n\t</div>");				
					echo ("\n</div>");
				}
				
			} else {
				if ($level==0){
					if ($this->DDownPositioning=="vertical"){
						echo ("\t\t</td>\n");
					}				
					echo ("\t</tr>\n");
					echo ("</table>\n");
				} else {
					print"\t".$levTabs."</div>\n";
				}
			}
		} // close list container
	}

	//---------------------------------------------------------------------	
	
	function getMenuImage(&$menu_param){
		//This function gets the menu image value from the parameters list
		$mStart=strpos($menu_param,"menu_image=");
		if ($mStart===false){return("");}
		$mLeft=substr($menu_param, $mStart);
		$mEnd=strpos($mLeft, chr(10)); 
		if (!$mEnd){$mEnd=strlen($menu_param);}
		$menuImage=substr($mLeft, 0, $mEnd);
		return (str_replace("menu_image=", "", $menuImage));
	}
	
	function resizeMenuImage (&$imgLoc, &$w, &$h){	
	
		$w=trim(str_replace("px", "", $w));
		$h=trim(str_replace("px", "", $h));	
		
		/**
		/* Test GD support (if no support then return image unsized) (New in v 1.0.6)
		*/
		if (!function_exists("imagecreatetruecolor")){
			return($imgLoc);
		}

		$size = getimagesize($imgLoc); // Get the image dimensions and mime type 
		$rposFile=strrpos($imgLoc, ".");
		$extension=substr($imgLoc,$rposFile); // use extension instead of mime type (cope with gif)
		$fileName=basename($imgLoc);
		$filePath=dirname($imgLoc);
		/*
		echo ("<script type='text/javascript'>alert('".$extension."');</script>");
		*/
				
		switch (strtolower($extension)){
			case ".gif" : 
				$resize = imagecreate($w, $h); // Create a blank image
				$tmpImg=imagecreatefromgif ($imgLoc);
				$colorTransparent = imagecolortransparent($tmpImg);
				imagepalettecopy($resize,$tmpImg);
				imagefill($resize,0,0,$colorTransparent);
				imagecolortransparent($resize, $colorTransparent);				
				imagecopyresampled($resize, $tmpImg, 0, 0, 0, 0, $w, $h, $size[0], $size[1]); // Resample the original GIF
				imagegif($resize, $filePath.'/thumb_'.$fileName); // Output the new GIF 
				break;

			case ".jpg" :		
				$resize = imagecreatetruecolor($w, $h); // Create a blank image
				$tmpImg=imagecreatefromjpeg ($imgLoc);
				imagecopyresampled($resize, $tmpImg, 0, 0, 0, 0, $w, $h, $size[0], $size[1]); // Resample the original JPEG 
				imagejpeg($resize, $filePath.'/thumb_'.$fileName, $quality); // Output the new JPEG 
				break;

			case ".jpeg" :
				$resize = imagecreatetruecolor($w, $h); // Create a blank image
				$tmpImg=imagecreatefromjpeg ($imgLoc);
				imagecopyresampled($resize, $tmpImg, 0, 0, 0, 0, $w, $h, $size[0], $size[1]); // Resample the original JPEG 
				imagejpeg($resize, $filePath.'/thumb_'.$fileName, $quality); // Output the new JPEG 
				break;

			case ".png" :
				$resize = imagecreatetruecolor($w, $h); // Create a blank image
				$tmpImg=imagecreatefrompng ($imgLoc);
				imagecopyresampled($resize, $tmpImg, 0, 0, 0, 0, $w, $h, $size[0], $size[1]); // Resample the original PNG
				imagepng($resize, $filePath.'/thumb_'.$fileName); // Output the new PNG
				break;
	
		}
		if ($tmpImg){
			imagedestroy($tmpImg);
			return ($GLOBALS["mosConfig_live_site"]."/images/stories/thumb_".$fileName);
		}
	}
	
	function checkSubMenus (&$currentID, &$mygid, &$params, &$database){
		// does current menu item have any sub menu items?
		$smQuery = "SELECT * FROM #__menu "
		. "\n WHERE menutype = '". $params->get( 'menu' ) ."' "
		. "\n AND access <= $mygid "
		. "\n AND published = '1' "
		. "\n AND parent = '$currentID'"
		. "\n ORDER BY '". $params->get( 'order' ) ."' ASC ";
		$database->setQuery( $smQuery );
		$subMenus = $database->loadObjectList();
		if ($subMenus) {return(true);}
	}
	
	function showImage(&$row, &$params, &$menuImgStr, &$spanStyle){
		/**
		/* Function Desc- If an image can be displayed it will set $menuImgStr to
		/* a string of html to be used
		*/
		$menuImage = mygosu_menus::getMenuImage($row->params);
		/*echo ("<script type='text/javascript'>alert ('name = ".$row->name." image = ".$menuImage."');</script>");*/
		$imgLoc=$GLOBALS["mosConfig_absolute_path"]."/images/stories/".$menuImage;
		if (!file_exists($imgLoc)){return("");} // if image doesn't exist then return ""
		if ($menuImage!="" && $menuImage!="-1"){
			$spanStyle=" style='margin:0px 0px 0px ".($params->get('img_resizew')+2)."px;'";					
			if ( $params->get( 'img_resize')){						
				$thumb=mygosu_menus:: resizeMenuImage ($imgLoc, $params->get('img_resizew'), $params->get('img_resizeh'));
				if ($thumb){
					$menuImgStr="<img class='lftImg' border='0' src='$thumb' />";								
				}
			}
			If ($menuImgStr==""){
				$menuImgStr="<span><img class='lftImg' border='0' src='".$GLOBALS["mosConfig_live_site"]."/images/stories/".$menuImage."' /></span>";					
			}										
		}
	}
	
	function module_end( &$params ) {
		/**
		/* Function Desc - Module - load script & end comments
		*/
		
		$this->mygosu_load_script($params);
	
		echo "\n";
		echo "<!-- END OF MODULE '". $params->get( 'module_name' ) ."'   --> \n\n\n";
	}
		
	function mygosu_load_script( &$params) {
		$menuType = $params->get('menu_type');
		$delShow = $params->get('delay_show');
		$delHide = $params->get('delay_hide');
		if ($menuType=="drop_down"){
						
			$menuScriptStr="var ".$this->menuUNID." = new DropDownMenuX('".$this->menuUNID."');".
			$this->menuUNID.".type = '".$this->DDownPositioning."';".
			$this->menuUNID.".delay.show = $delShow;".
			$this->menuUNID.".delay.hide = $delHide;";
			if ($this->DDownPositioning=="vertical"){$menuScriptStr=$menuScriptStr.$this->menuUNID.".position.level1.left = $this->DDownOverlapLeft;";}
			$menuScriptStr=$menuScriptStr.$this->menuUNID.".position.levelX.left = $this->DDownOverlapLeft;".
			$this->menuUNID.".fitWidth = $this->DDownHorizMinWidth;".
			$this->menuUNID.".init();";
									
			?>
			<script type = "text/javaScript" src="<?php echo $params->get( 'LSPath' ); ?>/js/dropdownmenux_crunched.js"></script> <!--Mod by Guy Thomas 2004/12/06-->
			<script type = "text/javaScript" src="<?php echo $params->get( 'LSPath' ); ?>/js/dropdownmenux_ie5_crunched.js"></script> <!--Mod by Guy Thomas 2004/12/06-->
			
			<!-- add menu initialise to onload event-->
			<script type="text/javascript">						
			// create init function
			function <?php echo($this->menuUNID)?>_init(){eval("<?php echo ($menuScriptStr);?>");}
			// add init function to onload event
			if (document.body.currentStyle){
				//ie code
				window.attachEvent('onload', <?php echo($this->menuUNID)?>_init);
			} else {
				//mozilla code
				document.addEventListener("load", <?php echo($this->menuUNID)?>_init(), false);
			}
			</script>			
			
			<?php
		} else {
			
			$menuScriptStr="var ".$this->menuUNID." = new DynamicTree('".$this->menuUNID."', '".$params->get( 'LSPath' )."');".$this->menuUNID.".init();";
			?>
			<script type="text/javascript" src="<?php echo $params->get( 'LSPath' ); ?>/js/dynamictree_crunched.js"></script>
			<script><?php echo($menuScriptStr);?></script>
			<?php			
		}		
		
	}
	
	function LoadStyleSheet (&$params){
		/**
		/* load stylesheet
		*/
		// Make sure css exists first - if not use default.
		
		$menuType=$params->get('menu_type');		
		if ($menuType=="tree"){$cssFolder="tree/";} else {$cssFolder="dropdown/";}				
		
		$cssFile=$cssFolder.$params->get('css_file'); // tree menu css file
		
		$templatePath=$GLOBALS[mosConfig_absolute_path]."/modules/infinity_menus/css/".$cssFile;
		echo ("<!--File to check for is ".$templatePath."-->");
		if (file_exists($templatePath)){		
			?>		
			<link rel="stylesheet" type="text/css" href="<?php echo $params->get( 'LSPath' )."/css/".$cssFile;?>" /> 
			<?php
			return (true); // loaded OK
		} else {
			?>
			<link rel="stylesheet" type="text/css" href="<?php echo $params->get( 'LSPath' )."/css/".$cssFolder."default.css";?>" />
			<?php
			return (false); // couldnt load so replaced with default
		}
	}
	
	function StartMenu_Tree (&$treeWidth, &$treeHeight) {
		/**
		/* Function Desc - Writes html to start the tree menu
		*/	
		echo ("\n<div class='$this->cssRoot'>");
		echo ("\n\t<div class='wrap1' style='width:$treeWidth; height:$treeHeight;' >");
		echo ("\n\t\t<div class='top' id ='tree-root'>Site Menu</div>");			
		echo ("\n\t\t\t<div class='wrap2' id='".$this->menuUNID."'>");	
	}
	
	
	function StartMenu_DropDown () {
		/**
		/* Function Desc - Writes html to start the dropdown menu
		*/	
	    echo("<table cellspacing='0' cellpadding='0' id='".$this->menuUNID."' class='$this->cssRoot'>\n");
		echo("\t<tr>\n");						
		if ($this->DDownPositioning=="vertical"){
			echo("\t<td>\n");
		}
	}
	
	
	function NewSection_DropDown (&$levTabs) {
		/**
		/* Function Desc - Writes html for a new section of dropdown menu
		*/
		echo("\t".$levTabs."<div class='section'>\n");
	}
	
	function NewItem_Tree(&$levTabs, &$treeItemClass, &$target, &$link, &$row){
		/**
		/* Function Desc - Writes html for a new tree item
		*/	
		echo ("\n\t\t\t".$levTabs."<div class='$treeItemClass'>");
		echo ("<a target=".$target." href='".$link."'>".$row->name."</a>");
	}
	
	function NewItem_DropDown(&$level, &$params, &$row, &$subMenus, &$imgPath, &$name, &$levTabs, &$cssRepeatNum, &$itemClass, &$target, &$link){
		/**
		/* Function Desc - Writes html for a new drop down item
		*/	
		$parentImgStr="";
		$menuImage="";
		$menuImgStr="";
		$spanStyle="";
		if ($level==0 && $this->DDownPositioning=="horizontal") {echo("\t\t<td>\n");}
		if ( $params->get( 'show_img' )){
			mygosu_menus::showImage($row, $params, $menuImgStr, $spanStyle);
		}
		if ($subMenus){
			$parentImgStr="<img class='rgtImg' border='0' src='".$imgPath.$params->get( 'img_parent' )."' alt='".$name."'/>";					
		}
		if ($row->type!="separator"){
			print "\t\t\t".$levTabs."<div class='menuCont_$cssRepeatNum' ><a class='".$itemClass."' target=".$target." href='".$link."'>".$menuImgStr."<span".$spanStyle.">".$row->name." </span>".$parentImgStr."</a></div>\n";					
		} else {
			print "\t\t\t".$levTabs."<div class='separator' >$row->name</div>\n";
		}
	}
/*==========================================================================*/
/*                               END OF CLASS                               */
/*==========================================================================*/
}	

?>