<?php
###################################################################################################
#  Module - Display Menu - Tigra [16 October 2004] 
#  Version  2-0
#
#  Copyright Rey Gigataras [stingrey]
#  stingrey MOS-Solutions
#  www.stingrey.biz
#  mambo@stingrey.biz
#  @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
#
#  Based on the Tigra Menu system
#  http://www.softcomplex.com/products/tigra_menu/
###################################################################################################


defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//
class dm_t_2_0 {
#											START OF CLASS											#


	/**---------------------------------------------------------------------**/
	## Loads start output
	function output_start( &$params ) { 
		echo "\n <!-- A 'stingrey MOS-Solutions' module ". $params->get( 'website' ) ." -->";
		echo "\n\n <!-- START   module '". $params->get( 'module_name' ) ."'   -->";
		echo "\n";
	
		// This is necessary to allow multiple copies/instances of the module to operate
		include_once( $params->get( 'pathA' ) .'/load_script.php' );
	}
	//---------------------------------------------------------------------	
	
	
	/**---------------------------------------------------------------------**/
	## Loads menu items
	function menu_items( &$menus, &$params ) {
		global $mosConfig_lang, $mosConfig_mbf_content, $mosConfig_live_site;
		$path = $mosConfig_live_site .'/images/M_images/';	

		/**---------------------------------------------------------------------**/
		## Loads image related paramters into $img array
		// This has been done to reduce number of variables the need to be listed
		$img[0] 		= $params->get( 'img_main' );
		$img[1] 		= $params->get( 'img_sub1' );
		$img[2] 		= $params->get( 'img_sub2' );
		$img[3] 		= $params->get( 'img_sub3' );
		//---------------------------------------------------------------------

		echo "
		<script type = 'text/javascript'>
		<!--
		var MENU_ITEMS". $params->get( 'counter' ) ." =
		[
		";
		
			// intialises sub menus array
			$subs = array();   
			
			// first pass to collect sub-menu items
			foreach ( $menus as $row ) {
				/**---------------------------------------------------------------------**/
				## MambelFish Support
				// Converts all sub-menu items
				if ($mosConfig_mbf_content) {
					$row 	= MambelFish::translate( $row, 'menu', $mosConfig_lang);
				}
				//---------------------------------------------------------------------	
				
				if ( $row->parent ) {
					if ( !array_key_exists( $row->parent, $subs ) ) {
						$subs[$row->parent] = array();
					}
					$subs[$row->parent][] = $row;
				}
			}
			
			// second pass to insert main-menu items
			foreach ( $menus as $row ) {
				if ( $row->parent == 0 && ( trim( $row->link ) || array_key_exists( $row->id, $subs ) ) ) {
					/**---------------------------------------------------------------------**/
					## MambelFish Support
					// Converts all main-menu items
					if ($mosConfig_mbf_content) {
						$row = MambelFish::translate( $row, 'menu', $mosConfig_lang );
					}
					//---------------------------------------------------------------------	
				
					$name 	= addslashes( $row->name );
					$alt 	= addslashes( $row->name );
					$link 	= $row->link ? $row->link : NULL;
					$visible	= $name;

					/**---------------------------------------------------------------------**/
					## Adds Image to left of Menu Item					 
					if ( $params->get( 'show_img' ) && ( $img[0] <> -1 ) ) {
						$visible = '<img src="' .$path . $img[0] . '" border="0">&nbsp;'. $name;
					} 
					//---------------------------------------------------------------------
		
					/**---------------------------------------------------------------------**/
					## Adds Itemid if link is not a url
					if ( $row->type != 'url' ) {
						$link .= '&Itemid='. $row->id;
					}
					//---------------------------------------------------------------------
			
					/**---------------------------------------------------------------------**/
					## Controls the page the link will be opened in
					if ( $row->browserNav ) {
						$target = "'_blank'";
					} else {
						$target = "'_self'";
					}
					//---------------------------------------------------------------------
				
					/**---------------------------------------------------------------------**/
					## 
					if ( $params->get( 'show_status' ) ) {
						$status = ", 'sb' : '". $name ."'";
					} else {
						if ( $row->type == "separator" ) {
							$status = ", 'sb' : ' '";
						} else {
							$status = ", 'sb' : '". $link ."'";
						}
					}
					//---------------------------------------------------------------------
		
					/**---------------------------------------------------------------------**/
					## SEF Support
					$link_sef = "'". sefRelToAbs( $link ) ."'";
					//---------------------------------------------------------------------
		
					/**---------------------------------------------------------------------**/
					## Displays link or if seperator, replaces with a non-linkable pattern as set in the Main Menu
					if ( $row->type != 'separator' ) {
						echo "\n wrap(['". $visible ."', ". $link_sef .", {'tw' : ". $target ."". $status ."}";
					} else {
						if ($params->get( 'show_separator' )) {
							echo "\n wrap(['". $visible ."', null, {'tw' : ". $target ."". $status ."}";
						} else {
							echo "\n wrap(['". $params->get( 'separator_code' ) ."', null, {'tw' : ". $target ."". $status ."}";
						}
					}
					//---------------------------------------------------------------------
					if ( array_key_exists( $row->id, $subs ) ) {
						echo ',';
						// third pass to insert sub-menu items
						foreach ( $subs[ $row->id ] as $sub ) {
							$name 	= addslashes( $sub->name );
							$alt 	= addslashes( $sub->name );
							$link 	= $sub->link ? $sub->link : NULL;
							$visible	= $name;
			
							/**---------------------------------------------------------------------**/
							## Adds Image to left of Menu Item
							if ( $params->get( 'show_img' ) && ( $img[1] <> -1 ) ) {
								$visible = '<img src="' .$path . $img[1] . '" border="0">&nbsp;'. $name;
							}
							//---------------------------------------------------------------------
		
							/**---------------------------------------------------------------------**/
							## Adds Itemid if link is not a url
							if ( $sub->type != 'url' ) {
								$link .= '&Itemid='. $sub->id;
							}	
							//---------------------------------------------------------------------
				
							/**---------------------------------------------------------------------**/
							## Controls the page the link will be opened in
							if ( $sub->browserNav ) {
								$target = "'_blank'";
							} else {
								$target = "'_self'";
							}
							//---------------------------------------------------------------------
				
							/**---------------------------------------------------------------------**/
							## 
							if ( $params->get( 'show_status' ) ) {
								$status = ", 'sb' : '". $name ."'";
							} else {
								if ( $sub->type == "separator" ) {
									$status = ", 'sb' : ' '";
								} else {
									$status = ", 'sb' : '". $link ."'";
								}
							}
							//---------------------------------------------------------------------
				
							/**---------------------------------------------------------------------**/
							## SEF Support
							$link_sef = "'". sefRelToAbs( $link ) ."'";
							//---------------------------------------------------------------------
			
							/**---------------------------------------------------------------------**/
							## Displays link or if seperator, replaces with a non-linkable line
							if ( $sub->type != 'separator' ) {
								echo "\n ['". $visible ."', ". $link_sef .", {'tw' : ". $target ."". $status ."}";
							} else {
								if ($params->get( 'show_separator' )) {
									echo "\n ['". $visible ."', null, {'tw' : ". $target ."". $status ."}";
								} else {
									echo "\n ['". $params->get( 'separator_code' ) ."', null, {'tw' : ". $target ."". $status ."}";
								}
							}
							//---------------------------------------------------------------------	
							if ( array_key_exists( $sub->id, $subs ) ) {
								echo ',';
								// forth pass to insert sub-sub-menu items
								foreach ( $subs[$sub->id] as $sub2 ) {
									$name 	= addslashes( $sub2->name );
									$alt 	= addslashes( $sub2->name );
									$link 	= $sub2->link ? $sub2->link : NULL;
									$visible	= $name;
					
									/**---------------------------------------------------------------------**/
									## Adds Image to left of Menu Item
									if ( $params->get( 'show_img' ) && ( $img[2] <> -1 ) ) {
										$visible = '<img src="' .$path . $img[2] . '" border="0">&nbsp;'. $name;
									}
									//---------------------------------------------------------------------
		
									/**---------------------------------------------------------------------**/
									## Adds Itemid if link is not a url
									if ( $sub2->type != 'url' ) {
										$link .= '&Itemid='. $sub2->id;
									}
									//---------------------------------------------------------------------
				
									/**---------------------------------------------------------------------**/
									## Controls the page the link will be opened in
									if ( $sub2->browserNav ) {
										$target = "'_blank'";
									} else {
										$target = "'_self'";
									}
									//---------------------------------------------------------------------
				
									/**---------------------------------------------------------------------**/
									## 
									if ( $params->get( 'show_status' ) ) {
										$status = ", 'sb' : '". $name ."'";
									} else {
										if ( $sub2->type == "separator" ) {
											$status = ", 'sb' : ' '";
										} else {
											$status = ", 'sb' : '". $link ."'";
										}
									}
									//---------------------------------------------------------------------
						
									/**---------------------------------------------------------------------**/
									## SEF Support
									$link_sef = "'". sefRelToAbs( $link ) ."'";
									//---------------------------------------------------------------------
			
									/**---------------------------------------------------------------------**/
									## Displays link or if seperator, replaces with a non-linkable line
									if ( $sub2->type != 'separator' ) {
										echo "\n ['". $visible ."', ". $link_sef .", {'tw' : ". $target ."". $status ."}";
									} else {
										if ($params->get( 'show_separator' )) {
											echo "\n ['". $visible ."', null, {'tw' : ". $target ."". $status ."}";
										} else {
											echo "\n ['". $params->get( 'separator_code' ) ."', null, {'tw' : ". $target ."". $status ."}";
										}
									}
									//---------------------------------------------------------------------	
									if ( array_key_exists( $sub2->id, $subs ) ) {
										echo ',';
										// fifth pass to insert sub-sub-sub-menu items
										foreach ( $subs[ $sub2->id ] as $sub3 ) {
											$name 	= addslashes( $sub3->name );
											$alt 	= addslashes( $sub3->name );
											$link 	= $sub3->link ? $sub3->link : NULL;
											$visible	= $name;
							
											/**---------------------------------------------------------------------**/
											## Adds Image to left of Menu Item
											if ( $params->get( 'show_img' ) && ( $img[3] <> -1 ) ) {
												$visible = '<img src="' .$path . $img[3] . '" border="0">&nbsp;'. $name;
											}
											//---------------------------------------------------------------------
						
											/**---------------------------------------------------------------------**/
											## Adds Itemid if link is not a url
											if ( $sub3->type != "url" ) {
												$link .= '&Itemid='. $sub3->id;
											}
											//---------------------------------------------------------------------
				
											/**---------------------------------------------------------------------**/
											## Controls the page the link will be opened in
											if ( $sub3->browserNav ) {
												$target = "'_blank'";
											} else {
												$target = "'_self'";
											}
											//---------------------------------------------------------------------
								
											/**---------------------------------------------------------------------**/
											## 
											if ( $params->get( 'show_status' ) ) {
												$status = ", 'sb' : '". $name ."'";
											} else {
												if ( $sub3->type == "separator" ) {
													$status = ", 'sb' : ' '";
												} else {
													$status = ", 'sb' : '". $link ."'";
												}
											}
											//---------------------------------------------------------------------
								
											/**---------------------------------------------------------------------**/
											## SEF Support
											$link_sef = "'". sefRelToAbs( $link ) ."'";
											//---------------------------------------------------------------------
			
											/**---------------------------------------------------------------------**/
											## Displays link or if seperator, replaces with a non-linkable line
											if ( $sub3->type != 'separator' ) {
												echo "\n ['". $visible ."', ". $link_sef .", {'tw' : ". $target ."". $status ."}";
											} else {
												if ($params->get( 'show_separator' )) {
													echo "\n ['". $visible ."', null, {'tw' : ". $target ."". $status ."}";
												} else {
													echo "\n ['". $params->get( 'separator_code' ) ."', null, {'tw' : ". $target ."". $status ."}";
												}
											}
											//---------------------------------------------------------------------	
											if ( array_key_exists( $sub3->id, $subs ) ) {
												echo ',';
												// fifth pass to insert sub-sub-sub-menu items
												foreach ( $subs[ $sub3->id ] as $sub4 ) {
													$name 	= addslashes( $sub4->name );
													$alt 	= addslashes( $sub4->name );
													$link 	= $sub4->link ? $sub4->link : NULL;
													$visible	= $name;
									
													/**---------------------------------------------------------------------**/
													## Adds Image to left of Menu Item
													if ( $params->get( 'show_img' ) && ( $img[3] <> -1 ) ) {
														$visible = '<img src="' .$path . $img[3] . '" border="0">&nbsp;'. $name;
													}
													//---------------------------------------------------------------------
								
													/**---------------------------------------------------------------------**/
													## Adds Itemid if link is not a url
													if ( $sub4->type != "url" ) {
														$link .= '&Itemid='. $sub4->id;
													}
													//---------------------------------------------------------------------
						
													/**---------------------------------------------------------------------**/
													## Controls the page the link will be opened in
													if ( $sub4->browserNav ) {
														$target = "'_blank'";
													} else {
														$target = "'_self'";
													}
													//---------------------------------------------------------------------
										
													/**---------------------------------------------------------------------**/
													## 
													if ( $params->get( 'show_status' ) ) {
														$status = ", 'sb' : '". $name ."'";
													} else {
														if ( $sub4->type == 'separator' ) {
															$status = ", 'sb' : ' '";
														} else {
															$status = ", 'sb' : '". $link ."'";
														}
													}
													//---------------------------------------------------------------------
										
													/**---------------------------------------------------------------------**/
													## SEF Support
													$link_sef = "'". sefRelToAbs( $link ) ."'";
													//---------------------------------------------------------------------
					
													/**---------------------------------------------------------------------**/
													## Displays link or if seperator, replaces with a non-linkable line
													if ( $sub4->type != 'separator' ) {
														echo "\n ['". $visible ."', ". $link_sef .", {'tw' : ". $target ."". $status ."}]";
													} else {
														if ($params->get( 'show_separator' )) {
															echo "\n ['". $visible ."', null, {'tw' : ". $target ."". $status ."}]";
														} else {
															echo "\n ['". $params->get( 'separator_code' ) ."', null, {'tw' : ". $target ."". $status ."}]";
														}
													}
													if ( array_key_exists( $sub5->id, $subs ) ) {
														echo ',';
														// fifth pass to insert sub-sub-sub-menu items
														foreach ( $subs[ $sub4->id ] as $sub5 ) {
															$name 	= addslashes( $sub5->name );
															$alt 	= addslashes( $sub5->name );
															$link 	= $sub4->link ? $sub5->link : NULL;
															$visible	= $name;
											
															/**---------------------------------------------------------------------**/
															## Adds Image to left of Menu Item
															if ( $params->get( 'show_img' ) && ( $img[3] <> -1 ) ) {
																$visible = '<img src="' .$path . $img[3] . '" border="0">&nbsp;'. $name;
															}
															//---------------------------------------------------------------------
										
															/**---------------------------------------------------------------------**/
															## Adds Itemid if link is not a url
															if ( $sub5->type != 'url' ) {
																$link .= '&Itemid='. $sub4->id;
															}
															//---------------------------------------------------------------------
								
															/**---------------------------------------------------------------------**/
															## Controls the page the link will be opened in
															if ( $sub5->browserNav ) {
																$target = "'_blank'";
															} else {
																$target = "'_self'";
															}
															//---------------------------------------------------------------------
												
															/**---------------------------------------------------------------------**/
															## 
															if ( $params->get( 'show_status' ) ) {
																$status = ", 'sb' : '". $name ."'";
															} else {
																if ( $sub5->type == 'separator' ) {
																	$status = ", 'sb' : ' '";
																} else {
																	$status = ", 'sb' : '". $link ."'";
																}
															}
															//---------------------------------------------------------------------
												
															/**---------------------------------------------------------------------**/
															## SEF Support
															$link_sef = "'". sefRelToAbs( $link ) ."'";
															//---------------------------------------------------------------------
							
															/**---------------------------------------------------------------------**/
															## Displays link or if seperator, replaces with a non-linkable line
															if ( $sub5->type != 'separator' ) {
																echo "\n ['". $visible ."', ". $link_sef .", {'tw' : ". $target ."". $status ."}]";
															} else {
																if ($params->get( 'show_separator' )) {
																	echo "\n ['". $visible ."', null, {'tw' : ". $target ."". $status ."}]";
																} else {
																	echo "\n ['". $params->get( 'separator_code' ) ."', null, {'tw' : ". $target ."". $status ."}]";
																}
															}
															//---------------------------------------------------------------------
														}
													}
													/**---------------------------------------------------------------------**/
													## Closes entries for this level
													echo '],';
													//---------------------------------------------------------------------	
												}
											}
											/**---------------------------------------------------------------------**/
											## Closes entries for this level
											echo '],';
											//---------------------------------------------------------------------	
										}
									}
									/**---------------------------------------------------------------------**/
									## Closes entries for this level
									echo '],';
									//---------------------------------------------------------------------	
								}
							}
							/**---------------------------------------------------------------------**/
							## Closes entries for this level
							echo '],';
							//---------------------------------------------------------------------	
						}
					}
					echo ']),';
				}
			}
			
			echo "
		
		];
		
		function wrap( item ) {
			var url_current = String(window.location);
			var url_link = '". $mosConfig_live_site ."' + '/' + item[1];
		
			if ( url_current == url_link )
				item[0] = '<span id=\"". $params->get( 'css_prefix' ) ."dm_t-active_link\">' + item[0] + '</span>';
			return (item);
		
		}
		
		-->
		</script> \n
		";
	}
	//---------------------------------------------------------------------	
	
	
	/**---------------------------------------------------------------------**/
	## Loads menu structure
	function menu_structure( &$params ) {
	
		/**---------------------------------------------------------------------**/
		if ( $params->get( 'orientation' ) == 'c' ) {
			## Custom Settings	
		} else if ( $params->get( 'orientation' ) == "v" ) {
			## Vertical Orientation
			// offsets between items of the same level
			$top_parent 		= $params->get( 'height' );
			$left_parent 		= 0;
			$block_top_1 		= 0;
			$block_left_1 		= $params->get( 'width_parent' );
			$block_left_1_1 	= 0;
			$block_top_1_1 	= $params->get( 'height' )+1;
			$block_top_2 		= 0;
			$block_left_2 		= $params->get( 'width_child' );
		} else {
			## Horizontal Orientation
			// offsets between items of the same level
			$top_parent 		= 0;
			$left_parent 		= $params->get( 'width_parent' );
			$block_top_1 		= $params->get( 'height' )+1;
			$block_left_1 		= 0;
			$block_top_1 		= $params->get( 'height' )+1;
			$block_left_1_1 	= 0;
			$block_top_1_1 	= $params->get( 'height' )+1;
			$block_left_1 		= 0;
			$block_top_2 		= 0;
			$block_left_2 		= $params->get( 'width_child' );
		}
		//---------------------------------------------------------------------	
	
		echo "
	<script type = 'text/javascript'>
	<!--
	var MENU_POS". $params->get( 'counter' ) ." =
	[
	";
	
	echo "
	// parent level
	{
		'width': ". $params->get( 'width_parent' ) .",
		'height': ". $params->get( 'height' ) .",
		'top': ". $top_parent .",
		'left': ". $left_parent .",
		'block_top': ". $params->get( 'position_top' ) .",
		'block_left': ". $params->get( 'position_left' ) .",
		'hide_delay': ". $params->get( 'delay_hide' ) .",
		'expd_delay': ". $params->get( 'delay_expand' ) .",
		'css' : {
			'outer': '',
			'inner': ['". $params->get( 'css_prefix' ) ."dm_t-0', '". $params->get( 'css_prefix' ) ."dm_t-0_over', '". $params->get( 'css_prefix' ) ."dm_t-0_down']
		}
	},
	// 1st Sublevel
	{
		'width': ". $params->get( 'width_child' ) .",
		'height': ". $params->get( 'height' ) .",
		'top': ". $block_top_1_1 .",
		'left': ". $block_left_1_1 .",
		'block_top': ". $block_top_1 .",
		'block_left': ". $block_left_1 .",
		'css': {
			'outer': '',
			'inner': ['". $params->get( 'css_prefix' ) ."dm_t-1', '". $params->get( 'css_prefix' ) ."dm_t-1_over', '". $params->get( 'css_prefix' ) ."dm_t-1_down']
		}
	},
	// 2nd Sublevel
	{
		'block_top': ". $block_top_2 .",
		'block_left': ". $block_left_2 .",
		'css': {
			'outer': '',
			'inner': ['". $params->get( 'css_prefix' ) ."dm_t-2', '". $params->get( 'css_prefix' ) ."dm_t-2_over', '". $params->get( 'css_prefix' ) ."dm_t-2_down']
		}
	},
	// 3rd Sublevel
	{
		'block_top': ". $block_top_2 .",
		'block_left': ". $block_left_2 .",
		'css': {
			'outer': '',
			'inner': ['". $params->get( 'css_prefix' ) ."dm_t-3', '". $params->get( 'css_prefix' ) ."dm_t-3_over', '". $params->get( 'css_prefix' ) ."dm_t-3_down']
		}
	},
	";
	
		echo "
	
	];
	
	-->
	</script> \n
	";
	
	}
	//---------------------------------------------------------------------	
	
	
	/**---------------------------------------------------------------------**/
	## Loads end output
	function output_end( &$params ) {
		?>
	
	<div style="position: relative; z-index: 1000;"> 
	<script type = "text/javascript">
	<!--
	new menu( MENU_ITEMS<?php echo $params->get( 'counter' ); ?>, MENU_POS<?php echo $params->get( 'counter' ); ?> );
	-->
	</script>
	</div>
	<div class="<?php echo $params->get( 'css_prefix' ); ?>dm_t-whole" style="height: <?php echo $params->get( 'module_height' ); ?>px; width: <?php echo $params->get( 'module_width' ); ?>px;"></div>
		<?php
		echo "\n";
		echo "<!-- END   module '". $params->get( 'module_name' ) ."'   --> \n\n\n";
	}
	//---------------------------------------------------------------------	


#    										END OF CLASS										    #
}	
//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//-----//
?>