<?php
// You shouldn't need to change anything in this file, except if things aren't working!!
// This script will work out how to include the global mos configuration, include it and then set WP variables using the mos variables so that user doesn't need to do any configuration!

// uncomment for easy debug.
/*
ini_set('display_errors', true);
ini_set('error_reporting', E_ALL);
*/

if (!defined('_VALID_MOS')) {
	define('_VALID_MOS', true);
	define ( 'WP_MOS_ABSOLUTE_PATH', preg_replace('/mambots([\/\\\]+)editors([\/\\\]+)wysiwygpro([\/\\\]+)config.php/i', '', __FILE__));
	include_once (WP_MOS_ABSOLUTE_PATH."globals.php");
	include_once(WP_MOS_ABSOLUTE_PATH.'configuration.php');
	// enables switching to secure https 
	if (file_exists($mosConfig_absolute_path .'/includes/mambo.ssl.init.php')) {
		include_once( $mosConfig_absolute_path .'/includes/mambo.ssl.init.php' );
	}
	$wpInDialog = true;
} else {
	$wpInDialog = false;
}

$wp_live_site = preg_replace('/^http(|s):\/\/[^\/]+/smi', '', $mosConfig_live_site);
if (substr($wp_live_site, strlen($wp_live_site)-1) == '/') {
	$wp_live_site = substr($wp_live_site, 0, strlen($wp_live_site)-1);
}

define('DEFAULT_LANG', 'en-us.php');
define('DOMAIN_ADDRESS', strtolower(substr($_SERVER['SERVER_PROTOCOL'],0,strpos($_SERVER['SERVER_PROTOCOL'],'/')) . (isset($_SERVER['HTTPS']) ? ($_SERVER['HTTPS'] == "on" ? 's://' : '://') : '://' ) . $_SERVER['SERVER_NAME'] ) );
define('WP_FILE_DIRECTORY', dirname(__FILE__).'/');
define('WP_WEB_DIRECTORY', $wp_live_site.'/mambots/editors/wysiwygpro/');
$trusted_directories = array();
define('SMILEY_FILE_DIRECTORY', null);
define('SMILEY_WEB_DIRECTORY', null);
define('NOCACHE', false);
define('SAVE_DIRECTORY', $mosConfig_absolute_path.'/cache/');
define('SAVE_LENGTH', 9000);

// -------------------------------------------------------------------------------
// All of the following variables affect file management in the image and document windows:
// -------------------------------------------------------------------------------

//////////////////////////
// User Permissions
//////////////////////////

// We will check for valid mos users and dynamically set the permissions accordingly.
// Logged in users with a valid mos session will have full file system access, others will not.
// Note: directory editing is only available from the admin end
if ($wpInDialog) {
	
	// no permissions (default)
	$permissions = 0;
	$adminok = false;
	$adminattempted = false;
	
	//define('_VALID_MOS', true);
	
	// IN ADMIN AUTHENTICATION:
	//include_once ($mosConfig_absolute_path."/globals.php");
	//require_once ($mosConfig_absolute_path."/configuration.php");
	require_once ($mosConfig_absolute_path."/includes/mambo.php");
	
	// get database object
	if (!isset($database)) {
		$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );
		$database->debug( $mosConfig_debug );
	}
	
	// GET MAMBOT PARAMS
	$query = "SELECT id FROM #__mambots WHERE element = 'WysiwygPro' AND folder = 'editors'";
	$database->setQuery( $query );
	$id = $database->loadResult();
	$mambot = new mosMambot( $database );
	$mambot->load($id);
	$params = & new mosParameters($mambot->params);
	
	// do a check to see if user is logged into Admin:
	if (isset($_REQUEST[md5( $mosConfig_live_site )]) || isset($_REQUEST['mosadmin'])) {
		// looks like user is probably logged into Admin!
		
		$adminok = false;
		
		require_once( $mosConfig_absolute_path . "/administrator/includes/admin.php" );
		
		if (!isset($acl) && class_exists('gacl_api')) {
			$acl = new gacl_api();
		}
		
		// must start the session before we create the mainframe object
		if (isset($_REQUEST[md5( $mosConfig_live_site )])) {
			session_name( md5( $mosConfig_live_site ) );
		} else {
			session_name( 'mosadmin' );
		}
		session_start();
		
		$adminattempted = true;
		
		// mainframe is an API workhorse, lots of 'core' interaction routines
		$mainframe = new mosMainFrame( $database, 'com_admin', $mosConfig_absolute_path, true );
			
		//$mainframe->initSession( 'php' );
		// restore some session variables
		//$my = $mainframe->getUser();
		
		$my = new mosUser( $database );
		$my->id = mosGetParam( $_SESSION, 'session_user_id', '' );
		$my->username = mosGetParam( $_SESSION, 'session_username', '' );
		$my->usertype = mosGetParam( $_SESSION, 'session_usertype', '' );
		$my->gid = mosGetParam( $_SESSION, 'session_gid', '' );
		
		$session_id = mosGetParam( $_SESSION, 'session_id', '' );
		$logintime = mosGetParam( $_SESSION, 'session_logintime', '' );
		
		// required for Mambo versions before 4.5.3
		if ($session_id == md5( $my->id.$my->username.$my->usertype.$logintime )) {
			$query = "SELECT * FROM #__session"
			. "\nWHERE session_id='$session_id'";
			if (method_exists($database, 'getEscaped') && isset($my->id)) {
				$query .= " AND username = '" . $database->getEscaped( $my->username ) . "'";
				$query .= " AND userid = " . intval( $my->id );
			}
			if (!$result = $database->query()) {
				echo $database->stderr();
				exit();
			}
			if ($database->getNumRows( $result ) <> 1) {
				// user not logged into admin
				$adminok = false;
			} else {
				// user logged into admin
				$adminok = true;
			}
		}
		
		if ($adminok) {
			
			//echo 'Back-end';
			
			$permissions = 2;
			
			// update session timestamp
			$current_time = time();
			$database->setQuery( "UPDATE #__session SET time='$current_time'"
			. "\nWHERE session_id='$session_id'"
			);
			$database->query();
			
			// timeout old sessions
			$past = time()-1800;
			$database->setQuery( "DELETE FROM #__session WHERE time < '$past'" );
			$database->query();

		}
				
	}
	if ($adminok==false) {
		//exit('no admin session');
		// user does not have an admin session, we must be in the front-end
		/********************************************************************************
		Begin user upload privaleges mod.
		*/
		
		//echo 'Front-end';
		
		if ($adminattempted) {
			session_destroy();
		}
		
		$mainframe = new mosMainFrame( $database, '', $mosConfig_absolute_path);
		
		// FRONT-END "USER" AUTHENTICATION:
		
		$mainframe->initSession();
		$my = $mainframe->getUser();
		$gid = intval( $my->gid );
		
		//echo 'usertype:'.$my->usertype;
		//
		//print_r($my);
		
		if ($gid) {
			
			switch(strtolower($my->usertype)) {
				case 'manager' :
				case 'administrator' :
				case 'super administrator' :
					$permissions = 2;
					break;
				case 'author' :
				case 'editor' :
				case 'publisher' :
					$permissions = $params->get( 'permissions', '0' );
					break;
				default :
					$permissions = 0;
					break;
			}
			
		} else {
			
			// user not logged in anywhere, no permissions.
			$permissions = 0;
			
		}
	}
	
	
	// now actually set the permissions
	switch($permissions) {
		case 1 : // upload only
			$delete_files = false;
			$delete_directories = false;
			$create_directories = true;
			$rename_files = false;
			$rename_directories = false;
			$upload_files = true;
			$overwrite = false;
			break;
		case 2 : // all permissions
			$delete_files = true;
			$delete_directories = true;
			$create_directories = true;
			$rename_files = true;
			$rename_directories = true;
			$upload_files = true;
			$overwrite = true;
			break;
		default: // no permissions
			$delete_files = false;
			$delete_directories = false;
			$create_directories = false;
			$rename_files = false;
			$rename_directories = false;
			$upload_files = false;
			$overwrite = false;
			break;
	}	
	
	
	////////////////////////////
	// File Types  
	////////////////////////////
	
	// These variables decide what types of files users are allowed to upload using the image or document management windows
	
	// What types of images can be uploaded? Separate with a comma.
	$image_types = $params->get( 'image_types', '.jpg, .jpeg, .gif, .png' );
	
	// What types of documents can be uploaded? Separate with a comma.
	$document_types = $params->get( 'document_types', '.html, .htm, .pdf, .doc, .rtf, .txt, .xl, .xls, .ppt, .pps, .zip, .tar, .swf, .wmv, .rm, .mov, .jpg, .jpeg, .gif, .png' );
	
	////////////////////////////
	// File Sizes
	////////////////////////////
	
	// maximum width of uploaded images in pixels set this to ensure that users don't destroy your site's design!!
	$max_image_width = $params->get( 'max_image_width', 500 );
	
	// maximum height of uploaded images in pixels set this to ensure that users don't destroy your site's design!!
	$max_image_height = $params->get( 'max_image_height', 500 );
	
	// maximum image filesize to upload in bytes
	$max_file_size = $params->get( 'max_image_size', 80000 );
	
	// maximum size of documents to upload in bytes
	$max_documentfile_size = $params->get( 'max_document_size', 2000000 );
	
	
	// CHMOD files and folders?
	
	$file_CHMOD = $params->get( 'FILE_CHMOD_MODE', 0 );
	$folder_CHMOD = $params->get( 'CHMOD_MODE', 0 );
	if (!empty($file_CHMOD)) {
		define('FILE_CHMOD_MODE', $file_CHMOD);
	}
	if (!empty($folder_CHMOD)) {
		define('CHMOD_MODE', $folder_CHMOD);
	}
	
	// URLs
	// get params
	$image_directory = $params->get( 'image_folder', '/images/stories/');
	$document_directory = $params->get( 'document_folder', '/images/stories/');
	
	define('IMAGE_FILE_DIRECTORY', $mosConfig_absolute_path.$image_directory);
	define('DOCUMENT_FILE_DIRECTORY', $mosConfig_absolute_path.$document_directory);
	
	if (!$params->get( 'full_urls', 1 )) {
		define('IMAGE_WEB_DIRECTORY', $wp_live_site.$image_directory);
		define('DOCUMENT_WEB_DIRECTORY', $wp_live_site.$document_directory);
	} else {
		define('IMAGE_WEB_DIRECTORY', $mosConfig_live_site.$image_directory);
		define('DOCUMENT_WEB_DIRECTORY', $mosConfig_live_site.$document_directory);
	}
	
	// create folder if not exist
	if (!file_exists(IMAGE_FILE_DIRECTORY)) {
		@mkdir(IMAGE_FILE_DIRECTORY);
		@chmod(IMAGE_FILE_DIRECTORY, 0777);
	}
	if (!file_exists(DOCUMENT_FILE_DIRECTORY)) {
		@mkdir(DOCUMENT_FILE_DIRECTORY);
		@chmod(DOCUMENT_FILE_DIRECTORY, 0777);
	}
	
} else {
	define('IMAGE_FILE_DIRECTORY', $mosConfig_absolute_path.'/images/stories/');
	define('DOCUMENT_FILE_DIRECTORY', $mosConfig_absolute_path.'/images/stories/');
	define('IMAGE_WEB_DIRECTORY', $mosConfig_live_site.'/images/stories/');
	define('DOCUMENT_WEB_DIRECTORY', $mosConfig_live_site.'/images/stories/');
}
// end variables, do not change anything below
// ----------------------------------------
define('WP_CONFIG', true);
define('WP_MAMBOT_CONFIG', true);
global $wp_has_been_previous;
$wp_has_been_previous = false;
include(WP_FILE_DIRECTORY.'includes/error_reporting.php');
// ----------------------------------------
?>