<?php

/**
 * Quickdown mambot for Remository  1.3 (for use with mambo 4.5.1+) 
 * All rights reserved Mambo Open Source is Free Software Released under GNU/GPL
 * License : http://www.gnu.org/copyleft/gpl.html
 * @by Mamboaddons.com DEV
 * @package Mambo Open Source
 * @Copyright (C) 2004 - 2005 http://www.mamboaddons.com
 * Special Thanks to wolfi from http://www.mamboport.de for preparing version
 * 1.1b for Mambo 4.5.1
 */

defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

global $_MAMBOTS;
$_MAMBOTS->registerFunction('onPrepareContent', 'botQuickdown');

function botQuickdown($published, &$row, &$params, $page=0) {
	global $database, $mosConfig_live_site, $mosConfig_absolute_path, $mosConfig_lang, $mosConfig_sitename;
	
	if (!$published) {
		$row->text = preg_replace('/{quickdown:.+?}/', '', $row->text);
		$row->text = preg_replace('/{quickcat:.+?}/', '', $row->text);
		$row->text = preg_replace('/{quickfolder:.+?}/', '', $row->text);
		return;
	}

	//Loading Remository Configuration
	include_once('components/com_remository/com_remository_settings.php');

	# Load language if it exists
	if (file_exists('components/com_remository/language/'.$mosConfig_lang.'.php')) {
		include_once('components/com_remository/language/'.$mosConfig_lang.'.php');
	} else {
		include_once('components/com_remository/language/english.php');
	}

	// Get parameters from Database
	$query = "SELECT id FROM #__mambots WHERE element = 'quickdown' AND folder = 'content'";
	$database->setQuery($query);
	$id = $database->loadResult();
	$mambot = new mosMambot($database);
	$mambot->load($id);
	$param = &new mosParameters($mambot->params);

	// Get parameters from Database
	$content = $row->text;
	$matches = array ();



	if (isset($_POST['submit_vote_remository'])) {
		user_rate($_POST['id'], $_POST['user_rating']);
	}


	// Get ids from Quickdown command
	if (preg_match_all('/{quickdown:.+?}/', $content, $matches, PREG_PATTERN_ORDER)) {

		//Get IDS
		foreach ($matches as $fmatch) {
			foreach ($fmatch as $match) {
				$match = str_replace("{quickdown:", "", $match);
				$match = str_replace("}", "", $match);
				$output = createLink($match, $param,$Time_Stamp);
				$content = preg_replace("/{quickdown:$match}/", $output, $content);
			}
		}
		unset($matches);
	}

	if (preg_match_all('/{quickcat:.+?}/', $content, $matches, PREG_PATTERN_ORDER)) {
		//Get IDS from quickcat cmmand
		foreach ($matches as $fmatch) {
			foreach ($fmatch as $match) {
				$match = str_replace("{quickcat:", "", $match);
				$match = str_replace("}", "", $match);
				$match = intval($match);
				$sql = "SELECT f.id from #__downloads_files AS f, #__downloads_structure AS s WHERE s.container=$match AND s.item=f.containerid AND f.published=1";
				$database->setQuery($sql);
				$catrows=$database->loadObjectList();
				$output = '';
				if ($catrows) {
					foreach ($catrows as $catrow){
						$output.=createLink($catrow->id, $param, $Time_Stamp).$param->get("delimiter","<br><br>");
					}
				}
				$content = preg_replace("/{quickcat:$match}/", $output, $content);
			}
		}
		unset($matches);
	}


	if (preg_match_all('/{quickfolder:.+?}/', $content, $matches, PREG_PATTERN_ORDER)) {
		//Get IDS from quickcat cmmand
		foreach ($matches as $fmatch) {
			foreach ($fmatch as $match) {
				$match = str_replace("{quickfolder:", "", $match);
				$match = str_replace("}", "", $match);
				$match = intval($match);
				$sql = "SELECT id from #__downloads_files WHERE containerid=$match AND published='1'";
				$database->setQuery($sql);
				$folderrows=$database->loadObjectList();
				$output = '';
				if ($folderrows) {
					foreach ($folderrows as $folderrow){
						$output.=createLink($folderrow->id, $param, $Time_Stamp).$param->get("delimiter","<br><br>");
					}
				}
				$content = preg_replace("/{quickfolder:$match}/", $output, $content);
			}
		}
		unset($matches);
	}

	$row->text = $content;
	return true;
}

if (!is_callable('getItemID')) {
	function getItemID ($component_string) {
		global $database;
		if (isset($GLOBALS['remosef_itemids'][$component_string])) return $GLOBALS['remosef_itemids'][$component_string];
		$component_string = $database->getEscaped($component_string);
		$database->setQuery("SELECT id FROM #__menu WHERE link = 'index.php?option=$component_string'");
		$GLOBALS['remosef_itemids'][$component_string] = $database->loadResult();
		return $GLOBALS['remosef_itemids'][$component_string];
	}
}

/**
	 * This function create the output for the file with the given id
	 * @param int $id - The id of the file
	 * @param object $param - The parameter object, that hold the parameter
	 * @param TimeStamp $Time_Stamp - The Timestamp var from the Remository config
	 * @return String - The generated table with the Information for the file
	 */
function createLink($id, &$param, $Time_Stamp){
	global $database, $mosConfig_live_site, $mosConfig_absolute_path, $mosConfig_lang;

	global $mosConfig_sef;

	// Find out $Itemid
	$base_url = 'index.php?option=com_remository&Itemid='.getItemID('com_remository');        	// Base URL string

	// Generate download
	//Getting File-info from Database
	$id = intval($id);
	$database->setQuery("SELECT * FROM #__downloads_files WHERE id=$id");
	$filelist = $database->loadObjectList();
	if ($filelist) {
		$file = $filelist[0];
			$allvotes = 0;
			$rating = 0;
			$sql = "SELECT COUNT(id) as allvotes, AVG(value) as rating FROM #__downloads_log WHERE type=3 AND fileid=$id";
			$database->setQuery($sql);
			$result = $database->query();
			$database->loadObject($votes);
			$allvotes = $votes->allvotes;
			if ($votes->rating) $rating = round($votes->rating);
			else $rating = 0;
			$output = "<table>";
			
			// short description on top position
			if ($param->get("show_shortdesc","1") AND $param->get("show_shortdesc_pos")=='top'){
				$output .= "<tr><td>$file->smalldesc<br><br></td></tr>";
			}
			
			// full description on top position
			if ($param->get("show_desc","1") AND $param->get("show_desc_pos")=='top'){
				$output .= "<tr><td>$file->description<br><br></td></tr>";
			}
			//downloadlink
			if ($param->get("show_download","1")){
				$linkurl = sefRelToAbs($base_url."&func=startdown&id=$id");
				$output .= "<tr><td><a href=\"$linkurl\"><img src=\"components/com_remository/images/download_trans.gif\"border=\"0\">&nbsp;<b>"._DOWNLOAD."&nbsp;$file->filetitle</b></a></td></tr>";
			}
			
			$output .= "<tr><td><table>";
			
			//filetitle and link to entry
			if ($param->get('show_title', "1")){
				$output .= "<tr><td><b>"._DOWN_FILE_TITLE."</b></td><td>$file->filetitle";

				if ($param->get("show_ltentry","1")){
					$linkurl = sefRelToAbs($base_url."&func=fileinfo&id=$id");
					$output .= "&nbsp;<a href=\"$linkurl\"><i>(Details)</i></a>";
				}
				$output .= "</td></tr>";
			}
			//filetype
			if ($param->get('show_type', "1")){
				$output .= "<tr><td><b>"._DOWN_FILE_TYPE."</b></td><td>$file->filetype</td></tr>";
			}
			//file version
			if ($param->get('show_version', "1")){
				$output .= "<tr><td><b>"._DOWN_FILE_VER."</b></td><td>$file->fileversion</td></tr>";
			}
			//filesize
			if ($param->get('show_size', "1")){
				$output .= "<tr><td><b>"._DOWN_FILE_SIZE."</b></td><td>$file->filesize</td></tr>";
			}
			//license
			if ($param->get('show_license', "1")){
				$output .= "<tr><td><b>"._DOWN_LICENSE."</b></td><td>$file->license</td></tr>";
			}
			//author
			if ($param->get('show_author', "1")){
				$output .= "<tr><td><b>"._DOWN_FILE_AUTHOR."</b></td><td>$file->fileauthor</td></tr>";
			}
			//homepage
			if ($param->get('show_homepage', "1")){
				//check if http is given in url
				if(!strpos($file->filehomepage,"ttp://")){$nurl="http://$file->filehomepage";}
				else {$nurl="$file->filehomepage";}
				$output .= "<tr><td><b>"._DOWN_FILE_HOMEPAGE."</b></td><td><a href=\"$nurl\" target=\"_blank\">$file->filehomepage</a></td></tr>";
			}
			//download count
			if ($param->get('show_count', "1")){
				$output .= "<tr><td><b>"._DOWN_DOWNLOADS."</b></td><td>$file->downloads</td></tr>";
			}
			//show rating
			if ($param->get('show_rating', "1")){
				$output .= "<tr><td><b>"._DOWN_RATING."</b></td><td><img src=\"components/com_remository/images/stars/$rating.gif\">&nbsp;($allvotes "._DOWN_VOTES_TITLE.")</td></tr>";
			}
			/* form for frontend Voting */
			if ($param->get('allow_rating', "1")){
				$output .= "<tr><td><b>"._DOWN_YOUR_VOTE."</b></td><td><FORM METHOD=POST ACTION=\"".$_SERVER['PHP_SELF']."\">";
				$output .= "<SELECT NAME=\"user_rating\" class=\"inputbox\">";
				$output .= "<option value=\"0\">?</option>";
				$output .= "<option value=\"1\">1</option>";
				$output .= "<option value=\"2\">2</option>";
				$output .= "<option value=\"3\">3</option>";
				$output .= "<option value=\"4\">4</option>";
				$output .= "<option value=\"5\">5</option>";
				$output .= "</SELECT>";
				$output .= "<INPUT CLASS=\"button\" TYPE=\"submit\" NAME=\"submit_vote_remository\" VALUE="._DOWN_RATE_BUTTON.">";
				$output .= "<INPUT TYPE=\"hidden\" NAME=\"id\" value=\"$id\">";
				$output .= "</FORM> </td></tr>";
				/* end form */
			}
			
			$output .= "</table></td></tr><tr><td>";
			
			// short description on bottom position
			if ($param->get("show_shortdesc","1") AND $param->get("show_shortdesc_pos")=='bottom'){
				$output .= "<tr><td colspan=\"2\"><br>$file->smalldesc</td></tr>";
			}
			
			// full description on top position
			if ($param->get("show_desc","1") AND $param->get("show_desc_pos")=='bottom'){
				$output .= "<tr><td colspan=\"2\"><br>$file->description</td></tr>";
			}
			
			$output .= "</td></tr></table>";

	}
	return ($output);
}


function user_rate($id, $user_rating) {
	global $database, $my;
	//code taken from origina reomsitory.html.php
	if (!is_numeric($user_rating)) $user_rating = 0;
	if (($user_rating >= 1) AND ($user_rating <= 5)) {
		$currip = getenv("REMOTE_ADDR");
		$sql = "SELECT id FROM #__downloads_log WHERE fileid=$id AND type=3 AND ipaddress='$currip'";
		$database->setQuery($sql);
		$alreadyvoted = $database->loadResultArray();
		if (is_array($alreadyvoted) AND count($alreadyvoted)>0) {
			echo '<TABLE><TR><TD><B>'._DOWN_ALREADY_VOTE.'</B></TD></TR></TABLE>';
			return;
		}
		$type = 3;
		$date = date('Y-m-d H:i:s');
		$id = intval($id);
		$user_rating = intval($user_rating);
		$sql = "INSERT INTO #__downloads_log (type, date, userid, fileid, value, ipaddress) VALUES ('3', '$date', $my->id, $id, $user_rating, '$currip')";
		$database->setQuery($sql);
		$database->query();
	}
}
?>