<?php
/**
* RSSFEED Mambot
* author John Long <john_-a@t-_idealagent_-dot-_.com>
* function rssutil abstracted from: "components/com_newsfeeds"
* MODIFICATIONS:
*		4/9/2005 made corrections for &apos; HTML code
*
 * Based on the "Code Highliting Mambot" by eddieajau
**/
// $Id: moscode.php,v 1.1 2003/12/15 00:39:03 eddieajau Exp $
/**
* Code Highlighting Mambot
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Miro International Pty Ltd
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @version $Revision: 1.1 $
* @author Andrew Eddie <eddieajau@user.sourceforge.net>
**/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onPrepareContent', 'botKL_RSSFEED' );

/**
* RSSFEED Mambot
*
* <b>Usage:</b>
* {kl_rssfeed}full rssURL{/kl_rssfeed}
 *
 *You may override any parameter of the mambot
 *
* {kl_rssfeed items="5"debug="1"}full rssURL{/kl_rssfeed}
*
*/

function botKL_RSSFEED( $published, &$row, &$params, $page=0 ) {

	$regex = "#{kl_rssfeed*(.*?)}(.*?){/kl_rssfeed}#s";

	// perform the replacement
if($published){
		$row->text = preg_replace_callback( $regex, 'botKL_RSSFEED_replacer', $row->text );
	}else {
		$row->text = preg_replace( $regex, '', $row->text );
	}

	return true;
}

function botKL_RSSFEED_replacer( &$matches ) {
	global $mosConfig_absolute_path, $mosConfig_live_site, $database;
	require_once( $mosConfig_absolute_path . '/includes/domit/xml_saxy_lite_parser.php' );

	$query = "SELECT id FROM #__mambots WHERE element = 'kl_rssfeed' AND folder = 'content'";
	$database->setQuery( $query );
	$kl_id = $database->loadResult();
	$mambot = new mosMambot( $database );
	$mambot->load( $kl_id );
	$bot_params =& new mosParameters( $mambot->params );
	$kl_params = array();
	$kl_params['chtitle']			=	$bot_params->def( 'chtitle', '1' );
	$kl_params['chdesc']			=	$bot_params->def( 'chdesc', '1' );
	$kl_params['chsrc']				=	$bot_params->def( 'chsrc', '0' );
	$kl_params['itemsrc']			=	$bot_params->def( 'itemsrc', '0' );
	$kl_params['image']				=	$bot_params->def( 'image', '1' );
	$kl_params['title']				=	$bot_params->def( 'title', '1' );
	$kl_params['desc']				=	$bot_params->def( 'desc', '1' );
	$kl_params['item_one']				=	$bot_params->def( 'item_one', '1' );
	$kl_params['items']				=	$bot_params->def( 'items', '1' );
	$kl_params['word_count']	= $bot_params->def( 'word_count', '100' );
	$kl_params['span']				=	$bot_params->def( 'span', '0' );
	$kl_params['cache']				=	$bot_params->def( 'cache', '3600' );
	$kl_params['class']				=	$bot_params->def( 'class', '' );
	$kl_params['debug']				=	$bot_params->def( 'debug', '0' );
         
	$parser =& new SAXY_Lite_Parser();
	$attribs = $parser->parseAttributes( html_entity_decode(@$matches[1], ENT_QUOTES) );

	$kl_params['chtitle']			= trim(mosGetparam($attribs, 'chtitle'   , $kl_params['chtitle']));
	$kl_params['chdesc']			= trim(mosGetparam($attribs, 'chdesc'   ,  $kl_params['chdesc']));
	$kl_params['chsrc']				= trim(mosGetparam($attribs, 'chsrc'   ,   $kl_params['chsrc']	));
	$kl_params['itemsrc']			= trim(mosGetparam($attribs, 'itemsrc'   , $kl_params['itemsrc']));                  
	$kl_params['image']				= trim(mosGetparam($attribs, 'image'   ,   $kl_params['image']));
	$kl_params['title']				= trim(mosGetparam($attribs, 'title'   ,   $kl_params['title']));
	$kl_params['desc']				= trim(mosGetparam($attribs, 'desc'   ,    $kl_params['desc']	));
	$kl_params['item_one']				= trim(mosGetparam($attribs, 'item_one'   ,   $kl_params['item_one']));   
	$kl_params['items']				= trim(mosGetparam($attribs, 'items'   ,   $kl_params['items']));   
	$kl_params['word_count']	= trim(mosGetparam($attribs, 'word_count' ,$kl_params['word_count']));
	$kl_params['span']				= trim(mosGetparam($attribs, 'span'   ,    $kl_params['span']));
	$kl_params['cache']				= trim(mosGetparam($attribs, 'cache'   ,   $kl_params['cache']));
	$kl_params['class']				= trim(mosGetparam($attribs, 'class'   ,   $kl_params['class']));
	$kl_params['debug']				= trim(mosGetparam($attribs, 'debug',  $kl_params['debug']));

	$kl_params['item_one'] -=1; //zero base the counter
	if($kl_params['item_one']<0) $kl_params['item_one'] = 0;
	
	if ($kl_params['debug']) {
		print 'Debug-KL_RSSFEED:<br />------<br />';
		print_r($matches[1]);
		print '<br />--<br />';
		print $matches[2];
		print_r($kl_params);
		print '<br />------<br />';
	}
	if($kl_params['class'])
		$class = ' class="'.$kl_params['class'].'';
	else
		$class = '';
  ob_start();
  	 rssutil("$matches[2]", $class, $kl_params);
  $buf = ob_get_contents();
	ob_end_clean();
	$buf;

	if ($kl_params['span'])
    return  '<'.$kl_params['span'].' class="'.$kl_params['class'].'">'.$buf.'</'.$kl_params['span'].'>';
	else
    return  $buf;
}
function rssutil($rssurl, $class, $kl_params) {
	global $mosConfig_absolute_path;
?>

<?php
			$cacheDir = $mosConfig_absolute_path .'/cache/';
			$LitePath = $mosConfig_absolute_path .'/includes/Cache/Lite.php';
			//require_once( $mosConfig_absolute_path .'/includes/domit/xml_domit_rss_lite.php' );
			// full RSS parser used to access image information
			require_once( $mosConfig_absolute_path . "/includes/domit/xml_domit_rss.php");
	
			
			//ssDoc =& new xml_domit_rss_document_lite();
			$rssDoc =& new xml_domit_rss_document();
			$rssDoc->useCacheLite(true, $LitePath, $cacheDir, $kl_params['cache']);
			$rssDoc->loadRSS( $rssurl );
			$totalChannels = $rssDoc->getChannelCount();
//----------------------------
			for ( $i = 0; $i < $totalChannels; $i++ ) {
				$currChannel	=& $rssDoc->getChannel($i);
				$elements 		= $currChannel->getElementList();
				$descrip 		= 0;
				$iUrl			= 0;
				if ($kl_params['debug'] || $kl_params['chsrc'] ) {
					print $currChannel->toNormalizedString(1);
				}
				foreach ( $elements as $element ) {
					//image handling				
					if ( $element == 'image' ) {
						$image =& $currChannel->getElement( DOMIT_RSS_ELEMENT_IMAGE );
						$iUrl	= $image->getUrl();
						$iTitle	= $image->getTitle();
					}
					if ( $element == 'description' ) {
						$descrip = 1;
						// hide com_rss descrip in 4.5.0 feeds
						if ( $currChannel->getDescription() == 'com_rss' ) {
							$descrip = 0;
						}						
					}
				}
				?>
				<?php 
				// Channel Title
				if ( $kl_params['chtitle'] ) {
				?>
<h3<?php echo $class; ?>-title"><a href="<?php echo $currChannel->getLink(); ?>" target="_child"><?php $text 	= html_entity_decode( $currChannel->getTitle() );echo str_replace('&apos;', "'", $text); ?></a></h3>
				<?php
				}
				?>
				<?php 
				// feed description
				if ( $descrip && $kl_params['chdesc'] ) {
				?>

	<p><?php  
			$text 	= html_entity_decode( $currChannel->getDescription() );
			echo str_replace('&apos;', "'", $text);
	?></p>
				<?php
				}
				// feed image
				if ( $iUrl && $kl_params['image'] ) {
				?>
<image src="<?php echo $iUrl; ?>" alt="<?php echo $iTitle; ?>" />
				<?php
				}
				$actualItems 	= $currChannel->getItemCount() - ($kl_params['item_one']);
				$setItems 		= $kl_params['items'];
				if ( $setItems > $actualItems ) {
					$totalItems = $actualItems;
				} else {
					$totalItems = $setItems;
				}
				$totalItems+= ($kl_params['item_one']);
				?>
				
<ul<?php echo $class; ?>-ul">
<?php
for ( $j = 0; $j < $totalItems; $j++ ) {
	if ( $j < $kl_params['item_one'] ) {
		continue;
	}
	$currItem =& $currChannel->getItem($j);
	if ( $kl_params['itemsrc'] ) {
		print $currItem->toNormalizedString(1,1);
	}
?>
	<li<?php echo $class; ?>-li">
		<?php 
		// Title
		if ( $kl_params['title'] ) {
		?>
<h4<?php echo $class; ?>-item_title"><strong><a href="<?php echo $currItem->getLink(); ?>" target="_child">
		<?php 
		$text 	= html_entity_decode( $currItem->getTitle() );
		echo str_replace('&apos;', "'", $text);
		?></a></strong></h4>
		<?php
		}
		?>
		<?php 
		// item description
		if ( $kl_params['desc'] ) {
			$text	= html_entity_decode( $currItem->getDescription() );
			$text = html_entity_decode(str_replace('&apos;', "'", $text));
			$num 	= $kl_params['word_count'];
			// word limit check
			if ( $num ) {
				$texts = explode( ' ', $text );
				$count = count( $texts );
				if ( $count > $num ) {
					$text = '';
					for( $i=0; $i < $num; $i++ ) {
						$text .= ' '. $texts[$i];
					}
					$text .= '...';
				}
			}
		?>                                                                                                               
<p><?php echo $text; ?></p>				
		<?php
		}
		?>
	</li>
<?php
}
?>
</ul>

		<?php
			}
		?>
		<!-- </div> -->
<?php

}
?>