<?php
	/**
		*	mambo Silex Video class
		*
		* @package Silex Video
		* @copyright (C) 2004 by Christophe Guegan
		* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
		* 
		**/
/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
* @package com_silexvideo
*/
class mosSilexVideoType extends mosDBTable {
	var	$id 							= null;		/* @var int uid of the video type */
	var $name 						= "";
	var $type 						= "";
	var $description			= "";
	var $code 						= "";
	var $checked_out			= 0;
	var $checked_out_time	= "0000-00-00 00:00:00";
	
	function mosSilexVideoType( &$_db ) {
		$this->mosDBTable( '#__silexvideo_types', 'id', $_db );
	}
	
	function check() {
		// check for valid type extention
		if (trim($this->type == "")) {
			$this->_error = _VID_NOTYPE;
			return false;
		}
		// check for valid tname
		if (trim($this->name == "")) {
			$this->_error = _VID_NONAME;
			return false;
		}
		
		return true;
	}
}

/**
* @package com_silexvideo
*/
class mosSilexVideo extends mosDBTable {
	var $id								= null;
	var $type_id					= null;
	var $title						= "";
	var $name							= "";
	var $description			= "";
	var $file_name				= "";
	var $width						= null;
	var $height						= null;
	var $date							= "";
	var $checked_out			= 0;
	var $checked_out_time	= "000-00-00 00:00:00";
	var $published				= 0;
	
	function mosSilexVideo( &$_db ) {
		$this->mosDBTable( '#__silexvideos', 'id', $_db );
		$this->set("date",date("Y-m-d G:i:s"));
	}
	
	function check() {
		// check for valid type id
		if (is_null($this->type_id) || $this->type_id == 0) {
			$this->_error = _VID_NOTYPE;
			return false;
		}
		
		if(trim($this->name) == "") {
			$this->_error = _VID_NAME;
			return false;
		}
		
		return true;
	}
}
?>