<?php

/**

* SEF advance component extension

*

* This extension will give the SEF advance style URLs to the example component

* Place this file (sef_ext.php) in the main component directory

* Note that class must be named: sef_componentname

*

* Copyright (C) 2003-2004 Emir Sakic, http://www.sakic.net, All rights reserved.

*

* Comments: for SEF advance > v3.6

**/



class sef_example {



	/**

	* Creates the SEF advance URL out of the Mambo request

	* Input: $string, string, The request URL (index.php?option=com_example&Itemid=$Itemid)

	* Output: $sefstring, string, SEF advance URL ($var1/$var2/)

	**/

	function create ($string) {

		// $string == "index.php?option=com_example&Itemid=$Itemid&var1=$var1&var2=$var2"

		$sefstring = "";

		if (eregi("&amp;var1=",$string)) {

			$temp = split("&amp;var1=", $string);

			$temp = split("&", $temp[1]);

			$sefstring .= $temp[0]."/";

		}

		if (eregi("&amp;var2=",$string)) {

			$temp = split("&amp;var2=", $string);

			$temp = split("&", $temp[1]);

			$sefstring .= $temp[0]."/";

		}

		// $sefstring == "$var1/$var2/"

		return $sefstring;

	}



	/**

	* Reverts to the Mambo query string out of the SEF advance URL

	* Input:

	*    $url_array, array, The SEF advance URL split in arrays (first custom virtual directory beginning at $pos+1)

	*    $pos, int, The position of the first virtual directory (component)

	* Output: $QUERY_STRING, string, Mambo query string (var1=$var1&var2=$var2)

	*    Note that this will be added to already defined first part (option=com_example&Itemid=$Itemid)

	**/

	function revert ($url_array, $pos) {

		// define all variables you pass as globals

		global $var1, $var2;

 		// Examine the SEF advance URL and extract the variables building the query string

		$QUERY_STRING = "";

		if (isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {

			// component/example/$var1/

			$var1 = $url_array[$pos+2];

			$_GET['var1'] = $var1;

			$_REQUEST['var1'] = $var1;

			$QUERY_STRING .= "&var1=$var1";

		}

		if (isset($url_array[$pos+3]) && $url_array[$pos+3]!="") {

			// component/example/$var1/$var2/

			$var2 = $url_array[$pos+3];

			$_GET['var2'] = $var2;

			$_REQUEST['var2'] = $var2;

			$QUERY_STRING .= "&var2=$var2";

		}

		// $QUERY_STRING == "var1=$var1&var2=$var2";

		return $QUERY_STRING;

	}



}

?>