<?php
/*
SEF advance
Copyright (C) 2003-2005 Emir Sakic
v 4.2.2 (commercial)
Comments: for Mambo v 4.5

Licensed to: raunak.org
*/

/* ----- CONFIGURATIONS - Used for 4.5.0 only ----- */

// content strings
$_SEF_BLOGSECTION = "blogsection";
$_SEF_BLOGCATEGORY = "blogcategory";
$_SEF_ARCHIVESECTION = "archivesection";
$_SEF_ARCHIVECATEGORY = "archivecategory";
// component strings
$_SEF_FRONTPAGE = "frontpage";
$_SEF_WEBLINKS = "weblinks";
$_SEF_POLL = "poll";
$_SEF_BANNERS = "banners";
$_SEF_CONTACT = "contact";
$_SEF_LOGIN = "login";
$_SEF_SEARCH = "search";
$_SEF_NEWSFEEDS = "newsfeeds";
$_SEF_WRAPPER = "wrapper";
// custom components with extension
$custom_comp = array(
	"customcomp" => "cc"
);
// URL settings
$_SEF_SPACE = "_";					// divide words with underscores
									// can be changed to a hyphen "-"
$sufix = "";						// specify a sufix like .html
									// leave empty for directory like URL
$longurl = 1;						// 0 shorter URLs (by title)
									// 1 longer URLs (by name)
$lowercase = 0;						// 1 URL in lower case
									// 0 no change
$homeroot = 1;						// Home menu URL preferance
									// 0 Home links to "frontpage/"
									// 1 Home links to root
$uniqitem = 0;						// append creation date and id
									// to make items more unique
									// and Google news friendly
// custom 404 page
$custom404 = "";					// specify a custom 404 not found page
									// leave empty for homepage

// url replace
									// specify the special chars for replace rather than url encode
$url_replace = array(
	"" => "aa"
);
									// specify the chars you want excepted from url encode function
$url_exception = array("?","!");
									// specify the alias pairs
$url_alias = array(
	"index.php?option=com_content&task=view&id=4&Itemid=9" => "Newsflash_3"
);

/* ------------ NO CHANGES BELOW THIS LINE ------------- */
$sef_debug = 0;
if ($mosConfig_sef) {

	$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );

	$database->setQuery("SHOW TABLES LIKE '%sef_config'");
	$result = $database->loadResult();

	if ($result != "") {
		// read configuration
		$database->setQuery("SELECT * FROM #__sef_config LIMIT 1");
		$rows = $database->loadObjectList();
		$row = $rows[0];
		// content strings
		$_SEF_BLOGSECTION = "$row->blogsection";
		$_SEF_BLOGCATEGORY = "$row->blogcategory";
		$_SEF_ARCHIVESECTION = "$row->archivesection";
		$_SEF_ARCHIVECATEGORY = "$row->archivecategory";
		// component strings
		$_SEF_FRONTPAGE = "$row->frontpage";
		$_SEF_WEBLINKS = "$row->weblinks";
		$_SEF_POLL = "$row->poll";
		$_SEF_BANNERS = "$row->banners";
		$_SEF_CONTACT = "$row->contact";
		$_SEF_LOGIN = "$row->login";
		$_SEF_SEARCH = "$row->search";
		$_SEF_NEWSFEEDS = "$row->newsfeeds";
		$_SEF_WRAPPER = "$row->wrapper";
		// custom components with extension
		$custom_comp = array();
		$pairs = split(",", $row->custom_comp);
		foreach($pairs as $pair) {
			if (ereg("=>",$pair)) {
				$name = split("=>", $pair);
				$custom_comp[trim($name[0])] = trim($name[1]);
			}
		}
		// URL settings
		$_SEF_SPACE = "$row->space";
		$sufix = "$row->sufix";
		$longurl = $row->longurl;
		$lowercase = $row->lowercase;
		$homeroot = $row->homeroot;
		$uniqitem = $row->uniqitem;
		$sef_debug = $row->debug;
		// custom 404 page
		$custom404 = "$row->custom404";
		// url replace
		$url_replace = array();
		$pairs = split(",", $row->url_replace);
		foreach($pairs as $pair) {
			if (ereg("=>",$pair)) {
				$char = split("=>", $pair);
				$url_replace[trim($char[0])] = trim($char[1]);
			}
		}
		$url_exception = array();
		$char = split(",", $row->url_exception);
		foreach($char as $value) {
			$url_exception[] = $value;
		}
	}

	$database->setQuery("SHOW TABLES LIKE '%sef_alias'");
	$result = $database->loadResult();

	if ($result != "") {
		// read aliases
		$url_alias = array();
		$database->setQuery("SELECT * FROM #__sef_alias WHERE published='1'");
		$rows = $database->loadObjectList();
		foreach ($rows as $row) {
			$url_alias[$row->non_sef_url] = $row->alias;
		}
	}

	// content strings
	define("_SEF_BLOGSECTION", "$_SEF_BLOGSECTION");
	define("_SEF_BLOGCATEGORY", "$_SEF_BLOGCATEGORY");
	define("_SEF_ARCHIVESECTION", "$_SEF_ARCHIVESECTION");
	define("_SEF_ARCHIVECATEGORY", "$_SEF_ARCHIVECATEGORY");
	// component strings
	define("_SEF_FRONTPAGE", "$_SEF_FRONTPAGE");
	define("_SEF_WEBLINKS", "$_SEF_WEBLINKS");
	define("_SEF_POLL", "$_SEF_POLL");
	define("_SEF_BANNERS", "$_SEF_BANNERS");
	define("_SEF_CONTACT", "$_SEF_CONTACT");
	define("_SEF_LOGIN", "$_SEF_LOGIN");
	define("_SEF_SEARCH", "$_SEF_SEARCH");
	define("_SEF_NEWSFEEDS", "$_SEF_NEWSFEEDS");
	define("_SEF_WRAPPER", "$_SEF_WRAPPER");
	// URL settings
	define("_SEF_SPACE", "$_SEF_SPACE");

	if ($longurl) {
		$whereurl = "name";
		$whereitem = "title";
	} else {
		$whereurl = "title";
		$whereitem = "title_alias";
	}

	if ($custom404 == "") {
		$custom404 = "$mosConfig_live_site";
	}

	// Check license
	// Redirect if trailing slash not present
	if (substr($_SERVER['REQUEST_URI'],-1) != "/" &&
		substr($_SERVER['REQUEST_URI'],-strlen($sufix)) != $sufix &&
		!eregi("\.", $_SERVER['REQUEST_URI'])) {
		header("HTTP/1.0 301 Moved Permanently");
		header("Location: " . $_SERVER['REQUEST_URI'] . "/");
		die;
	}

	// Replace the sufix with the trailing slash
	if ($sufix != "") {
		$_SERVER['REQUEST_URI'] = str_replace($sufix, "/", $_SERVER['REQUEST_URI']);
	}

	$url_array = explode("/", $_SERVER['REQUEST_URI']);
	//echo "<pre>\n"; print_r ($url_array); echo "</pre>\n"; exit;

	// Check Mambo version
	if (defined("_RELEASE") && _RELEASE=="4.5" && defined("_DEV_LEVEL") && !is_numeric("_DEV_LEVEL")) {
		$mambo_version = "4.5.0";
	} else {
		// 4.5.1, 4.5.2 or Joomla 1.x
		$mambo_version = "4.5.x";
	}

	/* Determine the type of the content out of the URL */
	$pos = 0;
	$rel_uri = str_replace("/index.php", "", $_SERVER['PHP_SELF']);
	if (substr($rel_uri, 0, 1)=="/") {
		$rel_uri = substr($rel_uri, 1);
		$rel_uri_array = split("/", $rel_uri);
		$rel_uri = $rel_uri_array[count($rel_uri_array)-1];
		$pos = array_search ($rel_uri, $url_array);
		if (!$pos) $pos = 0;
	}

	$component_name = $url_array[$pos+1];

	// Detect built-in SEF links
	if ($component_name=="content" || $component_name=="component") {
		process_old($_SERVER['REQUEST_URI']);
	}

	// fix for option not being on the first place in some custom components
	if ( eregi("option,", $_SERVER['REQUEST_URI']) ) {
		// custom component
		if ( !eregi("option,", $url_array[$pos+1]) ) {
			// option not in the first one
			foreach ($url_array as $value) {
				if (eregi("option,", $value)) {
					$component_name = $value;
					break;
				}
			}
		}
	}

	// replace for custom components with extensions
	if (in_array($component_name, $custom_comp)) {
		$component_name = array_search($component_name, $custom_comp);
	}

	$core_component = 0;
	$custom_component = 0;
	$extension_component = 0;

	if ($component_name==_SEF_FRONTPAGE
			|| $component_name==_SEF_WEBLINKS
			|| $component_name==_SEF_POLL
			|| $component_name==_SEF_BANNERS
			|| $component_name==_SEF_CONTACT
			|| $component_name==_SEF_LOGIN
			|| $component_name==_SEF_SEARCH
			|| $component_name==_SEF_NEWSFEEDS
			|| $component_name==_SEF_WRAPPER) {
		$core_component = 1;
	} else if (eregi("option,com_", $component_name)) {
		$custom_component = 1;
	} else if (component_id($component_name)) {
		$extension_component = 1;
	}

	// Handle alias
	$alias_string = "";
	if (isset($url_array[$pos+1]) && $url_array[$pos+1]!="") {
		$uri = explode($url_array[$pos+1], $_SERVER['REQUEST_URI']);
		$alias = $url_array[$pos+1].$uri[1];
		if (substr($alias, -1)=="/") {
			$alias = substr($alias, 0, strlen($alias)-1);
		}
		if (in_array($alias, $url_alias)) {
			$alias_string = array_search($alias, $url_alias);
		}
	}
	if ($alias_string != "") {
		/*
		Alias
		*/

		$uri = explode($alias, $_SERVER['REQUEST_URI']);

		$alias_string = str_replace( '&amp;', '&', $alias_string );
		$temp = split("\?", $alias_string);
		$QUERY_STRING = $temp[1];

		$temp = split("&", $QUERY_STRING);
		foreach($temp as $pair) {
			$temp2 = split("=", $pair);
			$key = $temp2[0];
			$value = $temp2[1];
			$GLOBALS[$key] = $value;
			$_GET[$key] = $value;
			$_REQUEST[$key] = $value;
		}

		$_SERVER['QUERY_STRING'] = $QUERY_STRING;
		$REQUEST_URI = $uri[0]."index.php?".$QUERY_STRING;
		$_SERVER['REQUEST_URI'] = $REQUEST_URI;

	} else if ($core_component || $custom_component || $extension_component) {
		/*
		Components
		$name/xxxx
		*/

		// Core components
		if ($core_component) {
			// components/$option/

			$uri = explode("$component_name/", $_SERVER['REQUEST_URI']);

			// Replace core component names
			if ($component_name==_SEF_FRONTPAGE) {
				$component_name = "frontpage";
			} else if ($component_name==_SEF_WEBLINKS) {
				$component_name = "weblinks";
			} else if ($component_name==_SEF_POLL) {
				$component_name = "poll";
			} else if ($component_name==_SEF_BANNERS) {
				$component_name = "banners";
			} else if ($component_name==_SEF_CONTACT) {
				$component_name = "contact";
			} else if ($component_name==_SEF_LOGIN) {
				$component_name = "login";
			} else if ($component_name==_SEF_SEARCH) {
				$component_name = "search";
			} else if ($component_name==_SEF_NEWSFEEDS) {
				$component_name = "newsfeeds";
			} else if ($component_name==_SEF_WRAPPER) {
				$component_name = "wrapper";
			}
			$option = "com_".$component_name;
			$_GET['option'] = $option;
			$_REQUEST['option'] = $option;
			$database->setQuery("SELECT id "
			."FROM #__menu "
			."WHERE link = 'index.php?option=$option' AND published=1 ORDER BY access");
			$Itemid = $database->loadResult();
			$_GET['Itemid'] = $Itemid;
			$_REQUEST['Itemid'] = $Itemid;
			$QUERY_STRING = "option=$option&Itemid=$Itemid";

			// Frontpage
			if ($component_name=="frontpage" &&
				isset($url_array[$pos+2]) && $url_array[$pos+2]!="" &&
				isset($url_array[$pos+3]) && $url_array[$pos+3]!="") {
				// frontpage/$limit/$limitstart
				$limit = $url_array[$pos+2];
				$limitstart = $url_array[$pos+3];
				$_GET['limit'] = $limit;
				$_REQUEST['limit'] = $limit;
				$_GET['limitstart'] = $limitstart;
				$_REQUEST['limitstart'] = $limitstart;
				$QUERY_STRING .= "&limit=$limit&limitstart=$limitstart";
			}
			// Weblinks
			if ($component_name=="weblinks" && isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {
				$catname = sefdecode($url_array[$pos+2]);
				$database->setQuery("SELECT id "
				."FROM #__categories "
				."WHERE $whereurl='$catname' AND section='com_weblinks'");
				$catid = $database->loadResult();
				$_GET['catid'] = $catid;
				$_REQUEST['catid'] = $catid;
				$QUERY_STRING .= "&catid=$catid";
			}
			if ($component_name=="weblinks" && isset($url_array[$pos+3]) && $url_array[$pos+3]!="") {
				$task = "view";
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$title = sefdecode($url_array[$pos+3]);
				$database->setQuery("SELECT id "
				."FROM #__weblinks "
				."WHERE title='$title'");
				$id = $database->loadResult();
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$QUERY_STRING .= "&task=$task&id=$id";
			}
			// Poll
			if ($component_name=="poll" && isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {
				$task = "results";
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$title = sefdecode($url_array[$pos+2]);
				$database->setQuery("SELECT id "
				."FROM #__polls "
				."WHERE title='$title'");
				$id = $database->loadResult();
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$QUERY_STRING .= "&task=$task&id=$id";
			}
			// Banners
			if ($component_name=="banners" && isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {
				$task = "click";
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$name = sefdecode($url_array[$pos+2]);
				$database->setQuery("SELECT bid "
				."FROM #__banner "
				."WHERE name='$name'");
				$bid = $database->loadResult();
				$_GET['bid'] = $bid;
				$_REQUEST['bid'] = $bid;
				$QUERY_STRING .= "&task=$task&bid=$bid";
			}
			// Contact
			if ($component_name=="contact" && isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {
				if ($mambo_version == "4.5.0") {
					$name = sefdecode($url_array[$pos+2]);
					$database->setQuery("SELECT id "
					."FROM #__contact_details "
					."WHERE name='$name'");
					$contact_id = $database->loadResult();
					$_GET['contact_id'] = $contact_id;
					$_REQUEST['contact_id'] = $contact_id;
					$QUERY_STRING .= "&contact_id=$contact_id";
				} else {
					$name = sefdecode($url_array[$pos+2]);
					$database->setQuery("SELECT id "
					."FROM #__categories "
					."WHERE name='$name' AND section='com_contact_details'");
					$catid = $database->loadResult();
					if ($catid!="") {
						$_GET['catid'] = $catid;
						$_REQUEST['catid'] = $catid;
						$QUERY_STRING .= "&catid=$catid";
						$database->setQuery("SELECT id "
							."FROM #__menu "
							."WHERE link = 'index.php?option=$option&catid=$catid'");
						$_Itemid = $database->loadResult();
						if ($_Itemid != "") {
							$Itemid = $_Itemid;
							$_GET['Itemid'] = $Itemid;
							$_REQUEST['Itemid'] = $Itemid;
							$QUERY_STRING = "option=$option&Itemid=$Itemid";
						}
					} else {
						$task = "view";
						$_GET['task'] = $task;
						$_REQUEST['task'] = $task;
						$database->setQuery("SELECT id "
						."FROM #__contact_details "
						."WHERE name='$name'");
						$contact_id = $database->loadResult();
						$_GET['contact_id'] = $contact_id;
						$_REQUEST['contact_id'] = $contact_id;
						$QUERY_STRING .= "&task=$task&contact_id=$contact_id";
						$database->setQuery("SELECT id "
							."FROM #__menu "
							."WHERE link = 'index.php?option=$option&task=$task&contact_id=$contact_id'");
						$_Itemid = $database->loadResult();
						if ($_Itemid != "") {
							$Itemid = $_Itemid;
							$_GET['Itemid'] = $Itemid;
							$_REQUEST['Itemid'] = $Itemid;
							$QUERY_STRING = "option=$option&Itemid=$Itemid";
						}
					}
				}
			}
			// Newsfeeds
			if ($component_name=="newsfeeds" && isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {
				if ($url_array[$pos+2]=="view") {
					$task = $url_array[$pos+2];
					$_GET['task'] = $task;
					$_REQUEST['task'] = $task;
					$QUERY_STRING .= "&task=$task";
					if (isset($url_array[$pos+3]) && $url_array[$pos+3]!="") {
						$name = sefdecode($url_array[$pos+3]);
						$database->setQuery("SELECT id "
						."FROM #__newsfeeds "
						."WHERE name='$name' AND published='1'");
						$feedid = $database->loadResult();
						$_GET['feedid'] = $feedid;
						$_REQUEST['feedid'] = $feedid;
						$QUERY_STRING .= "&feedid=$feedid";
					}
				} else {
					$name = sefdecode($url_array[$pos+2]);
					$database->setQuery("SELECT id "
					."FROM #__categories "
					."WHERE name='$name' AND section='com_newsfeeds'");
					$catid = $database->loadResult();
					$_GET['catid'] = $catid;
					$_REQUEST['catid'] = $catid;
					$QUERY_STRING .= "&catid=$catid";
				}
			}
			// Wrapper
			if ($component_name=="wrapper" && isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {
				$name = sefdecode($url_array[$pos+2]);
				$database->setQuery("SELECT id "
					."FROM #__menu "
					."WHERE name='$name' AND type='wrapper'");
				$Itemid = $database->loadResult();
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$QUERY_STRING = "option=$option&Itemid=$Itemid";
			}
		// API for custom component extension
		} else if (@file_exists("components/com_".$component_name."/sef_ext.php")) {
			$uri = explode($url_array[$pos+1]."/", $_SERVER['REQUEST_URI']);
			$option = "com_".$component_name;
			$_GET['option'] = $option;
			$_REQUEST['option'] = $option;
			$database->setQuery("SELECT id "
			."FROM #__menu "
			."WHERE link='index.php?option=$option'");
			$Itemid = $database->loadResult();
			$_GET['Itemid'] = $Itemid;
			$_REQUEST['Itemid'] = $Itemid;
			$QUERY_STRING = "option=$option&Itemid=$Itemid";
			include_once ("components/com_".$component_name."/sef_ext.php");
			$class_name = "sef_".$component_name;
			$sef_ext = new $class_name();
			$QUERY_STRING .= $sef_ext->revert($url_array, $pos);
		// Custom components
		} else {
			$uri_array1[] = $url_array[$pos+1];
			$uri = explode($url_array[$pos+1]."/", $_SERVER['REQUEST_URI']);
			$uri_array2 = explode("/", $uri[1]);
			$uri_array = array_merge($uri_array1,$uri_array2);

			$QUERY_STRING = "";
			foreach($uri_array as $value) {
				$temp = explode(",", $value);
				if (isset($temp[0]) && $temp[0]!="" && isset($temp[1]) && $temp[1]!="") {
					$_GET[$temp[0]] = $temp[1];
					$_REQUEST[$temp[0]] = $temp[1];
					$QUERY_STRING .= $temp[0]=="option" ? "$temp[0]=$temp[1]" : "&$temp[0]=$temp[1]";
				}
			}
			// custom 404 redirect for not found component
			if ($QUERY_STRING=="") {
				handle404();
				exit;
			}
		}

		$_SERVER['QUERY_STRING'] = $QUERY_STRING;
		$REQUEST_URI = $uri[0]."index.php?".$QUERY_STRING;
		$_SERVER['REQUEST_URI'] = $REQUEST_URI;

	} else if (!eregi("\.php", $_SERVER['REQUEST_URI']) && empty($_REQUEST['option'])) {
		/*
		Content
		Section_Name/Category_Name/Item_Name/
		*/

		$uri = explode($url_array[$pos+1]."/", $_SERVER['REQUEST_URI']);
		if ($mambo_version == "4.5.0") {
			$option = "content";
		} else {
			$option = "com_content";
		}
		$_GET['option'] = $option;
		$_REQUEST['option'] = $option;

		if (isset($url_array[$pos+4]) && $url_array[$pos+4]!="") {
			if ($url_array[$pos+1]==_SEF_BLOGSECTION || $url_array[$pos+1]==_SEF_BLOGCATEGORY) {
				if ($mambo_version == "4.5.0") {
					// Mambo 4.5.0
					// blogsection/Section_Name/$count/$intro
					$task = $url_array[$pos+1]==_SEF_BLOGSECTION ? "blogsection" : "blogcategory";
					$blog_name = $url_array[$pos+2];
					if ($task=="blogsection") {
						$blog_name = sefdecode($blog_name);
						if ($blog_name == "0") {
							$id = 0;
						} else {
							$database->setQuery("SELECT id "
							."FROM #__sections "
							."WHERE $whereurl='$blog_name'");
							$id = $database->loadResult();
						}
					} else {
						$blog_name = sefdecode($blog_name);
						$database->setQuery("SELECT id "
						."FROM #__categories "
						."WHERE $whereurl='$blog_name' AND LEFT(section, 4)<>'com_'");
						$id = $database->loadResult();
					}
					$where_type = $task=="blogsection" ? "content_blog_section" : "content_blog_category";
					$database->setQuery("SELECT id "
					."FROM #__menu "
					."WHERE type = '$where_type' AND componentid='$id'");
					$Itemid = $database->loadResult();
					$count = $url_array[$pos+3];
					$intro = $url_array[$pos+4];
					$_GET['task'] = $task;
					$_REQUEST['task'] = $task;
					$_GET['id'] = $id;
					$_REQUEST['id'] = $id;
					$_GET['Itemid'] = $Itemid;
					$_REQUEST['Itemid'] = $Itemid;
					$_GET['count'] = $count;
					$_REQUEST['count'] = $count;
					$_GET['intro'] = $intro;
					$_REQUEST['intro'] = $intro;
					$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid&count=$count&intro=$intro";
				} else {
					// Mambo 4.5.1
					// blogsection/Section_Name/$limit/$limitstart
					$task = $url_array[$pos+1]==_SEF_BLOGSECTION ? "blogsection" : "blogcategory";
					$blog_name = $url_array[$pos+2];
					if ($task=="blogsection") {
						$blog_name = sefdecode($blog_name);
						if ($blog_name == "0") {
							$id = 0;
						} else {
							$database->setQuery("SELECT id "
							."FROM #__sections "
							."WHERE $whereurl='$blog_name'");
							$id = $database->loadResult();
						}
					} else {
						$blog_name = sefdecode($blog_name);
						$database->setQuery("SELECT id "
						."FROM #__categories "
						."WHERE $whereurl='$blog_name' AND LEFT(section, 4)<>'com_'");
						$id = $database->loadResult();
					}
					$where_type = $task=="blogsection" ? "content_blog_section" : "content_blog_category";
					$database->setQuery("SELECT id "
					."FROM #__menu "
					."WHERE type = '$where_type' AND componentid='$id'");
					$Itemid = $database->loadResult();
					$limit = $url_array[$pos+3];
					$limitstart = $url_array[$pos+4];
					$_GET['task'] = $task;
					$_REQUEST['task'] = $task;
					$_GET['id'] = $id;
					$_REQUEST['id'] = $id;
					$_GET['Itemid'] = $Itemid;
					$_REQUEST['Itemid'] = $Itemid;
					$_GET['limit'] = $limit;
					$_REQUEST['limit'] = $limit;
					$_GET['limitstart'] = $limitstart;
					$_REQUEST['limitstart'] = $limitstart;
					$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
				}
			} else {
				$temp = sefdecode($url_array[$pos+3]);
				if (is_numeric($temp)) {
					// Section_Name/Category_Name/$limit/$limitstart
					$task = "category";
					$limit = sefdecode($url_array[$pos+3]);
					$limitstart = $url_array[$pos+4];
					$section_name = sefdecode($url_array[$pos+1]);
					$database->setQuery("SELECT id "
					."FROM #__sections "
					."WHERE $whereurl='$section_name'");
					$sectionid = $database->loadResult();
					$category_name = $url_array[$pos+2];
					$category_name = sefdecode($category_name);
					$database->setQuery("SELECT id "
					."FROM #__categories "
					."WHERE $whereurl='$category_name'");
					$id = $database->loadResult();
					$database->setQuery("SELECT m.id "
					."FROM #__sections AS s "
					."LEFT JOIN #__menu AS m "
					."ON m.componentid=s.id "
					."WHERE m.type='content_section' AND s.id='$sectionid' AND m.published=1");
					$Itemid = $database->loadResult();
					if ($Itemid=="") {
						// category directly linked
						$database->setQuery("SELECT sectionid, catid "
						."FROM #__content "
						."WHERE id='$id'");
						$result = $database->loadObjectList();
						$row = $result[0];
						$database->setQuery("SELECT id "
						."FROM #__menu "
						."WHERE link='index.php?option=$option&task=category&sectionid=$row->sectionid&id=$row->catid'");
						$Itemid = $database->loadResult();
					}
					$_GET['task'] = $task;
					$_REQUEST['task'] = $task;
					$_GET['sectionid'] = $sectionid;
					$_REQUEST['sectionid'] = $sectionid;
					$_GET['id'] = $id;
					$_REQUEST['id'] = $id;
					$_GET['Itemid'] = $Itemid;
					$_REQUEST['Itemid'] = $Itemid;
					$_GET['limit'] = $limit;
					$_REQUEST['limit'] = $limit;
					$_GET['limitstart'] = $limitstart;
					$_REQUEST['limitstart'] = $limitstart;
					$QUERY_STRING = "option=$option&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
				} else {
					// Section_Name/Category_Name/Item_Name/$limitstart
					$task = "view";
					$item_name = sefdecode($url_array[$pos+3]);
					if ($uniqitem) {
						// YYYYMMDDID
						$temp = split(" ", $item_name);
						$dateid = $temp[count($temp)-1];
						$id = (int) substr($dateid, 8, 4);
					} else {
						$query = "SELECT id "
							."FROM #__content "
							."WHERE $whereitem='$item_name' AND state > 0";
						$database->setQuery($query);

						$database->query();
						if ($database->getNumRows() > 1) {
							// have items with same names in different categories
							$section_name = sefdecode($url_array[$pos+1]);
							$database->setQuery("SELECT id "
								."FROM #__sections "
								."WHERE $whereurl='$section_name'");
							$sectionid = $database->loadResult();

							$category_name = sefdecode($url_array[$pos+2]);
							$database->setQuery("SELECT id "
								."FROM #__categories "
								."WHERE $whereurl='$category_name' "
								."AND section='$sectionid'");
							$categoryid = $database->loadResult();

							$query = "SELECT id "
								."FROM #__content "
								."WHERE $whereitem='$item_name' "
								."AND sectionid='$sectionid' "
								."AND catid='$categoryid' "
								."ORDER BY state DESC";
							$database->setQuery($query);
						}
						$id = $database->loadResult();
					}
					$limit = 1;
					$limitstart = $url_array[$pos+4];
					$Itemid = sefgetItemid ($id, $option);
					$_GET['task'] = $task;
					$_REQUEST['task'] = $task;
					$_GET['id'] = $id;
					$_REQUEST['id'] = $id;
					$_GET['Itemid'] = $Itemid;
					$_REQUEST['Itemid'] = $Itemid;
					$_GET['limit'] = $limit;
					$_REQUEST['limit'] = $limit;
					$_GET['limitstart'] = $limitstart;
					$_REQUEST['limitstart'] = $limitstart;
					$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
				}
			}
		} else if (!(isset($url_array[$pos+4]) && $url_array[$pos+4]!="") && isset($url_array[$pos+3]) && $url_array[$pos+3]!="") {
			if ($url_array[$pos+1]==_SEF_ARCHIVECATEGORY) {
				// archivecategory/2004/05/
				$task = "archivecategory";
				$year = $url_array[$pos+2];
				$month = $url_array[$pos+3];
				$module = 1;
				$id = 0;	// to avoid 404 redirect
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['year'] = $year;
				$_REQUEST['year'] = $year;
				$_GET['month'] = $month;
				$_REQUEST['month'] = $month;
				$_GET['module'] = $module;
				$_REQUEST['module'] = $module;
				$QUERY_STRING = "option=$option&task=$task&year=$year&month=$month&module=$module";
			} else {
				// Section_Name/Category_Name/Item_Name
				$task = "view";
				$item_name = sefdecode($url_array[$pos+3]);
				if ($uniqitem) {
					// YYYYMMDDID
					$temp = split(" ", $item_name);
					$dateid = $temp[count($temp)-1];
					$id = (int) substr($dateid, 8, 4);
				} else {
					$query = "SELECT id "
						."FROM #__content "
						."WHERE $whereitem='$item_name' AND state > 0";
					$database->setQuery($query);

					$database->query();
					if ($database->getNumRows() > 1) {
						// have items with same names in different categories
						$section_name = sefdecode($url_array[$pos+1]);
						$database->setQuery("SELECT id "
							."FROM #__sections "
							."WHERE $whereurl='$section_name'");
						$sectionid = $database->loadResult();

						$category_name = sefdecode($url_array[$pos+2]);
						$database->setQuery("SELECT id "
							."FROM #__categories "
							."WHERE $whereurl='$category_name' "
							."AND section='$sectionid'");
						$categoryid = $database->loadResult();

						$query = "SELECT id "
							."FROM #__content "
							."WHERE $whereitem='$item_name' "
							."AND sectionid='$sectionid' "
							."AND catid='$categoryid' "
							."ORDER BY state DESC";
						$database->setQuery($query);
					}
					$id = $database->loadResult();
				}
				$Itemid = sefgetItemid ($id, $option);
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid";
			}
		} else if (!(isset($url_array[$pos+3]) && $url_array[$pos+3]!="") && isset($url_array[$pos+2]) && $url_array[$pos+2]!="") {
			$name = sefdecode($url_array[$pos+1]);
			if ($id = static_id($name) && is_numeric($url_array[$pos+2])) {
				// Item_Name/$limitstart
				$task = "view";
				if ($whereurl=="name") {
					$database->setQuery("SELECT id "
					."FROM #__content "
					."WHERE title='$name' ORDER BY state DESC");
				} else {
					$database->setQuery("SELECT c.id AS id "
					."FROM #__content AS c "
					."LEFT JOIN #__menu AS m "
					."ON m.componentid=c.id "
					."WHERE m.name='$name' ORDER BY c.state DESC");
				}
				$id = $database->loadResult();
				$limit = 1;
				$limitstart = $url_array[$pos+2];
				$database->setQuery("SELECT id "
				."FROM #__menu "
				."WHERE type = 'content_typed' AND componentid='$id' AND (published='1' OR published='0') ORDER BY id");
				$Itemid = $database->loadResult();
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$_GET['limit'] = $limit;
				$_REQUEST['limit'] = $limit;
				$_GET['limitstart'] = $limitstart;
				$_REQUEST['limitstart'] = $limitstart;
				$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
			} else if ($url_array[$pos+1]==_SEF_BLOGSECTION || $url_array[$pos+1]==_SEF_BLOGCATEGORY) {
				// blogsection/Section_Name
				$task = $url_array[$pos+1]==_SEF_BLOGSECTION ? "blogsection" : "blogcategory";
				$blog_name = $url_array[$pos+2];
				if ($task=="blogsection") {
					$blog_name = sefdecode($blog_name);
					if ($blog_name == "0") {
						$id = 0;
					} else {
						$database->setQuery("SELECT id "
						."FROM #__sections "
						."WHERE $whereurl='$blog_name'");
						$id = $database->loadResult();
					}
				} else {
					$blog_name = sefdecode($blog_name);
					if ($blog_name == "0") {
						$id = 0;
					} else {
						$database->setQuery("SELECT id "
						."FROM #__categories "
						."WHERE $whereurl='$blog_name' AND LEFT(section, 4)<>'com_'");
						$id = $database->loadResult();
					}
				}
				$where_type = $task=="blogsection" ? "content_blog_section" : "content_blog_category";
				$database->setQuery("SELECT id "
				."FROM #__menu "
				."WHERE type = '$where_type' AND componentid='$id'");
				$Itemid = $database->loadResult();
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid";
			} else if ($url_array[$pos+1]==_SEF_ARCHIVESECTION || $url_array[$pos+1]==_SEF_ARCHIVECATEGORY) {
				// archivesection/Section_Name
				$task = $url_array[$pos+1]==_SEF_ARCHIVESECTION ? "archivesection" : "archivecategory";
				$archive_name = $url_array[$pos+2];
				if ($task=="archivesection") {
					$archive_name = sefdecode($archive_name);
					if ($archive_name == "0") {
						$id = 0;
					} else {
						$database->setQuery("SELECT id "
						."FROM #__sections "
						."WHERE $whereurl='$archive_name'");
						$id = $database->loadResult();
					}
				} else {
					$archive_name = sefdecode($archive_name);
					$database->setQuery("SELECT id "
					."FROM #__categories "
					."WHERE $whereurl='$archive_name' AND LEFT(section, 4)<>'com_'");
					$id = $database->loadResult();
				}
				$where_type = $task=="archivesection" ? "content_archive_section" : "content_archive_category";
				$database->setQuery("SELECT id "
				."FROM #__menu "
				."WHERE type = '$where_type' AND componentid='$id'");
				$Itemid = $database->loadResult();
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid";
			} else if (is_numeric($url_array[$pos+1]) && is_numeric($url_array[$pos+2])) {
				// $limit/$limitstart
				$option = "com_frontpage";
				$_GET['option'] = $option;
				$_REQUEST['option'] = $option;
				$database->setQuery("SELECT id "
					."FROM #__menu "
					."WHERE link='index.php?option=$option'");
				$Itemid = $database->loadResult();
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$limit = $url_array[$pos+1];
				$limitstart = $url_array[$pos+2];
				$_GET['limit'] = $limit;
				$_REQUEST['limit'] = $limit;
				$_GET['limitstart'] = $limitstart;
				$_REQUEST['limitstart'] = $limitstart;
				$QUERY_STRING = "option=$option&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
			} else {
				// Section_Name/Category_Name
				$task = "category";
				$section_name = sefdecode($url_array[$pos+1]);
				$database->setQuery("SELECT id "
					."FROM #__sections "
					."WHERE $whereurl='$section_name'");
				$sectionid = $database->loadResult();
				$category_name = sefdecode($url_array[$pos+2]);
				$database->setQuery("SELECT id "
					."FROM #__categories "
					."WHERE $whereurl='$category_name' "
					."AND section='$sectionid'");
				$id = $database->loadResult();
				// category directly linked ?
				$database->setQuery("SELECT id "
					."FROM #__menu "
					."WHERE link LIKE '%&task=$task&sectionid=$sectionid&id=$id'");
				$Itemid = $database->loadResult();
				if ($Itemid=="") {
					// not directly linked
					$database->setQuery("SELECT m.id "
						."FROM #__sections AS s "
						."LEFT JOIN #__menu AS m "
						."ON m.componentid=s.id "
						."WHERE m.type='content_section' AND s.id='$sectionid' AND m.published=1");
					$Itemid = $database->loadResult();
				}
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['sectionid'] = $sectionid;
				$_REQUEST['sectionid'] = $sectionid;
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$QUERY_STRING = "option=$option&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid";
			}
		} else if (!(isset($url_array[$pos+2]) && $url_array[$pos+2]!="") && (isset($url_array[$pos+1]) && $url_array[$pos+1]!="")) {
			$name = sefdecode($url_array[$pos+1]);
			if ($id = static_id($name)) {
				// Item_Name
				$task = "view";
				$database->setQuery("SELECT id "
				."FROM #__menu "
				."WHERE type = 'content_typed' AND componentid='$id' AND (published='1' OR published='0') ORDER BY id");
				$Itemid = $database->loadResult();
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid";
			} else {
				// Section_Name
				$task = "section";
				$section_name = $name;
				$database->setQuery("SELECT id "
					."FROM #__sections "
					."WHERE $whereurl='$name'");
				$id = $database->loadResult();
				$database->setQuery("SELECT m.id "
					."FROM #__sections AS s "
					."LEFT JOIN #__menu AS m "
					."ON m.componentid=s.id "
					."WHERE m.type='content_section' AND s.id='$id' AND m.published='1'");
				$Itemid = $database->loadResult();
				$_GET['task'] = $task;
				$_REQUEST['task'] = $task;
				$_GET['id'] = $id;
				$_REQUEST['id'] = $id;
				$_GET['Itemid'] = $Itemid;
				$_REQUEST['Itemid'] = $Itemid;
				$QUERY_STRING = "option=$option&task=$task&id=$id&Itemid=$Itemid";
			}
		} else {
			// index.php
			$option = "";
			$_GET['option'] = $option;
			$_REQUEST['option'] = $option;
			$Itemid = "";
			$_GET['Itemid'] = $Itemid;
			$_REQUEST['Itemid'] = $Itemid;
			$QUERY_STRING = "";
		}
		$_SERVER['QUERY_STRING'] = $QUERY_STRING;
		$REQUEST_URI = $uri[0]."index.php?".$QUERY_STRING;
		$_SERVER['REQUEST_URI'] = $REQUEST_URI;


		// custom 404 redirect for not found content
		if ( ( eregi("option=com_content",$REQUEST_URI) || eregi("option=content",$REQUEST_URI) ) && (!isset($id) || $id==="") && !$sef_debug ) {
			handle404();
			exit;
		}
	} else if (!eregi("index\.php", $_SERVER['REQUEST_URI']) && !eregi("index2\.php", $_SERVER['REQUEST_URI']) && empty($_REQUEST['option'])) {
		// call for non-existent .php files
		handle404();
		exit;
	}

	if ($sef_debug) {
		echo "<pre>";
		print_r ($_REQUEST);
		echo $REQUEST_URI;
		echo "</pre>";
	}

	// Extract to globals
	while(list($key,$value)=each($_GET)) $GLOBALS[$key]=$value;
	include( "configuration.php" );

}

function sefRelToAbs( $string ) {
	GLOBAL $mosConfig_live_site, $mosConfig_sef, $database;
	GLOBAL $whereurl, $whereitem, $homeroot, $sufix, $custom_comp, $uniqitem, $url_alias;
	//echo $string."<br>";

	if ($mosConfig_sef && !eregi("^(([^:/?#]+):)",$string) && !strcasecmp(substr($string,0,9),"index.php") && !eregi("lang=",$string)) {
		// Replace all & with &amp;
		$string0 = str_replace( '&amp;', '&', $string );
		$string = str_replace( '&', '&amp;', $string0 );

		/*
		Home
		index.php
		*/
		if ($string=="index.php" && $homeroot) {
			$string="";
		}

		$sefstring = "";
		if (array_key_exists($string0, $url_alias)) {
			/*
			Alias
			*/
			$string = $url_alias[$string0];
			if (substr($string, -1)!="/") {
				$string .= "/";
			}
		} else if ( (eregi("option=com_content",$string) || eregi("option=content",$string)) && !eregi("task=new",$string) && !eregi("task=edit",$string) ) {
			/*
			Content
			index.php?option=com_content&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart
			*/
			if (eregi("&amp;sectionid=",$string)) {
				$temp = split("&amp;sectionid=", $string);
				$temp = split("&", $temp[1]);
				$database->setQuery("SELECT $whereurl FROM #__sections WHERE id=".$temp[0]);
				$section_name = $database->loadResult();
				$sefstring .= sefencode($section_name)."/";
			}
			if (eregi("&amp;id=",$string) && eregi("&amp;task=section",$string)) {
				$temp = split("&amp;id=", $string);
				$temp = split("&", $temp[1]);
				$database->setQuery("SELECT $whereurl FROM #__sections WHERE id=".$temp[0]);
				$section_name = $database->loadResult();
				$sefstring .= sefencode($section_name)."/";
			} else if (eregi("&amp;id=",$string) && eregi("&amp;task=category",$string)) {
				$temp = split("&amp;id=", $string);
				$temp = split("&", $temp[1]);
				$database->setQuery("SELECT $whereurl FROM #__categories WHERE id=".$temp[0]);
				$sefstring .= sefencode($database->loadResult())."/";
			} else if (eregi("&amp;id=",$string) && eregi("&amp;task=view",$string)) {
				$temp = split("&amp;id=", $string);
				$temp = split("&", $temp[1]);
				if ($uniqitem) {
					$query = "SELECT i.id AS item_id, i.$whereitem AS item_title, DATE_FORMAT(i.created,'%Y%m%d') AS item_date, c.$whereurl AS category_name, s.$whereurl AS section_name "
						."FROM #__content AS i "
						."LEFT JOIN #__categories AS c "
						."ON i.catid=c.id "
						."LEFT JOIN #__sections AS s "
						."ON c.section=s.id "
						."WHERE i.id=".$temp[0];
				} else {
					$query = "SELECT i.$whereitem AS item_title, c.$whereurl AS category_name, s.$whereurl AS section_name "
						."FROM #__content AS i "
						."LEFT JOIN #__categories AS c "
						."ON i.catid=c.id "
						."LEFT JOIN #__sections AS s "
						."ON c.section=s.id "
						."WHERE i.id=".$temp[0];
				}
				$database->setQuery($query);
				$result = $database->loadObjectList();
				$row = $result[0];
				$section_name = sefencode($row->section_name);
				$category_name = sefencode($row->category_name);
				$item_title = $row->item_title;
				if ($uniqitem && $section_name!="" && $category_name!="") {
					// YYYYMMDDID
					//$item_id = sprintf("%04d",$row->item_id);
					$item_id = $row->item_id;
					$item_title .= " ".$row->item_date.$item_id;
				}
				$item_title = sefencode($item_title);
				if ($section_name!="" && $category_name!="") {
					$sefstring .= $section_name."/".$category_name."/".$item_title."/";
				} else {
					if ($whereurl == "name") {
						$sefstring .= $item_title."/";
					} else {
						$database->setQuery("SELECT m.name AS menu_name "
						."FROM #__menu AS m "
						."LEFT JOIN #__content AS c "
						."ON m.componentid=c.id "
						."WHERE m.type='content_typed' "
						."AND c.id=".$temp[0]);
						$result = $database->loadObjectList();
						$row = $result[0];
						$menu_name = sefencode($row->menu_name);
						$sefstring .= $menu_name."/";
					}
				}
			} else if (eregi("&amp;id=",$string) && eregi("&amp;task=blogsection",$string)) {
				$temp = split("&amp;id=", $string);
				$temp = split("&", $temp[1]);
				$database->setQuery("SELECT $whereurl FROM #__sections WHERE id=".$temp[0]);
				$sectionname = $temp[0] == 0 ? 0 : $database->loadResult();
				$sefstring .= _SEF_BLOGSECTION."/".sefencode($sectionname)."/";
			} else if (eregi("&amp;id=",$string) && eregi("&amp;task=blogcategory",$string)) {
				$temp = split("&amp;id=", $string);
				$temp = split("&", $temp[1]);
				$database->setQuery("SELECT $whereurl FROM #__categories WHERE id=".$temp[0]);
				$categoryname = $temp[0] == 0 ? 0 : $database->loadResult();
				$sefstring .= _SEF_BLOGCATEGORY."/".sefencode($categoryname)."/";
			} else if (eregi("&amp;id=",$string) && eregi("&amp;task=archivesection",$string)) {
				$temp = split("&amp;id=", $string);
				$temp = split("&", $temp[1]);
				$database->setQuery("SELECT $whereurl FROM #__sections WHERE id=".$temp[0]);
				$sectionname = $temp[0] == 0 ? 0 : $database->loadResult();
				$sefstring .= _SEF_ARCHIVESECTION."/".sefencode($sectionname)."/";
			} else if (eregi("&amp;id=",$string) && eregi("&amp;task=archivecategory",$string)) {
				$temp = split("&amp;id=", $string);
				$temp = split("&", $temp[1]);
				$database->setQuery("SELECT $whereurl FROM #__categories WHERE id=".$temp[0]);
				$sefstring .= _SEF_ARCHIVECATEGORY."/".sefencode($database->loadResult())."/";
			} else if (eregi("&amp;task=archivecategory",$string) && eregi("&amp;module=1",$string)) {
				// archive module
				$temp = split("&amp;year=", $string);
				$temp = split("&", $temp[1]);
				$year = $temp[0];
				$temp = split("&amp;month=", $string);
				$temp = split("&", $temp[1]);
				$month = $temp[0];
				$sefstring .= _SEF_ARCHIVECATEGORY."/$year/$month/";
			}
			if (eregi("&amp;limit=",$string) && !eregi("&amp;task=view",$string)) {
				$temp = split("&amp;limit=", $string);
				$temp = split("&", $temp[1]);
				$sefstring .= $temp[0]."/";
			}
			if (eregi("&amp;limitstart=",$string)) {
				$temp = split("&amp;limitstart=", $string);
				$temp = split("&", $temp[1]);
				if ( !(eregi("task=view",$string) && $temp[0]=="0") ) {
					$sefstring .= $temp[0]."/";
				}
			}
			if (eregi("&amp;count=",$string)) {
				$temp = split("&amp;count=", $string);
				$temp = split("&", $temp[1]);
				$sefstring .= $temp[0]."/";
			}
			if (eregi("&amp;intro=",$string)) {
				$temp = split("&amp;intro=", $string);
				$temp = split("&", $temp[1]);
				$sefstring .= $temp[0]."/";
			}
			$string = $sefstring;
		} else {
			/*
			Components
			index.php?option=com_xxxx&...
			*/
			// Find out option
			$sefoption = "";
			if (eregi("option=com_",$string)) {
				$temp = split("option=com_", $string);
				$temp = split("&", $temp[1]);
				$sefoption = $temp[0];
			}

			if (eregi("option=com_frontpage",$string)) {
				if ($homeroot) {
					$sefstring = "";
				} else {
					$sefstring = _SEF_FRONTPAGE."/";
				}
				if (eregi("&amp;limit=",$string)) {
					$temp = split("&amp;limit=", $string);
					$temp = split("&", $temp[1]);
					$sefstring .= $temp[0]."/";
				}
				if (eregi("&amp;limitstart=",$string)) {
					$temp = split("&amp;limitstart=", $string);
					$temp = split("&", $temp[1]);
					$sefstring .= $temp[0]."/";
				}
				$string = $sefstring;
			} else if (eregi("option=com_weblinks",$string) && !eregi("task=new",$string)) {
				$sefstring = _SEF_WEBLINKS."/";
				if (eregi("&amp;catid=",$string)) {
					$temp = split("&amp;catid=", $string);
					$temp = split("&", $temp[1]);
					$database->setQuery("SELECT $whereurl FROM #__categories WHERE id=".$temp[0]);
					$sefstring .= sefencode($database->loadResult())."/";
				}
				if (eregi("&amp;id=",$string)) {
					$temp = split("&amp;id=", $string);
					$temp = split("&", $temp[1]);
					$database->setQuery("SELECT title FROM #__weblinks WHERE id=".$temp[0]);
					$sefstring .= sefencode($database->loadResult())."/";
				}
				$string = $sefstring;
			} else if (eregi("option=com_poll",$string) && !eregi("option=com_pollxt",$string)) {
				$sefstring = _SEF_POLL."/";
				if (eregi("&amp;id=",$string)) {
					$temp = split("&amp;id=", $string);
					$temp = split("&", $temp[1]);
					if ($temp[0] == "' + this.options[selectedIndex].value + '") {
						$sefstring .= "' + this.options[selectedIndex].text + '/";
					} else {
						$database->setQuery("SELECT title FROM #__polls WHERE id=".$temp[0]);
						$sefstring .= sefencode($database->loadResult())."/";
					}
				}
				$string = $sefstring;
			} else if (eregi("option=com_banners",$string)) {
				$sefstring = _SEF_BANNERS."/";
				if (eregi("&amp;bid=",$string)) {
					$temp = split("&amp;bid=", $string);
					$temp = split("&", $temp[1]);
					$database->setQuery("SELECT name FROM #__banner WHERE bid=".$temp[0]);
					$sefstring .= sefencode($database->loadResult())."/";
				}
				$string = $sefstring;
			} else if (eregi("option=com_contact",$string)) {
				$sefstring = _SEF_CONTACT."/";
				if (eregi("&amp;catid=",$string)) {
					$temp = split("&amp;catid=", $string);
					$temp = split("&", $temp[1]);
					$database->setQuery("SELECT name FROM #__categories WHERE id=".$temp[0]);
					$sefstring .= sefencode($database->loadResult())."/";
				}
				if (eregi("&amp;contact_id=",$string)) {
					$temp = split("&amp;contact_id=", $string);
					$temp = split("&", $temp[1]);
					$database->setQuery("SELECT name FROM #__contact_details WHERE id=".$temp[0]);
					$sefstring .= sefencode($database->loadResult())."/";
				}
				$string = $sefstring;
			} else if (eregi("option=com_login",$string)) {
				$string = _SEF_LOGIN."/";
			} else if (eregi("option=com_search",$string)) {
				$string = _SEF_SEARCH."/";
			} else if (eregi("option=com_newsfeeds",$string)) {
				$sefstring = _SEF_NEWSFEEDS."/";
				if (eregi("&amp;catid=",$string)) {
					$temp = split("&amp;catid=", $string);
					$temp = split("&", $temp[1]);
					$database->setQuery("SELECT name FROM #__categories WHERE id=".$temp[0]);
					$sefstring .= sefencode($database->loadResult())."/";
				}
				if (eregi("&amp;task=",$string)) {
					$temp = split("&amp;task=", $string);
					$temp = split("&", $temp[1]);
					$sefstring .= $temp[0]."/";
				}
				if (eregi("&amp;feedid=",$string)) {
					$temp = split("&amp;feedid=", $string);
					$temp = split("&", $temp[1]);
					$database->setQuery("SELECT name FROM #__newsfeeds WHERE id=".$temp[0]);
					$sefstring .= sefencode($database->loadResult())."/";
				}
				$string = $sefstring;
			} else if (eregi("option=com_wrapper",$string)) {
				$sefstring = _SEF_WRAPPER."/";
				$database->setQuery("SELECT count(id) FROM #__menu WHERE type='wrapper' AND published=1");
				if ($database->loadResult() > 1) {
					if (eregi("&amp;Itemid=",$string)) {
						$temp = split("&amp;Itemid=", $string);
						$temp = split("&", $temp[1]);
						$database->setQuery("SELECT name FROM #__menu WHERE id=".$temp[0]);
						$sefstring .= sefencode($database->loadResult())."/";
					}
				}
				$string = $sefstring;
			// API for custom component extension
			} else if ($sefoption != "" && @file_exists("components/com_$sefoption/sef_ext.php")) {
				include_once ("components/com_$sefoption/sef_ext.php");
				$class_name = "sef_$sefoption";
				$sef_ext = new $class_name();
				if (array_key_exists($sefoption, $custom_comp)) {
					$sefoption = $custom_comp[$sefoption];
				}
				$string = "$sefoption/".$sef_ext->create($string);
			} else if (eregi("option=com_",$string) && !eregi("option=com_registration",$string) && !eregi("task=new",$string) && !eregi("task=edit",$string)) {
				$sefstring = "";
				$temp = split("\?", $string);
				$temp = split("&amp;", $temp[1]);
				foreach($temp as $key => $value) {
					$sefstring .= $value."/";
				}

				$string = str_replace( '=', ',', $sefstring );
			}
		}
		// Replace the trailing slash with the sufix
		if ($sufix != "" && $string != "" && !eregi("index.php",$string)) {
			$string = substr($string, 0, strlen($string)-1) . $sufix;
		}
		//echo $mosConfig_live_site."/".$string;
		return $mosConfig_live_site."/".$string;
	} else {
		return $string;
	}

}

function sefgetItemid ($id, $option) {
	global $database, $Itemid;

	$_Itemid = "";

	// Content Item Link
	if ($_Itemid == "") {
		$database->setQuery( "SELECT id "
			."FROM #__menu "
			."WHERE type='content_item_link' AND published='1' AND link='index.php?option=$option&task=view&id=$id'" );
		$_Itemid = $database->loadResult();
	}

	// Typed Content Link
	if ($_Itemid == "") {
		$database->setQuery( "SELECT id "
			."FROM #__menu "
			."WHERE type='content_typed' AND published='1' AND link='index.php?option=$option&task=view&id=$id'" );
		$_Itemid = $database->loadResult();
	}

	// Content Section List
	if ($_Itemid == "") {
		$database->setQuery( "SELECT m.id "
			."FROM #__content AS i "
			."LEFT JOIN #__sections AS s ON i.sectionid=s.id "
			."LEFT JOIN #__menu AS m ON m.componentid=s.id "
			."WHERE m.type='content_section' AND m.published='1' AND i.id='$id'" );
		$_Itemid = $database->loadResult();
	}

	// Content Category List
	if ($_Itemid == "") {
		$database->setQuery( "SELECT sectionid, catid "
			."FROM #__content WHERE id='$id'" );
		$row = null;
		$database->loadObject( $row );

		$database->setQuery("SELECT id "
			."FROM #__menu "
			."WHERE type='content_category' AND published='1' AND link='index.php?option=$option&task=category&sectionid=$row->sectionid&id=$row->catid'");
		$_Itemid = $database->loadResult();
	}

	// Content Category Blog (specific)
	if ($_Itemid == "") {
		$database->setQuery( "SELECT m.id "
			."FROM #__content AS i "
			."LEFT JOIN #__categories AS c ON i.catid=c.id "
			."LEFT JOIN #__menu AS m ON m.componentid=c.id "
			."WHERE m.type='content_blog_category' AND m.published='1' AND i.id='$id'" );
		$_Itemid = $database->loadResult();
	}

	// Content Section Blog (specific)
	if ($_Itemid == "") {
		$database->setQuery( "SELECT m.id "
			."FROM #__content AS i "
			."LEFT JOIN #__sections AS s ON i.sectionid=s.id "
			."LEFT JOIN #__menu AS m ON m.componentid=s.id "
			."WHERE m.type='content_blog_section' AND m.published='1' AND i.id='$id'" );
		$_Itemid = $database->loadResult();
	}

	// Content Category Blog (global)
	if ($_Itemid == "") {
		$database->setQuery( "SELECT id "
			."FROM #__menu "
			."WHERE type='content_blog_category' AND published='1' AND componentid='0'" );
		$_Itemid = $database->loadResult();
	}

	// Content Section Blog (global)
	if ($_Itemid == "") {
		// Search in global blog section
		$database->setQuery( "SELECT id "
			."FROM #__menu "
			."WHERE type='content_blog_section' AND published='1' AND componentid='0'" );
		$_Itemid = $database->loadResult();
	}

	//echo $_Itemid;

	if ($_Itemid != "") {
		return $_Itemid;
	} else {
		return $Itemid;
	}
}

function handle404() {
	global $mosConfig_live_site, $custom404;
	$file404 = str_replace("$mosConfig_live_site/","",$custom404);
	if ( @file_exists($file404) ) {
		header("HTTP/1.0 404 Not Found");
		include_once($file404);
	} else {
		header("HTTP/1.0 301 Moved Permanently");
		header("Location: $custom404");
	}
}

function static_id($name) {
	global $database, $whereurl;
	if ($whereurl=="name") {
		$query = "SELECT id "
			."FROM #__content "
			."WHERE title='$name' AND sectionid='0' AND catid='0' ORDER BY state DESC";
		$database->setQuery($query);
	} else {
		$database->setQuery("SELECT c.id AS id "
			."FROM #__content AS c "
			."LEFT JOIN #__menu AS m "
			."ON m.componentid=c.id "
			."WHERE m.name='$name' AND m.type='content_typed' ORDER BY c.state DESC");
	}
	return $database->loadResult();
}

function component_id($name) {
	global $database;
	$database->setQuery("SELECT id "
		."FROM #__components "
		."WHERE link='option=com_$name' AND link<>'' ORDER BY id DESC");
	return $database->loadResult();
}

function sefencode($string) {
	global $lowercase, $url_replace, $url_exception;
	foreach ($url_replace as $key => $value) {
		$string = ereg_replace($key, $value, $string);
	}
	$string = urlencode($string);
	$string = eregi_replace("%2F", "%10", $string);
	$string = eregi_replace(_SEF_SPACE, "%11", $string);
	$string = eregi_replace("\+", _SEF_SPACE, $string);
	foreach ($url_exception as $value) {
		if ($value != "") {
			$string = ereg_replace(urlencode($value), $value, $string);
		}
	}
	if ($lowercase) {
		$string = strtolower($string);
	}
	return $string;
}

function sefdecode($string) {
	global $url_replace;
	$string = eregi_replace(_SEF_SPACE, "%20", $string);
	$string = eregi_replace("%11", _SEF_SPACE, $string);
	$string = eregi_replace("%10", "%2F", $string);
	$string = urldecode($string);
	$string = addslashes($string);
	foreach ($url_replace as $key => $value) {
		$string = ereg_replace($value, $key, $string);
	}
	return $string;
}

function process_old($url) {
	$url_array = explode("/", $_SERVER['REQUEST_URI']);
	/**
	* Content
	* http://www.domain.com/$option/$task/$sectionid/$id/$Itemid/$limit/$limitstart
	*/
	if (in_array("content", $url_array)) {

		$uri = explode("content/", $_SERVER['REQUEST_URI']);
		$option = "com_content";
		$_GET['option'] = $option;
		$_REQUEST['option'] = $option;
		$pos = array_search ("content", $url_array);

		// language hook for content
		$lang = "";
		foreach($url_array as $key=>$value) {
			if ( !strcasecmp(substr($value,0,5),"lang,") ) {
				$temp = explode(",", $value);
				if (isset($temp[0]) && $temp[0]!="" && isset($temp[1]) && $temp[1]!="") {
					$_GET['lang'] = $temp[1];
					$_REQUEST['lang'] = $temp[1];
					$lang = $temp[1];
				}
				unset($url_array[$key]);
			}
		}

		// $option/$task/$sectionid/$id/$Itemid/$limit/$limitstart
		if (isset($url_array[$pos+6]) && $url_array[$pos+6]!="") {
			$task = $url_array[$pos+1];
			$sectionid = $url_array[$pos+2];
			$id = $url_array[$pos+3];
			$Itemid = $url_array[$pos+4];
			$limit = $url_array[$pos+5];
			$limitstart = $url_array[$pos+6];
			$_GET['task'] = $task;
			$_REQUEST['task'] = $task;
			$_GET['sectionid'] = $sectionid;
			$_REQUEST['sectionid'] = $sectionid;
			$_GET['id'] = $id;
			$_REQUEST['id'] = $id;
			$_GET['Itemid'] = $Itemid;
			$_REQUEST['Itemid'] = $Itemid;
			$_GET['limit'] = $limit;
			$_REQUEST['limit'] = $limit;
			$_GET['limitstart'] = $limitstart;
			$_REQUEST['limitstart'] = $limitstart;
			$QUERY_STRING = "option=com_content&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
			// $option/$task/$id/$Itemid/$limit/$limitstart
		} else if (isset($url_array[$pos+5]) && $url_array[$pos+5]!="") {
			$task = $url_array[$pos+1];
			$id = $url_array[$pos+2];
			$Itemid = $url_array[$pos+3];
			$limit = $url_array[$pos+4];
			$limitstart = $url_array[$pos+5];
			$_GET['task'] = $task;
			$_REQUEST['task'] = $task;
			$_GET['id'] = $id;
			$_REQUEST['id'] = $id;
			$_GET['Itemid'] = $Itemid;
			$_REQUEST['Itemid'] = $Itemid;
			$_GET['limit'] = $limit;
			$_REQUEST['limit'] = $limit;
			$_GET['limitstart'] = $limitstart;
			$_REQUEST['limitstart'] = $limitstart;
			$QUERY_STRING = "option=com_content&task=$task&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
			// $option/$task/$sectionid/$id/$Itemid
		} else if (!(isset($url_array[$pos+5]) && $url_array[$pos+5]!="") && isset($url_array[$pos+4]) && $url_array[$pos+4]!="") {
			$task = $url_array[$pos+1];
			$sectionid = $url_array[$pos+2];
			$id = $url_array[$pos+3];
			$Itemid = $url_array[$pos+4];
			$_GET['task'] = $task;
			$_REQUEST['task'] = $task;
			$_GET['sectionid'] = $sectionid;
			$_REQUEST['sectionid'] = $sectionid;
			$_GET['id'] = $id;
			$_REQUEST['id'] = $id;
			$_GET['Itemid'] = $Itemid;
			$_REQUEST['Itemid'] = $Itemid;
			$QUERY_STRING = "option=com_content&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid";
			// $option/$task/$id/$Itemid
		} else if (!(isset($url_array[$pos+4]) && $url_array[$pos+4]!="") && (isset($url_array[$pos+3]) && $url_array[$pos+3]!="")) {
			$task = $url_array[$pos+1];
			$id = $url_array[$pos+2];
			$Itemid = $url_array[$pos+3];
			$_GET['task'] = $task;
			$_REQUEST['task'] = $task;
			$_GET['id'] = $id;
			$_REQUEST['id'] = $id;
			$_GET['Itemid'] = $Itemid;
			$_REQUEST['Itemid'] = $Itemid;
			$QUERY_STRING = "option=com_content&task=$task&id=$id&Itemid=$Itemid";
			// $option/$task/$id
		} else if (!(isset($url_array[$pos+3]) && $url_array[$pos+3]!="") && (isset($url_array[$pos+2]) && $url_array[$pos+2]!="")) {
			$task = $url_array[$pos+1];
			$id = $url_array[$pos+2];
			$_GET['task'] = $task;
			$_REQUEST['task'] = $task;
			$_GET['id'] = $id;
			$_REQUEST['id'] = $id;
			$QUERY_STRING = "option=com_content&task=$task&id=$id";
			// $option/$task
		} else if (!(isset($url_array[$pos+2]) && $url_array[$pos+2]!="") && (isset($url_array[$pos+1]) && $url_array[$pos+1]!="")) {
			$task = $url_array[$pos+1];
			$_GET['task'] = $task;
			$_REQUEST['task'] = $task;
			$QUERY_STRING = "option=com_content&task=$task";
		}

		if ($lang!="") {
			$QUERY_STRING .= "&lang=$lang";
		}

		$_SERVER['QUERY_STRING'] = $QUERY_STRING;
		$REQUEST_URI = $uri[0]."index.php?".$QUERY_STRING;
		$_SERVER['REQUEST_URI'] = $REQUEST_URI;
	}

	/*
	Components
	http://www.domain.com/component/$name,$value
	*/
	if (in_array("component", $url_array)) {

		$uri = explode("component/", $_SERVER['REQUEST_URI']);
		$uri_array = explode("/", $uri[1]);
		$QUERY_STRING = "";

		foreach($uri_array as $value) {
			$temp = explode(",", $value);
			if (isset($temp[0]) && $temp[0]!="" && isset($temp[1]) && $temp[1]!="") {
				$_GET[$temp[0]] = $temp[1];
				$_REQUEST[$temp[0]] = $temp[1];
				$QUERY_STRING .= $temp[0]=="option" ? "$temp[0]=$temp[1]" : "&$temp[0]=$temp[1]";
			}
		}

		$_SERVER['QUERY_STRING'] = $QUERY_STRING;
		$REQUEST_URI = $uri[0]."index.php?".$QUERY_STRING;
		$_SERVER['REQUEST_URI'] = $REQUEST_URI;
	}

	// Extract to globals
	while(list($key,$value)=each($_GET)) $GLOBALS[$key]=$value;
	// Don't allow config vars to be passed as global
	include( "configuration.php" );

	if (1) {
		$non_sef_url = "index.php?".$QUERY_STRING;
		$sef_adv_url = sefRelToAbs($non_sef_url);
		header("HTTP/1.0 301 Moved Permanently");
		header("Location: $sef_adv_url");
		die;
	}
}
?>
