<?php
/**
 * write.php
 *
 * Screen for creating and answering Messages
 *
 *
 * @package com_primezilla
 * @subpackage frontend
 *
 * @copyright 2006 joomster.com Achim Fischer
 * @author Achim Fischer
 *
 * This file is part of joomster.com Primezilla.
 *
 * Primezilla is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Primezilla is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Primezilla; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
?>

<link rel="stylesheet" href="components/com_primezilla/primezilla.css" type="text/css" />

<?php
global $database;

$Itemid  = intval( mosGetParam( $_REQUEST, 'Itemid', '0' ) );
$msgid   = intval( mosGetParam( $_REQUEST, 'msgid', '0' ) );

$page    = strval( mosGetParam( $_REQUEST, 'page', '' ) );
$mode    = strval( mosGetParam( $_REQUEST, 'mode', '' ) );

$msg_to       = strval( mosGetParam( $_REQUEST, 'msg_to', '' ) );
$msg_subject  = strval( mosGetParam( $_REQUEST, 'msg_subject', '' ) );
$msg_text     = strval( mosGetParam( $_REQUEST, 'msg_text', '' ) );


// settings when called from outside
$uid      = intval( mosGetParam( $_REQUEST, 'uid', '0' ) ); // recipient id
$uname    = strval( mosGetParam( $_REQUEST, 'uname', '' ) ); // recipient name

$subject  = strval( mosGetParam( $_REQUEST, 'subject', '' ) ); // subject


$database->setQuery("SELECT * FROM #__primezilla_config LIMIT 1");
$conf = $database->loadObjectList();
$iEmailNotificationIsAllowed    = $conf[0]->email_notification_is_allowed;
$iEmailNotificationIsDefault    = $conf[0]->email_notification_is_default;
$iEmailNotificationIsChangeable = $conf[0]->email_notification_is_changeable;
$sEmailServer                   = $conf[0]->email_server;
$sEmailUser                     = $conf[0]->email_user;
$sEmailPassword                 = $conf[0]->email_password;
$sEmailFrom                     = $conf[0]->email_from;
$sEmailSubject                  = $conf[0]->email_subject;
$sEmailHeader                   = $conf[0]->email_header;
$sEmailFooter                   = $conf[0]->email_footer;
$iEmailUseBanner                = $conf[0]->email_use_banner;
$sEmailBanner                   = $conf[0]->email_banner;
$iLoggingIsEnabled              = $conf[0]->logging_is_enabled;
$iSupportMode                   = (int) $conf[0]->support_mode;
$sSupportModeUsers              = $conf[0]->support_mode_users;
$iSupportModeUsersDisplay       = (int) $conf[0]->support_mode_users_display;



$sFadeMode = -1; // presetting



// get from user preferences
$database->setQuery("SELECT * FROM #__primezilla_preferences WHERE id='$my->id'");
$pref = $database->loadObjectList();

if( $pref != null) {  // got a record for this user
    $bUseSignature              = $pref[0]->use_signature;
    $bUseSignatureForReplies    = $pref[0]->use_signature_for_replies;
    $sSignature                 = $pref[0]->signature;
}
else {
    $bUseSignature              = 0;
    $bUseSignatureForReplies    = 0;
    $sSignature                 = "";
}

echo "<div class=\"jooWrapper\">";

include( $mosConfig_absolute_path.'/components/com_primezilla/topmenu.php');



// call from outside with recipient userid?
if( $uid > 0) {
    $database->setQuery( "SELECT username FROM #__users WHERE id='$uid'");
    $uname = $database->loadResult();
}

if ( $msg_to != "" && $msg_subject != "" && $msg_text != "") {


    if( $my->id > 0) {  // logged in

        // 1. insert message into inbox of receiver

        $database->setQuery( "SELECT id, block FROM #__users WHERE username='$msg_to'");
        $dbUser = $database->loadObjectList();
        $userid_to = $dbUser[0]->id;
        $block_to  = $dbUser[0]->block;

        if( $userid_to > 1 && $block_to == 0) {

            // get to-user preferences
            $database->setQuery("SELECT * FROM #__primezilla_preferences WHERE id='$userid_to'");
            $prefto = $database->loadObjectList();
            if( $prefto != null) {  // got a record for this user
                $bUseEmailNotification      = $prefto[0]->use_email_notification;
            }
            else {
                $bUseEmailNotification      = $iEmailNotificationIsDefault;  // take default-setting from config
            }


            $database->setQuery( "SELECT username FROM #__users WHERE id='$my->id'");
            $username_from = $database->loadResult();

            $sql_in = "INSERT INTO #__primezilla_inbox (
		                          userid, userid_from, username_from, msg_date, msg_time, subject, message
						      )
						      VALUES (
						          '$userid_to', '$my->id', '$username_from', CURRENT_DATE(), CURRENT_TIME(), '$msg_subject', '$msg_text'
						      )";

            $database->setQuery( $sql_in);

            if ($database->getErrorNum()) {
                echo $database->stderr();
            } else {
                $database->query();
            }

            $msgid = mysql_insert_id();



            // 2. insert message in to outbox of sender

            $sql_out = "INSERT INTO #__primezilla_outbox (
		                          id, userid, userid_to, username_to, msg_date, msg_time, subject, message
						      )
						      VALUES (
						          '$msgid', '$my->id', '$userid_to', '$msg_to', CURRENT_DATE(), CURRENT_TIME(), '$msg_subject', '$msg_text'
						      )";

            $database->setQuery( $sql_out);

            if ($database->getErrorNum()) {
                echo $database->stderr();
            } else {
                $database->query();
            }




            // 3. write log
            if ( $iLoggingIsEnabled == 1) {

                $sql_log = "INSERT INTO #__primezilla_log (
		                          userid_from, userid_to, msg_date, msg_time
						      )
						      VALUES (
						          '$my->id', '$userid_to', CURRENT_DATE(), CURRENT_TIME()
						      )";

                $database->setQuery( $sql_log);

                if ($database->getErrorNum()) {
                    echo $database->stderr();
                } else {
                    $database->query();
                }

            }


            echo "<center>";
            echo "<div id=\"jooInfoSuccess\">";
            echo JOO_SEND_OK;
            echo "</div>";
            echo "</center>";
            $sFadeMode = 0; // success




            // email-notification

            // check if a mail is to be send
            $bSendEmail = 0;

            if ( $iEmailNotificationIsAllowed == 1) {
                if ( $iEmailNotificationIsChangeable == 1) {
                    $bSendEmail = $bUseEmailNotification;

                }
                else { // not changeable by user
                    if ( $iEmailNotificationIsDefault == 1) {
                        $bSendEmail = 1;
                    }
                }
            }

            if ( $bSendEmail == 1) {

                $database->setQuery( "SELECT email FROM #__users WHERE id='$userid_to'");
                $sRecipientEmail = $database->loadResult();

                $sLink = sefRelToAbs( "index.php?option=com_primezilla&page=read&box=in&msgid=".$msgid."&Itemid=".$Itemid);

                require_once($mainframe->getCfg('absolute_path').'/components/com_primezilla/Swift.php');
                require_once($mainframe->getCfg('absolute_path').'/components/com_primezilla/Swift/Connection/SMTP.php');

                $mailer = new Swift(new Swift_Connection_SMTP( $sEmailServer, SWIFT_DEFAULT_PORT, SWIFT_OPEN));

                if ($mailer->isConnected()) {
                    if ($mailer->authenticate( $sEmailUser, $sEmailPassword)) {

                        $sEmailBody  = $sEmailHeader;
                        $sEmailBody .= $sLink;
                        $sEmailBody .= $sEmailFooter;

                        if( $iEmailUseBanner == 1) {
                            $sEmailBody .= $sEmailBanner;
                        }

                        $mailer->send(
                        $sRecipientEmail,
                        $sEmailFrom,
                        $sEmailSubject,
                        $sEmailBody
                        );

                    }
                    else {
                        echo "Did not authenticate to server";
                    }

                    $mailer->close();
                }

            }

        }
        else {
            if( $userid_to < 1) {
                echo "<center>";
                echo "<div id=\"jooInfoError\">";
                echo JOO_USER_NOT_EXISTS;
                echo "</div>";
                echo "</center>";
                $sFadeMode = 1; // error
            }
            elseif ( $block_to == 1) {
                echo "<center>";
                echo "<div id=\"jooInfoError\">";
                echo JOO_USER_IS_BLOCKED;
                echo "</div>";
                echo "</center>";
                $sFadeMode = 1; // error
            }
            else {
                echo "<center>";
                echo "<div id=\"jooInfoError\">";
                echo JOO_GENERAL_ERROR;
                echo "</div>";
                echo "</center>";
                $sFadeMode = 1; // error
            }
        }

    }
    else {
        echo "<br />";
        echo "Sorry, you have to log in to send private messages";
        echo "<br />";
        echo "<br />";
        echo "Maybe your connection timed out?";
        echo "<br />";
        echo "<br />";
    }


}
else {

    echo "<div style='text-align: left;'>";

    $bReply = false;
    if ( $msgid > 0) {  // reply

        $bReply = true;

        echo "<h2>".JOO_REPLY."</h2>";
        echo "<br />";



        $database->setQuery("SELECT * FROM #__primezilla_inbox WHERE id='$msgid'");
        $msgrow = $database->loadObjectList();

        $msg_from 		 = $msgrow[0]->username_from;
        $msg_date 		 = $msgrow[0]->msg_date;
        $msg_time 		 = $msgrow[0]->msg_time;
        $msg_subject 	 = $msgrow[0]->subject;
        $msg_message 	 = $msgrow[0]->message;

    }
    else {  // new msg
        echo "<h2>".JOO_NEW_MESSAGE."</h2>";
        echo "<br />";
    }

    echo "</div>";

    $sFormLink = sefRelToAbs( "index.php?option=com_primezilla&amp;page=write&amp;Itemid=".$Itemid);
    echo "<form action=".$sFormLink." method=\"post\" name=\"msgform\" id=\"msgform\">";

    echo "<table class=\"jooReadTable\" bgcolor=\"#CCCCCC\" cellspacing=\"1\" cellpadding=\"0\" width=\"100%\">";

    echo "<tr>";
    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
    echo "<b>".JOO_TO.":</b> ";
    echo "</td>";
    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" height='16' valign='center'>";
    if( $bReply) {
        echo "<input type='text' name='msg_to' id='msg_to' size='50' maxlength='50' value='$msg_from' readonly>";
    }
    else {  // normal write

        echo "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"padding:0px; margin:0px;\">";
        echo "<tr>";

        if ( $iSupportMode == 0 || $my->gid > 1) { // "normal mode" or special user

            echo "<td valign=\"center\" style=\"padding:0px; margin:0px;\" >";
            if( strlen( $uname) > 0) {
                echo "<input type='text' name='msg_to' id='msg_to' size='50' maxlength='50' value='$uname' >";
            }
            else {
                echo "<input type='text' name='msg_to' id='msg_to' size='50' maxlength='50' >";
            }
            echo "&nbsp;";
            echo "</td>";


            echo "<td width=\"20\" valign=\"center\" style=\"padding:0px; margin-left:10px;\" >";
                                    ?>
                                       <span id="indicator1" style="display:none;"><img src="components/com_primezilla/images/indicator.gif" alt="Searching..." /></span>
                                       <div id="ajax_resultset" class="msg_to"></div>
	                                   <script type="text/javascript">
	                                   new Ajax.Autocompleter( "msg_to", "ajax_resultset", "components/com_primezilla/get_user.php", {minChars: 2, indicator: 'indicator1'});
	                                   </script>
                                    <?php
                                    echo "</td>";

                                    echo "<td valign=\"center\" style=\"padding:0px; margin:0px;\" >";
                                    echo " ".JOO_SEARCH;
                                    echo "</td>";
        }
        else {  // support mode - let "normal" users select from restricted listbox

            echo "<td width=\"20\" valign=\"center\" style=\"padding:0px; margin-left:10px;\" >";

            echo "<select name='msg_to'>";

            $userArray = explode(',', $sSupportModeUsers);

            for( $x = 0; $x < count( $userArray); $x++){
                $sUserName = $userArray[$x];
                $database->setQuery( "SELECT name FROM #__users WHERE username='$userArray[$x]' ");
                $sName = $database->loadResult();

                switch( $iSupportModeUsersDisplay) {

                    case 1: {
                        echo "<option value='$sUserName' >".$sUserName."</option>";
                        break;
                    }
                    case 2: {
                        echo "<option value='$sUserName' >".$sName."</option>";
                        break;
                    }
                    default: {
                        echo "<option value='$sUserName' >".$sUserName." (".$sName.")"."</option>";
                        break;
                    }

                }
            }

            echo "</select>";

            echo "</td>";

            echo "<td valign=\"center\" style=\"padding:0px; margin:0px;\" >";
            echo "&nbsp";
            echo "</td>";
        }

        echo "</tr>";
        echo "</table>";



    }
    echo "</td>";
    echo "</tr>";

    echo "<tr>";
    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
    echo "<b>".JOO_SUBJECT.":</b> ";
    echo "</td>";
    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
    if( $bReply) {
        $sSubjectText = "Re:".$msg_subject;
        echo "<input type='text' name='msg_subject' size='80' maxlength='80' value='$sSubjectText'>";
    }
    else {
        if( strlen( $subject) > 0) {
            echo "<input type='text' name='msg_subject' size='80' maxlength='80' value='$subject' >";
        }
        else {
            echo "<input type='text' name='msg_subject' size='80' maxlength='80'>";
        }
    }
    echo "</td>";
    echo "</tr>";

    echo "<tr>";
    echo "<td class=\"jooReadTable\" valign=\"top\" style=\"padding: 5px;\" >";
    echo "<b><br />".JOO_TEXT.":</b> ";
    echo "</td>";
    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";



    echo "<textarea name='msg_text' cols='80' rows='20' wrap='VIRTUAL' id='msg_text'>";
    if( $bReply == true) {

        if ( $bUseSignature == 1 && $bUseSignatureForReplies == 1) {
            echo "\n\n\n\n";  // some lines before the reply msg
            echo $sSignature;
        }

        echo "\n\n\n\n";  // some lines before the reply msg

        echo "> --- ".$msg_from." wrote (".$msg_date." ".$msg_time.") ---";
        echo "\n> \n";

        $sReplyText = "> ".str_replace( "\n", "\n> ", $msg_message);
        echo $sReplyText;
    }
    else {  // new message
        if ( $bUseSignature == 1) {
            echo "\n\n\n\n";  // some lines before the signature
            echo $sSignature;
        }

    }
    echo "</textarea>";

    echo "</td>";
    echo "</tr>";

    echo "</table>";

    echo "<br />";
    echo "<br />";

    echo "<div style='text-align: left;'>";

    echo "<input type=\"submit\" name=\"sendmessage\" class=\"button\" value=\"".JOO_BUTTON_SENDMESSAGE."\" />";

    echo "</div>";

    echo "</form>";

}



echo "<br />";
echo "<br />";


include($mosConfig_absolute_path.'/components/com_primezilla/footer.php');

echo "</div>";
?>



<?php
if( $sFadeMode == 0) {  // success
?>

<script type="text/javascript">
<!--
Effect.Fade('jooInfoSuccess', {duration:3.0});
-->
</script>

<?php
}


if ( $sFadeMode == 1) {
?>

<script type="text/javascript">
<!--
Effect.Fade('jooInfoError', {duration:3.0});
-->
</script>

<?php
}
?>

