<?php
/**
 * read.php
 *
 * Screen for reading Messages
 *
 *
 * @package com_primezilla
 * @subpackage frontend
 *
 * @copyright 2006 joomster.com Achim Fischer
 * @author Achim Fischer
 *
 * This file is part of joomster.com Primezilla.
 *
 * Primezilla is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Primezilla is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Primezilla; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
?>

<link rel="stylesheet" href="components/com_primezilla/primezilla.css" type="text/css" />

<?php
global $database;
$Itemid = intval( mosGetParam( $_REQUEST, 'Itemid', '0' ) );
$page   = strval( mosGetParam( $_REQUEST, 'page', '' ) );
$box    = strval( mosGetParam( $_REQUEST, 'box', '' ) );
$msgid  = intval( mosGetParam( $_REQUEST, 'msgid', '0' ) );
$trash  = intval( mosGetParam( $_REQUEST, 'trash', '0' ) );

$myUserId = $my->id;



echo "<div class=\"jooWrapper\">";

include($mosConfig_absolute_path.'/components/com_primezilla/topmenu.php');

echo "<div style='text-align: left;'>";

echo "<h2>".JOO_READ_MESSAGE."</h2>";

echo "</div>";

echo "<br />";


if( $box == "in") {
    $linkReply    = sefRelToAbs( "index.php?option=com_primezilla&amp;page=write&amp;msgid=$msgid&amp;Itemid=".$Itemid);
    $linkDelete   = sefRelToAbs( "index.php?option=com_primezilla&amp;page=inbox&amp;box=in&amp;mode=d&amp;msgid=$msgid&amp;Itemid=".$Itemid);
    $linkUndelete = sefRelToAbs( "index.php?option=com_primezilla&amp;page=inbox&amp;box=in&amp;mode=u&amp;msgid=$msgid&amp;Itemid=".$Itemid);
    $linkPurge    = sefRelToAbs( "index.php?option=com_primezilla&amp;page=inbox&amp;box=in&amp;mode=p&amp;msgid=$msgid&amp;Itemid=".$Itemid);
}
else {
    $linkDelete   = sefRelToAbs( "index.php?option=com_primezilla&amp;page=outbox&amp;box=out&amp;mode=d&amp;msgid=$msgid&amp;Itemid=".$Itemid);
    $linkUndelete = sefRelToAbs( "index.php?option=com_primezilla&amp;page=outbox&amp;box=out&amp;mode=u&amp;msgid=$msgid&amp;Itemid=".$Itemid);
    $linkPurge    = sefRelToAbs( "index.php?option=com_primezilla&amp;page=outbox&amp;box=out&amp;mode=p&amp;msgid=$msgid&amp;Itemid=".$Itemid);
}





if( $box == "in") {
    $database->setQuery("SELECT * FROM #__primezilla_inbox WHERE id='$msgid'");
}
else {
    $database->setQuery("SELECT * FROM #__primezilla_outbox WHERE id='$msgid'");
}

$msgrow = $database->loadObjectList();

$msg_userid 	 = $msgrow[0]->userid;
$msg_date 		 = $msgrow[0]->msg_date;
$msg_time 		 = $msgrow[0]->msg_time;

$msg_from 		 = $msgrow[0]->username_from;
$msg_subject 	 = $msgrow[0]->subject;
$msg_message 	 = $msgrow[0]->message;



if( $myUserId == $msg_userid) { // message is for me

    echo "<div style='text-align: left;'>";

    echo "<table>";
    echo "<tr>";

    if( $box == "in" && $trash != 1) {
        echo "<td style='width: 25px; padding-left: 5px;'>";
        echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/reply.gif' align='center' border='0'>";
        echo "</td>";
        echo "<td style='width: 75px; padding-left: 5px;'>";
        echo "<a href=".$linkReply.">";
        echo JOO_REPLY;
        echo "</a>";
        echo "</td>";
    }


    if( $trash == 1) {
        echo "<td style='width: 25px; padding-left: 5px;'>";
        echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/undelete.gif' align='center' border='0'>";
        echo "</td>";
        echo "<td style='width: 120px; padding-left: 5px;'>";
        echo "<a href=".$linkUndelete.">";
        echo JOO_UNDELETE;
        echo "</a>";
        echo "</td>";

        echo "<td style='width: 25px; padding-left: 5px;'>";
        echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/purge.gif' align='center' border='0'>";
        echo "</td>";
        echo "<td style='width: 120px; padding-left: 5px;'>";
        echo "<a href=".$linkPurge.">";
        echo JOO_PURGE;
        echo "</a>";
        echo "</td>";

    }
    else {

        echo "<td style='width: 25px; padding-left: 5px;'>";
        echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/delete.gif' align='center' border='0'>";
        echo "</td>";

        echo "<td style='width: 75px; padding-left: 5px;'>";
        echo "<a href=".$linkDelete.">";
        echo JOO_DELETE;
        echo "</a>";
        echo "</td>";

    }

    echo "</tr>";
    echo "</table>";

    echo "</div>";



    // DB update

    if( $box == "in") { // only set read flag in inbox

        $sql = "UPDATE #__primezilla_inbox
                                SET flag_read = '1', read_date = CURRENT_DATE(), read_time = CURRENT_TIME()
                                WHERE id = $msgid and flag_read = '0'";

        $database->setQuery( $sql);
        if ($database->getErrorNum()) {
            echo $database->stderr();
        } else {
            $database->query();
        }

        $sql = "UPDATE #__primezilla_outbox
                                SET flag_read = '1', read_date = CURRENT_DATE(), read_time = CURRENT_TIME()
                                WHERE id = $msgid and flag_read = '0'";

        $database->setQuery( $sql);
        if ($database->getErrorNum()) {
            echo $database->stderr();
        } else {
            $database->query();
        }

    }





    echo "<table class=\"jooReadTable\" bgcolor=\"#CCCCCC\" cellspacing=\"1\" cellpadding=\"0\" width=\"100%\">";
    echo "<tr>";

    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
    echo "<b>".JOO_FROM.":</b> ";
    echo $msg_from;
    echo "</td>";

    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
    echo "<b>".JOO_DATE.":</b> ";
    echo $msg_date;
    echo "</td>";

    echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
    echo "<b>".JOO_TIME.":</b> ";
    echo $msg_time;
    echo "</td>";

    echo "</tr>";



    echo "<tr>";

    echo "<td colspan=\"3\" class=\"jooReadTable\" id=\"jooReadTableSubject\" >";
    echo $msg_subject;
    echo "</td>";

    echo "</tr>";



    echo "<tr>";

    echo "<td colspan=\"3\" class=\"jooReadTable\" style=\"padding: 5px;\" >";
    echo nl2br( $msg_message);
    echo "</td>";

    echo "</tr>";

    echo "</table>";


}
else { // not authorized

    echo JOO_NO_ACCESS;
    echo "<br />";
    echo "<br />";

}




echo "<br />";
echo "<br />";


include($mosConfig_absolute_path.'/components/com_primezilla/footer.php');

echo "</div>";
?>


