<?php
/**
 * primezilla.php
 *
 * This file controls the frontend calls
 *
 *
 * @package com_primezilla
 * @subpackage frontend
 *
 * @copyright 2006 joomster.com Achim Fischer
 * @author Achim Fischer
 *
 * This file is part of joomster.com Primezilla.
 *
 * Primezilla is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Primezilla is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Primezilla; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
?>

<script src="components/com_primezilla/js/prototype.js" type="text/javascript"></script>
<script src="components/com_primezilla/js/scriptaculous.js" type="text/javascript"></script>


<script type="text/javascript">
function checkboxStateAll() {

  var cbMsg = document.msgform.cb;
  var cbAll = document.msgform.cball;

  var jsMessages = "";


  if( cbAll.checked == true) { // mark all checked
    if(cbMsg.length == undefined) {
        cbMsg.checked = true;
        document.msgform.selectedMessages.value = cbMsg.value;
    }
    else {
        for(i=0; i<cbMsg.length; i++) {
            cbMsg[i].checked = true;
            if( jsMessages == "") {
                jsMessages = cbMsg[i].value;
            }
            else {
                jsMessages += " " + cbMsg[i].value;
            }
        }
        document.msgform.selectedMessages.value = jsMessages;

    }
  }
  else { // mark all unchecked
    if(cbMsg.length == undefined) {
        cbMsg.checked = false;
        document.msgform.selectedMessages.value = "";
    }
    else {
        for(i=0; i<cbMsg.length; i++) {
            cbMsg[i].checked = false;
        }
        document.msgform.selectedMessages.value = "";
    }

  }

}

function checkboxState() {

  var cbMsg = document.msgform.cb;

  var jsMessages = "";

  if( cbMsg.checked == true) { // one checkbox only
        jsMessages = cbMsg.value;
  }
  else if( cbMsg.checked == false) { // one checkbox only
        jsMessages = "";
  }
  else {
    for(i=0; i<cbMsg.length; i++) {
        if( cbMsg[i].checked == true) {
            if( jsMessages == "") {
                jsMessages = cbMsg[i].value;
            }
            else {
                jsMessages += " " + cbMsg[i].value;
            }
        }
    }
  }
  document.msgform.selectedMessages.value = jsMessages;

}
</script>


<?php
$Itemid = intval( mosGetParam( $_REQUEST, 'Itemid', '0' ) );
$page   = strval( mosGetParam( $_REQUEST, 'page', '' ) );


// get language file for primezilla
if(file_exists($mainframe->getCfg('absolute_path').'/components/com_primezilla/language/'.$mainframe->getCfg('lang').'.php')) {
  require_once($mainframe->getCfg('absolute_path').'/components/com_primezilla/language/'.$mainframe->getCfg('lang').'.php');
}
else {
  require_once($mainframe->getCfg('absolute_path').'/components/com_primezilla/language/english.php');
}


switch ($page) {

  case 'inbox': {
    include($mosConfig_absolute_path.'/components/com_primezilla/inbox.php');
    break;
  }

  case 'outbox': {
    include($mosConfig_absolute_path.'/components/com_primezilla/outbox.php');
    break;
  }

  case 'trash': {
    include($mosConfig_absolute_path.'/components/com_primezilla/trash.php');
    break;
  }

  case 'write': {
    include($mosConfig_absolute_path.'/components/com_primezilla/write.php');
    break;
  }

  case 'read': {
    include($mosConfig_absolute_path.'/components/com_primezilla/read.php');
    break;
  }

  case 'preferences': {
    include($mosConfig_absolute_path.'/components/com_primezilla/preferences.php');
    break;
  }

  default: {
    include($mosConfig_absolute_path.'/components/com_primezilla/inbox.php');
    break;
  }

}

?>

