<?php
/**
 * preferences.php
 *
 * Screen for user preferences
 *
 *
 * @package com_primezilla
 * @subpackage frontend
 *
 * @copyright 2006 joomster.com Achim Fischer
 * @author Achim Fischer
 *
 * This file is part of joomster.com Primezilla.
 *
 * Primezilla is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Primezilla is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Primezilla; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
?>

<link rel="stylesheet" href="components/com_primezilla/primezilla.css" type="text/css" />

<?php
global $database;

$Itemid = intval( mosGetParam( $_REQUEST, 'Itemid', '0' ) );
$page   = strval( mosGetParam( $_REQUEST, 'page', '' ) );
$box    = strval( mosGetParam( $_REQUEST, 'box', '' ) );

$dbmode                     = intval( mosGetParam( $_REQUEST, 'dbmode', '0' ) ); // 0=no dbmode, 1=insert, 2=update
$msgs_per_page              = intval( mosGetParam( $_REQUEST, 'msgs_per_page', '0' ) );
$use_email_notification     = intval( mosGetParam( $_REQUEST, 'use_email_notification', '0' ) );
$use_signature              = intval( mosGetParam( $_REQUEST, 'use_signature', '0' ) );
$use_signature_for_replies  = intval( mosGetParam( $_REQUEST, 'use_signature_for_replies', '0' ) );
$signature                  = strval( mosGetParam( $_REQUEST, 'signature', '' ) );

$myUserId   = $my->id;
$myUserName = $my->username;



$database->setQuery("SELECT * FROM #__primezilla_config LIMIT 1");
$conf = $database->loadObjectList();

$iConfigMsgsPerPage             = $conf[0]->msgs_per_page;

$iEmailNotificationIsAllowed    = $conf[0]->email_notification_is_allowed;
$iEmailNotificationIsDefault    = $conf[0]->email_notification_is_default;
$iEmailNotificationIsChangeable = $conf[0]->email_notification_is_changeable;
$sEmailServer                   = $conf[0]->email_server;
$sEmailUser                     = $conf[0]->email_user;
$sEmailPassword                 = $conf[0]->email_password;
$sEmailFrom                     = $conf[0]->email_from;
$sEmailSubject                  = $conf[0]->email_subject;
$sEmailHeader                   = $conf[0]->email_header;
$sEmailFooter                   = $conf[0]->email_footer;
$iEmailUseBanner                = $conf[0]->email_use_banner;
$sEmailBanner                   = $conf[0]->email_banner;




// default settings
$iMsgPerPage  = $iConfigMsgsPerPage;
$bUseEmailNotification = $iEmailNotificationIsDefault;
$bUseSignature = false;
$bUseSignatureForReplies = false;
$sSignature = "";




echo "<div class=\"jooWrapper\">";

    include($mosConfig_absolute_path.'/components/com_primezilla/topmenu.php');


    if ( $dbmode == 1 ) {  // insert

        if( $myUserId > 0) {  // check if user is logged in

            // 1. insert message into inbox of receiver
            $isql = "INSERT INTO #__primezilla_preferences (
		                          id, msgs_per_page, use_email_notification, use_signature, use_signature_for_replies, signature
						      )
						      VALUES (
						          '$myUserId', '$msgs_per_page', '$use_email_notification', '$use_signature', '$use_signature_for_replies', '$signature'
						      )";

            $database->setQuery( $isql);

            if ($database->getErrorNum()) {
                echo $database->stderr();
            } else {
                $database->query();
            }

            echo "<center>";
                echo "<div id=\"jooInfoSuccess\">";
		          echo JOO_PREF_SAVE_OK;
                echo "</div>";
            echo "</center>";

        }
        else {
            echo "<br />";
            echo "Sorry, you have to log in to save preferences";
            echo "<br />";
            echo "<br />";
            echo "Maybe your connection timed out?";
            echo "<br />";
            echo "<br />";
        }

    }


    if ( $dbmode == 2 ) {  // update

        if( $myUserId > 0) {  // check if user is logged in

            // 1. insert message into inbox of receiver
            $usql = "UPDATE #__primezilla_preferences SET
		                          msgs_per_page = '$msgs_per_page',
		                          use_email_notification = '$use_email_notification',
		                          use_signature = '$use_signature',
		                          use_signature_for_replies = '$use_signature_for_replies',
		                          signature = '$signature'
                                WHERE id = $myUserId";

            $database->setQuery( $usql);

            if ($database->getErrorNum()) {
                echo $database->stderr();
            } else {
                $database->query();
            }

            echo "<center>";
                echo "<div id=\"jooInfoSuccess\">";
		          echo JOO_PREF_UPDATE_OK;
                echo "</div>";
            echo "</center>";

        }
        else {
            echo "<br />";
            echo "Sorry, you have to log in to update preferences";
            echo "<br />";
            echo "<br />";
            echo "Maybe your connection timed out?";
            echo "<br />";
            echo "<br />";
        }

    }


    echo "<div style='text-align: left;'>";

    echo "<h2>".JOO_PREFERENCES."</h2>";

    echo "</div>";

    echo "<br />";
    echo "<br />";


    // get user preferences
    $database->setQuery("SELECT * FROM #__primezilla_preferences WHERE id='$myUserId'");
    $pref = $database->loadObjectList();

    if( $pref != null) {  // got a record for this user
        $iMsgPerPage                = $pref[0]->msgs_per_page;
        $bUseEmailNotification      = $pref[0]->use_email_notification;
        $bUseSignature              = $pref[0]->use_signature;
        $bUseSignatureForReplies    = $pref[0]->use_signature_for_replies;
        $sSignature                 = $pref[0]->signature;

        $iDbMode = 2; // update
    }
    else {
        $iDbMode = 1; // insert
    }


	$sFormLink = sefRelToAbs( "index.php?option=com_primezilla&amp;page=preferences&amp;Itemid=".$Itemid);
    echo "<form action=".$sFormLink." method=\"post\" name=\"preferencesform\" id=\"preferencesform\">";

    echo "<center>";

        echo "<table class=\"jooReadTable\" bgcolor=\"#CCCCCC\" cellspacing=\"1\" cellpadding=\"0\" width=\"100%\">";

            echo "<tr>";
                echo "<th colspan='2' class=\"jooReadTable\">";
                    echo JOO_PREF_FOR_USER.$myUserName;
                echo "</th>";
            echo "</tr>";


            echo "<tr>";

                echo "<td class=\"jooReadTable\" width='30%' style=\"padding: 5px;\" >";
                    echo "<b>".JOO_PREF_MSG_PER_PAGE.":</b> ";
                echo "</td>";

                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
                    echo "<select name='msgs_per_page'>";

				        if ( $iMsgPerPage == 10) {
				            echo "<option value='10' selected>10</option>";
				        }
				        else {
				            echo "<option value='10'>10</option>";
				        }
				        if ( $iMsgPerPage == 20) {
				            echo "<option value='20' selected>20</option>";
				        }
				        else {
				            echo "<option value='20'>20</option>";
				        }
				        if ( $iMsgPerPage == 30) {
				            echo "<option value='30' selected>30</option>";
				        }
				        else {
				            echo "<option value='30'>30</option>";
				        }
				        if ( $iMsgPerPage == 40) {
				            echo "<option value='40' selected>40</option>";
				        }
				        else {
				            echo "<option value='40'>40</option>";
				        }
				        if ( $iMsgPerPage == 50) {
				            echo "<option value='50' selected>50</option>";
				        }
				        else {
				            echo "<option value='50'>50</option>";
				        }

				    echo "</select>";

                echo "</td>";

            echo "</tr>";


            if ( $iEmailNotificationIsAllowed == 1 && $iEmailNotificationIsChangeable == 1) {
            echo "<tr>";

                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
                    echo "<b>".JOO_PREF_USE_EMAIL_NOTIFICATION.":</b> ";
                echo "</td>";

                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";

                    echo "<select name='use_email_notification'>";

				        if ( $bUseEmailNotification == 1) {
				            echo "<option value='1' selected>".JOO_YES."</option>";
				        }
				        else {
				            echo "<option value='1'>".JOO_YES."</option>";
				        }
				        if ( $bUseEmailNotification == 0) {
				            echo "<option value='0' selected>".JOO_NO."</option>";
				        }
				        else {
				            echo "<option value='0'>".JOO_NO."</option>";
				        }

				    echo "</select>";

                echo "</td>";

            echo "</tr>";
            }

            echo "<tr>";

                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
                    echo "<b>".JOO_PREF_USE_SIGNATURE.":</b> ";
                echo "</td>";

                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";

                    echo "<select name='use_signature'>";

				        if ( $bUseSignature == 1) {
				            echo "<option value='1' selected>".JOO_YES."</option>";
				        }
				        else {
				            echo "<option value='1'>".JOO_YES."</option>";
				        }
				        if ( $bUseSignature == 0) {
				            echo "<option value='0' selected>".JOO_NO."</option>";
				        }
				        else {
				            echo "<option value='0'>".JOO_NO."</option>";
				        }

				    echo "</select>";

                echo "</td>";

            echo "</tr>";



            echo "<tr>";

                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";
                    echo "<b>".JOO_PREF_USE_SIGNATURE_FOR_REPLIES.":</b> ";
                echo "</td>";

                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";

                    echo "<select name='use_signature_for_replies'>";

				        if ( $bUseSignatureForReplies == 1) {
				            echo "<option value='1' selected>".JOO_YES."</option>";
				        }
				        else {
				            echo "<option value='1'>".JOO_YES."</option>";
				        }
				        if ( $bUseSignatureForReplies == 0) {
				            echo "<option value='0' selected>".JOO_NO."</option>";
				        }
				        else {
				            echo "<option value='0'>".JOO_NO."</option>";
				        }

				    echo "</select>";

                echo "</td>";

            echo "</tr>";



            echo "<tr>";
                echo "<td class=\"jooReadTable\" valign=\"top\" style=\"padding: 5px;\" >";
                    echo "<b><br />".JOO_PREF_SIGNATURE.":</b> ";
                echo "</td>";
                echo "<td class=\"jooReadTable\" style=\"padding: 5px;\" >";

                    echo "<textarea name='signature' cols='80' rows='5' wrap='VIRTUAL' >";
                            echo $sSignature;
                    echo "</textarea>";

                echo "</td>";
            echo "</tr>";

        echo "</table>";

        echo "</center>";


        echo "<br />";
        echo "<br />";
        echo "<input type='hidden' name='dbmode' value='$iDbMode'>";

        echo "<div style='text-align: left;'>";

        echo "<input type=\"submit\" name=\"savepreferences\" class=\"button\" value=\"".JOO_PREF_BUTTON_SAVE."\" />";

        echo "</div>";

    echo "</form>";



    echo "<br />";
    echo "<br />";
    echo "<br />";
    echo "<br />";


    include($mosConfig_absolute_path.'/components/com_primezilla/footer.php');

echo "</div>";
?>

<script type="text/javascript">
<!--
  Effect.Fade('jooInfoSuccess', {duration:3.0});
-->
</script>

