<?php
/**
 * outbox.php
 *
 * Displays the outbox screen with all sent messages
 *
 *
 * @package com_primezilla
 * @subpackage frontend
 *
 * @copyright 2006 joomster.com Achim Fischer
 * @author Achim Fischer
 *
 * This file is part of joomster.com Primezilla.
 *
 * Primezilla is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Primezilla is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Primezilla; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
?>

<link rel="stylesheet" href="components/com_primezilla/primezilla.css" type="text/css" />

<?php
global $database;


$Itemid  = intval( mosGetParam( $_REQUEST, 'Itemid', '0' ) );
$trash   = intval( mosGetParam( $_REQUEST, 'trash', '0' ) );
$msgid   = intval( mosGetParam( $_REQUEST, 'msgid', '0' ) );

$mode    = strval( mosGetParam( $_REQUEST, 'mode', '' ) );
$selMsg  = strval( mosGetParam( $_REQUEST, 'selectedMessages', '' ) );
$button  = strval( mosGetParam( $_REQUEST, 'submit', '' ) );


// paging values
$limitstart = intval( mosGetParam( $_REQUEST, 'limitstart', 0 ) );

$myUserId = $my->id;

$sFadeMode = -1; // presetting



$database->setQuery("SELECT * FROM #__primezilla_preferences WHERE id='$myUserId'");
$pref = $database->loadObjectList();

if( $pref != null) {  // got a preference record for this user
    $limit  = $pref[0]->msgs_per_page;
}
else { // take the defaults
    $database->setQuery("SELECT * FROM #__primezilla_config LIMIT 1");
    $def = $database->loadObjectList();
    $limit  = $def[0]->msgs_per_page;
}




echo "<div class=\"jooWrapper\">";

    include($mosConfig_absolute_path.'/components/com_primezilla/topmenu.php');


    if( $button == JOO_BUTTON_DELETE) {
      if( strlen( $selMsg) > 0) {
        $whereclause="";
        $tok = strtok( $selMsg, " ");
        while ($tok !== false) {
            $whereclause .= "id='".$tok."'";
            $tok = strtok(" ");
            if( $tok !== false) {
                $whereclause .= " OR ";
            }
        }

        $sql = "UPDATE #__primezilla_outbox SET flag_deleted='1' WHERE $whereclause";

        $database->setQuery( $sql);

        if ($database->getErrorNum()) {
            echo $database->stderr();
        } else {
            $database->query();
        }

        echo "<center>";
        echo "<div id=\"jooInfoSuccess\">";
		    echo JOO_DELETE_OK;
        echo "</div>";
        echo "</center>";

        $sFadeMode = 0; // success

        unset($mode);
      }
    }

    if( $button == JOO_BUTTON_UNDELETE) {
      if( strlen( $selMsg) > 0) {
        $whereclause="";
        $tok = strtok( $selMsg, " ");
        while ($tok !== false) {
            $whereclause .= "id='".$tok."'";
            $tok = strtok(" ");
            if( $tok !== false) {
                $whereclause .= " OR ";
            }
        }

        $sql = "UPDATE #__primezilla_outbox SET flag_deleted='0' WHERE $whereclause AND flag_deleted='1'";

        $database->setQuery( $sql);

        if ($database->getErrorNum()) {
            echo $database->stderr();
        } else {
            $database->query();
        }

        echo "<center>";
            echo "<div id=\"jooInfoSuccess\">";
	       	    echo JOO_UNDELETE_OK;
            echo "</div>";
        echo "</center>";

        $sFadeMode = 0; // success

        unset($mode);
      }
    }





    if( $button == JOO_BUTTON_PURGE) {
      if( strlen( $selMsg) > 0) {
        $whereclause="";
        $tok = strtok( $selMsg, " ");
        while ($tok !== false) {
            $whereclause .= "id='".$tok."'";
            $tok = strtok(" ");
            if( $tok !== false) {
                $whereclause .= " OR ";
            }
        }

        $sql = "DELETE FROM #__primezilla_outbox WHERE $whereclause AND flag_deleted='1'";

        $database->setQuery( $sql);

        if ($database->getErrorNum()) {
            echo $database->stderr();
        } else {
            $database->query();
        }

        echo "<center>";
        echo "<div id=\"jooInfoSuccess\">";
		    echo JOO_PURGE_OK;
        echo "</div>";
        echo "</center>";

        $sFadeMode = 0; // success

        unset($mode);
      }
    }



    // delete msg
    if( $mode == "d") {
        $database->setQuery( "SELECT userid FROM #__primezilla_outbox WHERE id='$msgid'");
        $dMsgId = $database->loadResult();

        if( $my->id == $dMsgId) {  // make sure this is the owner
            $sql = "UPDATE #__primezilla_outbox SET flag_deleted='1' WHERE id='$msgid'";

            $database->setQuery( $sql);

            if ($database->getErrorNum()) {
                echo $database->stderr();
            } else {
                $database->query();
            }

            echo "<center>";
                echo "<div id=\"jooInfoSuccess\">";
		          echo JOO_DELETE_OK;
                echo "</div>";
            echo "</center>";

            $sFadeMode = 0; // success

            unset($mode);
        }
        else {
            echo "<center>";
                echo "<div id=\"jooInfoError\">";
		          echo JOO_NO_ACCESS;
                echo "</div>";
            echo "</center>";
            $sFadeMode = 1; // error
        }

    }
    // delete msg


    // undelete msg
    if( $mode == "u") {
        $database->setQuery( "SELECT userid FROM #__primezilla_outbox WHERE id='$msgid'");
        $dMsgId = $database->loadResult();

        if( $my->id == $dMsgId) {  // make sure this is the owner
            $sql = "UPDATE #__primezilla_outbox SET flag_deleted = '0' WHERE id = $msgid and flag_deleted = '1'";

            $database->setQuery( $sql);
            if ($database->getErrorNum()) {
                echo $database->stderr();
            } else {
                $database->query();
            }

            echo "<center>";
                echo "<div id=\"jooInfoSuccess\">";
		          echo JOO_UNDELETE_OK;
                echo "</div>";
            echo "</center>";

            $sFadeMode = 0; // success

            unset($mode);
        }
        else {
            echo "<center>";
                echo "<div id=\"jooInfoError\">";
		          echo JOO_NO_ACCESS;
                echo "</div>";
            echo "</center>";
            $sFadeMode = 1; // error
        }

    }
    // undelete msg


    // purge msg
    if( $mode == "p") {
        $database->setQuery( "SELECT userid FROM #__primezilla_outbox WHERE id='$msgid'");
        $dMsgId = $database->loadResult();

        if( $my->id == $dMsgId) {  // make sure this is the owner
            $sql = "DELETE FROM #__primezilla_outbox WHERE id = $msgid and flag_deleted = '1'";

            $database->setQuery( $sql);
            if ($database->getErrorNum()) {
                echo $database->stderr();
            } else {
                $database->query();
            }

            echo "<center>";
                echo "<div id=\"jooInfoSuccess\">";
		          echo JOO_PURGE_OK;
                echo "</div>";
            echo "</center>";

            $sFadeMode = 0; // success

            unset($mode);
        }
        else {
            echo "<center>";
                echo "<div id=\"jooInfoError\">";
		          echo JOO_NO_ACCESS;
                echo "</div>";
            echo "</center>";
            $sFadeMode = 1; // error
        }
    }
    // purge msg



    echo "<div style='text-align: left;'>";

    if ( $trash <> 1) {
        echo "<h2>".JOO_OUTBOX."</h2>";
        echo "<br />";
    }
    else {
        echo "<h2>".JOO_OUTBOX_TRASH."</h2>";
        echo "<br />";
    }

    echo "</div>";


    $linkNewMsg  = sefRelToAbs( "index.php?option=com_primezilla&page=write&Itemid=".$Itemid);
    $linkTrash   = sefRelToAbs( "index.php?option=com_primezilla&page=outbox&trash=1&Itemid=".$Itemid);

    echo "<table style=\"width: 100%; margin: 5px;\">";
        echo "<tr>";

            echo "<td width='30' align='center' valign='center'>";
                echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/messagenew.gif' align='center' border='0'>";
            echo "</td>";
            echo "<td>";
                echo "<a href=".$linkNewMsg.">";
                    echo JOO_NEW_MESSAGE;
                echo "</a>";
            echo "</td>";

            echo "<td>";
                    echo "&nbsp;";
            echo "</td>";


            // count msg in trash
            $database->setQuery( "SELECT count(*) FROM #__primezilla_outbox WHERE userid=$myUserId AND flag_deleted='1'");
            $count_deleted = $database->loadResult();

            echo "<td width='30' align='center' valign='center'>";
                if ( $count_deleted > 0) {
                    echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/trashfull.gif' align='center' border='0'>";
                }
                else {
                    echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/trashempty.gif' align='center' border='0'>";
                }
            echo "</td>";
            echo "<td width='110' align='center' valign='center'>";
                echo "<a href=".$linkTrash.">";
                    echo JOO_TRASH." (".$count_deleted.")";
                echo "</a>";
            echo "</td>";

        echo "</tr>";
    echo "</table>";


    echo "<br />";


    // read tables
    if ( $trash <> 1) {

        // get counter
     	$database->setQuery( "SELECT count(*) FROM #__primezilla_outbox WHERE userid=$myUserId AND flag_deleted='0'");
     	$total = $database->loadResult();

     	if ($total <= $limit) {
     		$limitstart = 0;
     	}

        // build outbox page
        $database->setQuery("SELECT * FROM #__primezilla_outbox WHERE userid=$myUserId AND flag_deleted='0' ORDER BY msg_date DESC, msg_time DESC LIMIT $limitstart, $limit");

    }
    else {

        // get counter
     	$database->setQuery( "SELECT count(*) FROM #__primezilla_outbox WHERE userid=$myUserId AND flag_deleted='1'");
     	$total = $database->loadResult();

     	if ($total <= $limit) {
     		$limitstart = 0;
     	}
        // build trash page
        $database->setQuery("SELECT * FROM #__primezilla_outbox WHERE userid=$myUserId AND flag_deleted='1' ORDER BY msg_date DESC, msg_time DESC LIMIT $limitstart, $limit");
    }

    $rows = $database->loadObjectList();

    require_once( $mosConfig_absolute_path."/includes/pageNavigation.php");
    $pageNav = new mosPageNav( $total, $limitstart, $limit );


    if ( $trash==1){
        $linkForm = sefRelToAbs( "index.php?option=com_primezilla&amp;page=outbox&amp;box=out&amp;trash=1&amp;Itemid=".$Itemid);
    }
    else {
        $linkForm = sefRelToAbs( "index.php?option=com_primezilla&amp;page=outbox&amp;box=out&amp;Itemid=".$Itemid);
    }

	echo "<form action=\"$linkForm\" method=\"post\" name=\"msgform\" id=\"msgform\">";

    echo "<table class=\"jooInboxTable\" bgcolor=\"#CCCCCC\" cellspacing=\"1\" cellpadding=\"0\" >";
        echo "<tr>";

            echo "<th class=\"jooOutboxCellHeader\" style=\"width: 20px; padding: 5px; text-align: center;\" >";
                echo "<center><input type=\"checkbox\" name=\"cball\" onclick=\"checkboxStateAll()\" class=\"inputbox\" /></center>";
            echo "</th>";

            /*
            echo "<th class=\"jooOutboxCellHeader\" style=\"padding: 5px;\" >";
                echo JOO_PRIORITY;
            echo "</th>";
            */

            echo "<th class=\"jooOutboxCellHeader\" style=\"width: 120px; padding: 5px;\" >";
                echo JOO_TO;
            echo "</th>";

            echo "<th class=\"jooOutboxCellHeader\" style=\"padding: 5px;\" >";
                echo JOO_SUBJECT;
            echo "</th>";

            echo "<th class=\"jooOutboxCellHeader\" style=\"width: 60px; padding: 5px;\" >";
                echo JOO_DATE;
            echo "</th>";

            echo "<th class=\"jooOutboxCellHeader\" style=\"width: 60px; padding: 5px;\" >";
                echo JOO_TIME;
            echo "</th>";

            echo "<th class=\"jooOutboxCellHeader\" style=\"width: 20px; padding: 5px; text-align: center;\" >";
                echo JOO_READ;
            echo "</th>";

        echo "</tr>";

    foreach($rows as $row) {

        echo "<tr>";

            echo "<td class=\"jooInboxCellRead\" style=\"padding:5px;\">";
                echo "<center><input type=\"checkbox\" name=\"cb\" value=\"$row->id\" onclick=\"checkboxState()\" class=\"inputbox\" /></center>";
            echo "</td>";

            /*
            echo "<td style=\"text-align: center;\" class=\"jooInboxCellRead\" style=\"padding: 5px;\" >";
                echo $row->priority;
            echo "</td>";
            */

            echo "<td class=\"jooInboxCellRead\" style=\"padding:5px;\">";
                echo $row->username_to;
            echo "</td>";


            echo "<td class=\"jooInboxCellRead\" style=\"padding:5px;\">";

                if( $trash<>1) {
                    $linkReadMsg  = sefRelToAbs( "index.php?option=com_primezilla&page=read&box=out&msgid=".$row->id."&Itemid=".$Itemid);
                }
                else {
                    $linkReadMsg  = sefRelToAbs( "index.php?option=com_primezilla&page=read&box=out&trash=1&msgid=".$row->id."&Itemid=".$Itemid);
                }
                echo "<a href=".$linkReadMsg." style=\"font-weight:normal;\">";
                    echo $row->subject;
                echo "</a>";

            echo "</td>";


            echo "<td class=\"jooInboxCellRead\" style=\"padding:5px;\">";
                echo $row->msg_date;
            echo "</td>";


            echo "<td class=\"jooInboxCellRead\" style=\"padding:5px;\">";
                echo $row->msg_time;
            echo "</td>";


            echo "<td class=\"jooInboxCellRead\" style=\"padding:5px;\">";
                echo "<center>";
                if ( $row->flag_read == 0) {  // not read yet
                    echo " - ";
                }
                else {
                    $sAltTag = JOO_MESSAGE_WAS_READ_ON." ".$row->read_date." ".JOO_MESSAGE_WAS_READ_AT." ".$row->read_time;
                    echo "<img src='".$mosConfig_live_site."/components/com_primezilla/images/readcommit.gif' align='center' border='0' alt='$sAltTag' title='$sAltTag'>";
                }
                echo "</center>";
            echo "</td>";


        echo "</tr>";

    }

    echo "</table>";

    echo "<br />";

    echo "<input type=\"hidden\" name=\"selectedMessages\" value=\"\">";


    echo "<div style='text-align: left;'>";

    if( $trash == 1) {
        echo "<input type=\"submit\" name=\"submit\" class=\"button\" value=\"".JOO_BUTTON_UNDELETE."\" />";
        echo "&nbsp;";
        echo "<input type=\"submit\" name=\"submit\" class=\"button\" value=\"".JOO_BUTTON_PURGE."\" />";
    }
    else {
        echo "<input type=\"submit\" name=\"submit\" class=\"button\" value=\"".JOO_BUTTON_DELETE."\" />";
    }

    echo "</div>";

	echo "</form>";



    echo "<br />";
    echo "<br />";

    echo "<center>";
	$pageNav->writePagesCounter();
    if ( $trash==1){
	   echo $pageNav->writePagesLinks("index.php?option=com_primezilla&page=outbox&trash=1&Itemid=$Itemid");
    }
    else {
	   echo $pageNav->writePagesLinks("index.php?option=com_primezilla&page=outbox&Itemid=$Itemid");
    }
    echo "</center>";



    echo "<br />";
    echo "<br />";

    include($mosConfig_absolute_path.'/components/com_primezilla/footer.php');

echo "</div>";
?>



<?php
if( $sFadeMode == 0) {  // success
?>

<script type="text/javascript">
<!--
  Effect.Fade('jooInfoSuccess', {duration:3.0});
-->
</script>

<?php
}


if ( $sFadeMode == 1) {
?>

<script type="text/javascript">
<!--
  Effect.Fade('jooInfoError', {duration:3.0});
-->
</script>

<?php
}
?>

