<?php 
// Events//
// Copyright (C) 2004 Rob Clayburn
// All rights reserved.
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
// v 0.1a
// Rob Clayburn <rob@pollen-8.co.uk>
// ################################################################
// MOS Intruder Alerts
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');
// ################################################################
require_once($mainframe->getPath('front_html'));

require_once($mainframe->getPath('class'));

/**
 * CORE
 */

if (!isset ($act)) {
	$act = "";
} 

$arErrors = array();

switch ($act) {
	case "processform":

		$fileUploadFound = CheckForFileUpload($_POST);

		$arErrors = ValidateForm($_POST, $form_id, $fileUploadFound); 
		// print_r($arErrors);
		$row = getFormData($form_id);

		$form_err_message = $row->form_errmessage;

		if (count($arErrors) == 0) {
			if ($fileUploadFound) {
				$myTargetFolder = $_POST['ul_directory'];

				$myFileName = $_FILES['ul_userfile']['name'];

				$tmpFile = $_FILES['ul_userfile']['tmp_name'];

				$destFile = $mosConfig_absolute_path . $myTargetFolder . '/' . $myFileName;

				if (move_uploaded_file($tmpFile, $destFile) == false) {
					$arErrors['ul_userfile'][] = 'The file upload was unsuccessful (from $tmpFile to $destFile), please try again';

					writeform($form_id, $arErrors, $_POST, $form_err_message);

					break;
				} 
			} 

			if ($row->record_in_database == '1') {
				SubmitToDatabase($_POST, $form_id);
			} 

			if ($row->receipt_email != "") {
				SendReceipt($_POST, $form_id, $row);
			} 

			if (SendEmail($_POST, $row, $fileUploadFound)) {
				$row->form_submit_message = parseMessageForPlaceHolder($row->form_submit_message);

				mosform_html_content::displayThanks($row->form_title, $row->form_submit_message);
			} else {
				mosRedirect($row->form_submit_jumppage);
			} 
		} else {
			writeform($form_id, $arErrors, $_POST, $form_err_message);
		} 

		break;

	default:

		$form_id = $_GET['mosform'];

		writeform($form_id, $arErrors, $_POST, '');

		break;
} 
// this checks to see if the form has a file upload element
// and returns the correct
// encoding type for the form
function getFormEncType($form_id)
{
	$elements = getFormGroups($form_id);

	foreach($elements as $element) {
		$elementtype_id = $element->elementtype_id;

		if ($elementtype_id == '8') {
			return "multipart/form-data";
		} 
	} 

	return "application/x-www-form-urlencoded";
} 

function FileUpLoadParamsOK($data, $arErrors)
{
	if (!FileUploadFileTypeOK ($data)) {
		$arErrors['ul_userfile'][] = 'The file type is not allowed';
	} 

	if (!FileUploadSizeOK ($data)) {
		$mySize = $_FILES['ul_userfile']['size'];

		$mySize = $mySize / 1000;

		$max_size = $data['ul_max_file_size'];

		$arErrors['ul_userfile'][] = "The file is too large. The maximum file size is $max_size KB and your file is $mySize KB.";
	} 

	return $arErrors;
} 
// This checks the uploaded file type
// against the csv specified in the upload element
function FileUploadFileTypeOK($data)
{
	$ar_default_allowed_ft = array('.gif', '.jpg', '.png', '.bmp', '.doc', '.xls', 'ppt', '.swf', '.pdf', '.dcr');

	$curr_f_ext = strtolower(substr($_FILES['ul_userfile']['name'], -4));

	if (isset($data['ul_file_types']) and $data['ul_file_types'] != "") {
		$ul_file_types = $data['ul_file_types'];

		$ar_file_types = explode(",", $ul_file_types);

		foreach ($ar_file_types as $filetype) {
		
			$filetype = trim($filetype);

			if ($curr_f_ext == $filetype) {
			
				return true;
			} 
			
		} 
		
	} else {
		// check default file types
		foreach($ar_default_allowed_ft as $default_allowed_ft) {
		
			if ($curr_f_ext == $default_allowed_ft) {
			
				return true;
			} 
		} 
	} 

	return false;
} 
// This checks that thte fileupload size is not
// greater than that specified in the upload element
function FileUploadSizeOK($data)
{
	$mySize = $_FILES['ul_userfile']['size'];

	if (isset($data['ul_max_file_size'])) {
	
		$max_size = $data['ul_max_file_size'];
		
		$max_size = $max_size * 1000; //convert kb to bytes
		
		if ($mySize <= $max_size) {
		
			return true;
			
		} 
		
	} 

	return false;
} 

function CheckForFileUpload($data)
{
	if (isset($_FILES['ul_userfile'])) {
	
		if ($_FILES['ul_userfile']['name'] == "") {
	
			return false;
		
		} 
	    
	}


	foreach($data as $key => $val) {
	
		if ($key == "ul_max_file_size") {

			return true;
		} 
	} 

	return false;
} 

function SubmitToDatabase($data, $form_id)
{
	//echo("submitting to database");
	global $database; 
	// see if database exists
	if (DatabaseExists($form_id)) {
		// insert data
		//echo("database found<br>");
		$fields = "(";

		$values = "(";

		$arDontEmailThesKeys = array("Submit", "ul_max_file_size", "ul_file_types", "ul_directory");

		foreach($data as $key => $val) {
		
			if (!in_array($key, $arDontEmailThesKeys)) {
			
				$key = preg_replace("/[^A-Za-z0-9]/", "_", $key); // replace all non alphanumeric characters with _
				
				$fields .= "$key, ";
				
				if (is_array($val)) {
					$values .= "'" . implode(',', $val) . "', ";
					
				} else {
				
					$values .= "'$val', ";
					
				} 
				
			} 
			
		} 
		
		$fields = substr($fields, 0, strlen($fields)-2);
		
		$values = substr($values, 0, strlen($values)-2);
		
		$fields .= ")";
		
		$values .= ")";
		
		$sql = "insert into #__mosform_formdata_" . $form_id . " $fields VALUES $values"; 
		 //echo("sql $sql<br>");
		
		$database->setQuery($sql);
		
		if (!$database->query()) {
		
			$msg = $database->getErrorMsg() . "\n";
		
		} 
	
	} 

} 

function DatabaseExists($form_id)
{
	global $database, $mosConfig_dbprefix;
	$sql = "SHOW TABLES LIKE '" . $mosConfig_dbprefix . "mosform_formdata_" . $form_id . "'";
	//echo "database exsits sql = $sql <br>";
	$database->setQuery($sql);
	$total = $database->loadResult();
	//echo("total = $total<br>");
	$total = substr($total, 4, strlen($total)-1);
		//echo("total = $total<br>");
	if ($total == "mosform_formdata_" . $form_id) {
		return true;
	} else {
		return false;
	} 
} 

function parseMessageForPlaceHolder($msg)
{
	$msg = preg_replace("/{}/", "", $msg); // strip any empty tags
		$msg = preg_replace_callback("/{[^}]+}/i", "replaceWithFormData", $msg); // replace {element name} with form data
	return $msg;
} 

function replaceWithFormData($matches)
{
	$match = $matches[0];

	$match = substr($match, 1, strlen($match) - 2); // strip the {}
	$match = preg_replace("/ /", "_", $match); // replace spaces with
	if (isset($_POST[$match])) {
	    $match = $_POST[$match]; // get the post data
	}else{
		$match = "";
	}
	
	return $match;
} 

function getFormGroups($form_id)
{
	global $database, $my; 
	// get group info for form
	$sql = "SELECT * FROM #__mosform_formgroup

	LEFT JOIN #__mosform_groups 

	ON #__mosform_formgroup.group_id = #__mosform_groups.group_id

	LEFT JOIN #__mosform_elements  

	ON #__mosform_groups.group_id = #__mosform_elements.group_id 

	WHERE #__mosform_formgroup.form_id = '$form_id'

	ORDER BY #__mosform_formgroup.ordering,  #__mosform_formgroup.group_id, #__mosform_elements.ordering";

	$database->setQuery($sql);

	$groups = $database->loadObjectList();

	echo $database->getErrorMsg();

	return $groups;
} 

function writeform($form_id, $arErrors, $data, $form_err_message)
{
	$row = getFormData($form_id);

	$groups = getFormGroups($form_id);

	$enctype = getFormEncType($form_id);

	mosform_html_content::displayForm($row, $groups, $form_id, $arErrors, $data, $form_err_message, $enctype);
} 

function ValidateForm($data, $form_id, $fileUploadFound)
{ 
	// returns an array of error messages called arErrors() [form_element_name, error message]//
	global $database;

	$arErrors = array();

	$elements = getFormGroups($form_id);

	foreach($elements as $element) {
		$element_name = $element->element_name;
		$element_id = $element->element_id;

		$sql = "select * from #__mosform_validations v  left join #__mosform_validation_rules vr on v.validation_rule_id = vr.validation_rule_id where v.element_id = '$element_id'";

		$database->setQuery($sql);

		$validation_rules = $database->loadObjectList();

		foreach($validation_rules as $validation_rule) {
			if ($element_id == $validation_rule->element_id) {
				// echo("<br>");
				// print_r($validation_rule);
				$error_message = $validation_rule->message;
				$alpha_numeric_element_name = preg_replace("/[^A-Za-z0-9]/", "_", $element_name);
				$rule_id = $validation_rule->validation_rule_id;
				$rule_desc = $validation_rule->validation_rule_label;
				$form_data = $data[$alpha_numeric_element_name]; 
				// echo("<br>(rule id = $rule_id), $rule_desc applies to $element_name, whose data is $form_data<br>");
				switch ($rule_id) {
					case 1: // required field
						if ($form_data == "") {
							$arErrors[$alpha_numeric_element_name][] = $error_message;
						} 
						break;
					case 2: // must be alpha numeric
						if (!isAlphaNumeric($form_data)) {
							$arErrors[$alpha_numeric_element_name][] = $error_message;
						} 
						break;

					case 3: // must be an email address//
						if (!check_email_address($form_data)) {
							$arErrors[$alpha_numeric_element_name][] = $error_message;
						} 
						break;

					default: ;
				} // switch
			} 
		} 
	} 
	// get file upload errors
	if ($fileUploadFound) {
		$arErrors = FileUpLoadParamsOK($_POST, $arErrors);
	} 
	// print_r($data);
	return $arErrors;
} 

function SendEmail($data, $row, $fileUploadFound)
{
	global $my, $mosConfig_sitename, $database;

	global $mosConfig_live_site; 
	// print_r($_POST);
	$email_to = $row->email_to;

	$email_from = $row->email_from; 
	// $emailto = $data["mos_mosform_emailaddress_x"];
	$arDontEmailThesKeys = array("Submit", "ul_max_file_size", "ul_file_types");

	$message = "";
	
	foreach($data as $key => $val) {
		if (!in_array($key, $arDontEmailThesKeys)) {
			if (is_array($val)) {
				$message .= $key . ':' . implode(',', $val) . "\n";
			} else {
				$message .= $key . ':' . $val . "\n";
			} 
		} 
	} 

	if ($fileUploadFound) {
		$message .= "file uploaded: " . $_FILES['ul_userfile']['name'] . "\n";
	} 
	// Build e-mail message format
	$headers = getEmailHeaders($email_from, $email_to);

	$message = "This is a mail from " . $mosConfig_sitename . "\r \n \r \nMessage:\r \n" . stripslashes($message);

	if ($row->form_subject == "") {
		$subject = $mosConfig_sitename . " :: Mos Form Test";
	} else {
		$subject = $row->form_subject;
	} 
	// Send email
	$emails = explode(',', $email_to);

	foreach ($emails as $email) {
		mail($email, $subject, $message, $headers);
	} 

	if (isset($row->form_submit_jumppage) and $row->form_submit_jumppage != "") {
		return false;
	} else {
		return true;
	} 
} 

function getEmailHeaders($email_from, $email_to)
{
	$headers = "MIME-Version: 1.0\r\n";

	$headers .= 'From: ' . $email_from . "\r\n";

	$headers .= 'Reply-To: ' . $email_from . "\r\n";

	$headers .= "X-Priority: 3\r\n";

	$headers .= "X-MSMail-Priority: Normal\r\n";

	$headers .= "X-Mailer: Mambo Open Source 4.5\r\n";

	return $headers;
} 

function getFormData($form_id)
{
	global $database;

	$sql = "select * from #__mosform_forms where id = '$form_id'";

	$database->setQuery($sql);

	$rows = $database->loadObjectList();

	echo $database->getErrorMsg();

	if (count($rows) == 0) {
		echo("Error getting form_id to send email!");

		exit;
	} 

	$row = $rows[0];

	return $row;
} 

function SendReceipt($_POST, $form_id, $row)
{
	$message = parseMessageForPlaceHolder($row->receipt_message);
	
	$email_to = $row->email_to;

	$email_from = $row->email_from;

	$headers = getEmailHeaders($email_from, $email_to);

	$email = $_POST[$row->receipt_email];

	$subject = "receipt";

	mail($email, $subject, $message, $headers);
} 

function check_email_address($email)
{ 
	// echo("checking email address: $email");
	// First, we check that there's one symbol, and that the lengths are right
	if (!ereg("[^@]{1,64}@[^@]{1,255}", $email)) {
		// Email invalid because wrong number of characters in one section, or wrong number of symbols.
		return false;
	} 
	// Split it into sections to make life easier
	$email_array = explode("@", $email);

	$local_array = explode(".", $email_array[0]);

	for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[0])) {
			return false;
		} 
	} 

	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) { // Check if domain is IP. If not, it should be valid domain name
		$domain_array = explode(".", $email_array[1]);

		if (sizeof($domain_array) < 2) {
			return false; // Not enough parts to domain
		} 

		for ($i = 0; $i < sizeof($domain_array); $i++) {
			if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
				return false;
			} 
		} 
	} 

	return true;
} 

function isAlphaNumeric($data)
{
	if (ereg('[^A-Za-z0-9]', $data)) {
		return false;
	} else {
		return true;
	} 
} 

?>