<?php

//

// Copyright (C) 2004 Rob Clayburn

// All rights reserved.

//

// This program is free software; you can redistribute it and/or

// modify it under the terms of the GNU General Public License

// as published by the Free Software Foundation; either version 2

// of the License, or (at your option) any later version.

//

// This program is distributed in the hope that it will be useful,

// but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

// GNU General Public License for more details.

//

// You should have received a copy of the GNU General Public License

// along with this program; if not, write to the Free Software

// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

//

// The "GNU General Public License" (GPL) is available at

// http://www.gnu.org/copyleft/gpl.html.

//

// v 0.1a

// Rob Clayburn <rob@pollen-8.co.uk>





// ################################################################

// MOS Intruder Alerts

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// ################################################################

require_once( "includes/HTML_toolbar.php" );


Class mosform_html_content {

	function displayThanks(&$title, &$message){

		//echo("here is the thanks message:");

	  ?>

          <div class="componentheading"> <?php echo $title ?></div>

          <p> <?php echo $message ?></p>



          <?php 

	}

	

	function displayForm($form, $groups, $form_id, $arErrors, $data, $form_err_message, $enctype){


		/*print_r($arErrors);
		echo("<br />");
		print_r($data);*/

		$formwidth = $form->width;

		$formalign = $form->align;

	 	// these should be defined in the admin section //

	 	$default_group_css = "left:10px;right:10px;background-color:#DCDCDC;padding:10px;border:0px solid black;";

		/////////////////////////////////////////////////

		echo("<div style=\"text-align:$formalign;\">\n");
		
		echo("<form name=\"form1\"  enctype=\"$enctype\" method=\"post\" action=\"index.php?option=com_mosforms&amp;act=processform&amp;form_id=$form_id\">\n");

		echo("<span class=\"componentheading\">" . $form->form_title . "</span>\n");
		
		if (count($arErrors != 0)) {
	
		    echo("<p class=\"mosform_error\">$form_err_message</p>");
	
		}

	 	echo("<p>" .  $form->form_introtext . "</p>\n");	

		echo("<div style=\"width:$formwidth;border:0px solid black;\">\n");

		$curGroupID = "";

		$action_id ="";

		$counter = 0;

		
		foreach($groups as $groupelement){

			$counter ++;

			$elementid = "mosform_$counter";

			//echo("curGroupID = $curGroupID <br />");
			//echo("groupelement->group_id = " . $groupelement->group_id);
			if($curGroupID != $groupelement->group_id){

				if($curGroupID != ""){echo "</table>\n";}

				$curGroupID = $groupelement->group_id;

				echo "<span class=\"mosform_group_title\">" . $groupelement->group_title . "</span>\n";

				$group_css = $groupelement->group_css;

				//echo("group_css = $group_css <br>");

				$rubbish = array("<br />","<br>");

				$group_css = trim(str_replace( $rubbish, "", $group_css));

				if($group_css == ""){

					echo "<table style=\"$default_group_css\"";

				}else{

					echo "<table style=\"$group_css\"";

				}

				echo " summary=\"mosForm table to layout dynamc form\">\n";

			}

			$hidden = $groupelement->hidden;

			if ($hidden == "on") {

				$name = $groupelement->element_name;

				$value = $groupelement->default;

	    			echo "<input type=\"hidden\" name=\"$name\" value=\"$value\" />\n ";

			}else{

				$groupeltype = $groupelement->elementtype_id;
				
				
				
				$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $groupelement->element_name);
		
				$err_msg = "";
				
				if (isset($arErrors[$parsed_name])) {
				
					foreach($arErrors[$parsed_name] as $el_err_msg){
						$err_msg .= "$el_err_msg<br/>";
					}
				
				}
					    
				if ($groupeltype == '8') { // file upload element has extra error messages 
				
					if (isset($arErrors['ul_userfile'])) {
					
						foreach($arErrors['ul_userfile'] as $el_err_msg){
						
							$err_msg .= "$el_err_msg<br/>";
							
						}
					
					}
					
				}
				
				

				echo("<tr>\n<td  colspan=\"2\">\n<span class=\"mosform_error\"><strong>$err_msg</strong></span>\n</td>\n</tr>\n");

				if($groupeltype == '7' ){

					echo "<tr>\n<td colspan=\"2\">" . $groupelement->element_label  . "\n</td>\n</tr>";		

				}else{	

					echo "<tr>\n<td> <label for=\"$elementid\">" . $groupelement->element_label  . "</label>\n";
				
				}	
				
				echo "</td><td>";			


				switch($groupeltype){

					case '1':

						//this should not be available !!!

					case '2': 

						mosform_html_content::drawField($groupelement, $elementid, $data, $arErrors);

						break;

					case '3': 

						mosform_html_content::drawCheckBox($groupelement, $elementid, $data, $arErrors);

						break;

					case '4': 

						mosform_html_content::drawRadioButton($groupelement, $elementid, $data, $arErrors);

						break;

					case '5': 

						mosform_html_content::drawTextArea($groupelement, $elementid, $data, $arErrors);

						break;

					case '6': 

						mosform_html_content::drawDropDown($groupelement, $elementid, $data, $arErrors);

						break;

					case '7': 

						mosform_html_content::drawText($groupelement, $elementid, $data, $arErrors);

						break;

					case '8': 

						mosform_html_content::drawFileUpload($groupelement, $elementid, $data, $arErrors);

						break;

					case '9': 

						mosform_html_content::drawImage($groupelement, $elementid, $data, $arErrors);

						break;		
						
					case '10': 

						mosform_html_content::drawUsername($groupelement, $elementid, $data, $arErrors);

						break;			

				} // switch

				echo  ;

				echo "</td>\n</tr>\n";

			}

		}

		echo "<tr>\n";

		echo("<td colspan=\"2\" align=\"right\">\n");

		echo "<input type=\"submit\" name=\"Submit\" value=\"Submit\" />\n ";

		echo "</td>\n</tr>\n";

		if(count($groups) != 0){

			echo("</table>\n");

		}

		echo("</div>\n");

		echo("</form>\n</div>\n");

	}

   

	function drawField($groupelement, $id, $data, $arErrors){

		$name = $groupelement->element_name;

		$size = $groupelement->element_field_width;
		
		$maxlength = $groupelement->maxlength;
		
		if ($maxlength == "0" or $maxlength == "") {
		    
			$maxlength = $size;
		}

		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $name);
				
		if(isset($data[$parsed_name])) {
		
			$value = $data[$parsed_name];
			
		}else{
		
			$value = $groupelement->default;
			
		}
		
		/*if (isset($arErrors[$parsed_name])) {
		    $err_msg = $arErrors[$parsed_name];
		}
		echo($err_msg);*/
		if($groupelement->password == "on"){

			$type = "password";

		}else{

			$type = "text";

		}
		
		echo "<input class=\"inputbox\" type=\"$type\" name=\"$name\" id=\"$id\" size=\"$size\" maxlength=\"$maxlength\" value=\"$value\" />";

	}



	function drawCheckBox($groupelement, $id, $data){

		$name = $groupelement->element_name;

		$ck_value = $groupelement->ck_value;

		if($groupelement->box_checked == "on"){

			echo "<input type=\"checkbox\" name=\"$name\" value=\"$ck_value\" id=\"$id\" checked=\"checked\"/>";

		}else{

			echo "<input type=\"checkbox\" name=\"$name\" value=\"$ck_value\" id=\"$id\" />";

		}

	}



	function drawRadioButton($groupelement, $id, $data){

		$name = $groupelement->element_name;

		$rad_value = $groupelement->rad_value;

		if($groupelement->radio_checked == "on"){

			echo "<input type=\"radio\" name=\"$name\" value=\"$rad_value\" id=\"$id\" checked=\"checked\" />";

		}else{

			echo "<input type=\"radio\" name=\"$name\" value=\"$rad_value\" id=\"$id\" />";

		}

	}



	function drawTextArea($groupelement, $id, $data){

		$name = $groupelement->element_name;

		$cols = $groupelement->element_width;

		$rows = $groupelement->element_height;
		
		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $name);
		
		if(isset($data[$parsed_name])) {
		
			$value = $data[$parsed_name];
			
		}else{
		
			$value = $groupelement->default;
			
		}

		echo "<textarea class=\"inputbox\" name=\"$name\" id=\"$id\" cols=\"$cols\" rows=\"$rows\">" . $value . "</textarea>";

	}



	function drawDropDown($groupelement, $id, $data){

		$name = $groupelement->element_name;
		
		$parsed_name = preg_replace("/[^A-Za-z0-9]/", "_", $name);

		$vals = $groupelement->dd_values;

		$txt = $groupelement->dd_text;

		if(isset($data[$parsed_name])) {
		
			$intital_value = $data[$parsed_name];
			
		}else{
		
			$intital_value = $groupelement->dd_intial_selection;
			
		}

		$arVals = split(",", $vals);

		$arTxt = split(",", $txt);

		$multiple = $groupelement->multiple;

		$str = "<select ";

		

		if($multiple == "on"){

			$name .= "[]"; //add this in to allow for multiple selections //

			$str .=  " multiple=\"multiple\" ";

		}	

		$str .= " name=\"$name\" id=\"$id\" ";

		$str .= ">\n";

		echo $str;

		$i = 0;

		foreach($arVals as $tmpval){

			$tmptxt = $arTxt[$i];

			$str = "<option value=\"$tmpval\" ";

			if($tmpval == $intital_value){

				$str .=  "selected=\"selected\" ";

			}

			$str .= ">$tmptxt</option>\n";

			echo $str;

			$i++;

		}

		echo"</select>\n";

	}



	function drawText($groupelement, $data){}



	function drawFileUpload($groupelement, $data){
	
		global $mosConfig_absolute_path;
		
		$ul_max_file_size = $groupelement->ul_max_file_size;
		
		$ul_directory = $groupelement->ul_directory;
		
		$ul_file_types = $groupelement->ul_file_types;
		
		 echo('<input type="hidden" name="ul_max_file_size" value="' . $ul_max_file_size . '">');
		echo('<input type="hidden" name="ul_directory" value="' . $ul_directory . '">');
		echo('<input type="hidden" name="ul_file_types" value="' . $ul_file_types . '">');
		echo('Send this file: <input name="ul_userfile" type="file">');
	
	}



	function drawImage($groupelement, $data){

		global $mosConfig_absolute_path;

		echo('<img src="/images/' . $groupelement->image_name . '" alt="mosForm image"/>');

	}

	function drawUsername($groupelement, $id){

		global $my;

		$name = $groupelement->element_name;

		$value = $my->username;

		echo "<input type=\"hidden\" name=\"$name\" value=\"$value\" id=\"$id\" />";

	}

}// end class

?>

