<?php
/**
* MkPostman Newsletter Component
* 
* @package MkPostman
* @author: sebastian
* @copyright das medienkombinat <kontakt@das-medienkombinat.de>
* @copyright Soeren Eberhardt <soeren@virtuemart.net>
    (who just needed an easy and *working* Newsletter component for Mambo 4.5.1 and mixed up Newsletter and YaNC)
* @copyright Mark Lindeman <mark@pictura-dp.nl> 
    (parts of the Newsletter component by Mark Lindeman; Pictura Database Publishing bv, Heiloo the Netherland)
* @copyright Adam van Dongen <adam@tim-online.nl>
    (parts of the YaNC component by Adam van Dongen, www.tim-online.nl)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

require_once( "includes/HTML_toolbar.php" );

class HTML_MkPostman {

    function listAll ($menuname, &$rows, $mkpostman_rights, $pageNav )
    {
        global $Itemid, $mosConfig_live_site;
    ?>
    <table width="100%" cellpadding="4" cellspacing="0" border="0" align="center">
        <tr>
        	<td colspan="4" class="componentheading"><?php echo $menuname; ?></td>
			<td align="right" class="componentheading" nowrap="nowrap">
				<?php
				echo '&nbsp;&nbsp;&nbsp;'. _PN_DISPLAY_NR .'&nbsp;';
				$link = 'index.php?option=com_mkpostman&amp;Itemid='. $Itemid;
				echo $pageNav->getLimitBox( $link );
				?>
			</td>
        </tr>
    <?php 
    if (count ($rows )) { ?>
        <tr>
          <td width="32" align="center" class="sectiontableheader">&nbsp;</td>
          <td width="70%" class="sectiontableheader"><?php echo _E_SUBJECT; ?></td>
          <td width="20%" class="sectiontableheader"><?php echo _E_START_PUB;?></td>
          <td width="10%" align="left" class="sectiontableheader"><?php echo _HEADER_HITS;?></td>
          <td width="32" align="center" class="sectiontableheader">&nbsp;</td>
        </tr>
<?php
        $k = 0;
        $tabclass = array("sectiontableentry1", "sectiontableentry2");
        foreach ($rows as $row) {
            $k = $k ? 0 : 1 ;
        ?>
            <tr class="<?php echo $tabclass[$k]; ?>">
              <td width="32" align="center">&nbsp;</td>
              <td width="70%">
              <a href="<?php echo sefRelToAbs("index.php?option=com_mkpostman&amp;task=view&amp;Itemid=$Itemid&amp;id=$row->id"); ?>"><?php echo $row->subject; ?></a>
          <?php
          if( $mkpostman_rights['is_editor'] ) { ?>
              &nbsp;&nbsp;<a title="<?php echo _E_EDIT ?>" href="<?php echo sefRelToAbs("index.php?option=com_mkpostman&amp;task=edit&amp;Itemid=$Itemid&amp;id=$row->id"); ?>">
              <img src="images/M_images/edit.png" align="center" border="0" alt="" /></a>
          <?php 
          }
          if( $mkpostman_rights['is_sender'] ) { ?>
              &nbsp;&nbsp;<a title="<?php echo _SEND_BUTTON ?>" href="<?php echo sefRelToAbs("index.php?option=com_mkpostman&amp;task=sendNow&amp;Itemid=$Itemid&amp;id=$row->id"); ?>">
              <img src="components/com_mkpostman/images/mail_send.png" align="center" border="0" alt="<?php echo _SEND_BUTTON ?>" /></a>
          <?php 
          }
          ?>
              </td>
              <td width="20%"><?php echo $row->send;?></td>
              <td width="9%" align="center"><?php echo $row->hits;?></td>
              <td width="32" align="center"><?php
          if( $mkpostman_rights['can_delete'] ) { ?>
              <form name="deleteForm<?php echo $row->id;?>" action="index.php?option=com_mkpostman" method="post">
              <input type="hidden" name="id" value="<?php echo $row->id ?>" />
              <input type="hidden" name="task" value="remove" />
              <input type="hidden" name="Itemid" value="<?php echo $Itemid ?>" />
              </form>
              &nbsp;&nbsp;<a title="<?php echo _CMN_DELETE ?>" href="javascript: if( confirm('Are you sure you want to delete selected item?')) { document.deleteForm<?php echo $row->id;?>.submit(); }">
              <img src="components/com_mkpostman/images/delete.png" align="center" border="0" height="22" width="22" alt="<?php echo _CMN_DELETE ?>" /></a>
              
          <?php 
          } ?>&nbsp;</td>
            </tr>

        <?php  
        } ?>
		<tr>
			<td colspan="5">&nbsp;</td>
		</tr>
		<tr>
			<td align="center" colspan="5" class="sectiontablefooter">
			<?php
			$link = 'index.php?option=com_mkpostman&amp;Itemid='. $Itemid;
			echo $pageNav->writePagesLinks( $link );
			?>
			</td>
		</tr>
		<tr>
			<td colspan="5" align="center">
			<?php echo $pageNav->writePagesCounter(); ?>
			</td>
		</tr>
    <?php 
    } 
    else { ?>
        <tr><td colspan="5"><?php echo _NOKEYWORD; ?></td></tr>
    <?php 
    } ?>
    </table>
    <?php

    }
function editNewsletter( &$row, &$publist, $option , $glist ) {
      global $mosConfig_absolute_path;
      
		if( function_exists( "botTinymceEditorInit" ))
		  $savetext = "tinyMCE.triggerSave();\n";
		else
		  $savetext = "";
	  ?>
	  <link rel="stylesheet" type="text/css" media="all" href="includes/js/calendar/calendar-mos.css" title="green" />
	  <script type="text/javascript" src="includes/js/calendar/calendar.js"></script>
	  <script type="text/javascript" src="includes/js/calendar/lang/calendar-en.js"></script>
		<script language="javascript" type="text/javascript">
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}

			// do field validation
			try {
			document.adminForm.onsubmit();
			}
			catch(e){}
			if (form.subject.value == ""){
				alert( "Newsletter must have a subject" );
			} 
			else {
				<?php echo $savetext ?>
				submitform( pressbutton );
			}
		}
		</script>
	<table cellspacing="0" cellpadding="0" border="0" width="100%">
		<tr>
			<td class="contentheading" ><?php echo $row->id ? _E_EDIT : _E_ADD; echo ": ".LM_NEWSLETTER_ITEM; ?></td>
			<td width="10%">
			 <?php
             require_once( $mosConfig_absolute_path."/includes/HTML_toolbar.php");
			 mosToolBar::startTable();
			 mosToolBar::save();
			 mosToolBar::spacer(25);
			 mosToolBar::cancel();
			 mosToolBar::endtable();
			?>
			</td>
		</tr>
		</table>
        <br/><br/>
	<form action="index.php" method="post" name="adminForm">

		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminform">
			<tr>
				<td width="200"><div style="font-weight:bold;text-align:right"><?php echo _E_SUBJECT ?></div></td>
				<td><input class="inputbox" type="text" name="subject" size="25" value="<?php echo $row->subject; ?>" style="width:500px" ></td>
			</tr>

			<tr>
				<td valign="top"><div style="font-weight:bold;text-align:right"><?php echo LM_MSG_HTML.": </div><br/>".LM_NAME_TAG_USAGE ?></td>
				<td><?php
				editorArea( "html_message", str_replace('&','&amp;',$row->html_message), "html_message", 500, 300, 70, 20 );
			  
				?>
				</td>
			</tr>

			<tr>
				<td valign="top"><div style="font-weight:bold;text-align:right"><?php echo LM_TEXT_MSG.": </div><br/><br/>".LM_NAME_TAG_USAGE ?></td>
				<td><textarea name="message" cols="70" rows="20" style="width:500px; height:300px;"><?php echo str_replace('&','&amp;',$row->message); ?></textarea>
				</td>
			</tr>
			<tr>
				<td valign="top"><div style="font-weight:bold;text-align:right"><?php echo _CMN_PUBLISHED ?>:</div></td>
				<td>
					<?php echo $publist; ?>
				</td>
			</tr>
            <tr>
                <td><div style="font-weight:bold;text-align:right"><?php echo _E_STATE; ?></div></td>
                <td><?php 
				if ($row->published == "1") {
				  echo _CMN_PUBLISHED;
				} 
				else {
				  echo _CMN_UNPUBLISHED;
				}
                        ?>
                    </td>
            </tr>
            <tr>
                <td><div style="font-weight:bold;text-align:right"><?php echo _E_ACCESS_LEVEL; ?></div></td>
                <td> <?php echo $glist; ?> </td>
            </tr>
            <tr>
                <td><div style="font-weight:bold;text-align:right"><?php echo _E_START_PUB; ?></div></td>
                <td><input class="inputbox" type="text" name="publish_up" id="publish_up" size="25" maxlength="19" value="<?php echo $row->publish_up; ?>" />
                <input name="reset" type="reset" class="button" onClick="return showCalendar('publish_up', 'y-mm-dd');" value="..." />
                </td>
            </tr>
            <tr>
                <td><div style="font-weight:bold;text-align:right"><?php echo _E_FINISH_PUB; ?></div></td>
                <td><input class="inputbox" type="text" name="publish_down" id="publish_down" size="25" maxlength="19" value="<?php echo $row->publish_down; ?>" />
                    <input name="reset2" type="reset" class="button" onClick="return showCalendar('publish_down', 'y-mm-dd');" value="..." />
                </td>
            </tr>
		</table>


	<?php if (!$row->id) { ?>
            <input type="hidden" name="created" value="<?php echo date('Y-m-d H:i:s'); ?>" />
	<?php }
		  else { ?>
			<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
	<?php }
	?>
			<input type="hidden" name="task" value="">
			<input type="hidden" name="option" value="<?php echo $option; ?>" />
			</form>
	<?php 
  }
  
    function showItem( $row, $gid ) {
      
      ?><div class="componentheading">Newsletter Item <a href="javascript: history.back()">&nbsp;[ back ]</a></div>
      <div align="right" class="createdate">Date: <?php echo $row->created ?></div>
      <div><strong><?php echo $row->title; ?></strong></div><br/>
      <div><?php echo $row->text; ?></div>
    <?php
    
    }
    
	function sendNewsletter( &$row, $option , $grouplist, $admin_email ) {
		global $lm_params;
	  ?> 
      <div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>		  
      <script language="Javascript" src="includes/js/overlib_mini.js"></script>
	  <table cellpadding="4" cellspacing="0" border="0" width="100%">
		  <tr>
			<td class="contentheading" ><?php echo LM_SEND_NEWSLETTER ?></td>
		  </tr>
		</table>
	  <form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="post" name="adminForm">

		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminform">
            <tr>
                <td width="250"><strong><?php echo LM_SEND_TO_GROUP ?>:</strong></td>
                <td width="85%"><?php echo $grouplist; ?></td>
            </tr>
            <tr>
                <td width="250"><strong><?php echo LM_CONFIRMED_ACCOUNTS_ONLY ?></strong></td>
                <td width="85%"><input type="checkbox" name="confirmed_accounts" value="1">
				<?php echo mosToolTip( LM_CONFIRMED_ACCOUNTS_ONLY_TIP ) ?></td>
            </tr>
			<tr>
				<td><strong><?php echo LM_MAIL_FROM ?>:</strong></td>
				<td><input class="inputbox" type="text" name="mailfrom" size="25" value="<?php echo $admin_email; ?>" style="width:200px" ></td>
			</tr>
			<tr>
				<td><strong><?php echo LM_REPLY_TO ?>:</strong></td>
				<td><input class="inputbox" type="text" name="replyto" size="25" value="<?php echo $admin_email; ?>" style="width:200px" ></td>
			</tr>
            <tr>
                <td width="250"><strong><?php echo LM_DISABLE_TIMEOUT ?>:</strong></td>
                <td width="85%"> <input type="checkbox" checked="checked" name="disable_timeout" value="1">
				<?php echo mosToolTip( LM_DISABLE_TIMEOUT_TIP ) ?></td>
            </tr>
            <?php
            if( strstr( $row->html_message, '[NAME]') === false && strstr( $row->message, '[NAME]') === false) {
            	$mails_per_pageload= $lm_params->get( 'normal_mails_per_pageload', 500 );
            }
            else {
            	$mails_per_pageload = $lm_params->get('personalized_mails_per_pageload' , 100 );
            }
	            ?>
            <tr>
                <td style="text-align:right;" width="250"><label for="mails_per_pageload"><strong><?php echo LM_MAILS_PER_STEP ?>:</strong></label></td>
                <td width="85%"><input type="text" id="mails_per_pageload" name="mails_per_pageload" value="<?php echo $mails_per_pageload ?>" /></td>
            </tr>
            
			<tr><td colspan="2"><hr/></td></tr>
			
			<tr>
				<td><strong><?php echo _E_SUBJECT ?></strong></td>
				<td><?php echo $row->subject; ?></td>
			</tr>
			<tr>
				<td valign="top"><strong><?php echo LM_MSG_HTML ?>:</strong></td>
				<td valign="top"><?php echo $row->html_message; ?></td>
			</tr>
			<tr>
				<td valign="top"><strong><?php echo LM_MSG ?>:</strong></td>
				<td valign="top"><?php echo htmlspecialchars($row->html_message); ?></td>
			</tr>
			<tr>
				<td valign="top"><strong><?php echo LM_TEXT_MSG ?>:</strong></td>
				<td valign="top"><?php echo nl2br($row->message); ?></td>
			</tr>
		</table>
		
			<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="option" value="<?php echo $option; ?>" />
		</form>
<?php
	}
    

	function sendMailInfo( $all_rows, $startfrom, $msg ) {
		global $mosConfig_mailfrom;
		$mails_per_pageload  = intval( mosGetParam( $_POST, "mails_per_pageload", 100 ));
		$option  = mosGetParam( $_POST, "option", 'com_mkpostman' );
		$disable_timeout  = mosGetParam( $_POST, "disable_timeout", '' );
		$id  = mosGetParam( $_POST, "id", '' );
		$sendto = mosGetParam( $_POST, "sendto", null );
		$mailfrom = mosGetParam( $_POST, "mailfrom", $mosConfig_mailfrom );
		$confirmed_accounts = mosGetParam( $_POST, "confirmed_accounts", "0" );
		$replyto = mosGetParam( $_POST, "replyto", false );
		
		echo '<h3>'.LM_SEND_LOG.'</h3>
		<pre>'. $msg .'</pre>
		<p><strong>'.sprintf( LM_NUMBER_OF_MAILS_SENT, $startfrom , $all_rows ).'<strong></p>
		<p>'.sprintf( LM_SEND_NEXT_X_MAILS, $mails_per_pageload ) .'</p>
		<br/>
		<br/>
		<form action="'. $_SERVER['PHP_SELF'] .'" method="post" name="adminForm">
		'.LM_CHANGE_MAILS_PER_STEP.': <input type="text" name="mails_per_pageload" value="'. $mails_per_pageload .'" size="4" />
		<br />
		<br />
			<input type="hidden" name="startfrom" value="'. $startfrom .'" />
			<input type="hidden" name="disable_timeout" value='. $disable_timeout .'" />
			<input type="hidden" name="id" value="'. $id .'" />
			<input type="hidden" name="sendto" value="'. $sendto .'" />
			<input type="hidden" name="mailfrom" value="'. $mailfrom .'" />
			<input type="hidden" name="confirmed_accounts" value="'. $confirmed_accounts .'" />
			<input type="hidden" name="replyto" value="'. $replyto .'" />
			<input type="hidden" name="task" value="sendMail" />
			<input type="hidden" name="option" value="'. $option .'" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
			<input style="font-weight:bold;" type="submit" name="send" value="&nbsp;&nbsp;&nbsp;&nbsp;'. _SEND_BUTTON .'&nbsp;&nbsp;&nbsp;&nbsp;" />
			&nbsp;&nbsp;&nbsp;&nbsp;
			<input type="button" name="abort" value="'. _CMN_CANCEL .'" onclick="if( confirm( \''.LM_CONFIRM_ABORT_SENDING.'\' )) { document.location=\''. $_SERVER['PHP_SELF']  .'?option=com_mkpostman\'; }" />
		</form>
		<br/><br/>';
		
	}
	
	function subscribe( $subscriber){
	  global $database, $my, $Itemid;
      
      $check = "SELECT id FROM #__users, #__mkpostman_subscribers WHERE user_id=id AND user_id='".$my->id."'";
      $database->setQuery( $check );
      $database->loadObject( $result );
      
      $name = addslashes(mosGetParam( $_REQUEST,'subscriber_name','Subscriber' ));
      $email = addslashes(mosGetParam( $_POST, 'email'));
      $newsletter_type = addslashes(mosGetParam( $_POST, 'newsletter_type'));
      
      if( !$result ) {
        if(!empty($email)){
            saveSubscriber( $name, $email, $newsletter_type);
        }
        else {
            //new subscriber
            HTML_MkPostman::showField( "subscribe");
        }
      }
      else {
        mosRedirect( "index.php?option=com_mkpostman&Itemid=$Itemid" , LM_ALREADY_SUBSCRIBED );
      }
	}
	
	function unsubscribe($subscriber){
	  global $database, $my, $Itemid;
      $name = addslashes(mosGetParam( $_POST,'subscriber_name'));
      $email = addslashes(mosGetParam( $_POST, 'email'));
      
      if( !empty($email) ) {
        $check = "SELECT subscriber_name FROM #__mkpostman_subscribers WHERE subscriber_email='$email'";
        $database->setQuery( $check );
        $database->loadObject( $result );
        if( $result ) {
            //delete
            deleteSubscriber( $result->subscriber_name, $email );
        }
        else {
          mosRedirect( "index.php?option=com_mkpostman&Itemid=$Itemid" , _ERROR_PASS );
        }
      }
      else{
        //new subscriber
        HTML_MkPostman::showField("unsubscribe", $subscriber);
      }
      
	}
    
	function showField( $action, $subscriber = ''){
		global $Itemid, $letters, $database, $my;
		
        if( $my->id ) {
          if( $action == "subscribe") {
            $query="SELECT name as subscriber_name, email as subscriber_email FROM #__users WHERE id = '" . $my->id . "'";
            $database->setQuery($query);
            $database->loadObject($subscriberdata);
          }
          elseif( $action == "unsubscribe") {
            $query="SELECT subscriber_name, subscriber_email FROM #__mkpostman_subscribers WHERE user_id=" . $my->id;
            $database->setQuery($query);
            $database->loadObject($subscriberdata);
          }
		}
        if( empty($subscriberdata)) {
          $subscriberdata =& new stdClass();
          $subscriberdata->subscriber_email = ""; 
          $subscriberdata->subscriber_name = ""; 
        }
        
		$query = "SELECT id FROM #__modules WHERE module = 'mod_mkpostmansubscribe'";
		$database->setQuery( $query );
		$id = $database->loadResult();
        if( $id ) {
          $module = new mosModule( $database );
          $module->load( $id );
          $params =& new mosParameters( $module->params );
          $hide_name_field = $params->get( "hide_name_field", "0" );
        }
        else {
          $hide_name_field = 0;
        }
        $action_lbl = ($action=="subscribe") ? LM_SUBSCRIBE : LM_UNSUBSCRIBE;

        ?>
          <script type="text/javascript">
          <!--
          
          function validate(){
            if(<?php if($hide_name_field=='0'){ ?>document.showField.subscriber_name.value == "" || <?php } ?>document.showField.email.value == ""){
              alert('<?php echo _SAVE_ERR ?>');
              return false;
            }
            else{
              return true;
            }
          }
          
          //-->
          </script>
            <form method="post" name="showField" action="<?php echo sefRelToAbs("index.php?option=com_mkpostman&amp;Itemid=$Itemid&amp;task=$action"); ?>">
            <table border="0" cellpadding="0" cellspacing="0" class="contentpane" width="100%">
            <tr>
              <th align="left" colspan="2"><?php echo LM_YOUR_DETAILS ?></th>
              <th width="40%"><br /><br /></th>
            </tr>
        <?php if($hide_name_field=='0'){ ?>
            <tr>
              <td><?php echo _REGISTER_NAME ?></td>
              <td><input type="text" name="subscriber_name" size="32" class="inputbox" maxlength="64" value="<?php echo $subscriberdata->subscriber_name; ?>" <?php if ($action=='unsubscribe' && !empty($subscriberdata->subscriber_name)){echo 'readonly="readonly"';}; ?> /></td>
              <td><br /><br /></td>
            </tr>
        <?php }
            else { ?>
              <input type="hidden" name="subscriber_name" size="32" class="inputbox" maxlength="64" value="<?php echo $subscriberdata->subscriber_name; ?>" <?php if ($action=='unsubscribe' && !empty($subscriberdata->subscriber_name)){echo 'readonly="readonly"';}; ?>>
      <?php } ?>
            <tr>
              <td><?php echo _PROMPT_EMAIL ?></td>
              <td><input type="text" name="email" size="32" class="inputbox" maxlength="64" value="<?php echo $subscriberdata->subscriber_email; ?>" <?php if ($action=='unsubscribe' && !empty($subscriberdata->subscriber_name)){echo 'readonly="readonly"';}; ?>></td>
              <td><br /><br /></td>
            </tr> 
            <tr>
              <td><?php echo LM_SUBSCRIBER_NEWSLETTER_TYPE ?></td>
              <td>
              
              	<select name="newsletter_type" class="inputbox" id="mk_newsletter_type">
					<option value="<?echo MK_POSTMAN_NEWSLETTER_TYPE_TEXT;?>"<?php if($row->newsletter_type== MK_POSTMAN_NEWSLETTER_TYPE_TEXT ){ echo " selected=\"selected\""; }?> >
					Text</option>
					<option value="<?echo MK_POSTMAN_NEWSLETTER_TYPE_HTML;?>"<?php if($row->newsletter_type== MK_POSTMAN_NEWSLETTER_TYPE_HTML){ echo " selected=\"selected\""; }?> >
					HTML</option>
					<option value="<?echo MK_POSTMAN_NEWSLETTER_TYPE_PDF;?>"<?php if($row->newsletter_type== MK_POSTMAN_NEWSLETTER_TYPE_PDF){ echo " selected=\"selected\""; }?> >
					PDF</option>
				</select>
            
              
              </td>
              <td><br /><br /></td>
            </tr>
    
            <tr>
              <td colspan="2"><br />
              <input type="submit" name="submit" value="<?php echo $action_lbl; ?>" class="button" onclick="return validate();" /></td>
              <td></td>
            </tr>
          </table>
            </form>
        <?php
	}
    
    function header() {
    
    }
    
    function footer() {
    
    }
    
    function new_bar() {
        global $mosConfig_absolute_path, $mosConfig_live_site, $Itemid;
        require_once( $mosConfig_absolute_path."/includes/HTML_toolbar.php");
        mosToolBar::startTable(); ?>
        <td width="25" align="right">
		<a href="<?php echo sefRelToAbs( "index.php?option=com_mkpostman&amp;task=edit&amp;Itemid=$Itemid") ?>" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('new','','<?php echo $mosConfig_live_site; ?>/administrator/images/new_f2.png',1);">
		<img name="new" src="<?php echo $mosConfig_live_site; ?>/administrator/images/new.png" height="32" width="32" border="0" />
		</a>
		</td>
        <?php
        mosToolBar::endtable();
    }
    
    function send_bar( $id ) {
        global $mosConfig_absolute_path, $mosConfig_live_site, $Itemid;
        require_once( $mosConfig_absolute_path."/includes/HTML_toolbar.php");
        ?>
        <script language="javascript" type="text/javascript">
		  function submitbutton(pressbutton) {
			  var form = document.adminForm;
			  if (pressbutton == 'cancel') {
				  submitform( pressbutton );
				  return;
			  }
			  // do field validation
			  if (getSelectedValue('adminForm','sendto') < 0){
				  alert( "Please select a group" );
			  } else if (confirm ("<?php echo LM_WARNING_SEND_NEWSLETTER ?>")) {
				  submitform( 'sendMail' );
			  }
		  }
	  </script>	 
      <?php
        mosToolBar::startTable(); ?>
 
        <td width="50%" align="right">
		<a href="javascript:submitbutton('sendMail');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('publish','','<?php echo $mosConfig_live_site; ?>/administrator/images/publish_f2.png',1);">
		<img name="publish" src="<?php echo $mosConfig_live_site; ?>/administrator/images/publish.png" align="center" height="32" width="32" border="0" />
		</a>&nbsp;
		</td>
        <td width="50%" align="left">&nbsp;
		<a href="javascript:submitbutton('cancel');" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('back','','<?php echo $mosConfig_live_site; ?>/administrator/images/back_f2.png',1);">
		<img name="back" src="<?php echo $mosConfig_live_site; ?>/administrator/images/back.png" align="center" height="32" width="32" border="0" />
		</a>
		</td>
        <?php
        mosToolBar::endtable();
    }
    
    function subscriber_bar() {
      global $Itemid, $my, $database;
      $subscriber = null;
      if( $my->id ) {
	      $database->setQuery('SELECT user_id FROM `#__mkpostman_subscribers` WHERE user_id='.$my->id .' OR subscriber_email =\''.$my->email.'\'');
	      $database->loadObject( $subscriber );
      }
?>
        <table align="center">
          <tr>
          <?php
          if(!$subscriber) {
          	?>
            <td>
              <a href="<?php echo sefRelToAbs( 'index.php?option=com_mkpostman&amp;task=subscribe&amp;Itemid='. $Itemid ) ?>" title="<?php echo LM_SUBSCRIBE ?>">
              <img src="components/com_mkpostman/images/subscribe.png" alt="<?php echo LM_SUBSCRIBE ?>" align="center" border="0" />&nbsp;<?php echo LM_SUBSCRIBE_TO ?></a>
            </td>
            <?php
          }
          else {
          	?>
            <td>&nbsp;&nbsp;
              <a href="<?php echo sefRelToAbs( 'index.php?option=com_mkpostman&amp;task=unsubscribe&amp;Itemid='. $Itemid ) ?>" title="<?php echo LM_UNSUBSCRIBE ?>">
              <img src="components/com_mkpostman/images/unsubscribe.png" alt="<?php echo LM_UNSUBSCRIBE ?>" align="center" border="0" />&nbsp;<?php echo LM_UNSUBSCRIBE_FROM ?></a>
            </td>
            <?php
          }
          ?>
          </tr>
        </table>
<?php
    }
}

class HTML_mylinks {


	function orderUpIcon( $i, $limitstart=0, $condition=true, $task='orderupBookmark', $alt=_MYL_MOVEUP ) {
		if (($i > 0 || ($i+$limitstart > 0)) && $condition) {
		    return '<a href="#reorder" onClick="return listItemTask(\'cb'.$i.'\',\''.$task.'\')" title="'.$alt.'"><img src="administrator/components/com_mkpostman/images/uparrow.png" width="12" height="12" border="0" alt="'.$alt.'"></a>';
  		} else {
//  		    return '&nbsp;';
  		    return '';
		}
	}

	function orderDownIcon( $i, $total, $limitstart=0, $condition=true, $task='orderdownBookmark', $alt=_MYL_MOVEDOWN ) {
		if (($i < $total-1 || $i+$limitstart < $total-1) && $condition) {
			return '<a href="#reorder" onClick="return listItemTask(\'cb'.$i.'\',\''.$task.'\')" title="'.$alt.'"><img src="administrator/components/com_mkpostman/images/downarrow.png" width="12" height="12" border="0" alt="'.$alt.'"></a>';
  		} else {
//  		    return '&nbsp;';
  		    return '';
		}
	}


    function showMyLinks( $option, $Itemid, &$rows, $search, $total) {
        global $my, $mosConfig_live_site;
?>
        <script language="javascript" type="text/javascript">
        function OpenWin(URL) {
           win  = window.open(URL,"_blank","scrollbars=yes,toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,resizable=yes");
        }
        </script>


        <table cellpadding="4" cellspacing="0" border="0" width="100%">
          <tr>
            <td width="50%"><span class="contentheading">Bookmarks</span></td>
            <td width="50%">
<?php   // *** Action Buttons
            mosToolBar::startTable();
            mosToolBar::spacer();
            mosToolBar::addNew('addBookmark');
            mosToolBar::spacer(25);
            mosToolBar::editList('editBookmark');
            mosToolBar::spacer(25);
            mosToolBar::deleteList('', 'removeBookmark');
            mosToolBar::endtable();
?>
            </td>
          </tr>
        </table>

        <form action="index.php" method="post" name="adminForm">

        <div class="componentheading">

        </div>

        <table class="contentpane" border="0" cellpadding="1" cellspacing="0" width="100%">
            <tr>
                <td class="sectiontableheader" width="20">
                <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows ); ?>);" />
                </td>
                <td class="sectiontableheader" nowrap="nowrap">
                <?php echo _MYL_LINKS; ?>
                </td>
                <td class="sectiontableheader" align="center" width="50">
                <?php echo _MYL_URL; ?>
                </td>
                <td class="sectiontableheader" align="center" width="50" nowrap="nowrap">
                <?php echo _MYL_OPENWIN; ?>
                </td>
                <td class="sectiontableheader" align="center" width="50" nowrap="nowrap">
                <?php echo _MYL_REORDER; ?>
                </td>
            </tr>
<?php
        $rowstyle = "sectiontableentry";

        $k = 0;
        for ($i=0, $n=count( $rows ); $i < $n; $i++) {
            $row = &$rows[$i];
?>
            <tr class="<?php echo $rowstyle.($k+1); ?>">
                <td>
                  <?php echo mosHTML::idBox( $i, $row->id, ($row->checked_out && $row->checked_out != $my->id ) ); ?>
                </td>

                <td>
                  <a href="#editBookmark" title="Edit MyLink" onclick="return listItemTask('cb<?php echo $i;?>','editBookmark')">
                  <b><?php echo $row->title; ?></b>
                  </a>
                </td>

                <td align="center">
<?php    if ($row->URL) { ?>
                <img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_mkpostman/images/html.png" title="<?php echo _MYL_OPEN; ?> : <?php echo mosMyLinksTools::URLMaxSize($row->URL); ?>" alt="verify" onclick="OpenWin('<?php echo $row->URL; ?>'); return false" />

<?php    } ?>
                </td>

                <td align="center">
<?php
                    $task = $row->openwin ? 'openparent' : 'openblank';
                    $tasktitle = $row->openwin ? _MYL_OPEN_BLANK : _MYL_OPEN_PARENT;
                    $img = $row->openwin ? 'openparent.png' : 'openblank.png';
?>
                   <a href="javascript:void(0);" onclick="return listItemTask('cb<?php echo $i; ?>','<?php echo $task; ?>')" title="<?php echo $tasktitle; ?>"><img src="<?php echo $mosConfig_live_site; ?>/administrator/components/com_mkpostman/images/<?php echo $img; ?>" border="0" alt="<?php echo $task; ?>" /></a>
                </td>

                <td align="center">
                  <?php echo HTML_mylinks::orderUpIcon( $i ); ?><?php echo HTML_mylinks::orderDownIcon( $i, $total ); ?>
                </td>

            </tr>
<?php
            $k = 1 - $k;
        }
?>
        </table>

        <input type="hidden" name="option" value="<?php echo $option; ?>" />
        <input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        </form>
        <br />

<?php
    }  // End function


/**
* Writes the edit form for new and existing record
*
* A new record is defined when <var>$row</var> is passed with the <var>id</var>
* property set to 0.
* @param mosSearchExtended The Engine object
* @param string The html for the categories select list
* @param string The html for the Openwin select list
* @param string The html for the Ordering select list
*/
    function editMyLink( $option, $Itemid, &$row, &$lists, $task ) {

?>
        <script language="javascript" type="text/javascript">
        function submitbutton(pressbutton) {
            var form = document.adminForm;

            if (pressbutton == 'cancelBookmark') {
<?php
            if ($task == 'addBookmark') {   // New record
                echo "                pressbutton = 'canceladdBookmark';  // Action : New => redirect to original page...\n";
            }
?>
                submitform( pressbutton );
                return;
            }

            // do field validation
            if (form.title.value == ""){
                alert( "<?php echo _MYL_MUST_HAVE_TITLE; ?>" );
            } else if (form.URL.value == ""){
                alert( "<?php echo _MYL_MUST_HAVE_URL; ?>" );
            } else {
<?php
            if ($task == 'addBookmark') {   // New record
                echo "                pressbutton = 'saveaddBookmark';  // Add => redirect to original page...\n";
            }
?>
                submitform( pressbutton );
            }
        }
        </script>

        <table cellpadding="4" cellspacing="0" border="0" width="100%">
          <tr>
            <td width="50%"><span class="contentheading"><?php echo $row->id ? _MYL_EDIT : _MYL_ADD;?> <?php echo _MYL_MYLINKS; ?></span></td>
              <td width="50%">
<?php   // *** Action Buttons
            mosToolBar::startTable();
            mosToolBar::spacer();
            mosToolBar::save('saveBookmark');
            mosToolBar::spacer(25);
            mosToolBar::cancel('cancelBookmark');
            mosToolBar::endtable();
?>
            </td>
          </tr>
        </table>

        <form action="index.php?&amp;Itemid=" method="post" name="adminForm" id="adminForm">
        <table class="adminform" cellpadding="4" cellspacing="1" border="0" width="100%" id="adminform">
          <tr>
            <td width="100" align="right">
            <?php echo _MYL_TXT_LINK; ?>:
            </td>
            <td width="500">
            <input class="inputbox" type="text" name="title" size="50" maxlength="50" value="<?php echo $row->title;?>">
            </td>
          </tr>

          <tr>
            <td valign="top" align="right">
            <?php echo _MYL_TXT_URL; ?>:
            </td>
            <td>
            <input class="inputbox" type="text" name="URL" size="60" value="<?php echo $row->URL; ?>">
            </td>
          </tr>

          <tr>
            <td valign="top" align="right">
            <?php echo _MYL_TXT_OPENWIN; ?>:
            </td>
            <td>
            <?php echo $lists->owlist; ?>
            </td>
          </tr>

          <tr>
            <td valign="top" align="right">
            <?php echo _MYL_TXT_ORDERING; ?>:
            </td>
            <td>
            <?php echo $lists->olist; ?>
            </td>
          </tr>

        </table>

        <input type="hidden" name="id" value="<?php echo $row->id; ?>">
        <input type="hidden" name="userid" value="<?php echo $row->userid; ?>">
        <input type="hidden" name="option" value="com_mkpostman">
        <input type="hidden" name="Itemid" value="<?php echo $Itemid;?>">
        <input type="hidden" name="task" value="">
        </form>
<?php
    }  // End Function
    
    
    function showLogin($url)
    {
    	global $mainframe, $params, $mosConfig_live_site;
    	
		$registration_enabled 	= $mainframe->getCfg( 'allowUserRegistration' );
		$message_login 			= $params->def( 'login_message', 0 );
		$message_logout 		= $params->def( 'logout_message', 0 );
		$pretext 				= $params->get( 'pretext' );
		$posttext 				= $params->get( 'posttext' );
		$login 					= $params->def( 'login', $return );
		$logout 				= $params->def( 'logout', $return );
		$name 					= $params->def( 'name', 1 );
		$greeting 				= $params->def( 'greeting', 1 );
		// Login output
		?>
		<form action="<?php echo sefRelToAbs( 'index.php' ); ?>" method="post" name="login" >
		<?php
		echo $pretext;
		?>
		<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
		<tr>
			<td>
				<label for="mod_login_username">
					<?php echo _USERNAME; ?>
				</label>
				<br />
				<input name="username" id="mod_login_username" type="text" class="inputbox" alt="username" size="10" />
				<br />
				<label for="mod_login_password">
					<?php echo _PASSWORD; ?>
				</label>
				<br />
				<input type="password" id="mod_login_password" name="passwd" class="inputbox" size="10" alt="password" />
				<br />
				<input type="checkbox" name="remember" id="mod_login_remember" class="inputbox" value="yes" alt="Remember Me" />
				<label for="mod_login_remember">
					<?php echo _REMEMBER_ME; ?>
				</label>
				<br />
				<input type="hidden" name="option" value="login" />
				<input type="submit" name="Submit" class="button" value="<?php echo _BUTTON_LOGIN; ?>" />
			</td>
		</tr>
		<tr>
			<td>
			<a href="<?php echo sefRelToAbs( 'index.php?option=com_registration&amp;task=lostPassword' ); ?>">
				<?php echo _LOST_PASSWORD; ?></a>
			</td>
		</tr>
		<?php
		if ( $registration_enabled ) {
			?>
			<tr>
				<td>
					<?php echo _NO_ACCOUNT; ?>
					<a href="<?php echo sefRelToAbs( 'index.php?option=com_registration&amp;task=register' ); ?>">
						<?php echo _CREATE_ACCOUNT; ?></a>
				</td>
			</tr>
			<?php
		}
		?>
		</table>
		<?php
		echo $posttext;
		?>
	
		<input type="hidden" name="op2" value="login" />
		<input type="hidden" name="lang" value="<?php echo $mosConfig_lang; ?>" />
		<input type="hidden" name="return" value="<?php echo $mosConfig_live_site.'/index.php?'.$url; ?>" />
		<input type="hidden" name="message" value="<?php echo $message_login; ?>" />
		</form>
		<?
    }


}  // End Class
?>
