<?php
/**
* MkPostman Newsletter Component
* 
* @package MkPostman
* @author: sebastian
* @copyright das medienkombinat <kontakt@das-medienkombinat.de>
* @copyright Soeren Eberhardt <soeren@virtuemart.net>
    (who just needed an easy and *working* Newsletter component for Mambo 4.5.1 and mixed up Newsletter and YaNC)
* @copyright Mark Lindeman <mark@pictura-dp.nl> 
    (parts of the Newsletter component by Mark Lindeman; Pictura Database Publishing bv, Heiloo the Netherland)
* @copyright Adam van Dongen <adam@tim-online.nl>
    (parts of the YaNC component by Adam van Dongen, www.tim-online.nl)
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

define('MK_POSTMAN_NEWSLETTER_TYPE_TEXT', 	1);
define('MK_POSTMAN_NEWSLETTER_TYPE_HTML', 	2);
define('MK_POSTMAN_NEWSLETTER_TYPE_PDF', 	3);
define('MK_POSTMAN_NEWSLETTER_TYPE', 		'Format');

/**
*  Table Class
*
* Provides access to the mos_letterman table
*/
class mosMkPostman extends mosDBTable {
	/** @var int Unique id*/
	var $id=null;
	/** @var string */
	var $subject=null;
	/** @var string */
	var $headers=null;
	/** @var string */
	var $message=null;
	/** @var string */
	var $html_message=null;
	/** @var string */
	var $pdf_message=null;
	/** @var string */
	var $pdf_attachment=null;
	/** @var int */
	var $published=null;
	/** @var int */
	var $checked_out=null;
	/** @var datetime */
	var $checked_out_time=null;
	/** @var datetime */
	var $publish_up=null;
	/** @var datetime */
	var $publish_down=null;
	/** @var int */
	var $created=null;
    /** @var datetime */
	var $send=null;
    /** @var datetime */
	var $hits=null;
	/** @var int */
	var $access=null;
	/** @var int */
	var $default_group=null;
	/**
	* @param database A database connector object
	*/
	function mosMkPostman( &$database ) {
		global $mosConfig_absolute_path, $lm_params;
		$this->mosDBTable( '#__mkpostman', 'id', $database );
		
		if( !isset($GLOBALS['lm_params']) || !empty($_REQUEST['lm_params'])) {
			// pull id of mkpostman component
			$query = "SELECT a.id FROM `#__components` AS a"
			. "\n WHERE `a`.`option` = 'com_mkpostman' AND `parent` = 0";
			$database->setQuery( $query );
			$mkpostman_id = $database->loadResult();
			
			// load mkpostman parameters
			$component = new mosComponent( $database );
			$component->load( $mkpostman_id );
			$GLOBALS['lm_params'] = $lm_params = new mosParameters( $component->params );
			
			if( empty($lm_params->_params->newsletter_css)) {
				$database->setQuery('SELECT template FROM `#__templates_menu` WHERE client_id=0 ORDER BY menuid ASC LIMIT 0, 1');
				$cur_template = $database->loadResult();
				$template_css_file = $mosConfig_absolute_path."/templates/$cur_template/css/template_css.css";
				if( file_exists($template_css_file)) {
					
					$template_css = str_replace( "\r\n", "\n", file_get_contents( $template_css_file ));
					
					$txt = array();
					foreach ($lm_params->_params as $k=>$v) {
						$txt[] = "$k=$v";
					}
					$txt[] = "newsletter_css=".$template_css;
						
					$total = count( $txt );
					for( $i=0; $i < $total; $i++ ) {
						if ( strstr( $txt[$i], "\n" ) ) {
							$txt[$i] = str_replace( "\n", '<br />', $txt[$i] );
						}
					}
					
					$params = implode( "\n", $txt );
					
					$component->params = $params;
					$component->store();
				}
	
			}
		}
		
	}
	function check() {
		
		if( empty( $this->created ) ) {
			$this->created = date('Y-m-d H:i:s');
		}
		
		return true;
	}
}
/**
*  Table Class
*
* Provides access to the mos_mkpostman_subscribers table
*/
class mosMkPostmanSubscribers extends mosDBTable {
	/** @var int Unique id*/
	var $subscriber_id=null;
	/** @var string */
	var $subscriber_name=null;
	/** @var string */
	var $user_id=null;
	/** @var string */
	var $subscriber_email=null;
	/** @var int */
	var $confirmed=null;
	/** @var int */
	var $newsletter_type=null;
	/** @var int */
	var $subscribe_date=null;
	/**
	* @param database A database connector object
	*/
	function mosMkPostmanSubscribers( &$database ) {
		$this->mosDBTable( '#__mkpostman_subscribers', 'subscriber_id', $database );
	}
}

/**
*  Table Class
*
* Provides access to the jos_mkpostman_groups table
*/
class josMkpostmanGroups extends mosDBTable {
	/** @var int Unique id*/
	var $group_id=null;
	/** @var string */
	var $name=null;
	/** @var string */
	var $default=null;

	/**
	* @param database A database connector object
	*/
	function josMkpostmanGroups( &$database ) {
		$this->mosDBTable( '#__mkpostman_groups', 'group_id', $database );
	}
}

/**
*  Table Class
*
* Provides access to the jos_mkpostman_subscriber_group table
*/
class josMkpostmanSubscriberGroup extends mosDBTable {
	/** @var int Unique id*/
	var $group_id=null;
	/** @var string */
	var $subscriber_id=null;
	/** @var string */

	/**
	* @param database A database connector object
	*/
	function josMkpostmanSubscriberGroup( &$database ) {
		$this->mosDBTable( '#__mkpostman_subscriber_group ', '', $database );
	}
}

/**
*  Table Class
*
* Provides access to the jos_mkpostman_subscriber_group table
*/
class josMkpostmanAttachment extends mosDBTable {
	/** @var int Unique id*/
	var $id=null;
	/** @var string */
	var $filename=null;
	/** @var string */

	/**
	* @param database A database connector object
	*/
	function josMkpostmanAttachment( &$database ) {
		$this->mosDBTable( '#__mkpostman_attachment ', '', $database );
	}
}
/**
 * Replaces all src attributes with a full URL to the live site
 * OR (when images are to be embedded) embeds the images into
 * the mail and changes the src attributes to a content id (=cid)
 * refrencing the encoded image in the mail body
 *
 * @param string $html_message
 * @param mosPHPMailer $mymail
 */
function lm_replaceImagesInMailBody( $html_message, &$mymail ) {
	global $lm_params, $mosConfig_absolute_path, $mosConfig_live_site;
	
	$embed_images = $lm_params->get('embed_images', 1);
	
	// Handle <img />Images and embed ALL images
	$images = array();
	if (preg_match_all("/<img[^>]*>/", $html_message, $images) > 0) {
		$i = 0;
		foreach ($images as $image) {
			if ( is_array( $image ) ) {
				foreach( $image as $src) {
					preg_match("'src=\"[^\"]*\"'si", $src, $matches);
					$source = str_replace ("src=\"", "", $matches[0]);

					$source = str_replace ("\"", "", $source);
					
					if( $embed_images ) {
						$filename = basename( $source );
						// must be a remote Image or somethin with ../../../image.gif then
						if (!stristr($source, $mosConfig_live_site)) {
	
							// must be a local image.
							// Attention! Now we guess it's located somewhere in the folder /images/ !!!
							if (!stristr($source, "http")) {
								// convert "media/mypicture.gif" to "/home/user/public_html/media/mypicture.gif"
								$tmp_source = "$mosConfig_absolute_path/$source";
								if( !file_exists($tmp_source)) {
									// IN /ADMINISTRATOR/ then!
									// convert "images/mypicture.gif" to "/home/user/public_html/administrator/images/mypicture.gif"					
									$tmp_source = "$mosConfig_absolute_path/administrator/$source";
									if( !file_exists($tmp_source)) {
										// leave the URL unchanged (we don't know where to find the image here!)
										continue;
									}
								}
								$source = $tmp_source;
							}
							else {
								// remote pictures are left unchanged
								continue;
							}
						}
						else {
							$source = str_replace( $mosConfig_live_site, $mosConfig_absolute_path, $source );
						}
						$pathinfo  = pathinfo( $filename );
						$cid = basename( $filename, ".".$pathinfo['extension'] );
						$size = @getimagesize( $source );
	
						switch($pathinfo['extension']) {
							case "jpg":
							case "jpeg":
							$mimetype = "image/jpeg"; break;
							case "png":
							$mimetype = "image/png"; break;
							case "gif":
							$mimetype = "image/gif"; break;
							case "swf":
							$mimetype = "image/swf"; break;
						}
						$mymail->AddEmbeddedImage( $source, $cid, $filename, "base64", $mimetype );
						$newtag = $size[3] ." src=\"cid:$cid\"";
						$html_message = str_replace( $matches[0], $newtag, $html_message );
					}
					else {
						if (!stristr($source, $mosConfig_live_site)) {
							if( substr($source, 0, 3) == '../') {
								$source = str_replace('../', '', $source);
							}
							// must be a remote Image or somethin with ../images/stories/image.jpg then
							$source = "$mosConfig_live_site/$source";
							$html_message = str_replace( $matches[0], "src=\"$source\"", $html_message );
						}
					}
				}
			}
		}
	}
	return $html_message;
}




function mk_replaceMyLinksHtml(&$matches)
{
	global  $mosConfig_live_site, $mosConfig_sitename;
		
	$id = intval($matches[1]);
	$title = $matches[2];
	
	if($id != 0){
		$link = '<p>'
				.'<a href="'.$mosConfig_live_site.'/index.php?option=com_mkpostman&task=addBookmark&title='.urlencode($title)
				.'&url='.urlencode($mosConfig_live_site.'/index.php?option=com_content&task=view&id='.$id).'">'
				.'Artikel auf '.$mosConfig_sitename.' in meinen Bookmarks speichern</a>'
				.'</p>';
		return $link;
	}
}

function mk_replaceMyLinksText(&$matches)
{
	global  $mosConfig_live_site, $mosConfig_sitename;
		
	$id = intval($matches[1]);
	$title = $matches[2];
	
	if($id != 0){
		$link = 'Artikel auf '.$mosConfig_sitename.' in meinen Bookmarks speichern'."\n"
				.$mosConfig_live_site.'/index.php?option=com_mkpostman&task=addBookmark&title='.urlencode($title)
				.'&url='.urlencode($mosConfig_live_site.'/index.php?option=com_content&task=view&id='.$id)
				."\n";
		return $link;
	}
}

function uploadFile( $filename, $userfile_name, $dir, &$msg ) {
	global $mosConfig_absolute_path;
	//$baseDir = mosPathName( $mosConfig_absolute_path . '/media/' );
	$baseDir = mosPathName( $mosConfig_absolute_path . '/'.$dir.'/' );

	if (file_exists( $baseDir )) {
		if (is_writable( $baseDir )) {
			//echo $baseDir . $userfile_name;
			if (move_uploaded_file( $filename, $baseDir . $userfile_name )) {
				if (mosChmod( $baseDir . $userfile_name )) {
					return true;
				} else {
					$msg = 'Failed to change the permissions of the uploaded file.';
				}
			} else {
				$msg = 'Failed to move uploaded file to <code>/media</code> directory.';
			}
		} else {
			$msg = 'Upload failed as <code>/media</code> directory is not writable.';
		}
	} else {
		$msg = 'Upload failed as <code>/media</code> directory does not exist.';
	}
	return false;
}

/**
* Engine database table class
*/
class mosMyLinks extends mosDBTable {

    /** @var int Primary key */
    var $id=null;
    /** @var int */
    var $userid=null;
    /** @var string */
    var $title=null;
    /** @var string */
    var $URL=null;
    /** @var int */
    var $openwin=null;
    /** @var string */
    var $date=null;
    /** @var int */
    var $ordering=null;
    /** @var int */
    var $checked_out=null;
    /** @var time */
    var $checked_out_time=null;


    /**
    * Get actual version information
    */
    function getVersion() {
        return 'v1.1 (2005-04-14)';
    }


    /**
    * @param database A database connector object
    */
    function mosMyLinks( &$db ) {
        $this->mosDBTable( '#__mkpostman_bookmark', 'id', $db );
    }


    // overloaded check function
    function check() {
        // check for valid title
        if (trim( $this->title ) == '') {
            $this->_error = "Your Link must contain a title.";
            return False;
        }

        // *** Add "http://" to URLs if missing
        if (!(eregi("http://", $this->URL) || (eregi("https://",$this->URL)))) {
            $this->URL = "http://".$this->URL;
        }

        return True;
    }

}  // end

class mosMyLinksTools {

    function URLMaxSize($URL, $size=50, $pattern='...') {
      if ($size && strlen($URL) > $size) {
         $URL = substr($URL,0,$size) . $pattern;
      }
      return $URL;
    }

}
?>
