<?php
/**
* @version $Id: ebackup.php 2006-06-05 23:00
* @package eBackup
* @copyright Copyright (C) 2006 by Mambobaer.de. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined('_VALID_MOS') or die('Restricted access');

require_once($mosConfig_absolute_path.'/administrator/components/com_ebackup/config.ebackup.php');
require_once($mosConfig_absolute_path.'/administrator/components/com_ebackup/class.ebackup.php');
require_once($mosConfig_absolute_path.'/administrator/components/com_ebackup/backup.ebackup.php');

//Get right Language file
if (file_exists($mosConfig_absolute_path.'/administrator/components/com_ebackup/language/'.$mosConfig_lang.'.php')) {
  include($mosConfig_absolute_path.'/administrator/components/com_ebackup/language/'.$mosConfig_lang.'.php');
} else {
  include($mosConfig_absolute_path.'/administrator/components/com_ebackup/language/english.php');
}

  function check4Backup(){
    global $database, $mosConfig_db, $mosConfig_mailfrom, $mosConfig_fromname, $mosConfig_sitename, $mosConfig_absolute_path,
           $mosConfig_cachepath;

    $tstart      = mosProfiler::getmicrotime();

    $sql = "SELECT * FROM `#__ebackup_scheduler` WHERE `state` =1";
    $database->setQuery($sql);
    $jobs = $database->loadObjectList();
    foreach($jobs as $job){
           if ($job->last_run != NULL){
              switch ($job->schedule_type){
                     case 0:
                       $diff = -1;
                       break;
                     case 1:
                       $diff = strtotime($job->last_run)-(time()-((3600*1)*1));
                       break;
                     case 2:
                       $diff = strtotime($job->last_run)-(time()-((3600*24)*1));
                       break;
                     case 3:
                       $diff = strtotime($job->last_run)-(time()-((3600*24)*7));
                       break;
                     case 4:
                       $diff = strtotime($job->last_run)-(time()-((3600*24)*30));
                       break;
              }
           }else{
              $diff = 0;
           }
           if ($diff <= 0){
              $lock = lock($mosConfig_cachepath, "ebackup_job".$job->id."_", 1);
              if (!$lock){
                 // Backup in process by an other client!
                 return;
              }
              $stats    = new BackupStats();
              $bkp_file = "";
              ebackup_log(&$stats, $job->id, 'Job "'.$job->job_name.'" '._BBKP_JOB_START);

              $set_config = new JConfig;
              $set_config->loadJobSetting($job);

              if ($job->versions > 0){
                 checkVersions($job->id, $job->versions);
                 if (($job->ftp_srv != "") && ($set_config->o_gzip)){
                    $attachement = "";
                    $canCheck    = checkFTPVersions($attachement, $job->ftp_srv, $job->ftp_pasv, $job->ftp_port, $job->ftp_user, $job->ftp_pw, $job->ftp_path, $job->id, $job->versions);
                    if ($canCheck == NULL){
                       ebackup_log(&$stats, $job->id, 'FTP Check => '._BBKP_FTP_SUCCESS);
                    }else{
                       ebackup_log(&$stats, $job->id, 'ERROR: FTP Check => '.$canCheck." (".$job->ftp_srv.")");
                    }
                 }
              }

              $SQLDump  = new JFiler($set_config->o_gzip);
              $tables   = explode(";", $job->tables);
              $sql_time = time();
              $sql_file = $mosConfig_db."_JOBID".$job->id."_".strftime("%Y%m%d_%H%M%S", $sql_time).".sql";
              $SQLDump->createFile($mosConfig_absolute_path."/administrator/backups/".$sql_file);
              makeHeaderTableDefJob($mosConfig_db, $sql_time, &$SQLDump, count($tables), $job->job_name, &$set_config, '');
              $startTime = mosProfiler::getmicrotime()+7200;
              $rec_no = 0;
              $key = 0;
              while ($key < count($tables)){
                    if ($set_config->o_structure == 1) makeTableDef($mosConfig_db, $tables[$key], &$SQLDump, &$set_config);
                    makeTableContent($tables[$key], &$rec_no, &$SQLDump, $startTime, &$set_config);
                    $key++;
              }
              $SQLDump->closeFile();
              if ($SQLDump->zipped){
                 $bkp_file = $bkp_file.".gz";
                 $attachement = $SQLDump->filename.".gz";
              }else{
                 $attachement = $SQLDump->filename;
              }
              $last_backup_run = strftime("%Y-%m-%d %H:%M:%S", time());
              $sql = "UPDATE `#__ebackup_scheduler` SET `last_run`= '".$last_backup_run."' WHERE `id` = ".$job->id;
              $database->setQuery($sql);
              $database->query();
              ebackup_log(&$stats, $job->id, 'SQL Dump '._BBKP_JOB_FINISH);
              if (($set_config->o_email != "") && ($set_config->o_gzip)) {
                 $body     = makeBody($mosConfig_db, time(), count($tables), &$set_config, '');
                 $subject  = _BBKP_SUBJECT."(".$job->job_name." ".$mosConfig_sitename." ".$sql_file.")";
                 $can_send = mosMail($mosConfig_mailfrom, $mosConfig_fromname, $set_config->o_email, $subject, $body, true, NULL, NULL, $attachement);
                 if (!$can_send){
                    ebackup_log(&$stats, $job->id, 'ERROR: eMail Transfer => '._BBKP_JOB_TRANS_SQL.$set_config->o_email);
                 }else{
                    ebackup_log(&$stats, $job->id, 'eMail Transfer => '._BBKP_JOB_TRANS_SQL.$set_config->o_email);
                 }
              }
              if (($job->ftp_srv != "") && ($set_config->o_gzip)){
                 $canTrans = transferFTP($attachement, $job->ftp_srv, $job->ftp_pasv, $job->ftp_port, $job->ftp_user, $job->ftp_pw, $job->ftp_path);
                 if($canTrans == NULL){
                   ebackup_log(&$stats, $job->id, 'FTP Transfer => '._BBKP_JOB_TRANS_SQL.$job->ftp_srv);
                 }else{
                   ebackup_log(&$stats, $job->id, 'ERROR: FTP Transfer => '.$canTrans." (".$job->ftp_srv.")");
                 }
              }
              if ($lock) unlock($mosConfig_cachepath, "ebackup_job".$job->id."_");
              ebackup_log(&$stats, $job->id, 'Job "'.$job->job_name.'" '._BBKP_JOB_FINISH);
              return;
           }
    }
  }

check4Backup();

?>