<?php
	/**
		*	mambo Silex Video admin
		*
		* @package Silex Video
		* @copyright (C) 2004 by Christophe Guegan
		* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
		* 
		**/
	
	/** ensure this file is being included by a parent file */
	defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
	
	// ensure user has access to this function
	if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
	| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_silexvideo' ))) {
		mosRedirect( 'index2.php', _NOT_AUTH );
	}
	
	require_once( $mainframe->getPath( 'admin_html' ) );
	require_once( $mainframe->getPath( 'class' ) );
	
	$id = mosGetParam( $_REQUEST, 'cid', array(0) );
	
	// Dont know why, but sometime $act is empty and $task old the data
	if (!$act) $act = $task;
	
	switch ($act) {
		case "new_type":
			editVideoType( 0, $option );
			break;
		case "edit_type":
			editVideoType( $id[0], $option );
			break;
		case "save_type":
			saveVideoType( $option );
			break;
		case "remove_types":
			removeVideoType( $id, $option );
			break;
		case "cancel_type":
			cancelEditType( $option );
			break;
		case "list_types":
			viewVideoTypes( $option );
			break;
	
		// video EVENTS
		case "new":
			editVideo( null, $option);
			break;
		case "cancel":
			cancelEditVideo( $option);
			break;
		case "upload":
			upload();
			saveVideo( $option);
			break;	
		case "save":
			saveVideo( $option);
			break;
		case "edit":
			editVideo( $id[0], $option);
			break;
		case "remove":
			removeVideo( $id, $option);
			break;
		case "publish":
			publishVideo( $id,1,$option);
			break;
		case "unpublish":
			publishVideo( $id, 0, $option);
			break;
		case "listVideo":
		default:
			viewVideo( $option);
			break;
	}

	/**
		*	view list of SilexVideos
    *
    * This function displays the list of all availaible SilexVideos.
    *
    * @param string	$option : the option list in the url
    **/
	function viewVideo( $option ) {
		global $database, $mainframe, $mosConfig_list_limit;
		
		$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
		$limitstart = $mainframe->getUserStateFromRequest( "viewban{$option}limitstart", 'limitstart', 0 );
	
		// get the total number of records
		$database->setQuery( "SELECT count(*) FROM #__silexvideos" );
		$total = $database->loadResult();
	
		require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
		$pageNav = new mosPageNav( $total, $limitstart, $limit );
	
		$query = "			SELECT v.*,"
						."						 u.name as editor,"
						."						 t.name as vtype"
						."				FROM #__silexvideos as v "
						."\n LEFT JOIN #__users AS u ON u.id = v.checked_out" 
						."\n LEFT JOIN #__silexvideo_types AS t ON t.id = v.type_id" 
						."\n		 LIMIT $pageNav->limitstart,$pageNav->limit";
		$database->setQuery( $query );
	
		if(!$result = $database->query()) {
			echo $database->stderr();
			return false;
		}
		$rows = $database->loadObjectList();
		HTML_silexvideo::showVideoList( $rows, $pageNav, $option );
	}
	
	/**
		*	edit video entry
    *
    * This function allows the creation and the edition of a video entry
    *
    * @param int 		$id : the id of the video.
    * @param string	$option : the option list in the url
    *
    **/
	function editVideo ( $id, $option ) {
		global $database, $mainframe, $my;
		$lists = array();
	
		$row = new mosSilexVideo($database);
		$row->load( $id );
		
		// fail if checked out not by 'me'
		if ($row->checked_out && $row->checked_out <> $my->id) {
			mosRedirect( "index2.php?option=$option",
			'The component $row->name is currently being edited by another administrator.' );
		}
		
		if ($id) {
			// do stuff for existing record
			$row->checkout( $my->id );
		}
		
		// Build video type select list
		$sql	= "SELECT id as value, name as text FROM #__silexvideo_types";
		$database->setQuery($sql);
		if (!$database->query()) {
			echo $database->stderr();
			return false;
		}
		
		$typelist[] = mosHTML::makeOption( '0', 'Select Video Type' );
		$typelist = array_merge( $typelist, $database->loadObjectList() );
		$lists['type_id'] = mosHTML::selectList( $typelist, 'type_id', 'class="inputbox" size="1"','value', 'text', $row->type_id);
			
		HTML_silexvideo::videoForm( $row, $lists, $option );
	}
	
	/** 
		*	Save the video entry
    *
    *	This function saves the video
    *
    * @param string	$option : the option list in the url
    * 
    **/
	function saveVideo ( $option ) {
		global $database;
		$row = new mosSilexVideo($database);
		
		if (!$row->bind( $_POST )) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		if (!$row->check()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		if (!$row->store()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		$row->checkin();
		mosRedirect( "index2.php?option=$option" );
	}
	
	/** 
		*	Cancel the video editing
    *
    *	This function cancel the video editing
    *
    * @param string	$option : the option list in the url
    * 
    **/
	function cancelEditVideo( $option ) {
		global $database;
		$row = new mosSilexVideo($database);
		$row->bind( $_POST );
		$row->checkin();
		mosRedirect( "index2.php?option=$option" );
	}

	
	/** 
		*	Publish the video
    *
    *	This function cancel the video editing
    *
    *	@param int $id : the id of the video
    * @param int $publish : (0|1) publish or unpublish
    * @param string	$option : the option list in the url
    * 
    **/
	function publishVideo( $id, $publish=1 ,$option ) {
		global $database, $my;
		
		if (!is_array( $id ) || count( $id ) < 1) {
			$action = $publish ? 'publish' : 'unpublish';
			echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";
			exit;
		}
		
		$ids = implode( ',', $id );
		
		$query = "	UPDATE #__silexvideos"
						."     SET published='$publish'"
						."   WHERE id IN ($ids)"
						."     AND (checked_out=0 OR (checked_out='$my->id'))";
		$database->setQuery( $query );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}
	
		if (count( $id ) == 1) {
			$row = new mosSilexVideo( $database );
			$row->checkin( $id[0] );
		}
		mosRedirect( "index2.php?option=$option" );
	
	}
	/**
		* Delete a video
    *
    * This function delete the video entry from the database and also try to
    * delete the file from the file system. The only way to replace a file should
    * be to delete the movie then re-create and upload a new one. Preventing
    * this way accidental replaces.
    * 
    *	@param int $id : id of the video
    * @param string	$option : the option list in the url
    **/
	function removeVideo ( $id, $option ) {
		global 	$database,
						$mosConfig_absolute_path,
						$my;
		
		$dest_dir = $mosConfig_absolute_path.'/media/video/';
			
		if (count( $id )) {
			// for each movie to delete
			for($i=0;$i<count($id);$i++) {
				// Get the file name
        $video = new mosSilexVideo($database);
				$video->load( $id[$i] );
				// fail if checked out not by 'me'
				if ($video->checked_out && $row->checked_out <> $my->id) {
					mosRedirect( "index2.php?option=$option",
					"The component $video->name is currently being edited by another administrator." );
				}
				$file = $dest_dir.$video->file_name;
				if ( is_file( $file ) ) {
					if ( !unlink ( $file ) ) {
						mosRedirect( "index2.php?option=$option",
						"The file $file cannot be deleted, please check with a file admin." );
					}
				}
				$video->delete();
			}
		}
		mosRedirect( "index2.php?option=$option" );
	}

// ---------- video TYPES ----------
	/**
		* listing of the video types
    *
    * This function display the listing of all the video types.
    *
    * @param string	$option : the option list in the url
    * 
    **/
	function viewVideoTypes ( $option ) {
		global $database, $mainframe, $mosConfig_list_limit;
		
		$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
		$limitstart = $mainframe->getUserStateFromRequest( "viewcli{$option}limitstart", 'limitstart', 0 );
		
		// count the number of video types
		$database->setQuery( "SELECT count(*) FROM #__silexvideo_types" );
		$total = $database->loadResult();
		
		require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
		$pageNav = new mosPageNav( $total, $limitstart, $limit );
	
		$query = "			SELECT t.*,"
						."             count(v.id) AS vid"
						."				FROM #__silexvideo_types AS t"
						."   LEFT JOIN #__silexvideos AS v ON t.id = v.type_id"
						."			 GROUP BY t.id"
						. "      LIMIT $pageNav->limitstart,$pageNav->limit";
		$database->setQuery($query);
	
		if(!$result = $database->query()) {
			echo $database->stderr();
			return false;
		}
		$rows = $database->loadObjectList();
	
		HTML_silexvideotype::showTypes( $rows, $pageNav, $option );
	}
	
	/**
		*	Edit the video type entry
    *
    *	This function allows the edition of a video type
    *
    * @param int $id : the id of the video type
    * @param string	$option : the option list in the url
    * 
    **/
	function editVideoType ( $id, $option ) {
		global $database, $my;
		$row = new mosSilexVideoType($database);
		$row->load($id);
	
		// fail if checked out not by 'me'
		if ($row->checked_out && $row->checked_out <> $my->id) {
			mosRedirect( "index2.php?option=$option&act=listtypes",
			'The component $row->name is currently being edited by another administrator.' );
		}
	
		if ($id) {
			// do stuff for existing record
			$row->checkout( $my->id );
		}
		HTML_silexvideotype::videoTypeForm( $row, $option );
	}
	
	/**
		*	Save the video type entry
    *
    *	This function saves the edition of a video type
    *
    * @param string	$option : the option list in the url
    * 
    **/
	function saveVideoType( $option ) {
		global $database;
		$row = new mosSilexVideoType ( $database );
		if (!$row->bind( $_POST )) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		
		if (!$row->check()) {
			mosRedirect( "index2.php?option=$option&act=edit_type&id[]=$row->id", $row->getError() );
		}
		
		if (!$row->store()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		$row->checkin();
		mosRedirect( "index2.php?option=$option&act=list_types" );
	}
	
	/**
		* Cancel the edition of the video type
    *
    * @param string	$option : the option list in the url
    * 
    **/
	function cancelEditType( $option ) {
		global $database;
		$row = new mosSilexVideoType( $database );
		$row->bind( $_POST );
		$row->checkin();
		mosRedirect( "index2.php?option=$option&act=list_types" );
	}

	/**
	  *	Delete a video type
    * 
    *	@param int $id : the id of the video type
    * @param string	$option : the option list in the url
    * 
    **/
	function removeVideoType( $id, $option ) {
		global $database;
	
		for ($i = 0; $i < count($id); $i++) {
			$query = "SELECT COUNT(id) FROM #__silexvideos WHERE type_id='".$id[$i]."'";
			$database->setQuery($query);
	
			if(($count = $database->loadResult()) == null) {
				echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			}
	
			if ($count != 0) {
				mosRedirect( "index2.php?option=$option&act=listtypes",
				"Cannot delete this type at this time because some video use it" );
			} else {
				$query="DELETE FROM #__silexvideo_types WHERE `id`='".$id[$i]."'";
				$database->setQuery($query);
				$database->query();
			}
		}
		mosRedirect("index2.php?option=$option&act=list_types");
	}
	
	/**
		*	upload function
    *
    * This function do some checks before the real upload
    *
    **/
	function upload(){
		global $mosConfig_absolute_path;
		
		$id = $_REQUEST['id'];
		$option = $_REQUEST['option'];
		$error = $_FILES['upload']['error'];
		
		switch($error) {
			case '1':
				echo("<span class='error'>UPLOAD_ERR_INI_SIZE</span>");
				editVideo($id, $option);
				exit();
				break;
			case '2':
				echo("<span class='error'>UPLOAD_ERR_FORM_SIZE</span>");
				editVideo($id, $option);
				exit();
				break;
			case '3':
				echo("<span class='error'>UPLOAD_ERR_PARTIAL</span>");
				editVideo($id, $option);
				exit();
				break;
			case '4':
				echo ("<span class='error'>UPLOAD_ERR_NO_FILE</span>");
				editVideo($id, $option);
				exit();
				break;
		}
		
		$file = $_FILES['upload'];
		if(!isset($_FILES['upload'])) {
				echo ("<span class='error'>UPLOAD_ERR_NO_FILE</span>");
				editVideo($id, $option);
				exit();
		} elseif ((strcasecmp(substr($file['name'],-4),".mov"))
					 && (strcasecmp(substr($file['name'],-4),".wmv"))) {
			echo ("<span class='error'>Only files of type .mov or .wmv can be uploaded</span>");
			editVideo($id, $option);
			exit();
		} else {
			$dest_dir = $mosConfig_absolute_path.'/media/video/';
			if (file_exists($dest_dir.$file['name'])) {
				echo ("<span class='error'>Upload FAILED.File allready exists</span>" );
				editVideo($id, $option);
				exit();
			}
			if (!move_uploaded_file($file['tmp_name'], $dest_dir.strtolower($file['name']))) {
				echo ("<span class='error'>Upload FAILED" );
				editVideo($id, $option);
				exit();
			} else {
				chmod($dest_dir.$file['name'], 0666);
				$_POST['file_name']= $file['name'];
				print_r($_POST);
				
				//exit();
			}
		}
	}
?>
