<?php
	/**
		*	mambo Silex Video admin HTML
		*
		* @package Silex Video
		* @copyright (C) 2004 by Christophe Guegan
		* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
		* 
		**/

	/** ensure this file is being included by a parent file */
	defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
	* @package component Silex Video
	*
  **/
	class HTML_silexvideo {
		/**
			*	view of the video listing.
			*
			**/
		function showVideoList( &$rows, &$pageNav, $option ) {
			global $my;
	?>
		<form action="index2.php" method="post" name="adminForm">
		<table class="adminheading">
			<tr>
				<th>SilexVideo Manager</th>
			</tr>
		</table>
		<table class="adminlist">
			<tr>
				<th width="20">#</th>
				<th width="20"><input type="checkbox" name="toggle" value="" onClick="checkAll(<?=count( $rows ); ?>);" /></th>
				<th align="left" nowrap>Video Name</th>
				<th align="left" nowrap>Video Title</th>
				<th align="left" nowrap>Type</th>
				<th nowrap>Published</th>
				<th nowrap>Checked Out</th>
			</tr>
	<?php
	$k = 0;
	for ($i=0, $n=count( $rows ); $i < $n; $i++) {
		$row = &$rows[$i];
		$impleft = $row->imptotal - $row->impmade;
		if($impleft < 0)
		$impleft = "unlimited";
	
		if ($row->impmade != 0) {
			$percentClicks = substr(100 * $row->clicks/$row->impmade, 0, 5);
		} else {
			$percentClicks = 0;
		}
	?>
			<tr class="<?="row$k"; ?>">
				<td width="20" align="center"><?=$pageNav->rowNumber( $i ); ?></td>
				<td width="20"><?=mosHTML::idBox( $i, $row->id, ($row->checked_out && $row->checked_out != $my->id ) ); ?>
				<td width="42%" align="left">
					<?php
					if ( $row->checked_out && ( $row->checked_out != $my->id ) ) {
						?>
						<?=$row->name; ?>
						&nbsp;[ <i>Checked Out</i> ]
						<?php
					} else {
						?>
						<a href="#edit" onclick="return listItemTask('cb<?=$i; ?>','edit')">
						<?=$row->name; ?>
						</a>
						<?php
					}
					?>
				</td>
				<td width="30%" align="left">
					<?=$row->title?>
				</td>
				<td width="5%" align="left" nowrap>
					<?=$row->vtype?>
				</td>
	<?php
	$act = $row->published ? 'unpublish' : 'publish';
	$img = $row->published ? 'publish_g.png' : 'publish_x.png';
	$alt = $row->published ? 'Published' : 'Unpublished';
	?>
				<td width="10%" align="center"><a href="javascript: void(0);" onClick="return listItemTask('cb<?=$i;?>','<?=$act;?>')">
				<img src="images/<?=$img;?>" width="12" height="12" border="0" alt="<?=$alt; ?>" /></a></td>
				<td width="12%" align="center"><?=$row->checked_out ? $row->editor : "";?>&nbsp;</td>
	<?php		$k = 1 - $k; ?>
			</tr>
	<?php	}
	?>
		</table>
		<?=$pageNav->getListFooter(); ?>
	
		<input type="hidden" name="option" value="<?=$option; ?>">
		<input type="hidden" name="task" value="">
		<input type="hidden" name="boxchecked" value="0">
		</form>
	<?php
		}
	
		/**
			* view of the video editing form.
			* 
			**/
		function videoForm( &$_row, &$lists, $_option ) {
			global $mosConfig_live_site;
			//mosMakeHtmlSafe( $_row, ENT_QUOTES, 'customvideocode' );
			
			// Maxupload size
			$maxUploadSize = ini_get('upload_max_filesize');
			if ( substr($maxUploadSize,-1)=='M' ) {
				$upload_max_filesize = $upload_max_filesize*1048576;
			} elseif ( substr($maxUploadSize,-1)=='K' ) {
				$upload_max_filesize = $upload_max_filesize*1024;
			}
			
			//Get the files located in the directory /media/video/

			$dir = dirname(__FILE__)."/../../../media/video";
			if (is_dir($dir)) {
			   if ($dh = opendir($dir)) {
				   while (false !== ($file = readdir($dh))) {
					   if (is_file($dir."/".$file)){
					   		$file_dd .=  "<option value='".$file."'>".$file."</option>";
						}
				   }
				   closedir($dh);
			   } else {
			   		echo "can't open ".$dir;
			   }
			} else {
				echo $dir." is not a directory";
			}
			
	?>
		<script language="javascript">
		<!--
		function changeDisplayImage() {
			if (document.adminForm.imageurl.value !='') {
				document.adminForm.imagelib.src='../images/video/' + document.adminForm.imageurl.value;
			} else {
				document.adminForm.imagelib.src='images/blank.png';
			}
		}
		function submitbutton(pressbutton) {
			var form = document.adminForm;
			if (pressbutton == 'cancel') {
				submitform( pressbutton );
				return;
			}
			// do field validation
			if (form.name.value == "") {
				alert( "You must provide a video name." );
				return;
			} else if (getSelectedValue('adminForm','type_id') < 1) {
				alert( "Please select a video type." );
				return;
			} else {
				submitform( pressbutton );
			}
		}
		//-->
		</script>
		<table class="adminheading">
			<tr>
				<th><?=$_row->id ? 'Edit' : 'Add';?> SilexVideo</th>
			</tr>
		</table>
		<form action="index2.php" method="post" name="adminForm" enctype="multipart/form-data">
		<table class="adminform">
			<tr>
				<td width="10%"  align="right">Video Name:</td>
				<td width="20%"  align="left"><input class="inputbox" type="text" name="name" value="<?=$_row->name;?>"></td>
				<td rowspan="10" valign="top">
					<?php HTML_silexvideo::warningBox(); ?>
				</td>
			</tr>
			<tr>
				<td align="right">Video Title:</td>
				<td align="left"><input class="inputbox" type="text" name="title"  size="40" value="<?=$_row->title;?>"></td>
			</tr>
			<tr>
				<td align="right">Video File:</td>
				<td align="left"><input class="inputbox" type="text" name="file_name"  size="40" value="<?=$_row->file_name;?>"></td>
			</tr>
			<script language="JavaScript" type="text/JavaScript">
				function doChange(ref) {
					ref.form.file_name.value = ref.form.file_list.options[ref.form.file_list.selectedIndex].value;
				}
			</script>

			<tr>
				<td align="right">or choose here</td>
				<td align="left"><select name="file_list" size="1" onChange="javascript:doChange(this)"><option>---</option><?php echo $file_dd ?></select></td>
			</tr>
			<tr>
				<td align="right">File Type:</td>
				<td align="left"><?=$lists['type_id']; ?></td>
			</tr>
			<tr>
			<tr>
				<td align="right">Width:</td>
				<td align="left"><input class="inputbox" type="text" name="width" size="4" value="<?=$_row->width;?>"></td>
			</tr>
			<tr>
			<tr>
				<td align="right">Height:</td>
				<td align="left"><input class="inputbox" type="text" name="height"  size="4" value="<?=$_row->height;?>"></td>
			</tr>
			<tr>
				<td valign="top" align="right">Description:</td>
				<td><textarea class="inputbox" cols="50" rows="5" name="description"><?=$_row->description;?></textarea></td>
			</tr>
			<tr>
				<td align="left">Upload</td>
				<input type="hidden" name="MAX_FILE_SIZE" value="<?=$upload_max_filesize?>" />
				<td><input class="inputbox" type="file" name="upload" id="upload" size=50">&nbsp;</td>
			</tr>
			<tr>
				<td colspan="3">&nbsp;</td>
			</tr>
		</table>
		<input type="hidden" name="published" value="<?=$_row->published; ?>">
		<input type="hidden" name="option" value="<?=$_option; ?>">
		<input type="hidden" name="id" value="<?=$_row->id; ?>">
		<input type="hidden" name="task" value="">
		</form>
	<?php
		}
		
		function warningBox() {
			?>
	<table  class="adminform">
		<tr>
			<td>
				<h3>Attention, please read carefully!</h3>
				You are about to upload a video file to the web server.
				<?php
					if (ini_get('file_uploads') == 1 ) {
				?>
				You must be aware that :
				<ul>
					<li>your php config allows you to upload
					a file with a max size of <strong><?= ini_get('upload_max_filesize')?>bytes</strong>
					only. Please do not try to bypass this directive.</li>
					<li>your apache server has a maximum keep alive time of <strong><?=getenv ('HTTP_KEEP_ALIVE')?>
					seconds</strong>, it means that if you have a slow connection, the upload will be
					interrupted after this time.</li>
					<li>The file name you enter will be overwriten be the name of the uploaded file.</li>
				</ul>
				<?php
					} else {
						echo "You are not allowed to upload file in your php config file.";	
					}
				?>
				If you just want to save info, use <strong>save</strong> button, and not
				the upload button.
			</td>
		</tr>
	</table>
			<?php
			}
	}

	/**
		* video types
		*
    *	This class contains all the views to manage the video types.
    *
		* @package component SilexVideo
		**/
class HTML_silexvideotype {
	/**
		*	view of the video type listing.
    *
    **/
	function showTypes( &$rows, &$pageNav, $option ) {
?>
	<form action="index2.php" method="post" name="adminForm">
	<table class="adminheading">
		<tr>
			<th>video type Manager</th>
		</tr>
	</table>
	<table class="adminlist">
		<tr>
			<th width="20">#</th>
			<th width="20"><input type="checkbox" name="toggle" value="" onClick="checkAll(<?=count( $rows ); ?>);" /></th>
			<th align="left" nowrap>type Name</th>
			<th align="left" nowrap>Type</th>
			<th align="center" nowrap># of video</th>
			<th align="center" nowrap>Checked Out</th>
		</tr>
<?php
$k = 0;
for ($i=0, $n=count( $rows ); $i < $n; $i++) {
	$row = &$rows[$i];
?>
		<tr class="<?="row$k"; ?>">
			<td width="20" align="center"><?=$pageNav->rowNumber( $i ); ?></td>
			<td width="20"><?=mosHTML::idBox( $i, $row->id ); ?></td>
			<td width="40%"><a href="#edit" onclick="return listItemTask('cb<?=$i; ?>','edit_type')"><?=$row->name; ?></a></td>
			<td width="40%"><?=$row->type;?></td>
			<td width="20%" align="center"><?=$row->vid;?></td>
			<td width="10%" align="center"><?=(isset($row->editor) ? $row->editor : "&nbsp;");?></td>
		</tr>
<?php		$k = 1 - $k;
}
?>
	</table>
	<?=$pageNav->getListFooter(); ?>
	<input type="hidden" name="option" value="<?=$option; ?>">
	<input type="hidden" name="task" value="">
	<input type="hidden" name="boxchecked" value="0">
	</form>
<?php
	}

	/**
		*	view of the video type editing form.
    *
    **/
	function videoTypeForm( &$row, $option ) {
		//mosMakeHtmlSafe( $row, ENT_QUOTES, 'extrainfo' );
?>
	<script language="javascript">
	<!--
	function submitbutton(pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'canceltype') {
			submitform( pressbutton );
			return;
		}
		// do field validation
		if (form.name.value == "") {
			alert( "Please fill in the Type Name." );
			return;
		} else {
			submitform( pressbutton );
			return;
		}
	}
	//-->
	</script>
	<table class="adminheading">
		<tr>
			<th><?=$row->id ? 'Edit' : 'Add';?> video type</th>
		</tr>
	</table>
	<form action="index2.php" method="post" name="adminForm">
	<table class="adminform">
		<tr>
			<td width="10%" style="text-align:right;">Video Type Name:</td>
			<td><input class="inputbox" type="text" name="name" size="30" maxlength="60" valign="top" value="<?=$row->name; ?>"></td>
		</tr>
		<tr>
			<td width="10%"  style="text-align:right;">Type extention:</td>
			<td><input class="inputbox" type="text" name="type" size="4" maxlength="60" value="<?=$row->type; ?>"></td>
		</tr>
		<tr>
			<td valign="top" style="text-align:right;">Description:</td>
			<td><textarea class="inputbox" name="description" cols="60" rows="5"><?=str_replace('&','&amp;',$row->description);?></textarea>
			</td>
		</tr>
		<tr>
			<td valign="top" style="text-align:right;">Code:</td>
			<td><textarea class="inputbox" name="code" cols="60" rows="10"><?=str_replace('&','&amp;',$row->code);?></textarea>
			</td>
	</table>
	<input type="hidden" name="option" value="<?=$option; ?>">
	<input type="hidden" name="id" value="<?=$row->id; ?>">
	<input type="hidden" name="task" value="">
	</form>
<?php }


}
?>
