<?php

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );



if (!$acl->acl_check( 'administration', 'config', 'users', $my->usertype )) {

	mosRedirect( 'index2.php', _NOT_AUTH );

}



if ( defined("_RELEASE") && _RELEASE=="4.5" && defined("_DEV_LEVEL") && !is_numeric("_DEV_LEVEL") ) {

	// 4.5.0

	echo "SEF advance administration is only available for Mambo >=4.5.1.<br />

		To install SEF advance on $version uninstall this and just replace following files with the coresponding files from the package:<br />

		.htaccess<br />

		includes/sef.php";

	die();

} else {

	// >=4.5.1

}



require_once( $mainframe->getPath( 'admin_html' ) );



/**

* Sef Table Class

*

* Provides access to the table

*/

class mosSefConfig extends mosDBTable {

	/** @var int Unique id*/

	var $id=1;

	/** @var string */

	var $blogsection=null;

	/** @var string */

	var $blogcategory=null;

	/** @var string */

	var $archivesection=null;

	/** @var string */

	var $archivecategory=null;

	/** @var string */

	var $frontpage=null;

	/** @var string */

	var $weblinks=null;

	/** @var string */

	var $poll=null;

	/** @var string */

	var $banners=null;

	/** @var string */

	var $contact=null;

	/** @var string */

	var $login=null;

	/** @var string */

	var $search=null;

	/** @var string */

	var $newsfeeds=null;

	/** @var string */

	var $wrapper=null;

	/** @var string */

	var $custom_comp=null;

	/** @var string */

	var $space=null;

	/** @var string */

	var $sufix=null;

	/** @var int */

	var $longurl=null;

	/** @var int */

	var $lowercase=null;

	/** @var int */

	var $homeroot=null;

	/** @var int */

	var $uniqitem=null;

	/** @var int */

	var $debug=null;

	/** @var string */

	var $custom404=null;

	/** @var string */

	var $url_replace=null;

	/** @var string */

	var $url_exception=null;



	/**

	* @param database A database connector object

	*/

	function mosSefConfig( $database ) {

		$this->mosDBTable( '#__sef_config', 'id', $database );

	}

}



class mosSefAlias extends mosDBTable {

	/** @var int Primary key */

	var $id=null;

	/** @var string */

	var $non_sef_url=null;

	/** @var string */

	var $alias=null;

	/** @var int */

	var $published=null;



	/**

	* @param database A database connector object

	*/

	function mosSefAlias() {

	    global $database;

		$this->mosDBTable( '#__sef_alias', 'id', $database );

	}

}



$id = mosGetParam( $_POST, 'id', null );

$task = mosGetParam( $_REQUEST, 'task', null );

$option = mosGetParam( $_REQUEST, 'option', null );



switch($task) {

	case "config":

		showConfig();

		break;

	case "save":

		saveConfig();

		break;

	case "alias":

		listAlias();

		break;

	case "new":

	case "edit":

		editAlias();

		break;

	case "savealias":

		saveAlias();

		break;

	case 'remove':

		removeAlias();

		break;

	case "cancelalias":

		cancelAlias();

		break;

	case "publish":

		changeState( 1 );

		break;

	case "unpublish":

		changeState( 0 );

		break;

	case "diagnostics":

		showDiagnostics();

		break;

	case "info":

		HTML_sef::showInfo("components/$option/readme.txt");

		break;

	case "license":

		HTML_sef::showInfo("components/$option/LICENSE.TXT");

		break;

	default:

		HTML_sef::showFront();

		break;

}



// Functions

function showConfig() {

	global $database, $option;



	$database->setQuery( "SELECT * FROM #__sef_config LIMIT 1" );

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {

		echo $database->stderr();

		return false;

	}

	$row = $rows[0];



	$lists = array();

	$lists['longurl'] = mosHTML::yesnoRadioList( 'longurl', 'class="inputbox"', $row->longurl );

	$lists['lowercase'] = mosHTML::yesnoRadioList( 'lowercase', 'class="inputbox"', $row->lowercase );

	$lists['homeroot'] = mosHTML::yesnoRadioList( 'homeroot', 'class="inputbox"', $row->homeroot );

	$lists['uniqitem'] = mosHTML::yesnoRadioList( 'uniqitem', 'class="inputbox"', $row->uniqitem );

	$lists['debug'] = mosHTML::yesnoRadioList( 'debug', 'class="inputbox"', $row->debug );



	HTML_sef::showConfig( $row, $lists );

}



function saveConfig() {

	global $database, $option;



	$row = new mosSefConfig( $database );

	if (!$row->bind( $_POST )) {

		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit();

	}



	//echo '<pre>'; print_r($row);echo '</pre>';die;



	if (!$row->check()) {

		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit();

	}

	if (!$row->store()) {

		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit();

	}



	mosRedirect( "index2.php?option=$option&task=config" );

}



function listAlias() {

    global $database, $mainframe, $option;



	$search = trim( strtolower( mosGetParam( $_POST, 'search', '' ) ) );

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', 10 );

	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );



	$query = "SELECT count(id) FROM #__sef_alias";

	if ($search != "") {

		$query .= " WHERE (alias LIKE '%$search%')";

	}

	$database->setQuery($query);

	$total = $database->loadResult();

	echo $database->getErrorMsg();



	if ($limit > $total) {

		$limitstart = 0;

	}



	$query = "SELECT id, non_sef_url, alias, published "

		."FROM #__sef_alias";

	if ($search != "") {

		$query .= " WHERE (alias LIKE '%$search%')";

	}

	$query .= " ORDER BY non_sef_url";

	$query .= " LIMIT $limitstart, $limit";



	$database->setQuery( $query );

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {

		echo $database->stderr();

		return false;

	}



	//echo "<pre>"; print_r($rows); die;



	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );

	$pageNav = new mosPageNav( $total, $limitstart, $limit );



	HTML_sef::listAlias( $rows, $search, $pageNav );

}



function editAlias() {

	global $database, $my, $task;



	$id = mosGetParam( $_REQUEST, 'id', '' );

	$cid = mosGetParam( $_POST, 'cid', array(0) );

	if ($cid[0]!="" && $task!="new") {

		$id = $cid[0];

	}



	// load the row from the db table

	$row = new mosSefAlias( $database );

	$row->load( $id );



	if (!$row->id) {

		$row->id = "";

		$row->non_sef_url = "";

		$row->alias = "";

		$row->published = "1";

	}



	HTML_sef::editAlias( $row );

}



function saveAlias() {

	global $database, $option, $task;



	$row = new mosSefAlias( $database );



	if (!$row->bind( $_POST )) {

		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit();

	}



	//echo '<pre>'; print_r($row); echo '</pre>';die;



	$row->non_sef_url = trim($row->non_sef_url);

	$row->alias = trim($row->alias);

	if (substr($row->alias, -1)=="/") {

		$row->alias = substr($row->alias, 0, strlen($row->alias)-1);

	}

	if (substr($row->alias, 0, 1)=="/") {

		$row->alias = substr($row->alias, 1);

	}



	if (!$row->check()) {

		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit();

	}

	if (!$row->store()) {

		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit();

	}



	$msg = 'Successfully Saved';

	mosRedirect( "index2.php?option=$option&task=alias&mosmsg=$msg" );

}



function removeAlias() {

	global $database, $option;



	$cid = mosGetParam( $_POST, 'cid', array(0) );

	$total = count( $cid );



	if ($total < 1) {

		echo "<script> alert('Select an item to delete'); window.history.go(-1);</script>\n";

		exit;

	}

	if (count( $cid )) {

		$cids = implode( ',', $cid );

		$database->setQuery( "DELETE FROM #__sef_alias WHERE id IN ($cids)" );

		if (!$database->query()) {

			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";

		}

	}

	$msg = $total ." Item(s) Successfully Removed";

	mosRedirect( "index2.php?option=$option&task=alias&mosmsg=$msg" );

}



function cancelAlias() {

	global $option;

	mosRedirect( "index2.php?option=$option&task=alias" );

}



function changeState( $state=0 ) {

	global $database, $option;



	$id = mosGetParam( $_REQUEST, 'id', '0' );

	$cid = mosGetParam( $_POST, 'cid', array() );



	if ($id) {

		$cid[] = $id;

	}



	if (count( $cid ) < 1) {

		$action = $state == 1 ? 'publish' : 'unpublish';

		echo "<script> alert('Select an item to $action'); window.history.go(-1);</script>\n";

		exit;

	}



	$cids = implode( ',', $cid );



	$database->setQuery( "UPDATE #__sef_alias SET published='$state'"

	. "\nWHERE id IN ($cids)"

	);

	if (!$database->query()) {

		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";

		exit();

	}



	if ( $state == "1" ) {

		$msg = $total ." Item(s) Successfully Published";

	} else if ( $state == "0" ) {

		$msg = $total ." Item(s) Successfully Unpublished";

	}



	mosRedirect( "index2.php?option=$option&task=alias&mosmsg=$msg" );

}



function showDiagnostics() {

	global $mosConfig_absolute_path, $mosConfig_sef, $version, $xmlDoc;

	global $option, $task;



	$info = array();

	if (isset($_SERVER['SERVER_SOFTWARE'])) {

		$info['server'] = $_SERVER['SERVER_SOFTWARE'];

	} else if (($sf = getenv('SERVER_SOFTWARE'))) {

		$info['server'] = $sf;

	} else {

		$info['server'] = 'n/a';

	}



	$info['sef'] = $mosConfig_sef;



	if (file_exists("$mosConfig_absolute_path/.htaccess")) {

		$info['htaccess'] = "1";

	} else {

		$info['htaccess'] = "0";

	}



	if (extension_loaded('zlib')) {

		$info['zlib'] = "1";

	} else {

		$info['zlib'] = "0";

	}



	$info['mambo_version'] = $version;



	require_once( $mosConfig_absolute_path . '/includes/domit/xml_domit_lite_include.php' );

	$componentBaseDir = mosPathName( $mosConfig_absolute_path . '/administrator/components' );



	$componentDirs = mosReadDirectory( $componentBaseDir );

	$dirName = $componentBaseDir . $option;

	$xmlFilesInDir = mosReadDirectory( $dirName, '.xml' );

	$xmlfile = $xmlFilesInDir[0];

	$xmlDoc =& new DOMIT_Lite_Document();

	$xmlDoc->resolveErrors( true );

	if (!$xmlDoc->loadXML( $dirName . '/' . $xmlfile, false, true )) {

		continue;

	}

	$element = &$xmlDoc->documentElement;

	$element = &$xmlDoc->getElementsByPath('version', 1);

	$info['sef_advance_version'] = $element ? $element->getText() : '';



	HTML_sef::showDiagnostics( $info );

}

?>