<?php
/**
 * admin.primezilla.php
 *
 * Backend administration
 *
 * @package com_primezilla
 * @subpackage backend
 *
 * @copyright 2006 joomster.com Achim Fischer
 * @author Achim Fischer
 *
 * This file is part of joomster.com Primezilla.
 *
 * Primezilla is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Primezilla is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Primezilla; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Dont allow direct linking
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');


// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_primezilla' ))) {
    mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );



$id = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $id )) {
    $id = array(0);
}


switch($act)
{
    case "configuration": {
        switch($task) {
            case "save": {
                saveConfiguration($option);
                break;
            }

            default: {
                listConfiguration($option);
                break;
            }
        }
        break;
    }

    case "statistic": {
        	showStatistic($option);
        break;
    }

    case "about": {
        	showAbout($option);
        break;
    }


    default: {
        break;
    }

}


/********************************************************************************************************/
function saveConfiguration($option) {
    global $database;
    $row = new primezillaConf($database);


    // bind it to the table
    if (!$row -> bind($_POST)) {
        echo "<script> alert('"
        .$row -> getError()
        ."'); window.history.go(-1); </script>\n";
        exit();
    }

    // store it in the db
    if (!$row -> store()) {
        echo "<script> alert('"
        .$row -> getError()
        ."'); window.history.go(-1); </script>\n";
        exit();
    }

    mosRedirect("index2.php?option=$option&act=configuration", "Configuration Saved");
}

/********************************************************************************************************/
function listConfiguration($option) {
    global $database;

    $database->setQuery("SELECT * FROM #__primezilla_config"  );
    $rows = $database -> loadObjectList();
    if ($database -> getErrorNum()) {
        echo $database -> stderr();
        return false;
    }
    HTML_primezilla::listConfiguration($option, $rows);
    return true;
}

/********************************************************************************************************/
function showStatistic($option) {
    global $database;

    $database->setQuery("SELECT msg_date, count(*) AS msg_count FROM #__primezilla_log GROUP BY msg_date ORDER BY msg_date desc LIMIT 14"  );
    $rows = $database -> loadObjectList();
    if ($database -> getErrorNum()) {
        echo $database -> stderr();
        return false;
    }
    HTML_primezilla::showStatistic($option, $rows);
    return true;
}

/********************************************************************************************************/
function showAbout($option) {
    HTML_primezilla::showAbout($option);
    return true;
}



?>
