<?php
/**
 * admin.primezilla.html.php
 *
 * Backend administration HTML
 *
 * @package com_primezilla
 * @subpackage backend
 *
 * @copyright 2006 joomster.com Achim Fischer
 * @author Achim Fischer
 *
 * This file is part of joomster.com Primezilla.
 *
 * Primezilla is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Primezilla is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Primezilla; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// Dont allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

class HTML_primezilla{


	function listConfiguration($option, $rows) {
		global $mosConfig_absolute_path;
        ?>

    <table class="adminheading">
       <tr>
          <th class="config">Primezilla Configuration</th>
       </tr>
    </table>
	<br />

	<form action="index2.php" method="post" name="adminForm">

	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">

	<?php
	$row = $rows[0];
	?>

	<tr>
		<td>Messages per page</td>
		<td><input type="text" name="msgs_per_page" value="<?php echo $row->msgs_per_page; ?>" /></td>
		<td>How many messages are listed on one page</td>
	</tr>

	<tr>
		<td>Max messages</td>
		<td><input type="text" name="max_msgs" value="<?php echo $row->max_msgs; ?>" /></td>
		<td>Message quota for users (not used yet)</td>
	</tr>


	<tr>
		<td colspan="3"><br /><b>Email settings (SMTP)</b></td>
	</tr>

	<tr>
		<td>Email notification is allowed</td>
		<td><?php echo mosHTML::yesnoSelectList( "email_notification_is_allowed", "", $row->email_notification_is_allowed ); ?></td>
		<td>Set to <b>Yes</b> will allow users to use email notification when a PM arrives, set to <b>No</b> will not</td>
	</tr>


	<tr>
		<td>Email notification is default</td>
		<td><?php echo mosHTML::yesnoSelectList( "email_notification_is_default", "", $row->email_notification_is_default ); ?></td>
		<td>Set to <b>Yes</b> will notify users by email when a PM arrives, set to <b>No</b> will not</td>
	</tr>


	<tr>
		<td>Email notification is changeable</td>
		<td><?php echo mosHTML::yesnoSelectList( "email_notification_is_changeable", "", $row->email_notification_is_changeable ); ?></td>
		<td>Set to <b>Yes</b> will allow users to change default setting, set to <b>No</b> will not</td>
	</tr>

	<tr>
		<td>Email server</td>
		<td><input type="text" name="email_server" value="<?php echo $row->email_server; ?>" /></td>
		<td>SMTP server</td>
	</tr>

	<tr>
		<td>Email user</td>
		<td><input type="text" name="email_user" value="<?php echo $row->email_user; ?>" /></td>
		<td>Email user for SMTP server</td>
	</tr>

	<tr>
		<td>Email password</td>
		<td><input type="text" name="email_password" value="<?php echo $row->email_password; ?>" /></td>
		<td>Email password for SMTP server</td>
	</tr>

	<tr>
		<td>Email from</td>
		<td><input type="text" name="email_from" value="<?php echo $row->email_from; ?>" /></td>
		<td>Email from (i.e. yourdomain.com &lt;noreply@yourdomain.com&gt;)</td>
	</tr>


	<tr>
		<td>Email subject</td>
		<td><input type="text" name="email_subject" value="<?php echo $row->email_subject; ?>" /></td>
		<td>Email subject for notification mail</td>
	</tr>

	<tr>
		<td>Email header</td>
		<td>
		<textarea name="email_header" cols="50" rows="5" wrap="VIRTUAL"><?php echo $row->email_header; ?></textarea>
		</td>
		<td>The header ( part before the link) in the notification mail</td>
	</tr>

	<tr>
		<td>Email footer</td>
		<td>
		<textarea name="email_footer" cols="50" rows="5" wrap="VIRTUAL"><?php echo $row->email_footer; ?></textarea>
		</td>
		<td>The footer ( part after the link) in the notification mail</td>
	</tr>

	<tr>
		<td>Use banner in notification emails</td>
		<td><?php echo mosHTML::yesnoSelectList( "email_use_banner", "", $row->email_use_banner ); ?></td>
		<td>Set to <b>Yes</b> will append a text banner to the emails</td>
	</tr>

	<tr>
		<td>Email banner</td>

		<td>
		  <textarea name="email_banner" cols="50" rows="5" wrap="VIRTUAL"><?php echo $row->email_banner; ?></textarea>
		</td>
		<td>A text banner which is appended to the emails</td>
	</tr>



	<tr>
		<td colspan="3"><br /><b>Logging</b></td>
	</tr>

	<tr>
		<td>Enable logging</td>
		<td><?php echo mosHTML::yesnoSelectList( "logging_is_enabled", "", $row->logging_is_enabled ); ?></td>
		<td>Set to <b>Yes</b> will write timestamps of sent messages in the log-table, set to <b>No</b> will not. Logging is required for the Statistic</td>
	</tr>


	<tr>
		<td colspan="3"><br /><b>Support Mode</b></td>
	</tr>

	<tr>
		<td>Enable Support Mode</td>
		<td><?php echo mosHTML::yesnoSelectList( "support_mode", "", $row->support_mode ); ?></td>
		<td>Set to <b>Yes</b> will only allow special users to send PM to everybody - normal users will see a restricted selectbox with the configured support mode users, set to <b>No</b> will allow all users to send PM to all other users (normal operation mode)</td>
	</tr>

	<tr>
		<td>Support Mode Users</td>
		<td>
		    <input type="text" name="support_mode_users" value="<?php echo $row->support_mode_users; ?>" />
		</td>
		<td>
		    Enter existing(!) users for support mode in a comma seperated list. These users will be displayed in the listbox.<br />
		    i.E. "Support, Helpdesk, Presales"
		</td>
	</tr>

	<tr>
		<td>Support Mode Users Display</td>
		<td>
		    <?php
            $displaySelect = array();
            $displaySelect[] = mosHTML::makeOption( '0', 'Name (Username)');
            $displaySelect[] = mosHTML::makeOption( '1', 'Name');
            $displaySelect[] = mosHTML::makeOption( '2', 'Username');
            echo mosHTML::selectList( $displaySelect, 'support_mode_users_display', 'size="1" class="inputbox"', 'value', 'text', $row->support_mode_users_display );
            ?>
		</td>
		<td>
		    How to show the support mode users in the listbox: Name + Username, Name only, Username only
		</td>
	</tr>




	</table>

	<input type="hidden" name="option" value="<?php echo $option; ?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="id" value="<?php echo $row->id; ?>" />
	<input type="hidden" name="act" value="configuration" />

	</form>

	<br />

	<?php
	echo "<table>";
	echo "<tr>";
	echo "<td>";
	include($mosConfig_absolute_path.'/components/com_primezilla/footer.php');
	echo "</td>";
	echo "</tr>";
	echo "</table>";
	}





function showStatistic($option, $rows) {
		global $mosConfig_absolute_path;
        ?>

    <table class="adminheading">
       <tr>
          <?php
          $bgImage = $mosConfig_live_site."/administrator/images/browser.png";
          ?>
          <th style="background: url( <?php echo $bgImage; ?>) no-repeat left;">Primezilla Statistic</th>
       </tr>
    </table>
	<br />



	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">

	<tr>
		<td colspan="3"><br /><b>Messages last 14 days</b></td>
	</tr>

	<tr>
		<td>Date</td>
		<td># Messages</td>
		<td width="50%"">&nbsp;</td>
	</tr>


	<?php
	$k = 0;
    for( $i=0; $i < count( $rows ); $i++) {

    	$row = $rows[$i];
	?>

	<tr>
		<td><?php echo $row->msg_date; ?></td>
		<td><?php echo $row->msg_count; ?></td>
		<td width="50%"">&nbsp;</td>
	</tr>

	<?php
	}
	?>

	</table>



	<br />

	<?php
	echo "<table>";
	echo "<tr>";
	echo "<td>";
	include($mosConfig_absolute_path.'/components/com_primezilla/footer.php');
	echo "</td>";
	echo "</tr>";
	echo "</table>";
}


function showAbout($option) {
	global $mosConfig_absolute_path;
    ?>

    <center>

    <table class="adminheading">
       <tr>
          <?php
          $bgImage = $mosConfig_live_site."/administrator/images/credits.png";
          ?>
          <th style="background: url( <?php echo $bgImage; ?>) no-repeat left;">About Primezilla</th>
       </tr>
    </table>
	<br />


	<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">

	<tr>
		<td align="center">
            <h3>Primezilla Private Messaging</h3>
            <b>Developer</b>
            <br />
            <br />
            Achim Fischer - <a href="http://www.joomster.com" target="_blank">joomster.com</a>
            <br />
            <br />
		</td>
	</tr>

	<tr>
		<td align="center">
            <b>Credits</b>
            <br />
            <br />
            Mika Salo(mikkeli) <a href="http://www.rakshop.net/" target="_blank">www.rakshop.net</a> - Finnish language translation & Forum Moderation
            <br />
            <br />
		</td>
	</tr>

	<tr>
		<td align="center">
            <b>Sponsors</b>
            <br />
            <br />
            <a href="http://www.gabou.eu" target="_blank">Gabou.eu</a> - Support Mode
            <br />
            <br />
            <br />
            Want to sponsor a feature?
            <br />
            Send an email to <a href="mailto:info@joomster.com">info@joomster.com</a> for details.
            <br />
            <br />
		</td>
	</tr>

	<tr>
		<td align="center">
            <b>Libraries / Icon Sets</b>
            <br />
            <br />

            SWIFT Mailer Class by Chris Corbyn <a href="http://www.swiftmailer.org/" target="_blank">www.swiftmailer.org</a>
            <br />
            <br />

            FamFamFam Silk Icon Set by Mark James <a href="http://www.famfamfam.com/" target="_blank">www.famfamfam.com</a>
            <br />
            <br />

            Script.aculo.us Javascript Library <a href="http://script.aculo.us/" target="_blank">script.aculo.us</a>
            <br />
            <br />

            Prototype Javascript Library <a href="http://prototype.conio.net/" target="_blank">prototype.conio.net/</a>
            <br />
            <br />

		</td>
	</tr>


	</table>

    </center>

    <br />


	<?php
	echo "<table>";
	echo "<tr>";
	echo "<td>";
	include($mosConfig_absolute_path.'/components/com_primezilla/footer.php');
	echo "</td>";
	echo "</tr>";
	echo "</table>";
	}



}
?>
