<?php
defined( '_VALID_MOS' ) or die( 'Restricted access' );
/***********************************************************
*****   Copyright and author information about phpForm   ***
************************************************************
***
**   Author:        Simon ander
**   Copyright by:  Simon ander
**   Authors email: simons@email.si
**
**   This program is free for commercial and noncommercial 
**   use. (Hope to get some credit at St. Peter's gate:)
**   It's licensed under GNU license.
**
**   To run, this program requires template library
**   "template.inc" which is part of PHPLIB that can
**   be found at http://phplib.netuse.de/
***
************************************************************
*****                 Why to use phpForm?                ***
************************************************************
***
**   Because I guarantee you that it will save you
**   a lot of time, money and your nerves :). For more
**   goodies read features section.
***
************************************************************
*****                  Testing platforms                 ***
************************************************************
***
**   Program was tested with folowing browsers:
**   
**   Internet explorer 5.5
**   Netscape Navigator 6.0
**   Netscape Navigator 4.61
**   
**   Works yust fine with all of them ;)
**   
**   For beter performance and look of your forms I 
**   recomend you to use Netscape Navigator 6.x or 
**   Microsoft Internet Explorer 5.x.
***
************************************************************
*****                      Features                      ***
************************************************************
***
**   phpForm gives you all the freedom to create forms
**   of your dreams :) without writing any line of PHP code
**   to process it. It do not limit your creativity in any 
**   way. 
**
**   - write once use manny times
**   - easy to use
**   - authomatic form HTML code generation from PHP array
**   - authomatic required field checking
**   - authomatic field content checking
**   - HTML 4 form field syntax checking
**   - full code separation from design
**   - authomatic advance to ACTION page when form is
**     entered correctly
**   - support both POST and GET submit method
***
***********************************************************/
global $mosConfig_live_site;
if (file_exists($mosConfig_absolute_path.'/administrator/components/com_securityimages/client.php')) {
	include ($mosConfig_absolute_path.'/administrator/components/com_securityimages/client.php'); 
	include ($mosConfig_absolute_path.'/administrator/components/com_securityimages/server.php');
}

class phpform {
	// PUBLIC properties
  var $debug;
	var $arrForm;
	var $strMethod;
	var $strAction;
	var $strRequiredFieldMark;
	var $strMissingFieldMsg;
	var $strSkin;
	var $bolShowWarnings;
	var $strBreakOptionFields;
	var $bolIgnoreHidden;
	var $use_securityimages;
	var $securityImageHelp;
	var $securityImageError;
	var $formImage;
	var $intro;
	
	// Constructor
	function phpform( $strFormName, $arrForm ) {
global $mosConfig_debug;
		// PRIVATE properties
    $this->debug = $mosConfig_debug;
		$this->bolFormOK = false;
		$this->arrInputTypes = array( 'button', 'checkbox', 'file', 'hidden', 'image','select', 'password', 'radio', 'reset', 'submit', 'text', 'textarea', 'textual','date','pagebreak' );
		$this->arrAttrWithValues = array( 'accesskey', 'align', 'alt', 'class', 'dynsrc', 'id', 'lang', 'language', 'lowsrc', 'maxlength', 'name', 'size', 'src', 'style', 'tabindex', 'title', 'type', 'value', 'event', "rows", "cols", "wrap" );
		$this->arrAttrEvents = array( 'onabort','onafterupdate','onbeforeunload','onbeforeupdate','onblur','onbounce','onchange','onclick','ondataavailable','ondatasetchanged','ondatasetcomplete','ondblclick','ondragstart','onerror','onerrorupdate','onfilterchange','onfinish','onfocus','onhelp','onkeydown','onkeypress','onkeyup','onload','onmousedown','onmousemove','onmouseout','onmouseover','onmouseup','onreadystatechange','onreset','onresize','onrowenter','onrowexit','onscroll','onselect','onselectstart','onstart','onsubmit','onunload' );
		$this->arrAttrWithoutValues = array( 'disabled', 'readonly', 'multiple', 'checked', 'selected' );
		$this->arrPHPFormAttr = array( 'caption', 'separator', 'required', 'usecaption', 'useintro', 'options', 'help', 'check', 'minlength', 'lCellAtt', 'rCellAtt', 'errMsg' );
		$this->arrInputSelectType = array( 'radio' => 'checked', 'select' => 'selected', 'checkbox' => 'checked' );
		$this->arrValuesTypes = array( 'string', 'name', 'float', 'integer', 'email', 'url' );
		$this->bolFrmSubmited = false;
		$this->strAuthorName	= "Simon ander";			// please never change this!!
		$this->strAuthorEmail	= "simon@vizija.si";  // please never change this!!
		$this->strVersion			= "1.0.9";						// please never change this!!
		$this->strHomePage		= "http://phpform.sourceforge.net";		// please never change this!!
				
		// PUBLIC properties
		$this->arrForm = $arrForm;
		$this->strMethod = "post";
		$this->strRequiredFieldMark = '<span class="performs_required"> *</span>';
		$this->strMissingFieldMsg = 'Please fill out!';
		$this->strFormName = $strFormName;
		$this->bolShowWarnings = true;
		$this->strBreakOptionFields = true;
		$this->bolIgnoreHidden = false;
		$this->use_securityimages=false;
		$this->securityImageHelp="Enter what you see";
		$this->securityImageError="The code is wrong";	
		$this->formImage="";	
		$this->intro="";
	}

	// Displays warning message and terminate program if it's necessary
	function warning( $strMessage, $strLevel = 1 ) {
		$this->bolFormOK = false;
		if ( $this->bolShowWarnings ) {
			echo "Warning: $strMessage\n<br>";
		}
		if ( $strLevel == 0 ) {
			exit;
		}
	}

	// generate HTML 4 atribute list for input field
	function attributes( $arrAttributes ) {
		$strAttributes = "";
		foreach( $arrAttributes as $strAttrName => $strAttrValue ) {
			if ( in_array( $strAttrName, $this->arrAttrWithValues ) ) {
				$strAttributes .= " $strAttrName=\"$strAttrValue\"";
			} elseif ( in_array( $strAttrName, $this->arrAttrWithoutValues ) ) {
				$strAttributes .= " $strAttrName";
			} elseif ( in_array( $strAttrName, $this->arrAttrEvents ) ) {
				$strAttributes .= " $strAttrName=\"$strAttrValue\"";
			} elseif ( !in_array( $strAttrName, $this->arrPHPFormAttr ) ) {
				$this->warning( "Wrong/unknown attribute '".$strAttrName."'.", 0 );
			}
		}
		return $strAttributes;
	}

	// generate option list
	function options( $arrAttr ) {
		$strOptions = "";
		switch( $arrAttr['type'] ) {
			case "select":
				foreach( $arrAttr['options'] as $strOptionName => $arrAttributes ) {
					if ( count( $arrAttributes ) > 1 ) {
            $strOptions .= "<option value=\"$arrAttributes[0]\" $arrAttributes[1]>$strOptionName</option>\n";
          } else {
            $strOptions .= "<option value=\"$arrAttributes[0]\">$strOptionName</option>\n";
          }
				}
				break;
			case "radio": case "checkbox":
				$strAttributes = $this->attributes( $arrAttr );
        
				foreach( $arrAttr['options'] as $strRadioName => $arrRadioAttributes ) {
					if ( $this->strBreakOptionFields ) {
						$strBR = "<br>";
					} else {
						$strBR = "";
					}
					if ( count( $arrRadioAttributes ) > 1 ) {
						$strOptions .= "<input$strAttributes value=\"$arrRadioAttributes[0]\" $arrRadioAttributes[1]>$strRadioName$strBR\n";
					} else {
						$strOptions .= "<input$strAttributes value=\"$arrRadioAttributes[0]\"> $strRadioName$strBR\n";
					}					
				}
				if ( $this->strBreakOptionFields ) {
					$strOptions = substr( $strOptions, 0, -5 );
				}
				break;
			default:
				$this->warning( "Invalid type ".$arrAttr['type'], 0 );
				break;
		}
		return $strOptions;
	}

	// checks if the required fields are filed in and if they are filed in correctly
	function checkField( $arrAttributes ) {
		$strRes = "";
		switch ( $arrAttributes['type'] ) {
			case "select": case "radio": case "checkbox":
#				if ( $arrAttributes['required'] ) {
        if ( array_key_exists('required', $arrAttributes) ) {
					$strTmp = $this->getFieldName( $arrAttributes['name'] );
					$strVal = array();
					if ( isset( $strTmp ) ) {
						$strVal = $this->arrSubmitedFields[$strTmp];
					}
					if ( count( $strVal ) == 0 ) {
						$strRes = $this->strMissingFieldMsg;
						$this->warning( "Missing value in this field '".$arrAttributes['name']."'." );
					}
				}
				break;
			case 'textual':
				// ignore textual fields
				break;
			default:
//				if ( isset( $arrAttributes['required'] ) && !$arrAttributes['value'] ) {
        if ( isset( $arrAttributes['required'] ) && empty( $arrAttributes['value'] ) ) {
					$strRes = $this->strMissingFieldMsg;
					$this->warning( "Missing value in this field '".$arrAttributes['name']."'." );
				}
				break;
		}

		$strCheck = "";
		if ( isset( $arrAttributes['check'] ) && !empty( $arrAttributes['value'] ) ) {
			switch( $arrAttributes['check'] ) {
				case 'string':
					if ( !isString( $arrAttributes['value'] ) ) {
						$strCheck = $arrAttributes['errMsg'];
					}
					break;
				case 'name':
					if ( !isName( $arrAttributes['value'] ) ) {
						$strCheck = $arrAttributes['errMsg'];
						$this->warning( "Wrong value in this field '".$arrAttributes['name']."'." );
					}
					break;
				case 'float':
					if ( !isFloat( $arrAttributes['value'] ) ) {
						$strCheck = $arrAttributes['errMsg'];
						$this->warning( "Wrong value in this field '".$arrAttributes['name']."'." );
					}
					break;
				case 'integer':
					if ( !isInteger( $arrAttributes['value'] ) ) {
						$strCheck = $arrAttributes['errMsg'];
						$this->warning( "Wrong value in this field '".$arrAttributes['name']."'." );
					}
					break;
				case 'email':
					if ( !isEmail( $arrAttributes['value'] ) ) {
						$strCheck = $arrAttributes['errMsg'];
						$this->warning( "Wrong value in this field '".$arrAttributes['name']."'." );
					}
					break;
				case 'url':
					if ( !isValidURL( $arrAttributes['value'] ) ) {
						$strCheck = $arrAttributes['errMsg'];
						$this->warning( "Wrong value in this field '".$arrAttributes['name']."'." );
					}
					break;
				default:
					$this->warning( "Invalid checking type '".$arrAttributes[check]."'." );
					break;
			}
		}
		if ( !empty( $strRes ) ) {
			$strRes = "<div class=\"performs_error\" >$strRes</div>";
		}
		if ( !empty( $strCheck ) ) {
			$strCheck = "<div class=\"performs_error\" >$strCheck</div>";
		}
		return $strRes.$strCheck;
	}

	// Checks for submit button in the form, and returns it's position in array
	function checkForSubmitBtn( &$strSubmitBtnName ) {
		$bolRes = false;
		foreach( $this->arrForm as $arrAttributes ) {
			if ( strcasecmp( $arrAttributes['type'], "submit" ) == 0 ) {
				// submit button found
				$strSubmitBtnName = $arrAttributes['name'];
				$bolRes = true;
				break;
			}
		}
		if ( !$bolRes ) {
			$this->warning( "There is no submit button in this form." );
		}
		return $bolRes;
	}

	// convert form results into PHP array
	function formToArray() {
  global $mosConfig_debug;
		$arrRes = array();
    if ($mosConfig_debug) {
      echo '<hr><div><h1>formToArray</h1><blockquote>';
    }
		foreach( $this->arrForm as $strKey => $arrAttributes ) {
      $rawelementname = $arrAttributes['name']; //element name may contain []
//      $elementname = $this->getFieldName($rawelementname);//remove [] 
      $elementname = $rawelementname;//remove [] 
    
//      if (array_key_exists("separator", $arrAttributes)) {
if ($mosConfig_debug) {
          echo '<hr><div>name='.$elementname.'</div>';
          echo '<div>type='.$arrAttributes['type'].'</div>';
          }

			switch( $arrAttributes['type'] ) {
				case "select": case "radio": case "checkbox":
					$strFieldName = $this->getFieldName( $elementname );
          if (array_key_exists($strFieldName, $arrAttributes)) {
            $arrRes[$strFieldName] =	array(
													"value"		=> $this->arrSubmitedFields[$strFieldName],
													"separator"	=> strip_tags( $arrAttributes['separator'] ),
													"caption"	=> strip_tags( $arrAttributes['caption'] ),
													 "usecaption"=> $arrAttributes['usecaption']
                                            );
          } else {
            $arrRes[$strFieldName] =	array(
                                        "value"		=> "",
                                        "separator"	=> strip_tags( $arrAttributes['separator'] ),
                                        "caption"	=> strip_tags( $arrAttributes['caption'] ),
                                        "usecaption"=> $arrAttributes['usecaption']
                                            );
          }
          if ($mosConfig_debug) {
            echo '<div>strCaption='.strip_tags( $arrAttributes['caption'] ).'</div>';
            echo '<div>value='.$this->arrSubmitedFields[$strFieldName].'</div>';
          }
					break;
				case "submit": case "reset": case "button":	case 'textual':
					// ignore those fields
					break;
        case "text":
					#$strFieldName = $this->getFieldName( $elementname );	
          if ($mosConfig_debug) {
            echo '<div>strCaption='.strip_tags( $arrAttributes['caption'] ).'</div>';
            echo '<div>value='.$this->arrSubmitedFields[$elementname].'</div>';
          }
						$strCaption = strip_tags( $arrAttributes['caption'] );
					$arrRes[$arrAttributes['name']] =	array(
															"value"		=> $this->arrSubmitedFields[$elementname],
															"caption"	=> strip_tags( $strCaption ),
															"separator"	=> strip_tags( $arrAttributes['separator'] ),
													    "usecaption"=> $arrAttributes['usecaption']
														);
                            break;
        
				default:
					//$strFieldName = $this->getFieldName( $elementname );	
          if ($mosConfig_debug) {
            echo '<hr><h3>default:</h3><div style="background-color:wheat;color:maroon;padding:12pt;">';
            echo $arrAttributes['type'];
            echo '</div>';
        }
					if ( ( $arrAttributes['type'] == 'hidden' ) && $this->bolIgnoreHidden ) {
						# ignore hidden fields
						continue;
					}

					if ( $arrAttributes['type'] == 'hidden' ) {
						$strCaption = $arrAttributes['name'];
					} else {
						$strCaption = strip_tags( $arrAttributes['caption'] );
					}
          
          $strSeparator = ''; 
          $strUseCaption = '';
          
      if (array_key_exists("separator", $arrAttributes)) {
        $strSeparator = strip_tags( $arrAttributes['separator'] );
      }
      if (array_key_exists("usecaption", $arrAttributes)) {
        $strUseCaption = $arrAttributes['usecaption'];
      }

					$arrRes[$arrAttributes['name']] =	array(
															"value"		=> $this->arrSubmitedFields[$elementname],
															"caption"	=> strip_tags( $strCaption ),
															"separator"	=> $strSeparator,
													        "usecaption"=> $strUseCaption
														);

					break;
			}
  //    }//if array_key_exists()
  if ($mosConfig_debug) {
      echo "</blockquote>";
  }
		}
    if ($mosConfig_debug) {
      echo '</blockquote></div>';
    }
		return $arrRes;
	}

	// Convert form results into HTML table
function formToTable() {
  $strStyle = '<style type="text/css">';
  $strStyle .= 'td { padding-right: 12pt; }';
  $strStyle .= 'th { background-color: aliceblue; color: navy; }';
  $strStyle .= '</style>';
		$strRes = $strStyle."<table>";
    //	echo "<br>----&gt;"; print_r( $this->formToArray() ); echo "&lt;---<br>";
    $sep="";
    $sep2="";
    $strRes .= '<tr><th>Item</th><th>Value</th></tr>'."\n";
    
    $arr = $this->formToArray();
		foreach( $arr as $strKey => $strVal ) {
      $strRes .= '<tr>';
      //		foreach( $this->formToArray() as $strKey => $strVal ) {
			$sep2=$sep;
			if($strKey=="formid")
				continue;
			
		    $caption = strip_tags( $strVal['caption'] );
		    $endline = "newline";
        if ( is_array( $strVal['value'] ) ) {
          if ( $strVal['usecaption'] ) {
            $strRes .= '<td>'.$caption."</td> ";
		        }
          $endline = $strVal['separator'];
          $strRes .= '<td>'.implode( ",", $strVal['value'] ).'</td>';
        }
        else {
          if ( !empty( $strVal['value'] ) ) {
            if ( $strVal['usecaption'] ) {
              $strRes .= '<td>'.$caption."</td>";
            }
            $endline = $strVal['separator'];
            $strRes .= '<td>'.$strVal['value'].'</td>';
          }
          //				else
          //				    $strRes .= $caption.": [empty]";
        }
        switch ($endline)
        {
			    case "space":
            $sep = " ";
            break;
			    case "comma":
            $sep = ",";
            break;
			    case "comma+space":
            $sep = ", ";
            break;
			    case "hyphen":
            $sep = "-";
            break;
			    case "newline":
			    default:
            $sep = "\n</tr>\n";
            break;
        }
        $strRes .=$sep2."\n";
      }
    $strRes .= '</table>';
		return stripslashes($strRes);
  }

	// Convert form results into plain text
	function formToText() {
		$strRes = "";
			//	echo "<br>----&gt;"; print_r( $this->formToArray() ); echo "&lt;---<br>";
			$sep="";
			$sep2="";
      
      $arr = $this->formToArray();
		foreach( $arr as $strKey => $strVal ) {
      
//		foreach( $this->formToArray() as $strKey => $strVal ) {
			$sep2=$sep;
			if($strKey=="formid")
				continue;
			
		    $caption = strip_tags( $strVal['caption'] );
		    $endline = "newline";
			if ( is_array( $strVal['value'] ) ) {
                if ( $strVal['usecaption'] ) {
		            $strRes .= $caption.": ";
		        }
                $endline = $strVal['separator'];
				$strRes .= implode( ",", $strVal['value'] );
			}
			else {
				if ( !empty( $strVal['value'] ) ) {
                    if ( $strVal['usecaption'] ) {
			            $strRes .= $caption.": ";
			        }
                    $endline = $strVal['separator'];
					$strRes .= $strVal['value'];
				}
//				else
//				    $strRes .= $caption.": [empty]";
			}
			switch ($endline)
			{
			    case "space":
			        $sep = " ";
			        break;
			    case "comma":
			        $sep = ",";
			        break;
			    case "comma+space":
			       $sep = ", ";
			        break;
			    case "hyphen":
			       $sep = "-";
			        break;
			    case "newline":
			    default:
			        $sep = "\n";
			        break;
			}
			$strRes .=$sep2."\n";
		}
		return stripslashes($strRes);
	}

	// Convert form results into CSV text
	function formToCSV( $strDelimiter = ";", $strText = '"' ) {
		foreach( $this->formToArray() as $strKey => $strVal ) {
			if ( is_array( $strVal['value'] ) ) {
				$strRes .= $strText.implode( ",", $strVal['value'] ).$strText;
			} else {
				if ( !isset( $strVal['value'] ) && empty( $strVal['value'] ) ) {
					$strRes .= $strText.$strText;
				} else {
					$strRes .= $strText.$strVal['value'].$strText;
				}
			}
			$strRes .= $strDelimiter;
		}
		$strRes = substr( $strRes, 0, -1 );
		return $strRes;
	}

	// save form results into plain text file
	function formToFile( $strFileName ) {
		if ( empty( $strFileName ) || !isset( $strFileName ) ) {
			$this->warning( "You must set the name of the file to save form result to.", 0 );
		}

		if ( $objFile = fopen( $strFileName, 'w+' ) ) {
     	fwrite( $objFile, $this->formToText() );
     	fclose( $objFile );
			return true;
    } else {
			return false;
		}
	}

	// generate SQL insert query from form result
	function formToSQLInsert( $strTableName ) {
		if ( empty( $strTableName ) || !isset( $strTableName ) ) {
			$this->warning( "You must set the name of the table into which the form data will be inserted.", 0 );
		}
		
		$arr = $this->formToArray();
		$strFields = "";
		$strValues = "";
		foreach( $arr as $strKey => $strVal ) {
			if($strKey=="formid")
				continue;
			$strFields .= "`$strKey`,";
			if ( is_array( $strVal['value'] ) ) {
				$strValues .= "'".mysql_escape_string(implode( ",", $strVal['value'] ))."',";
			} else {
				$strValues .= "'".mysql_escape_string($strVal['value'])."',";
			}
		}

		//$strFields = substr( $strFields, 0, -1 );
		//$strValues = substr( $strValues, 0, -1 );
		$strFields .=" `UserIp` ";
		$strValues .= " '".$_SERVER['REMOTE_ADDR']."'";
		return "INSERT INTO `$strTableName` ( $strFields ) VALUES ( $strValues );";
	}

	// generate SQL UPDATE query from form result
	function formToSQLUpdate( $strTableName ) {
		if ( empty( $strTableName ) || !isset( $strTableName ) ) {
			$this->warning( "You must set the name of the table in which the form data will be updated.", 0 );
		}

		foreach( $this->formToArray() as $strKey => $strVal ) {
			if ( is_array( $strVal['value'] ) ) {
				$strValues = implode( ",", $strVal['value'] );
			} else {
				$strValues = $strVal['value'];
			}
			$strFields .= "$strKey='$strValues',";
		}

		$strFields = substr( $strFields, 0, -1 );
		$strValues = substr( $strValues, 0, -1 );
		return "UPDATE $strTableName SET $strFields;";
	}

	// sends form to email
//	function formToEmail( $strFromEmail, $strToEmail, $strSubject, $strMessage="", $strCC="", $strBCC="" ) {
		// additional header pieces for errors, From cc's, bcc's, etc
//		$strHeaders .= "From: $strFromEmail\n";
//		$strHeaders .= "X-Sender: <$strFromEmail>\n"; 
//		$strHeaders .= "X-Mailer: phpForm\n"; // mailer
//		$strHeaders .= "X-Priority: 0\n";
//		$strHeaders .= "Return-Path: <$strFromEmail>\n";  // Return path for errors
//
//		$strHeaders .= "cc:$strCC\n"; // CC to
//		$strHeaders .= "bcc:$strBCC\n"; // BCCs to
//
		// and now mail it
//		$message = strtr($strMessage, array_flip(get_html_translation_table(HTML_SPECIALCHARS, ENT_QUOTES)));
//		return @mail( $strToEmail, strip_tags($strSubject), html_entity_decode(strip_tags($message)).$this->formToText(), $strHeaders );
//	}
  function formToEmail( $strFromName, $strFromEmail, $strToEmail, $strSubject, $strMessage, $strCC=NULL, $strBCC=NULL ) {
  global $mosConfig_debug;
		// load recipient(s) into array
    if ($mosConfig_debug) {
      echo '<span style="color: maroon; font-size: x-large;">formToEmail</span><hr>';
      echo '<div>strFromName = '.$strFromName.'</div>';
      echo '<div>strFromEmail = '.$strFromEmail.'</div>';
      echo '<div>strToEmail = '.$strToEmail.'</div>';
      echo '<div>strSubject = '.$strSubject.'</div>';
    }
    
    $strToEmail = explode( ',', str_replace( ' ', '', $strToEmail ) );
		$message = strtr($strMessage, array_flip(get_html_translation_table(HTML_SPECIALCHARS, ENT_QUOTES)));

#    $form2text = $this->formToText();
    $form2text = $this->formToTable();

    if ($mosConfig_debug) {
      echo '<hr><div>formToText = <blockquote><pre>';
      echo $form2text;
      echo '</pre></blockquote></div>';
    }
    
    return mosMail( $strFromEmail, $strFromName, $strToEmail, $strSubject, $form2text, TRUE, $strCC, $strBCC, NULL, $strFromEmail, $strFromName );
  }

	// get's the array of submited fields
	function getSubmitArray() {
/*		global $HTTP_POST_VARS, $HTTP_GET_VARS;		
		if ( strcasecmp( $this->strMethod, "post" ) == 0 ) {
			return $HTTP_POST_VARS;
		} elseif ( strcasecmp( $this->strMethod, "get" ) == 0 ) {
			return $HTTP_GET_VARS;
		} else {
			$this->warning( "Wrong form method type!", 0 );
		}*/
		return $_REQUEST;
	}

	// Checks if form was submited
	function formSubmited() {
		$this->checkForSubmitBtn( $strSubmitBtnName );
		$this->bolFrmSubmited = false;

		$this->arrSubmitedFields = $this->getSubmitArray();
		if ( isset( $this->arrSubmitedFields[$strSubmitBtnName] ) ) {
			$this->bolFrmSubmited = true;
		}
		return $this->bolFrmSubmited;
	}

	// get plain field name without [] for example.
	function getFieldName( $strFieldName ) {
  global $mosConfig_debug;
    if ($mosConfig_debug) echo '<div style="background-color:lavenderblush;padding:24pt;"><div><h2>getFieldName()</h2></div>';
		if ( eregi( "(.*)(\[\])", $strFieldName, $arrPat ) ) {
    if ($mosConfig_debug) {
      echo "<div>".count($arrPat)."</div><ol>";
      echo '<li>'.$arrPat[0].'</li>';
      echo '<li>'.$arrPat[1].'</li>';
      echo '</ol>';
      }
			return $arrPat[1];
		} else {
			$this->warning( "getFieldName - Field name mismatch '".$strFieldName."'.", 0 );
			return false;
		}
    if ($mosConfig_debug) echo '<hr></div>';
	}

	/** 
	*	@description returns the value of specified field
	* @param $strFieldName - name of the form field
	* @return mixed - value of the field
	*/
	function getFieldValue( $strFieldName ) {
		$arrData = $this->formToArray();
		foreach( $arrData as $strKey => $strValue ) {
			if ( strcmp( strtolower($strKey), strtolower($strFieldName) ) == 0 ) {
				return $strValue["value"];
			}
		}
		$this->warning( "getFieldValue - Field name mismatch '".$strFieldName."'." );
		return false;
	}

	function replaceVars( $str ) {
  global $mosConfig_debug;
  
if ($mosConfig_debug) echo '<div style="padding:24pt; background-color:gold;"><h1>replaceVars</h1>';
	
    	$arrData = $this->formToArray();
		foreach( $arrData as $strKey => $strValue ) {
			if ( is_array( $strValue["value"] ) ) {
				$strRes=",";
				switch ($strValue["separator"])
				{
					case "space":
						$strRes = " ";
						break;
					case "comma":
						$strRes = ",";
						break;
					case "comma+space":
						$strRes = ", ";
						break;
					case "hyphen":
						$strRes = "-";
						break;
					case "newline":
					default:
						$strRes = "\n";
						break;
				}
				$res = implode($strRes,$strValue["value"]);	
				$str = preg_replace("/(\{$strKey\})/i",$res,$str);
			} else {
				$str = preg_replace("/(\{$strKey\})/i",$strValue["value"],$str);
			}			 
		 
		}
		 $str = preg_replace("/(\{userip\})/i",$_SERVER['REMOTE_ADDR'],$str);
     
if ($mosConfig_debug)	echo '</div>';
    
		return $str;
	}

	// read the submited values and stores them into form array
	function rememberFormFields() {
  global $mosConfig_debug;
		foreach( $this->arrForm as $strKey => $arrAttributes ) {
			switch( $arrAttributes['type'] ) {
				case "select": case "radio": case "checkbox":
     if (array_key_exists($this->getFieldName( $arrAttributes['name'] ),$this->arrSubmitedFields)) {
					$arrSubmitedFields = $this->arrSubmitedFields[$this->getFieldName( $arrAttributes['name'] )];
					if ( count( $arrSubmitedFields ) > 0 ) {
						# check checked fields
						foreach( $arrSubmitedFields as $strSubmitedFieldValue ) {
							foreach( $arrAttributes['options'] as $arrOptions => $arrOptionAttributes ) {
								// mach field
								if ( strcasecmp( $arrOptionAttributes[0], $strSubmitedFieldValue ) == 0 ) {
									$this->arrForm[$strKey]['options'][$arrOptions][1] = $this->arrInputSelectType[$arrAttributes['type']];
								}
							}
						}
					}

					# uncheck fields that are not selected
					foreach( $arrAttributes['options'] as $arrOptions => $arrOptionAttributes ) {
						if ( $arrSubmitedFields ) {
							if ( !in_array( $arrOptionAttributes[0], $arrSubmitedFields ) ) {
								unset( $this->arrForm[$strKey]['options'][$arrOptionAttributes[0]][1] );
							}
						} else {
							unset( $this->arrForm[$strKey]['options'][$arrOptionAttributes[0]][1] );
						}
					}
          
     } else {
     if ($mosConfig_debug) echo '<div style="color:red;">Not a valid element: '.$this->getFieldName( $arrAttributes['name'] ).'</div>';
     }

					break;
				case "submit": case "button": case "reset": case 'textual':
					// don't remeber values in this field
					break;
				default:
					$this->arrForm[$strKey]['value'] = $this->arrSubmitedFields[$arrAttributes['name']];
					break;
			}
		}
	}

	// generate form HTML code from input array
	function make() {
    global $mosConfig_absolute_path, $mosConfig_live_site;
    $forPrint = !(!isset($_REQUEST['printing'])  || ((isset($_REQUEST['printing']) && ($_REQUEST['printing'] === 'false' )))) ;
    $forPDF = (isset($_REQUEST["pdf"]) ? ($_REQUEST["pdf"] === 'true') : false);

		$this->bolFormOK = true;
		$strHiddenFields = "";
		$strSubmitButton = "";
		$strResetButton = "";

		if ( count( $this->arrForm ) == 0 ) {
			$this->warning( "Form must contain at least one input field!", 0 );
		}
		
		if ( $this->formSubmited() ) {
			$this->rememberFormFields();
		}

		$objTpl = new Template( dirname( $this->strSkin ), "keep" );
		$objTpl->set_file( "tForm", basename( $this->strSkin ) );
		$objTpl->set_var( "TAG_METHOD", $this->strMethod );		
		$objTpl->set_var( "TAG_NAME", $this->strFormName );
		$objTpl->set_var( "TAG_ACTION", $this->strAction );

		$objTpl->set_var( "formRows", "" );
		$objTpl->set_block( "tForm", "formRow", "formRows" );
		$i=0;
		foreach( $this->arrForm as $arrAttributes ) {
		
			if ( !in_array( $arrAttributes['type'], $this->arrInputTypes ) ) {
				$this->warning( "Invalid input field type '".$arrAttributes['type']."'.", 0 );
			}

			if ( $arrAttributes['type'] == "hidden" ) {
				$strHiddenFields .= "<input".$this->attributes( $arrAttributes ).">\n";
				continue;
			} else if ( $arrAttributes['type'] == "submit" ) {
				$strSubmitButton .= "<input".$this->attributes( $arrAttributes ).">\n";
				continue;
			} else if ( $arrAttributes['type'] == "reset" ) {
				$strResetButton .= "<input".$this->attributes( $arrAttributes ).">\n";
				continue;
			}

			if($arrAttributes['type']=='pagebreak'){
					$objTpl->set_var( "PAGE_END_DIV", '</div>' );
					$objTpl->set_var( "PAGE_BEGIN_DIV", '<div class="tabbertab">' );	
					$objTpl->set_var( "TAG_FIELD_CAPTION", '');
					$objTpl->set_var( "TAG_REQUIRED_FIELD_MARK", "" );
					$objTpl->set_var( "TAG_ERROR_MESSAGE", "" );
					$objTpl->set_var( "TAG_HELP_MESSAGE", "" );
					$objTpl->set_var( "TAG_CAPTION_STYLE", "" );
					$objTpl->set_var( "TAG_FIELD_STYLE", "" );
					$objTpl->set_var( "TAG_FIELD_CONTENT", '<input type="button" name="Submit" value="Geri" onclick="javascript:document.getElementById(\'performTabs\').tabber.tabShow('.$i.');"/>&nbsp;&nbsp;<input type="button" name="Submit" value="ileri" onclick="javascript:document.getElementById(\'performTabs\').tabber.tabShow('.($i+1).');"/>');
					$objTpl->parse( "formRows", "formRow", true );
					$i++;
				continue;
			}else {
				$objTpl->set_var( "PAGE_END_DIV", '' );
				$objTpl->set_var( "PAGE_BEGIN_DIV", '' );			
			}

			switch( $arrAttributes['type'] ) {
				case "select":
					# preveri � se v imenu vnosnega polja nahaja '[]'
					if ( substr( $arrAttributes['name'], -2 ) != "[]" ) {
						$this->warning( "Invalid name '".$arrAttributes['name']."' for ".$arrAttributes['type'].". '[]' at the end of name is required!", 0 );
					}
					# zgenerira HTML kodo za polje tipa select
					$strFormCode = "<select".$this->attributes( $arrAttributes ).">\n".$this->options( $arrAttributes )."</select>";
					break;
				case "radio": case "checkbox":
					# preveri � se v imenu vnosnega polja nahaja '[]'
					if ( substr( $arrAttributes['name'], -2 ) != "[]" ) {
						$this->warning( "Invalid name '".$arrAttributes['name']."' for ".$arrAttributes['type'].". '[]' at the end of name is required!", 0 );
					}
					# zgenerira HTML kodo za polje tipa radio in checkbox
					$strFormCode = $this->options( $arrAttributes );
					break;
				case "textarea":
          if (!$forPrint) {
            if ( isset( $arrAttributes['value'] ) ) {
              $strAttVal = $arrAttributes['value'];
            } else {
              $strAttVal = "";
            }
# zgenerira HTML kodo za polje tipa textarea
            $strFormCode = "<textarea".$this->attributes( $arrAttributes ).">".$strAttVal."</textarea>";
          } else {
            $ta_width = intval($arrAttributes['cols']) * 7;
            $ta_height = intval($arrAttributes['rows']) * 15;
            $style= "border: thin gray solid; width: "
              .$ta_width."pt; height: "
              .$ta_height."pt;";
            $strFormCode = '<div style="'.$style.'">&nbsp;</div>';
          }
					break;
				case 'textual':
          if ( array_key_exists( 'value', $arrAttributes) ) {
            $strFormCode = '<div>'.$arrAttributes['value'].'</div>';
          } else {
            /*
            if ( array_key_exists( 'caption', $arrAttributes) ) {
              $strFormCode = '<div style="font-size=36pt">'.$arrAttributes['caption'].'</div>';
            }
            if ( array_key_exists( 'help', $arrAttributes ) ) {
              $strFormCode = '<div style="font-size=36pt">'.$arrAttributes['help'].'</div>';
            }
            */
            $strFormCode = "";
          }
					break;
				case 'date':
					$strFormCode = "<input readonly=\"true\" class=\"inputbox\" type=\"text\" name=\"".$arrAttributes['name']."\" id=\"".$arrAttributes['name']."\" size=25 maxlength=19  /><input name=\"reset\"  class=\"button\" type=\"reset\" onClick=\"return showCalendar('".$arrAttributes['name']."', 'y-mm-dd');\" value=\"...\"/>";
					break;
				default:
					$strFormCode = "<input ".$this->attributes( $arrAttributes ).">";
					break;
			}

			$objTpl->set_var( "TAG_FIELD_CAPTION", $arrAttributes['caption'] );
			
			# � ima polje nastavljen parameter required, se ob njegovem imenu izpie
			# poseben znak. Ponavadi je to zvezdica *.
			if ( isset( $arrAttributes['required'] ) ) {
				$objTpl->set_var( "TAG_REQUIRED_FIELD_MARK", $this->strRequiredFieldMark );
			} else {
				$objTpl->set_var( "TAG_REQUIRED_FIELD_MARK", "" );
			}

			# � je bila forma submitana, funkcija checkField preveri, � so bili vsi
			# zahtevani podatki vneeni in � so bili vneeni pravilno. Ob napaki se v
			# tag TAG_ERROR_MESSAGE nastavi ustrezno vizuelno sporo�lo o napaki.
			if ( $this->bolFrmSubmited ) {
				$objTpl->set_var( "TAG_ERROR_MESSAGE", $this->checkField( $arrAttributes ) );
			} else {
				$objTpl->set_var( "TAG_ERROR_MESSAGE", "" );
			}
			
			# ob vnosnem polju lahko e vnaprej izpiemo kratko sporo�lo za pomo�
			# � je atribut 'help' nastavljen, bo uporabnik to sporo�lo videl izpisano 
			# poleg vnosnega polja.
			if ( isset( $arrAttributes['help'] ) ) {
				$objTpl->set_var( "TAG_HELP_MESSAGE", "<div class=\"performs_help\">".$arrAttributes['help']."</div>");
			} else {
				$objTpl->set_var( "TAG_HELP_MESSAGE", "" );
			}

			# Z atributoma 'lCellAtt', lahko dodatno vplivamo na stil vnosnih polj
			if ( isset( $arrAttributes['lCellAtt'] ) ) {
				$objTpl->set_var( "TAG_CAPTION_STYLE", $arrAttributes['lCellAtt'] );
			} else {
				$objTpl->set_var( "TAG_CAPTION_STYLE", "" );
			}

			# Z atributoma 'rCellAtt', lahko dodatno vplivamo na stil vnosnih polj
			if ( isset( $arrAttributes['rCellAtt'] ) ) {
				$objTpl->set_var( "TAG_FIELD_STYLE", $arrAttributes['rCellAtt'] );
			} else {
				$objTpl->set_var( "TAG_FIELD_STYLE", "" );
			}

			$objTpl->set_var( "TAG_FIELD_CONTENT", $strFormCode );
                       
      if ($forPrint && !$forPDF) {
        $strControlButtons = '<div style="vertical-align: middle; text-align:right; height:16pt; border: thin gray solid; padding: 2pt;"><span style="height:100%; padding: 3pt; float:left; font-style: italic; font-family: helvetica; font-weight: lighter; font-size: small;"> '.$this->strFormName.'</span>';
        $strControlButtons .= '<img style="height:100%;" title="'._PRINT.'" alt="'._PRINT.'" onclick="window.print();" src="'.$mosConfig_live_site.'/administrator/images/print_f2.png" />';
        $strControlButtons .= '<img style="height:100%;" title="'.CLOSE.'" alt="'.CLOSE.'" onclick="window.close();" src="'.$mosConfig_live_site.'/administrator/images/cancel_f2.png" />';
        $strControlButtons .= '</div>';
        $objTpl->set_var( "CONTROL_BUTTONS", $strControlButtons );
      } else {
        $objTpl->set_var( "CONTROL_BUTTONS", "" );        
      }
      
			$objTpl->parse( "formRows", "formRow", true );
		
		}
		
    if (!$forPrint) {
      if($this->use_securityimages && file_exists($mosConfig_absolute_path."/components/com_securityimages") ) {
        $objTpl->set_var( "TAG_SECUREIMAGE",  insertSecurityImage("security_refid"));
        $objTpl->set_var( "TAG_SECUREIMAGE_INPUT",   getSecurityImageField("security_try"));
        $objTpl->set_var( "TAG_SECUREIMAGE_HELP", "<div class=\"performs_help\">".$this->securityImageHelp."</div>" );
        if ( $this->bolFrmSubmited ) {
          $security_refid = $_REQUEST['security_refid'];
          $security_try = $_REQUEST['security_try'];
          if(!checkSecurityImage($security_refid, $security_try)){
            $objTpl->set_var( "TAG_SECUREIMAGE_ERROR", "<div class=\"performs_error\">".$this->securityImageError."</div>" );		 
          }
          
        }	else $objTpl->set_var( "TAG_SECUREIMAGE_ERROR", "");			
        
      }
      else $objTpl->del_handle( "tForm", "secureimg" );
		}
		else $objTpl->del_handle( "tForm", "secureimg" );
		
		$objTpl->set_var( "LIVE_SITE", $mosConfig_live_site );
		
		if(empty($this->formImage))
			 $objTpl->del_handle( "tForm", "formimg" );
		else $objTpl->set_var("FORM_IMAGE",$this->formImage);
		
		$objTpl->set_var("FORM_MESSAGE",$this->intro);
		
		
	/*	$objTpl->set_block( "tForm", "deneme", "baska" );

		$objTpl->parse( "baska", "deneme", true );
*/
    //HACK: quick and dirty way of building a form with no buttons
    //for print/pdf...
    if (!$forPrint) {
      $objTpl->set_var( "TAG_HIDDEN_FIELDS", $strHiddenFields );
      $objTpl->set_var( "TAG_SUBMIT_BUTTON", $strSubmitButton );
      $objTpl->set_var( "TAG_RESET_BUTTON", $strResetButton );		
      $objTpl->set_var( "TAG_ABOUT", "" );
    } else {
      if ($forPDF) {
        $objTpl->set_var( "TAG_HIDDEN_FIELDS", '' );
        $objTpl->set_var( "TAG_SUBMIT_BUTTON", '' );
        $objTpl->set_var( "TAG_RESET_BUTTON", '' );		
        $objTpl->set_var( "TAG_ABOUT", "" );
      } else {
        $objTpl->set_var( "TAG_HIDDEN_FIELDS", $strHiddenFields );
        $objTpl->set_var( "TAG_SUBMIT_BUTTON", '' );
        $objTpl->set_var( "TAG_RESET_BUTTON", '' );		
        $objTpl->set_var( "TAG_ABOUT", "" );
      }
    }
		return $objTpl->parse( "output", "tForm" );
	}

	// generates the HTML code for form and displays it
	function show() {
		echo $this->make();
	}

	function about( $strType = 0 ) {
		$strAbout = "";
		switch ( $strType ) {
			case 0:
				if ( file_exists( "img/phpForm.gif" ) ) {
					$strAbout = '<a href="'.$this->strHomePage.'"><img border="0" src="img/phpForm.gif" width="88" height="31" alt="phpForm Home page"></a>';
				} else {
					$strAbout = '<a href="'.$this->strHomePage.'"><font face="Arial" size="-2">phpForm Home page</font></a>';
				}
				$strAbout .= '<br><font face="Arial" size="-2">Copyright &copy; <a href="mailto:'.$this->strAuthorEmail.'">'.$this->strAuthorName.'</a><br>version '.$this->strVersion."</font>";
				break;
			case 1:
				if ( file_exists( "img/phpForm.gif" ) ) {
					$strAbout = '<a href="'.$this->strHomePage.'"><img border="0" src="img/phpForm.gif" width="88" height="31" alt="phpForm Home page"></a>';
				} else {
					$strAbout = '<a href="'.$this->strHomePage.'"><font face="Arial" size="-2">phpForm Home page</font></a>';
				}
				break;
			case 2:
				$strAbout = '<br><font face="Arial" size="-2">Copyright &copy; <a href="mailto:'.$this->strAuthorEmail.'">'.$this->strAuthorName.'</a><br>version '.$this->strVersion."</font>";
				break;
		}
		return $strAbout;
	}
}
?>