<?php 
/**
* @version $id: install.performs.php,v 2.0 beta 2005/12/11 22:34:40 asasd Exp $
* @package performs
* @copyright (C) 2005 Ilhami KILIC
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Ilhami KILIC http://www.tuwitek.at
* Joomla is Free Software
*/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

function com_install() {
	global $database, $mosConfig_debug;
	
	$version = '2.1.2';
	
	//Need to detect/drop com_performs and com_performs_items if exist.Only if com_performs1 and com_performs1_items exist, though.
	// detect legacy perForms installation
	$legacyTableVersion = sqlUtils::detectLegacyTables();
	switch( $legacyTableVersion ) {
		case 2:
		sqlUtils::handleSqlFile( 'renPerforms2.sql' );
		break;
		case 1:
		sqlUtils::handleSqlFile( 'renPerforms1.sql' );
		break;
		case 0:
		break;
	}
	// At this point, we want to search for columns that exist only in the most recent, and work our way back through the revisions.
	//	Should only need to do this once or twice, as there aren't many major revisions to the db.
	
	// This line reads If the caption column exists in the jos_performs table, and is of type varchar, $legacyInstalledVersion = 2
	// 	Else, if the securityErrorText column exists in the jos_performs table, $legacyInstalledVersion = 1, otherwise, it's 0, and it's a fresh install.

  $jt = $database->getPrefix() . "performs";
  $ji = $database->getPrefix() . "performs_items";
  
	$legacyInstalledVersion = 
	( sqlUtils::columnExists( $jt, 'securityErrorText' ) ? 
    ( sqlUtils::columnOfTypeExists($ji, 'caption', 'text') ? 0 : 1) :
	( sqlUtils::columnOfTypeExists( $ji, 'caption', 'varchar' ) ? 2 : 0 ) ) ;

  if ($mosConfig_debug) echo '<div>legacyInstalledVersion: '.$legacyInstalledVersion.'</div>';

	if( $legacyInstalledVersion > 0 ) {
	$sqlFile = "";
		switch( $legacyInstalledVersion ) {
			case 2:
			if( $mosConfig_debug ) echo "<div>Legacy version detected. Performing Full Update</div>";
			$sqlFile = 'updateFull_2.1.1.sql';
			break;
			case 1:
			if( $mosConfig_debug ) echo "<div>Legacy version detected. Performing Partial Update</div>";
			$sqlFile = 'updatePartial_2.1.0-2.1.1.sql' ;
			break;
			default:
			if( $mosConfig_debug ) echo "<div>something is broken. It broke when checking for a legacy installation. value of: " . $legacyInstalledVersion . "</div>";
		}
		sqlUtils::handleSqlFile( $sqlFile );
	}
	else {
		sqlUtils::handleSqlFile( 'performs.sql' );
	}
	
	// This method call will update the theme column to the perForms standard from legacy values
	sqlUtils::updateDefaultValues();


  
	// Next, we need to make sure we modify the forum tables to include the extra column we specified
	$sql = "SELECT tablename FROM #__performs WHERE tablename IS NOT NULL";
	$database->setQuery( $sql );
	$tables = $database->loadResultArray();
if ($mosConfig_debug) {
  echo '<div>Traversing User Tables</div>';
}
	$ti = -1;
	foreach( $tables as $table ) {
  if ($table) {
  if ($mosConfig_debug)  echo $table.' ( '.(++$ti).')<br>';
    if (!sqlUtils::columnExists($table, 'UserIp')) {
      $database->setQuery( "ALTER TABLE `" . $table . "` ADD `UserIp` VARCHAR(20) DEFAULT \"\" NOT NULL" );
      if(!$database->query())
				die($database->getErrorMsg());
    }
   } else {
   //TODO: find out why $database->loadResultArray() appends a blank ...
   // 	Modified SQL query to check for is not null values. Pretty sure that's where the problem was coming from.
if ($mosConfig_debug) echo "<div>null table found! ".(++$ti)."</div>";
   }
	}
	

?>
    <hr>
    
    <table class="contentpaneopen" id="table1">
        <tr>
            <td vAlign="top" colSpan="2">
              <p><img hspace="6" src="<? echo $mosConfig_live_site; ?>/administrator/images/install.png" align="left" border="0"><b>Merci d'Avoir choisi perForms 2.1.2 beta.</b><br />
                <i>C'est une version beta</i>
                <br />

            Avec ce composant vous pouvez cr&eacute;er de multiples formulaires, compl&eacute;tement personnalis&eacute;s et les donn&eacute;es peuvent &ecirc;tre conserv&eacute;s en base de donn&eacute;es.<br>
            <br>
            <b>Features:</b><br />
            - Nom de champs illimit&eacute;s<br />
            - Choix entre  8 types de forme de champs <br />
            - Fonction d'envoi du formulaire par mail<br />
            - Option de cr&eacute;ation d'une base de donn&eacute;e s&eacute;par&eacute; pour chaque formulaire<br />
            - Validation de champs<br />
            - Personnalisation de messages d'erreurs<br />
            - Personnalisation de messages d'aide pour chaque champ<br />
            - Page de r&eacute;sultat visible poru les donn&eacute;es enregistr&eacute;es<br />
            - Syst&egrave;me de Template Simple <br /> 
            - Afficher / Exporter les donn&eacute;es par l'administrateur<br />
                - Afficher une version imprimable cot&eacute; visiteurs (front end)<br />
              - T&eacute;l&eacute;chargement au format Pdf </p>
              <hr>
            <p><b>perForms</b> est publi&eacute; sous licence <b>GPL</b> . Support disponible sur le site officiel: <a href="http://performs.jext.info" target="_blank">http://performs.jext.info</a>
          </td>
        </tr>
    </table>
<?php
}



class sqlUtils{
	/* utility functions */

	/**
	* @abstract Determine what legacy version, if any, is installed
	* @return int value of legacy found, 0 if fresh install
	**/
	function detectLegacyTables() {
		$legacyVersion = 0;

		sqlUtils::tableExists( 'performs1_items' ) ? $legacyVersion = 1 :
		( sqlUtils::tableExists( 'performs2_items' ) ? $legacyVersion = 2 : $legacyVersion = 0 );

		return $legacyVersion;
	}
	/**
	* @param string Table Name
	* @return bool true if exists
	**/
	function tableExists( $table ){
		global $database, $mosConfig_debug;
		$tableFound = false;

if ($mosConfig_debug) {
  echo '<div style="padding:12pt;background-color:wheat;"><div>Table: '.$table.'</div>';
}
		
		// Because the sql is not being fixed by joomla, we fix it ourselves. 
        //  <---- only we don't do it here
        //      because we don't prefix our user
        //      tables yet so it breaks the installer
		//	getPrefix() will return the value of what the prefix is, thus making our query correct without hardcoding the prefix
    // <---- unless we don't want to use the prefix
		//$table = $database->getPrefix() . $table;
		
		$list = $database->getTableList();

		foreach( $list as $t ) {
			if( strpos( $t, $table ) !== false )
			$tableFound = true;
		}

if ($mosConfig_debug) echo ($tableFound ? 'Exists.' : 'Does Not Exist.').'</div>';

		return $tableFound;
	}

	/**
	* @param String table name
	* @param String Column name
	* @return bool true if column exists
	**/
	function columnExists( $table, $column ) {
		global $database, $mosConfig_debug;
		$columnFound = false;
    if ($mosConfig_debug) {
      echo '<div style="background-color:lavenderblush;padding:12pt;"><div>Searching for column: <span>'.$column.' from table '.$table.'</span></div>';
    }
		// Check for the existance of the table first

//      $table = $database->getPrefix() . $table;

		if( sqlUtils::tableExists( $table ) ) {

			$tableArray[] = $table;
			// Get an array of the fields in the table specified
			$tableFields = $database->getTableFields( $tableArray );
      $columnNames = $tableFields[$table];
      
      if ($mosConfig_debug) echo "<div>Table Name: ".$table.'</div>';
      
			foreach ( $columnNames as $hname=>$type ) {
        if ($column == $hname) {
          if ($mosConfig_debug) {
            echo '<div>Field: '.$hname.'</div>';
          }
          $columnFound = true;
          break;
        }
			}
		}
      if ($mosConfig_debug) {
        echo '<div>columnExists: '.$table.' - '.$column.' = '.(($columnFound)?'true':'false').'</div></div>';
      }
			return $columnFound;
	}
	/**
	* @param String table name
	* @param String column name
	* @param String DataType
	* @return bool true if column is of type specified
	**/
	function columnOfTypeExists( $table, $column, $dataType ) {
		global $database, $mosConfig_debug;
		$columnFound = false;

    if ($mosConfig_debug) {
      echo '<div style="padding:12pt;background-color:aliceblue;"><div>Searching for column: <span>"'.$column.'" of type "'.$dataType.'" in table '.$table.'</span></div>';
    }

		// Check for the existance of the table first
		if( sqlUtils::tableExists( $table ) ) {

			$tableArray[] = $table;
			// Get an array of the fields in the table specified
			$tableFields = $database->getTableFields( $tableArray );

      //$tableschema = $tableFields[$table];

			foreach ( $tableFields as $c ) {
				if( array_key_exists( $column, $c ) === true )
				{
        
        if ($mosConfig_debug) echo '<div>column: '.$column.' type:'.$c[$column].'</div>';
					if(  $c[$column] == $dataType ) {
						$columnFound = true;
					}
				}
			}
		}
      if ($mosConfig_debug) {
        echo '<div>columnOfTypeExists: '.$table.' - '.$column.' - '.$dataType.' = '.(($columnFound)?'true':'false').'</div></div>';
      }
		return $columnFound;
	}


	/**
    * @param string File name
    * @return bool true if success
    **/
	function handleSqlFile( $sqlfile ){
		$result = sqlUtils::runSqlFile( $sqlfile );
		$sqlReturn = false;

		if( count( $result ) == 0 ){
			echo("Database tables configured succesfully.");
			$sqlReturn = true;
		}
		else{
			echo "<pre style='text-align:left;'>";
			foreach( $result as $e )
			print_r( $e );
			echo "</pre>";
		}
		return $sqlReturn;
	}

	/**
        ripped from joomla core: /installation/install2.php:populate_db()
    * @param string File name
    * @return array containing errors
    **/
	function runSqlFile( $sqlfile ) {
		global $database, $mosConfig_absolute_path;
		$sqlDir = $mosConfig_absolute_path . '/administrator/components/com_performs/sql/';
		$errors = array();

		$query = fread( fopen( $sqlDir . $sqlfile, 'r' ), filesize( $sqlDir . $sqlfile ) );
		$pieces  = sqlUtils::split_sql($query);

		for ($i=0; $i<count($pieces); $i++) {
			$pieces[$i] = trim($pieces[$i]);
			if(!empty($pieces[$i]) && $pieces[$i] != "#") {
				$database->setQuery( $pieces[$i] );
				if (!$database->query()) {
					$errors[] = array ( $database->getErrorMsg(), $pieces[$i] );
				}
			}
		}
		return $errors;
	}

	/**
        ripped from joomla core: /installation/install2.php
    * @param string
    */
	function split_sql($sql) {
		$sql = trim($sql);
		$sql = ereg_replace("\n#[^\n]*\n", "\n", $sql);

		$buffer = array();
		$ret = array();
		$in_string = false;

		for($i=0; $i<strlen($sql)-1; $i++) {
			if($sql[$i] == ";" && !$in_string) {
				$ret[] = substr($sql, 0, $i);
				$sql = substr($sql, $i + 1);
				$i = 0;
			}

			if($in_string && ($sql[$i] == $in_string) && $buffer[1] != "\\") {
				$in_string = false;
			}
			elseif(!$in_string && ($sql[$i] == '"' || $sql[$i] == "'") && (!isset($buffer[0]) || $buffer[0] != "\\")) {
				$in_string = $sql[$i];
			}
			if(isset($buffer[1])) {
				$buffer[0] = $buffer[1];
			}
			$buffer[1] = $sql[$i];
		}

		if(!empty($sql)) {
			$ret[] = $sql;
		}
		return($ret);
	}


	function updateDefaultValues() {
	global $database, $mosConfig_debug;
		$sql = "SELECT id, theme FROM #__performs WHERE theme LIKE 'default'";
		$database->setQuery( $sql );
				// This isn't going to work, but this is kinda what I need... Need to check for the existence of default, then plug the default rows into the update schema... unless I just do a blanket statement if any are returned with default, update them all.. which would work...
		if( !$database->query() ) {
			die( $database->getErrorMsg() );
		}
		else {
			if( $mosConfig_debug ) echo "<div>Updating the default values of the theme column</div>";
			
			$update = "UPDATE #__performs SET theme = 'performs.jpg' WHERE theme = 'default'";
			$database->setQuery( $update );
			if( !$database->query() ) {
				die( $database->getErrorMsg() );
			}
		}
	}
}

?>