<?php
/**
* @version $id: admin.performs.php,v 1.0 2005/12/11 22:34:40 asasd Exp $
* @package performs
* @copyright (C) 2005 Ilhami KILIC
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @author Ilhami KILIC http://www.tuwitek.at
* Joomla is Free Software
*/


/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )
		| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_newsfeeds' ))) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

global $mosConfig_absolute_path,$mosConfig_lang;

if (file_exists($mosConfig_absolute_path.'/components/com_performs/language/'.$mosConfig_lang.'.php')) {
  include($mosConfig_absolute_path.'/components/com_performs/language/'.$mosConfig_lang.'.php');

} else {
  include($mosConfig_absolute_path.'/components/com_performs/language/english.php');
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once($mosConfig_absolute_path."/administrator/components/com_performs/class.performs.php");

$id 	= mosGetParam( $_GET, 'id', 0 );
$formID = mosGetParam( $_REQUEST, 'formId', 0 );
$cid 	= mosGetParam( $_POST, 'cid', array(0) );

if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task) {

	case 'preview':
		include("performswindow.php");
		break;
// FORM ITEMS
	case 'itemsA':
		showFormItems( $formID,  $option );
		break;

	case 'items':
		showFormItems( $cid[0],  $option );
		break;
	
	case 'orderup':
		orderFormItem( $cid[0], 1, $option );
		break;

	case 'orderdown':
		orderFormItem( $cid[0], -1, $option );
		break;
		
	case 'closeItems':
		mosRedirect('index2.php?option=com_performs');
		break;	
		
	case 'cancelItem':
		cancelItem();
		break;

	case 'newItem':
		editFormItem($formID,'0', $option);
		break;

	case 'editItem':
		editFormItem($formID, $cid[0], $option);
		break;
		
	case 'editItemA':
		editFormItem($formID, $id, $option);
		break;
		
	case 'saveItem':
		saveFormItem( $option );
		break;		

	case 'deleteItem':
		removeFormItem( $formID,$cid, $option );
		break;
		
	case 'saveorder':
		 saveOrder( $cid );
		 break;
			
// FORMS
	case 'new':
		editForm( '0', $option);
		break;
		
	case 'copy':
		copyForm($cid[0], $option );
		break;

	case 'edit':
		editForm( $cid[0], $option );
		break;

	case 'editA':
		editForm( $id, $option );
		break;

	case 'save':
		saveForm( $option );
		break;

	case 'remove':
		removeForms( $cid, $option );
		break;

	case 'publish':
		changeForm( $cid, 1, $option );
		break;

	case 'unpublish':
		changeForm( $cid, 0, $option );
		break;
				
  	case 'cancel':
    	cancelForm();
		break;
		
	case 'dbtable':
		editDBTable( $cid[0], $option );
		break;
		
	case 'assigntable':
		editDBTable( $formID, $option );
		break;
		
	case 'saveDBTable':
		saveDBTable( $option );
		break;

  case 'showData':
    showBoundTable( $cid[0], $option );
    break;

  case 'FullExport':
    exportToExcel( $cid[0], $option, $formID );
    break;
    
	default:
		showForms( $option );
		break;
}

/**
* List the records
* @param string The current GET/POST option
*/
function showForms( $option ) {
	global $database, $mainframe, $mosConfig_list_limit;

	$limit 		= $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	
	// get the total number of records
	$database->setQuery( "SELECT COUNT(*) FROM #__performs" );
	$total = $database->loadResult();

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( $total, $limitstart, $limit  );
	
	// get the subset (based on limits) of required records
//	$query = "SELECT * "
//	. "\n FROM #__performs ORDER BY id DESC LIMIT $pageNav->limitstart, $pageNav->limit"	;
	
	$query = "SELECT m.*, u.name AS editor , u.name AS user,"
	. "\n COUNT(d.itemId) AS fieldCount"
	. "\n FROM #__performs AS m"
	. "\n LEFT JOIN #__users AS u ON u.id = m.checked_out"
	. "\n LEFT JOIN #__performs_items AS d ON d.formId = m.id "
	. "\n GROUP BY m.id"
	. "\n LIMIT $pageNav->limitstart,$pageNav->limit"
	;
	
	
	$database->setQuery( $query );
	$rows = $database->loadObjectList();
	
	for ($i=0, $n=count($rows); $i < $n; $i++) {
//		$database->setQuery( "SELECT COUNT(*) FROM #__performs_items WHERE formId = ".$rows[$i]->id );
//		$c = $database->loadResult();
		$r = "-";
		if(!empty($rows[$i]->tablename)){
			$database->setQuery( "SELECT COUNT(*) FROM ".$rows[$i]->tablename);
			$r = $database->loadResult();
		}		
	//	$rows[$i]->fieldCount = $c;
		$rows[$i]->recordsCount = $r;
	}

	HTML_perform::showForms( $rows, $pageNav, $option);
}

/**
* List the records
* @param int The current Form
* @param string The current GET/POST option
*/
function showFormItems( $formId,$option ) {
	global $database, $mainframe, $mosConfig_list_limit;
	
	$row = new mosForm( $database );
	// load the row from the db table
	$row->load($formId);

	if (!empty($row->tablename)) {
		echo "<script> alert('".ITEMS_CANT_EDITED."'); window.history.go(-1); </script>\n";
		exit();
	}
	
	
	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );

	// get the subset (based on limits) of required records
	$query = "SELECT * "
	. "\n FROM #__performs_items WHERE formId='$formId' ORDER BY ordering DESC"	;
	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	$pageNav = new mosPageNav( count($rows), 0, 999  );	
	
	HTML_perform::showFormItems( $rows, $pageNav, $option, $formId);
}

/**
* Moves the order of a record
* @param integer The increment to reorder by
*/
function orderFormItem( $uid, $inc, $option ) {
	global $database;

	$row = new mosFormItems( $database );
	$row->load( $uid );
	$row->move( $inc );

	mosRedirect( "index2.php?option=$option&task=itemsA&formId=".$row->formId );
}

/**
* Creates a new or edits and existing user record
* @param int The id of the record, 0 if a new entry
* @param string The current GET/POST option
*/
function editForm( $id, $option ) {
	global $database, $my;
	global $mosConfig_absolute_path;

	$row = new mosForm( $database );
	// load the row from the db table
	$row->load( $id );

	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect( 'index2.php?option='. $option, sprintf(FORM_CURRENTLY_EDITED, $row->title ) );
	}

	if ($id) {
		// do stuff for existing records	
		$row->checkout($my->id);		
	} else {
		// do stuff for new records)
		$row->r_url="http://";
		$row->published = 1;
		$row->mailIt=0;
		$row->mailAlways=0;
		$row->useintro=0;
		$row->includeReset=0;
		$row->submitLabel=SUBMIT_LABEL;
	}
	$lists = array();

//	$themes = array();
//	$temp = array();
//	$temp = getThemes($mosConfig_absolute_path."/components/com_performs/skins");
//	foreach($temp as $theme)
//		$themes[] = mosHTML::makeOption( $theme );
	
//	$themeScript = "onchange=\"javascript:if (document.forms[0].theme.options[selectedIndex].value!='') {document.themelib.src='../components/com_performs/skins/' + document.forms[0].theme.options[selectedIndex].value+'/theme.jpg'} else {document.themelib.src='../images/blank.png'}\"";

	// build the html select list for images
	$lists['image'] 			= mosAdminMenus::Images( 'image', $row->image );
	$lists['published'] 		= mosHTML::yesnoradioList( 'published', '', $row->published );
	$lists['mailIt'] 			= mosHTML::yesnoradioList( 'mailIt', '', $row->mailIt );
	$lists['mailAlways']		= mosHTML::yesnoradioList( 'mailAlways', '', $row->mailAlways );
	$lists['useintro'] 			= mosHTML::yesnoradioList( 'useintro', '', $row->useintro );
	$lists['includeReset'] 		= mosHTML::yesnoradioList( 'includeReset', '', $row->includeReset );
	$lists['use_securityimages'] 		= mosHTML::yesnoradioList( 'use_securityimages', '', $row->use_securityimages );
	// build the html select list for the group access
	$lists['access'] 			= mosAdminMenus::Access( $row );
									// Images( $name, &$active, $javascript=NULL, $directory=NULL ) 
									
	$javascript = "onchange=\"javascript:if (document.forms[0].theme.options[selectedIndex].value!='') {document.themelib.src='../components/com_performs/skins/' + document.forms[0].theme.options[selectedIndex].value} else {document.themelib.src='../images/M_images/blank.png'}\"";
									
	$lists['themes'] 			= mosAdminMenus::Images( 'theme', $row->theme , $javascript , "/components/com_performs/skins");

	HTML_perform::editform( $row, $lists, $option, $params );
}

function getThemes($path) {
   $fileNames = array();

   if (is_dir($path)) {
       if ($dh = opendir($path)) {
           while (($file = readdir($dh)) !== false) {
               if ($file == "." || $file == "..") continue;
               $fullpath = $path . "/" . $file;
               $fkey = strtolower($file);
               if(is_dir($fullpath)){
                  $fileNames[] = $file;
               }
           }
           closedir($dh);
       } else die ("Cannot open directory:  $path");
   } else die ("Path is not a directory:  $path");
 	asort($fileNames);
   
   return $fileNames;
}

/**
* Shows a report of the contents of table bound to a form
* @param int The id of the record, 0 if a new entry
*/
function showBoundTable( $id, $option ) {
	global $database;

	if($id==0){
		echo "<script> alert('".NO_FORM_FOUND.'('.$id.')'."'); window.history.go(-1); </script>\n";
		exit();	
	}
	
	$formRow = new mosForm( $database );
	$formRow->load( $id );

  HTML_perform::showBoundTable( $formRow, $option );
}

/**
* Exports the contents of a bound table to excel format (text/tab)
* @param int The id of the record, 0 if a new entry
*/
function exportToExcel( $id, $option, $formid ) {
	global $database;

	if($formid==0){
		echo "<script> alert('".NO_FORM_FOUND.'('.$formid.')'."'); window.history.go(-1); </script>\n";
		exit();	
	}
	
	$formRow = new mosForm( $database );
	$formRow->load( $formid );
  HTML_perform::exportToExcel( $formRow, $option, $formid );
}

/**
* Creates a new or edits and existing user record
* @param int The id of the record, 0 if a new entry
* @param string The current GET/POST option
*/
function editDBTable( $id, $option ) {
	global $database, $my;
	global $mosConfig_absolute_path;

	$row = new mosForm( $database );
	// load the row from the db table
	$row->load( $id );

	if (empty($row->title)) {
		echo "<script> alert('".NO_FORM_FOUND.'('.$id.')'."'); window.history.go(-1); </script>\n";
		exit();
	}
	HTML_perform::editDBTable( $row, $option);
}


/**
* Creates a new or edits and existing user record
* @param int The id of the record, 0 if a new entry
* @param string The current GET/POST option
*/
function editFormItem( $formId,$id, $option ) {
	global $database, $my;
	global $mosConfig_absolute_path;

	$row = new mosFormItems( $database );
	// load the row from the db table
	$row->load( $id );
	$values = array();
	if ($id) {
		// do stuff for existing records
		$row->checkout($my->id);
		if($row->type=='select' || $row->type=='checkbox' || $row->type=='radio')	{	
			$tailes = array();
			$tailes = explode( chr(167), $row->value);
			foreach($tailes as $tail){
				if(!empty($tail))
					$values[] = mosHTML::makeOption( $tail );	
			}
			$row->value = "";
		}	
				
	} else {
		// do stuff for new records
		$row->required = "0";
		$row->disabled = "0";
		$row->readonly = "0";
		$row->multiple = "0";
		$row->usecaption = "1";
		$row->formId = $formId;
		$row->type = "text";
	}
	
	$arrInputTypes = array( /* 'button' ,*/  'checkbox', /* 'file', */ 'hidden', /* 'image', */ 'select', 'password', 'radio', 'date', 'text', 'textarea', 'textual'/*,'pagebreak'  (not yet)*/);
	asort($arrInputTypes);
	$types = array();
	foreach($arrInputTypes as $type)
		$types[] = mosHTML::makeOption( $type,ucfirst($type) );
		
	$arrValuesTypes = array( 'string', 'name', 'float', 'integer', 'email' /*, 'url' */);
	asort($arrValuesTypes);
	$checks = array();
	$checks[] = mosHTML::makeOption( "" );
	foreach($arrValuesTypes as $check)
		$checks[] = mosHTML::makeOption( $check,ucfirst($check) );

	$arrSepTypes = array( 'newline', 'comma', 'comma+space', 'space', 'hyphen');
	$separators = array();
	foreach($arrSepTypes as $separator)
		$separators[] = mosHTML::makeOption( $separator,ucfirst($separator) );

	$lists = array();
	$lists['required'] 		= mosHTML::yesnoradioList( 'required',   '', $row->required   );
	$lists['disabled'] 		= mosHTML::yesnoradioList( 'disabled',   '', $row->disabled   );
	$lists['readonly'] 		= mosHTML::yesnoradioList( 'readonly',   '', $row->readonly   );
	$lists['multiple'] 		= mosHTML::yesnoradioList( 'multiple',   '', $row->multiple   );
	$lists['usecaption']	= mosHTML::yesnoradioList( 'usecaption', '', $row->usecaption );
	
	$lists['types'] 		= mosHTML::selectList( $types, 'type', 'size="1" class="inputbox"  onChange="setSize();"', 'value', 'text', $row->type);
	$lists['checks'] 		= mosHTML::selectList( $checks, 'check', 'size="1" class="inputbox"', 'value', 'text', $row->check);
	$lists['values'] 		= mosHTML::selectList( $values , 'values[]', 'size="10" class="inputbox"  multiple="true" id="values"', 'value', 'text', $row->checkOrSelect);
	$lists['separators']	= mosHTML::selectList( $separators, 'separator', 'size="1" class="inputbox"', 'value', 'text', $row->separator);




	HTML_perform::editformitem( $row, $lists, $option );
}


/**
* Saves the record from an edit form submit
* @param string The current GET/POST option
*/
function saveForm( $option ) {
	global $database;

	$row = new mosForm( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// save params
//	$params = mosGetParam( $_POST, 'params', '' );
//	if (is_array( $params )) {
//		$txt = array();
//		foreach ( $params as $k=>$v) {
//			$txt[] = "$k=$v";
//		}
//		$row->params = implode( "\n", $txt );
//	}
	if(empty($row->theme)){
		$row->theme="performs.jpg";
	}


	if(substr($row->r_url, 0, 7)!="http://")
		$row->r_url.="http://";


	// pre-save checks
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// save the changes
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	
	$row->checkin();
	$row->updateOrder();

	mosRedirect( "index2.php?option=$option" );
}


/**
* Saves the record from an edit form submit
* @param string The current GET/POST option
*/
function saveFormItem( $option ) {
	global $database;

	$row = new mosFormItems( $database );
	
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if($row->type=='select' || $row->type=='checkbox' || $row->type=='radio')	{
		$values =  $_POST['values'];
	//	asort($values);
	//	reset($values);
		$row->value = implode( chr(167), $values );
	}

//	$totalChar = 12; // number of chars in the field name
//	$salt = "abcdefghijklmnpqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";  // salt to select chars from
//	srand((double)microtime()*1000000); // start the random generator
//	$fieldname="i"; // set the inital variable
//	for ($i=0;$i<$totalChar;$i++)  
//		$fieldname = $fieldname . substr ($salt, rand() % strlen($salt), 1);
//
//	$row->name=$fieldname.$row->formId;
	
	// pre-save checks
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}

	// save the changes
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	
	$row->checkin();
	$row->updateOrder( "formId='$row->formId'" );
	
	mosRedirect( "index2.php?option=$option&task=itemsA&formId=".$row->formId );
}


function copyForm( $id, $option ) {
	global $database;

	if ($id ) {
		$database->setQuery( "INSERT INTO #__performs(`intro`, `note`, `title`, `published`, `start_date`, `finish_date`, `image`, `tablename`, `theme`, `emails`, `mailIt`, `mailAlways`, `submitLabel`, `includeReset`, `resetLabel`, `mailSubject`, `access`, `checked_out`, `checked_out_time`, `r_url`, `asub`,`strMissingFieldMsg`,`use_securityimages`,`securityHelpText`,`securityErrorText`) SELECT `intro`, `note`, `title`, 0, `start_date`, `finish_date`, `image`, NULL, `theme`, `emails`, `mailIt`, `mailAlways`, `submitLabel`, `includeReset`, `resetLabel`, `mailSubject`, `access`, `checked_out`, `checked_out_time`, `r_url`, `asub`,`strMissingFieldMsg`,`use_securityimages`, `securityHelpText`,`securityErrorText` FROM #__performs WHERE id='$id'" );

		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}
	$mysql_last_insert_id = $database->insertid();
	$query = "SELECT * FROM #__performs_items WHERE formId ='$id'";
	$database->setQuery( $query );
	$rows = $database->loadObjectList();

	for ($i=0, $n=count($rows); $i < $n; $i++) {
		$insert = "INSERT INTO `#__performs_items` ( `formId` , `type` , `name` , `value` , `caption` , `required` , `var1` , `var2` , `check` , `help` , `errMsg` , `disabled` , `readonly` , `multiple` , `checkOrSelect` , `ordering` )  SELECT $mysql_last_insert_id , `type` , `name` , `value` , `caption` , `required` , `var1` , `var2` , `check` , `help` , `errMsg` , `disabled` , `readonly` , `multiple` , `checkOrSelect` , `ordering`  FROM `#__performs_items`  WHERE `itemId` ='".$rows[$i]->itemId."'";
		$database->setQuery($insert);
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}
	}

	
	}

	mosRedirect( "index2.php?option=$option" );
}


/**
* Removes records
* @param array An array of id keys to remove
* @param string The current GET/POST option
*/
function removeForms( &$cid, $option ) {
	global $database;

	if (count( $cid )) {
		foreach($cid as $id){
			$formRow = new mosForm( $database );
			$formRow->load( $id );
			if(!empty($formRow->tablename)){
				$drop = 'DROP TABLE IF EXISTS `'.$formRow->tablename .'`';
				$database->setQuery( $drop );
				if (!$database->query()) {
					echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
					exit();
				}
			}
		}
	
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__performs WHERE id IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

	mosRedirect( "index2.php?option=$option" );
}


/**
* Removes records
* @param array An array of id keys to remove
* @param string The current GET/POST option
*/
function removeFormItem( $formId, &$cid, $option ) {
	global $database;

	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$database->setQuery( "DELETE FROM #__performs_items WHERE itemId IN ($cids)" );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}

		mosRedirect( "index2.php?option=$option&task=itemsA&formId=".$formId );
}

/**
* Changes the state of one or more content pages
* @param array An array of unique category id numbers
* @param integer 0 if unpublishing, 1 if publishing
* @param string The current option
*/
function changeForm( $cid=null, $state=0, $option ) {
	global $database, $my;

	if (count( $cid ) < 1) {
		$action = $state == 1 ? PUBLISH : UNPUBLISH;
		echo "<script> alert('".sprintf(SELECT_A_RECORD_TO,$action)."'); window.history.go(-1);</script>\n";
		exit;
	}

	$cids = implode( ',', $cid );

	$database->setQuery( "UPDATE #__performs SET published='$state'"
	. "\nWHERE id IN ($cids)"
	);
	if (!$database->query()) {
		echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		exit();
	}

	if (count( $cid ) == 1) {
		$row = new mosForm( $database );
		$row->checkin( intval( $cid[0] ) );
	}

	mosRedirect( "index2.php?option=$option" );
}

function saveDBTable( $option ) {
	global $database;
	$id =  mosGetParam( $_POST, 'id', 0 );
	$delete = mosGetParam( $_POST, 'delete', 0 );
	$tablename = mosGetParam( $_POST, 'tablename', 0 );
	
	if($id==0){
		echo "<script> alert('".NO_FORM_FOUND."'); window.history.go(-1); </script>\n";
		exit();	
	}
	
	$formRow = new mosForm( $database );
	$formRow->load( $id );

	if(empty($delete)){
	
		$tables = $database->getTableList();
		
		foreach($tables as $table){
			if($table==$tablename){
				echo "<script> alert('".sprintf(ALREADY_TABLE_EXISTS,$tablename)."'); window.history.go(-1); </script>\n";
				exit();			
			}
		}
		
		$query = "SELECT * "
		. "\n FROM #__performs_items WHERE formId='$id' ORDER BY ordering"	;
		$database->setQuery( $query );
		$rows = $database->loadObjectList();
		
		$insert = 'CREATE TABLE `'.$tablename.'` ( `id` int(11) NOT NULL auto_increment, ';
		for ($i=0, $n=count($rows); $i < $n; $i++) {
			$row = $rows[$i];
			if($row->type=="text" || $row->type=="hidden" || $row->type=="password" || $row->type=="date"){
				$insert .= '`'.$row->name.'` ';
				$insert .= ' varchar';
				if(!empty($row->var1) && intval($row->var1)>0)
					$insert .= '('.$row->var1.') ';
				else $insert .= '(100) ';
				if($row->required)
					$insert .= 'NOT NULL ';
				if(!empty($row->value))
					$insert .= "default '".$row->value."'";
				$insert .= ",";
			}
			else if($row->type=="textarea"){
				$insert .= '`'.$row->name.'` ';
				$insert .= ' text ';
				if($row->required)
					$insert .= 'NOT NULL ';
				$insert .= ",";			
			}
			else if($row->type=="checkbox" || $row->type=="select" || $row->type=="radio"){
				$insert .= '`'.$row->name.'` ';
				$insert .= ' varchar(255) ';
				if($row->required)
					$insert .= 'NOT NULL ';
				$insert .= ",";
			}
			
		}		
		$insert .= '`date_time` timestamp NOT NULL, `UserIp` varchar(20) NOT NULL,'
		  .'PRIMARY KEY  (`id`))';
		
		$database->setQuery( $insert );
		
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			exit();
		}
		$formRow->tablename = $tablename;
	}else {
		if(!empty($formRow->tablename)){
			$drop = 'DROP TABLE IF EXISTS `'.$formRow->tablename .'`';
			$database->setQuery( $drop );
			if (!$database->query()) {
				echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
				exit();
			}		
		}
		$formRow->tablename = "";
	}
	
	if (!$formRow->store()) {
		echo "<script> alert('".$formRow->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	
	mosRedirect( "index2.php?option=$option");
}

/** PT
* Cancels editing and checks in the record
*/
function cancelForm() {
	global $database;
	
	$row = new mosForm( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect('index2.php?option=com_performs');
}

function cancelItem() {
	global $database;
	
	$row = new mosFormItems( $database );
	$row->bind( $_POST );
	$row->checkin();
	mosRedirect('index2.php?option=com_performs&task=itemsA&formId='.$row->formId);
}
function saveOrder( &$cid ) {
	 global $database;

	 $total          = count( $cid );
	 $order          = josGetArrayInts( 'order' );

	 $row            = new mosFormItems( $database );

	 $conditions = array();

	 // update ordering values
	 for ( $i=0; $i < $total; $i++ ) {
			 $row->load( (int) $cid[$i] );
			 if ($row->ordering != $order[$i]) {
					 $row->ordering = $order[$i];
					 if (!$row->store()) {
							 echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
							 exit();
					 } // if
					 // remember to updateOrder this group
					 $condition = "formId=" . (int) $row->formId;
					 $found = false;
					 foreach ( $conditions as $cond )
							 if ($cond[1]==$condition) {
									 $found = true;
									 break;
							 } // if
					 if (!$found) $conditions[] = array($row->id, $condition);
			 } // if
	 } // for

	 // execute updateOrder for each group
	 foreach ( $conditions as $cond ) {
			 $row->load( $cond[0] );
			 $row->updateOrder( $cond[1] );
	 } // foreach

	 // clean any existing cache files
	 mosCache::cleanCache( 'com_perForms' );

	 $msg    = 'New ordering saved';
	 mosRedirect( 'index2.php?option=com_performs&task=itemsA&formId=' . $row->formId, $msg );
}
?>