<?php 
// $Id: admin.mosforms.php,v 1.16 2004/09/13 22:02:43 rob_clayburn Exp $
/**
 * Sections admin event handler
 * All rights reserved
 * Mambo Open Source is Free Software
 * Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package Mambo Open Source
 * @Copyright (C) 2000 - 2003 Miro International Pty Ltd
 * @version $Revision: 1.16 $
 */
// ensure this file is being included by a parent file
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

require_once($mainframe->getPath('admin_html'));

//echo "act = $act, task = $task <br />";
// get parameters from the URL or submitted form
$scope = mosGetParam($_REQUEST, 'scope', '');

$cid = mosGetParam($_REQUEST, 'cid', array(0));

if (!is_array($cid)) {
	$cid = array(0);
} 

switch ($act) {
	case "forms":

		require_once("../components/" . $option . "/mosforms.class.php");

		switch ($task) {
			case "new":

				editMosForm(0, $option);

				break;

			case "forms":

				editMosForm($cid[0], '', $option);

				break;

			case "groups":

				saveMosForm($option);

				break;

			case "save":

				saveMosFormFormGroup($option);

				break;

			case "remove":

				deleteMosForm($cid, $option);

				break;

			case "cancel":

				displayMosForm($option);

				break;

			case "menu":

				createMosFormMenu($cid[0]);

				break; //not sure if this should be here
			case "updatedatabase":

				updateMosFormDatabase($cid[0], $option);

				break;
				
			case "formgroups":
			
				editFormGroups($cid[0], $option);
				
				break;
				
			case "orderup":

				orderMosFormFormGroup($cid[0], -1, $option, $act);

				break;

			case "orderdown":

				orderMosFormFormGroup($cid[0], 1, $option, $act);

				break;

			case "viewdatabase":

				viewMosFormDatabase($cid[0], $option);

				break;

			default:

				displayMosForm($option);

				break;
		} 

		break;

	case "groups":

		require_once("../components/" . $option . "/mosform_groups.class.php");

		switch ($task) {
			case "new":

				editMosFormGroup(0, $option);

				break;

			case "edit":

				editMosFormGroup($cid[0], '', $option);

				break;

			case "save":

				saveMosFormGroup($option, $act);

				break;

			case "remove":

				deleteMosFormGroup($cid, $option, $act);

				break;

			case "cancel":

				displayMosFormGroup($option);

				break;

			default:

				displayMosFormGroup($option);

				break;
		} 

		break;

	case "elements":

		require_once("../components/" . $option . "/mosform_elements.class.php");

		switch ($task) {
			case "new":

				editMosFormElement(0, $option);

				break;

			case "edit":

				editMosFormElement($cid[0], '', $option);

				break;

			case "save":

				saveMosFormElement($option, $act);

				break;

			case "remove":

				deleteMosFormElement($cid, $option, $act);

				break;

			case "cancel":

				displayMosFormElement($option);

				break;

			case "orderup":

				orderMosFormElement($cid[0], -1, $option, $act);

				break;

			case "orderdown":

				orderMosFormElement($cid[0], 1, $option, $act);

				break;


			default:

				displayMosFormElement($option);

				break;
		} 

		break;

	case "validations":
	

		require_once("../components/" . $option . "/mosform_validation.class.php");

		switch ($task) {
			case "new":

				addElementValidation($cid[0], $option);

				break;

			case "save":

				saveMosFormValidation($option, $act);

				break;

			case "remove":

				deleteElementValidation($cid, $option, $act);
				
			case "edit":
			
				addElementValidation($cid[0], $option);

				break;		

			default:

				//viewElementValidation($cid[0], $option);
				viewElementValidation( $option);

				break;
		} 

		break;

	default:

		require_once("../components/" . $option . "/mosforms.class.php");

		displayMosForm($option);

		break;
} 
// // MAIN FORM CODE /////////////////////////////////////////////////////////////
function displayMosForm($option)
{
	global $database, $mainframe, $mosConfig_offset; 
	// get the total number of records
	$database->setQuery("SELECT count(*) FROM #__mosform_forms");

	$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = intval(mosGetParam($_POST, 'limit', 10));

	$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));

	$sql = "select * from #__mosform_forms LIMIT $limitstart,$limit";

	$database->setQuery($sql);

	include_once("includes/pageNavigation.php");

	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {
		echo $database->stderr();

		return false;
	} 

	html_content::showAllForms($rows, $pageNav, $option);
} 

function deleteMosForm($cid, $option)
{
	global $database;
	$msg = '';
	for ($i = 0, $n = count($cid); $i < $n; $i++) {
		//echo("<p>Need to delete form with id of" . $cid[$i] . "</p>");
		$sql = "delete from #__mosform_forms where id = '" . $cid[$i] . "'";
		$database->setQuery($sql);
		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 
	} 
	mosRedirect("index2.php?option=$option&mosmsg=$msg");
} 

function saveMosForm($option)
{
	global $database, $my;

	$id = $_POST['id'];

	if (isset($_POST['record_in_database'])) {
		$_POST['record_in_database'] = 1;
	} else {
		$_POST['record_in_database'] = 0;
	} 

	$row = new mosForms($database);

	if (!$row->bind($_POST)) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";
		exit();
	} 

	if (!$row->check()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$row->checkin();

	$selections = mosGetParam($_POST, 'selections', array());

	$isNew = ($row->id == 0);

	if ($isNew) {
		$sql = "select max(id) as id from #__mosform_forms";

		$database->setQuery($sql);

		$newrows = $database->loadObjectList();

		if ($database->getErrorNum()) {
			echo $database->stderr();

			return false;
		} 

		$id = $newrows[0]->id;
	} else {
		$id = $row->id; 
		// echo("not new id = " . $row->id . "<br />");
	} 
	
	editFormGroups($id, $option,  $_POST['record_in_database'] );

} 

function editFormGroups($id, $option, $record_in_database=null ){
	global $database, $my;
	
	//if record_in_database not specified get the info from the form (with id = $id)
	if (!isset($record_in_database)) {
	
			$database->setQuery("SELECT  record_in_database  FROM #__mosform_forms where id = '$id'");
			
			$record_in_database = $database->loadResult();
	    
	}
	
	$sql = "select COUNT(*) as co from #__mosform_groups";
	
	$database->setQuery($sql);

	$count = $database->loadObjectList();
	
	$count = $count[0];

	if ($count->co == 0) {
	    $nogroups = true;
	}else{
		$nogroups = false;
	}
	// get a list of used groups
	$sql = "SELECT  #__mosform_formgroup.group_id AS value,  

		#__mosform_groups.group_name as text

		FROM #__mosform_formgroup 

		left join #__mosform_groups 

		on #__mosform_formgroup.group_id = #__mosform_groups.group_id

		where  #__mosform_formgroup.form_id = '$id' 

		order by  #__mosform_formgroup.ordering";

	$database->setQuery($sql);

	$current_groups = $database->loadObjectList();
	
	$current_grouplist = mosHTML::selectList($current_groups, 'current_groups', "class=\"inputbox\" size=\"10\" ", 'value', 'text', '/');
	
	// get a list of available groups - need to make the sql only return groups not already listed in mos_mosform_fromgroup for $uid
	$sql = "SELECT  group_id AS value,  group_name as text FROM #__mosform_groups ";
	$i = 0;
	foreach($current_groups as $cg){
		if ($i == 0) {
		    $sql .= " WHERE ";
		}else{
			$sql .= " AND ";
		}
		$val = $cg->value;
		$sql .= " group_id <> '$val'";
		$i++;
	} 

	$database->setQuery($sql);

	$groups = $database->loadObjectList();
	
	$grouplist = mosHTML::selectList($groups, 'groups', "class=\"inputbox\" size=\"10\" ", 'value', 'text', null); 

	html_content::editFormGroup2($option, $id, $grouplist, $current_grouplist, $record_in_database, $nogroups);
}

function editMosForm($uid = 0, $scope = '', $option = 'com_mosforms')
{
	global $database, $my;

	$row = new mosForms($database);

	$row->load($uid); 
	// fail if checked out not by 'me'
	if (isset($row->checked_out )) {
	
		if ($row->checked_out && $row->checked_out <> $my->id) {
		
			mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=The form $row->title is currently being edited by another administrator");
		
		} 
	    
		if ($uid) {
		
			$row->checkout($my->id);
			
		} else {
		
			$row->scope = $scope;
			
		} 
		
	}

	// get available elements to list as possible email receipt fields//
	$sql = "SELECT element_name AS value, element_label as text FROM #__mosform_forms as f
	left join #__mosform_formgroup as fg
	on f.id = fg.form_id
	left join #__mosform_elements as e
	on fg.group_id = e.group_id
	where f.id = '1'
	and (elementtype_id = '2' or elementtype_id = '5')";

	$database->setQuery($sql);

	$possible_email_receipt_fields = $database->loadObjectList();
	

	$possible_email_receipt_fields[] = mosHTML::makeOption('', 'none');

	
	// print_r($row);
	if (isset($row->receipt_id)) {
	
	    $receipt_id = intval($row->receipt_id);
		
	}else{
	
		$receipt_id = 0;
		
	}
	
	$email_receipt_list = mosHTML::selectList($possible_email_receipt_fields , 'receipt_email', 'class="inputbox" size="1"', 'value', 'text', $receipt_id);

	$database->setQuery("SELECT  id AS value,  CONCAT_WS(': ', name,  email) as text FROM #__users");

	$users = $database->loadObjectList();

	if (isset($row->action_id)) {
	
	    $action_id = intval($row->action_id);
		
	}else{
	
		$action_id = 0;
		
	}
	
	$userslist = mosHTML::selectList($users, 'action_id', 'class="inputbox" size="1"', 'value', 'text', $action_id); 
	// get a list of available groups - need to make the sql only return groups not already listed in mos_mosform_fromgroup for $uid
	$database->setQuery("SELECT  group_id AS value,  group_name as text FROM #__mosform_groups");

	$groups = $database->loadObjectList();

	$grouplist = mosHTML::selectList($groups, 'groups', "class=\"inputbox\" size=\"10\" ", 'value', 'text', null); 
	// get a list of used groups
	$sql = "SELECT  #__mosform_formgroup.group_id AS value,  #__mosform_groups.group_name as text FROM #__mosform_formgroup 

		left join #__mosform_groups 

		on #__mosform_formgroup.group_id = #__mosform_groups.group_id

		where  #__mosform_formgroup.form_id = '$uid' 

		order by  #__mosform_formgroup.ordering";

	$database->setQuery($sql);

	$current_groups = $database->loadObjectList();

	$current_grouplist = mosHTML::selectList($current_groups, 'current_groups', "class=\"inputbox\" size=\"10\" ", 'value', 'text', '/'); 
	// make a list of alignment options
	$align_options[] = mosHTML::makeOption('left', 'left');

	$align_options[] = mosHTML::makeOption('center', 'center');

	$align_options[] = mosHTML::makeOption('right', 'right');

	$align = mosHTML::selectList($align_options, 'align', "class=\"inputbox\" size=\"1\" ", 'value', 'text', $row->align);

	html_content::editForms($option, $row, $grouplist, $current_grouplist, $align, $userslist, $email_receipt_list);
} 

function CreateFormTable($form_id)

{
	global $database, $my;
	$sql = "create table #__mosform_formdata_" . $form_id . "( id int not null auto_increment, time_date timestamp not null" ;
	
	$current_groups_str = $_POST['current_groups_str'];
	$arGroups = explode(",", $current_groups_str);
	$arAddedObj = array();
		
	foreach($arGroups as $group_id) {
		$groupsql = "select * from #__mosform_elements where group_id = '$group_id'";
		$database->setQuery($groupsql);
		$elements = $database->loadObjectList();
		foreach($elements as $obj) {
			$objname = $obj->element_name;
			$objname = preg_replace("/[^A-Za-z0-9]/", "_", $objname); // replace all non alphanumeric characters with _
			if(!in_array($objname, $arAddedObj)){ // any elements that are names the same (eg radio buttons) can not be entered twice into the database
				$arAddedObj[] = $objname;
				$objtypeid = $obj->elementtype_id;
				switch ($objtypeid) {
					case "2":
						$objtype = "varchar (255)";
					case "3":
						$objtype = "varchar (3)";
					case "4":
						$objtype = "varchar (3)";
					case "5":
						$objtype = "text ()";
					case "6":
						$objtype = "varchar (255)";
					case "7":
						$objtype = "";
					case "8":
						$objtype = "binary ()";
					case "9":
						$objtype = "";
					case "10":
						$objtype = "varchar (25)";
					default:
						$objtype = "varchar (255)";
				} 
				if ($objtype != "") {
					$sql .= ", $objname $objtype null ";
				} 
			}
		} 
	} 

	$sql .= ",  primary key (id))";
	$database->setQuery($sql);
	if (!$database->query()) {
		echo $database->getErrorMsg();
		exit;
	} 
} 

function AmmendTable($form_id)
{
	global $database, $my, $mosConfig_dbprefix;
	$ammend = false;
	$sql = "describe " . $mosConfig_dbprefix . "mosform_formdata_" . $form_id;
	$database->setQuery($sql);
	$dbdescriptions = $database->loadObjectList();
	foreach($dbdescriptions as $dbdescription) {
		$fieldname = $dbdescription->Field;
		$exitingfields[] = $fieldname;
	} 


	
	$lastfield = $fieldname;
	$sql = "alter table " . $mosConfig_dbprefix . "mosform_formdata_" . $form_id;
	if (!isset($_POST['current_groups_str'])) {
		// get a list of groups used by the form
		$groupsql = "SELECT  group_id FROM #__mosform_formgroup where form_id = '$form_id'";
		//echo("amend table sql = $sql <br>");
		$database->setQuery($groupsql);
		$groups = $database->loadObjectList();

		echo $database->getErrorMsg();
		$arGroups = array();
		foreach($groups as $g) {
			$arGroups[] = $g->group_id;
		} 
	} else {
		$current_groups_str = $_POST['current_groups_str'];
		$arGroups = explode(",", $current_groups_str);
		//$arGroups = $_POST['current_groups'];
	} 
	$arAddedObj = array();
	
	foreach($arGroups as $group_id) {
		$groupsql = "select * from #__mosform_elements where group_id = '$group_id'";
		$database->setQuery($groupsql);
		$elements = $database->loadObjectList();
		
		foreach($elements as $obj) {
			$objname = $obj->element_name;
			$objname = preg_replace("/[^A-Za-z0-9]/", "_", $objname); // replace all non alphanumeric characters with _
			if (!in_array($objname, $exitingfields)) { // make sure that the object is not already in the table
				if(!in_array($objname, $arAddedObj)){ // any elements that are names the same (eg radio buttons) can not be entered twice into the database
					$arAddedObj[] = $objname;
					$objtypeid = $obj->elementtype_id;
					switch ($objtypeid) {
						case "2":
							$objtype = "varchar (255)";
						case "3":
							$objtype = "varchar (3)";
						case "4":
							$objtype = "varchar (3)";
						case "5":
							$objtype = "text ()";
						case "6":
							$objtype = "varchar (255)";
						case "7":
							$objtype = "";
						case "8":
							$objtype = "binary ()";
						case "9":
							$objtype = "";
						case "10":
							$objtype = "varchar (25)";
						default:
							$objtype = "varchar (255)";
					} 
					if ($objtype != "") {
						$ammend = true;
						$sql .= ", add column $objname $objtype null after $lastfield";
					} 				
				}

			} 
		} 
	} 

	//echo("ammend sql = $sql <br>"); 
	// add column  new varchar(50) not null after How_many_units_would_you_like_to_hire_
	if ($ammend) {
		$database->setQuery($sql);
		if (!$database->query()) {
			echo $database->getErrorMsg();
			exit;
		} 
	} 
} 

function saveMosFormFormGroup($option)
{
	global $database, $my;

	$form_id = $_POST['id']; 
	
	// delete the old form groups //
	$sql = "delete from #__mosform_formgroup where form_id = '$form_id'";

	$database->setQuery($sql);

	if (!$database->query()) {
	
		$msg .= $database->getErrorMsg() . "\n";
	} 
	$record_in_database = $_POST['record_in_database'];

	if ($record_in_database == '1') {
	
		$dbExisits = DatabaseTableExists($form_id);
		
		if (!$dbExisits) {
		
			CreateFormTable($form_id);
			
		} else {
		
			AmmendTable($form_id);
			
		} 
		
	} 
	
	$orderid = 1;

	$current_groups_str = $_POST['current_groups_str'];
	
	$current_groups = explode(",", $current_groups_str);
	
	$err = false;
	
	foreach($current_groups as $group_id) {

		$sql = "insert into #__mosform_formgroup (form_id, group_id, ordering) values ('$form_id','$group_id','$orderid')"; 

		$database->setQuery($sql);
		
		if (!$database->query()) {
		
			$err = true;
			
			echo $database->getErrorMsg() . "\n";
			
		} 
		
		$orderid ++;
	} 
	
	if (!$err) {
	
	   mosRedirect("index2.php?option=$option"); 
	   
	}
	
} 
// // MAIN GROUP CODE /////////////////////////////////////////////////////////////
function displayMosFormGroup($option)
{
	global $database, $mainframe, $mosConfig_offset; 
	// get the total number of records
		$database->setQuery("SELECT count(*) FROM #__mosform_groups");
	
		$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = intval(mosGetParam($_POST, 'limit', 10));

	$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));

	$sql = "select * from #__mosform_groups LIMIT $limitstart,$limit";

	$database->setQuery($sql);

	include_once("includes/pageNavigation.php");

	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$rows = $database->loadObjectList();
	
	if ($database->getErrorNum()) {
		echo $database->stderr();

		return false;
	} 
	
	$arElcount = array();
	
	foreach ($rows as $row){
		$group_id = $row->group_id;
		
		$sql = "SELECT count( * ) AS total
		FROM `#__mosform_groups` AS g
		LEFT JOIN `#__mosform_elements` AS e ON g.group_id = e.group_id
		WHERE g.group_id = '$group_id'";
		
		$database->setQuery($sql);
		
		$elcount = $database->loadObjectList();

		$total = $elcount[0]->total;
		
		$arElcount[$group_id] = $total;
		
		if ($database->getErrorNum()) {
		
			echo $database->stderr();
			
		} 
		
	}

	html_content::showAllGroups($rows, $pageNav, $option, $arElcount);
} 

function deleteMosFormGroup($cid, $option, $act)
{
	global $database;

	$msg = '';

	for ($i = 0, $n = count($cid); $i < $n; $i++) {
		$sql = "delete from #__mosform_groups where group_id = '" . $cid[$i] . "'";

		$database->setQuery($sql);

		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 

		$sql = "delete from #__mosform_formgroup where group_id = '" . $cid[$i] . "'";

		$database->setQuery($sql);

		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 
	} 

	mosRedirect("index2.php?option=$option&mosmsg=$msg&act=$act");
} 

function saveMosFormGroup($option, $act)
{
	global $database, $my;

	$row = new mosForm_Group($database);

	if (!$row->bind($_POST)) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$isNew = ($row->group_id == 0);

	if (!$row->check()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$row->checkin();

	$selections = mosGetParam($_POST, 'selections', array());

	mosRedirect("index2.php?option=$option&act=$act");
} 

function editMosFormGroup($uid = 0, $scope = '', $option = 'com_mosforms', $msg = '')
{
	global $database, $my;

	$row = new mosForm_Group($database);

	$row->load($uid); 
	// fail if checked out not by 'me'
	if ($row->checked_out && $row->checked_out <> $my->id) {
		mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=The form $row->title is currently being edited by another administrator");
	} 

	if ($uid) {
		$row->checkout($my->id);
	} else {
		// $row->scope = $scope;
	} 
	// get the available element types//
	$database->setQuery("SELECT element_id AS value, element_name AS text FROM #__mosform_elements");

	$elements = $database->loadObjectList();

	$elementslist = mosHTML::selectList($elements, 'element_id', 'class="inputbox" size="1"',

		'value', 'text', intval($row->group_id));

	html_content::editGroup($option, $row, $elementslist, $msg);
} 
// // MAIN ELEMENT CODE /////////////////////////////////////////////////////////////
function displayMosFormElement($option)
{
	global $database, $mainframe, $mosConfig_offset; 
	// get the total number of records
	$database->setQuery("SELECT count(*) FROM #__mosform_elements");

	$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = intval(mosGetParam($_POST, 'limit', 10));

	$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));

	$sql = "select * from #__mosform_elements 

			left join #__mosform_groups 

			on #__mosform_elements.group_id = #__mosform_groups.group_id

			left join #__mosform_elementtypes 

			on #__mosform_elements.elementtype_id = #__mosform_elementtypes.elementtype_id

			order by #__mosform_groups.group_id,  #__mosform_elements.ordering 

			LIMIT $limitstart,$limit";

	$database->setQuery($sql);

	include_once("includes/pageNavigation.php");

	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {
		echo $database->stderr();

		return false;
	} 

	html_content::showAllElements($rows, $pageNav, $option);
} 

function deleteMosFormElement($cid, $option, $act)
{
	global $database;

	$msg = '';

	for ($i = 0, $n = count($cid); $i < $n; $i++) {
		//echo("<p>Need to delete form with id of" . $cid[$i] . "</p>");

		$sql = "delete from #__mosform_elements where element_id = '" . $cid[$i] . "'";

		$database->setQuery($sql);

		if (!$database->query()) {
			$msg .= $database->getErrorMsg() . "\n";
		} 
	} 

	mosRedirect("index2.php?option=$option&mosmsg=$msg&act=$act");
} 

function saveMosFormElement($option, $act)
{
	global $database, $my;

	$row = new mosForm_Element($database);

	$newAr = $_POST; 
	// get the max current ordering value//
	$database->setQuery("select max(ordering) from #__mosform_elements");

	$ordering = $database->loadResult();

	$ordering ++; 
	// $newAr['ordering'] = $ordering;
	if (!isset($newAr['ordering'])) {
		$newAr['ordering'] = $ordering;
	} 

	if ($newAr['ordering'] == 0) {
		$newAr['ordering'] = $ordering;
	} 
	// echo "newAr['ordering'] = " . $newAr['ordering'] . "<br />" ;
	if (!isset($newAr['hidden'])) {
		$newAr['hidden'] = "off";
	} 

	if (!isset($newAr['password'])) {
		$newAr['password'] = "off";
	} 

	if (!isset($newAr['box_checked'])) {
		$newAr['box_checked'] = "off";
	} 

	if (!isset($newAr['radio_checked'])) {
		$newAr['radio_checked'] = "off";
	} 

	if (!isset($newAr['multiple'])) {
		$newAr['multiple'] = "off";
	} 
	// foreach($_POST as $key => $val){echo("$key = $val <br />");}
	if (!$row->bind($newAr)) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$isNew = ($row->element_id == 0);

	if (!$row->check()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$row->checkin();

	$selections = mosGetParam($_POST, 'selections', array());

	mosRedirect("index2.php?option=$option&act=$act");
} 

function editMosFormElement($uid = 0, $scope = '', $option = 'com_mosforms')
{
	global $mosConfig_absolute_path;

	global $database, $my; 
	// check to see if a group exists if no group then we need to alert the user and go to the add group page//
	$database->setQuery("SELECT count(*) FROM #__mosform_groups");
	
	$total = $database->loadResult();

	if ($total == 0) {
	
		require_once("../components/" . $option . "/mosform_groups.class.php");
		
		editMosFormGroup(0, '', $option , 'Please create a group first, before creating your element');
		
	} else {
	
		$row = new mosForm_Element($database);

		$row->load($uid); 
		// fail if checked out not by 'me'
		if ($row->checked_out && $row->checked_out <> $my->id) {
		
			mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=The form $row->title is currently being edited by another administrator");
			
		} 
		// if you are editing an element then $uid will be set, thus you can check it out to avoid other people editing it at the same time. //
		if ($uid) {
			$row->checkout($my->id); // $my->id is the id of the current user //
		} 
		// get the available element types//
		$database->setQuery("SELECT elementtype_id AS value, elementtype_name AS text FROM #__mosform_elementtypes");

		$elementstypes = $database->loadObjectList(); 
		// put the avaialble element types in a selction list //
		$elementstypelist = mosHTML::selectList($elementstypes, 'elementtype_id', 'class="inputbox" onchange="dhtml.cycleTab(\'tab\'+this.options[this.selectedIndex].value)"  size="1"',

			'value', 'text', intval($row->elementtype_id)); 
		// get the available groups//
		$sql = "SELECT group_id AS value, group_name AS text FROM #__mosform_groups";

		$database->setQuery($sql);

		$groups = $database->loadObjectList(); 
		// put the avaialble groups in a selction list //
		$groupslist = mosHTML::selectList($groups, 'group_id', 'class="inputbox" size="1"',

			'value', 'text', intval($row->group_id)); 
		// get all mosimages//
		$img_path = "$mosConfig_absolute_path/images/";

		$imgFiles = mosReadDirectory($img_path);

		foreach ($imgFiles as $file) {
			if (eregi("bmp|gif|jpg|png", $file)) {
				$images[] = mosHTML::makeOption($file);
			} 
		} 

		$imagelist = mosHTML::selectList($images, 'image_name', "class=\"inputbox\" size=\"1\"" . " ", 'value', 'text', $row->image_name); 
		

		// get list of directories
		$listdir = $mosConfig_absolute_path.'/';
		$imgFiles = recursive_listdir( $mosConfig_absolute_path."/" );
		$images = array();
		$folders = array();
		$folders[] = mosHTML::makeOption( "/" );
		foreach ($imgFiles as $file) {
				$folders[] = mosHTML::makeOption( substr($file,strlen($mosConfig_absolute_path."/")) );
		}
	
		// create folder selectlist
		$dirPath = mosHTML::selectList( $folders, 'ul_directory', "class=\"inputbox\" size=\"1\" "
		."onchange=\"goUpDir()\" ",
		'value', 'text', $row->ul_directory );
	
		// draw the edit element page //
		html_content::editElement($option, $row, $elementstypelist, $groupslist, $imagelist, $dirPath);
	} 
} 

function orderMosFormElement($uid, $inc, $option, $act)
{
	global $database;

	$row = new mosForm_Element($database);

	$row->load($uid); 
	// $row->move( $inc, "group_id = '$group_id'" );
	$row->move($inc, "");

	mosRedirect("index2.php?option=$option&act=$act");
} 

function orderMosFormFormGroup($uid, $inc, $option, $act){

	require_once("../components/" . $option . '/mosform_formgroup.class.php');

	global $database;
	
	$row = new mosForm_FormGroup($database);
	//echo("odermosformgroup row = ");
	//print_r($row);
	//echo("<br>");
	//echo("<br><b> id = $uid</b><br>");
	$row->load($uid);
	
	$row->move($inc, "");
	
	//print_r($row);

	//echo("option  = $option act = $act");
	
	//mosRedirect("index2.php?option=$option&act=$act&task=formgroups");
}

function createMosFormMenu(&$form_id)
{
	global $database;

	global $mosConfig_absolute_path;

	$menu = new mosMenu($database);

	$menu->type = 'url';

	$menu->link = 'index.php?option=com_mosforms&mosform=' . $form_id;

	$menu->menutype = 'mainmenu';

	$menu->browserNav = 0;

	$menu->ordering = 9999;

	$menu->parent = 0;

	if (!$menu->store()) {
		echo "<script> alert('" . $menu->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	$cid = array();

	$cid[ 0 ] = $menu->id;

	$menutype = 'mainmenu';

	$option = 'com_menus';

	$task = 'edit';

	$menu->updateOrder("menutype='$menu->menutype' AND parent='$menu->parent'");

	require("$mosConfig_absolute_path/administrator/components/com_menus/url/url.menu.php");
} 

function DatabaseTableExists($form_id)
{
	global $database, $mosConfig_dbprefix;
	$sql = "SHOW TABLES LIKE '#__mosform_formdata_" . $form_id . "'";
	// for some god damn reason the above doesnt work!!!!!!, this hack needs to be fixed !!!!!!!
	$sql = "SHOW TABLES LIKE '" . $mosConfig_dbprefix . "mosform_formdata_" . $form_id . "'";
	$database->setQuery($sql);
	$total = $database->loadResult();
	$total = substr($total, 4, strlen($total)-1);
	if ($total == "mosform_formdata_" . $form_id) {
		return true;
	} else {
		return false;
	} 
} 

function updateMosFormDatabase($form_id , $option)
{
	$dbExisits = DatabaseTableExists($form_id);
	if (!$dbExisits) {
		CreateFormTable($form_id);
	} else {
		AmmendTable($form_id);
	} 
	displayMosForm($option);
} 

function viewMosFormDatabase($form_id, $option)
{
	global $database;
	$dbExisits = DatabaseTableExists($form_id);
	if (!$dbExisits) {
		echo("<p></strong>There is no database for this form!</strong><p>");
		exit();
	} else {
		$database->setQuery("SELECT count(*) FROM #__mosform_formdata_$form_id");
		$total = $database->loadResult();
		echo $database->getErrorMsg();
		$limit = intval(mosGetParam($_POST, 'limit', 10));
		$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));
		$sql = "select *, DATE_FORMAT(time_date, '%m.%d.%Y') AS 'date added' from #__mosform_formdata_$form_id LIMIT $limitstart,$limit";
		include_once("includes/pageNavigation.php");
		$pageNav = new mosPageNav($total, $limitstart, $limit);
		$database->setQuery($sql);
		$formdata = $database->loadObjectList();
		echo $database->getErrorMsg();
		if ($total == 0) {
			html_content::ShowNoDataMessage();
		} else {
			html_content::ViewDatabase($formdata, $pageNav, $option, $form_id);
		} 
	} 
} 

//function viewElementValidation($element_id, $option)
function viewElementValidation($option)
{
	global $database; 
	// echo("view element Validation rules for $element_id, $option");
	$sql = "SELECT * from #__mosform_validations as v
	LEFT JOIN #__mosform_validation_rules as r
	on v.validation_rule_id = r.validation_rule_id 
	LEFT JOIN #__mosform_elements as e
	ON v.element_id = e.element_id
	";
	//echo $sql;
	$database->setQuery($sql);
	$validations = $database->loadObjectList();
	echo $database->getErrorMsg();
	//html_content::ShowAllValidations($validations, $option, $element_id);
	html_content::ShowAllValidations($validations, $option);
} 

function addElementValidation($validation_id = 0, $option)
{
	global $database;	
	
	$row = new mosForm_Validation($database);

	$row->load($validation_id); 
	// fail if checked out not by 'me'
	//if ($row->checked_out && $row->checked_out <> $my->id) {
	//	mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=This form Validation is currently being edited by another administrator");
	//} 
	// if you are editing a Validation then $Validation_id will be set, thus you can check it out to avoid other people editing it at the same time. //
	if ($validation_id) {
		$row->checkout($my->validation_id); // $my->id is the id of the current user //
	} 

	$sql = "select validation_rule_id as value, validation_rule_label as text from #__mosform_validation_rules";
	$database->setQuery($sql);
	$validationrules = $database->loadObjectList();
	echo $database->getErrorMsg();
	$validationrulelist = mosHTML::selectList($validationrules, 'validation_rule_id', "class=\"inputbox\"  size=\"1\" ", 'value', 'text', $row->validation_rule_id);
	
	$sql = "select element_id as value, element_name as text from #__mosform_elements";
	
	$database->setQuery($sql);
	
	$elements = $database->loadObjectList();

	echo $database->getErrorMsg() . "\n";
		
	$element_list = mosHTML::selectList($elements, 'element_id', "class=\"inputbox\"  size=\"1\"", 'value', 'text', $row->element_id);

	html_content::AddElementValidation($validationrulelist, $option, $validation_id, $element_list, $row);
} 

function saveMosFormValidation($option)
{
	global $database;
	
	$row = new mosForm_Validation($database);

	if (!$row->bind($_POST)) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 
	
	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	//print_r($_POST);
	
	/*$message = $_POST['err_message'];

	$element_id = $_POST['element_id'];

	$cid = $_POST['cid'];

	$rule_id = $_POST['validation_type'];

	$sql = "insert into #__mosform_validations (element_id, validation_rule_id, message) values ('$element_id','$rule_id','$message' )";
	
	//echo($sql);

	$database->setQuery($sql);
	
	if (!$database->query()) {

		echo $database->getErrorMsg() . "\n";

	} */

	viewElementValidation($option);
} 


function deleteElementValidation($cid, $option, $act)
{
	global $database;

	if (is_array($cid)) {

		foreach ($cid as $id) {
			
			$sql = "delete from #__mosform_validations where validation_id = '$id'";
			
			//echo("$sql <br>");
			
			$database->setQuery($sql);
			
			if (!$database->query()) {
		
				echo $database->getErrorMsg() . "\n";
		
			} 

		} 
		
	} 

	mosRedirect("index2.php?option=$option&act=$act");

} 

function recursive_listdir($base)
{
	static $filelist = array();
	static $dirlist = array();

	if (is_dir($base)) {
		$dh = opendir($base);
		if ($dh != false) {
			while (false !== ($dir = readdir($dh))) {
				if (is_dir($base . "/" . $dir) && $dir !== '.' && $dir !== '..' && strtolower($dir) !== 'cvs') {
					$subbase = $base . "/" . $dir;
					$dirlist[] = $subbase;
					$subdirlist = recursive_listdir($subbase);
				} 
			} 
			closedir($dh);
		} 
	} 
	return $dirlist;
} 

?>