<?php
/*************************************************************
 * jAwards, the Joomla Awards Component
 * Author Armin Hornung
 * @ Released under GNU/GPL License : 
 * http://www.gnu.org/copyleft/gpl.html
 *************************************************************/

// no direct access
defined( '_VALID_MOS' ) or die( 'Restricted access' );

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_jawards' ))) {
	mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once( $mainframe->getPath( 'admin_html' ) );
require_once( $mainframe->getPath( 'class' ) );

$showallusers = mosGetParam($_REQUEST, 'showallusers', '');
$cid = mosGetParam( $_REQUEST, 'cid', array(0) );
if (!is_array( $cid )) {
	$cid = array(0);
}

switch ($task) {
	
	// Config:
	case 'showconfig':
		showConfig($option);
		break;
	case 'saveconfig':
		saveConfig($option);
	
		
	//Awards events

	case 'newmedal':
		editMedal(null, $option );
		break;

	case 'editmedal':
		editMedal( $cid[0], $option );
		break;

	case 'editmedalA':
		editMedal( $cid, $option );
		break;

	case 'savemedal':
		saveMedal( $option );
		break;

	case 'cancelmedal':
		cancelEditMedal( $option );
		break;

	case 'listmedals':
		viewMedals( $option );
		break;
		
	case 'removemedal':
		removeMedal($cid, $option);
		break;

	// Award Management Events

	case 'new':
		editAward( null, $option, $showallusers );
		break;

	case 'cancel':
		cancelEditAward();
		break;

	case 'save':
		saveAward( $task );
		break;

	case 'edit':
		editAward( $cid[0], $option, true );
		break;

	case 'editA':
		editAward( $cid, $option );
		break;

	case 'remove':
		removeAward( $cid );
		break;

	default:
		viewAwards( $option );
		break;
}

function showConfig( $option ) {
	include_once( "components/com_jawards/config.jawards.php" );
	$lists = array();	
	// make a standard yes/no list
	$yesno = array();
	$yesno[] = mosHTML::makeOption( '0', "No" );
	$yesno[] = mosHTML::makeOption( '1', "Yes" );

	
	$lists['showawardReason'] = mosHTML::selectList( $yesno, 'cfg_showawardreason', 'class="inputbox" size="1"', 'value', 'text', $ja_config['showawardreason'] );
	$lists['cbIntegration'] = mosHTML::selectList( $yesno, 'cfg_cbintegration', 'class="inputbox" size="1"', 'value', 'text', $ja_config['cbintegration'] );
	
	
	HTML_awards::config($ja_config, $lists, $option);
	
	
}

function saveConfig ( $option ) {
	
   //Add code to check if config file is writeable.
   $configfile = "components/com_jawards/config.jawards.php";
   @chmod ($configfile, 0766);
   if (!is_writable($configfile)) {
      mosRedirect("index2.php?option=$option", "FATAL ERROR: Config File  $configfile Not writeable" );
   }

   $txt = "<?php\n";
   foreach ($_POST as $k=>$v) {
   	  if (is_array($v)) $v = implode("|*|", $v);
      if (strpos( $k, 'cfg_' ) === 0) {
         if (!get_magic_quotes_gpc()) {
            $v = addslashes( $v );
         }
         $txt .= "\$ja_config['".substr( $k, 4 )."']='$v';\n";
      }
   }
   $txt .= "?>";

   if ($fp = fopen( $configfile, "w")) {
      fputs($fp, $txt, strlen($txt));
      fclose ($fp);
      mosRedirect( "index2.php?option=$option&task=showconfig", "Configuration file saved" );
   } else {
      mosRedirect( "index2.php?option=$option", "FATAL ERROR: File could not be opened." );
   }
}

function viewAwards( $option ) {
	global $database, $mainframe, $mosConfig_list_limit;

	$limit 		= $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	
	$search = $mainframe->getUserStateFromRequest( "search{$option}", 'search', '' );
    $search = $database->getEscaped( trim( strtolower( $search ) ) );

	// get the total number of records
	$query = "SELECT COUNT(*)"
	. "\n FROM #__jawards_awards AS a"
	. "\n LEFT JOIN #__users AS u ON a.userid = u.id";
	if ($search) {
    	$query .= "\n WHERE LOWER(u.username) LIKE '%$search%' ";
	}

	$database->setQuery( $query );
	$total = $database->loadResult();
	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$query = "SELECT a.*, m.image, m.name, u.username"
	. "\n FROM #__jawards_awards AS a "
	. "\n LEFT JOIN #__jawards_medals AS m ON a.award = m.id"
	. "\n LEFT JOIN #__users AS u ON a.userid = u.id"
	. "\n ORDER BY u.username, m.name";
	
	if ($search) {
    	$query .= "\n WHERE LOWER(u.username) LIKE '%$search%' ";
	}
	$query.= "\n LIMIT $pageNav->limitstart, $pageNav->limit";
	
	$database->setQuery( $query );

	if(!$result = $database->query()) {
		echo $database->stderr();
		return;
	}
	$rows = $database->loadObjectList();

	HTML_awards::showAwards( $rows, $pageNav, $option, $search );
}

function removeAward( $cid ) {
	global $database;
	if (count( $cid )) {
		$cids = implode( ',', $cid );
		$query = "DELETE FROM #__jawards_awards"
		. "\n WHERE id IN ( $cids )"
		;
		$database->setQuery( $query );
		if (!$database->query()) {
			echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
		}
	}
	mosRedirect( 'index2.php?option=com_jawards' );
}

function editAward( $awardid, $option, $showallusers=false ) {
	global $database, $my;
	$lists = array();

	$row = new mosAward($database);
	$row->load( $awardid );
	
	// Build Medal select list
	$sql	= "SELECT *"
	. "\n FROM #__jawards_medals"
	;
	$database->setQuery($sql);
	if (!$database->query()) {
		echo $database->stderr();
		return;
	}

	$medalslist[] 	= mosHTML::makeOption( '0', 'Select Medal', 'id', 'name' );
	$medalslist 	= array_merge( $medalslist, $database->loadObjectList() );
	$lists['medals'] 	= mosHTML::selectList( $medalslist, 'award', 'class="inputbox" size="1"','id', 'name', $row->award);
	
	
	


  	HTML_awards::awardForm( $row, $lists, $option, $showallusers );
}

function saveAward( $task ) {
	global $database;

	$row = new mosAward($database);

	$msg = 'Saved Award info';
	
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	mosRedirect( 'index2.php?option=com_jawards', $msg );
}

function cancelEditAward() {
	global $database;

	$row = new mosAward($database);
	$row->bind( $_POST );
	mosRedirect( 'index2.php?option=com_jawards' );
}



// ---------- MEDAL MANAGEMENT ----------

function viewMedals( $option ) {
	global $database, $mainframe, $mosConfig_list_limit;

	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $limit );
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}limitstart", 'limitstart', 0 );
	
	$search = $mainframe->getUserStateFromRequest( "medalsearch{$option}", 'medalsearch', '' );
    $search = $database->getEscaped( trim( strtolower( $search ) ) );
	
	// get the total number of records
	$query = "SELECT COUNT(*)"
	. "\n FROM #__jawards_medals";
	if ($search) {
    	$query .= "\n WHERE LOWER(#__jawards_medals.name) LIKE '%$search%' ";
	}
	
	$database->setQuery( $query );
	$total = $database->loadResult();

	require_once("includes/pageNavigation.php");
	$pageNav = new mosPageNav( $total, $limitstart, $limit );

	$sql = "SELECT *"
	. "\n FROM #__jawards_medals";
	if ($search) {
    	$sql .= "\n WHERE LOWER(#__jawards_medals.name) LIKE '%$search%' ";
	}
	$sql .= "\n LIMIT $pageNav->limitstart, $pageNav->limit";
	$database->setQuery($sql);

	if(!$result = $database->query()) {
		echo $database->stderr();
		return;
	}
	$rows = $database->loadObjectList();

	HTML_Medals::showMedals( $rows, $pageNav, $option, $search );
}

function editMedal( $id, $option ) {
	global $database, $my;

	$row = new mosMedal($database);
	$row->load($id);
	
	// Imagelist
	$javascript 	= 'onchange="changeDisplayImage();"';
	$directory 		= '/images/medals';
	$lists['image'] = mosAdminMenus::Images( 'image', $row->image, $javascript, $directory );

	HTML_Medals::medalForm( $row, $lists, $option );
}

function saveMedal( $option ) {
	global $database;

	$row = new mosMedal( $database );
	if (!$row->bind( $_POST )) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	if (!$row->check()) {
		mosRedirect( "index2.php?option=$option&task=editclient&cid[]=$row->id", $row->getError() );
	}

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
		exit();
	}
	$row->checkin();
	$msg = 'Saved Medal info';
	mosRedirect( "index2.php?option=$option&task=listmedals",$msg );
}

function cancelEditMedal( $option ) {
	global $database;
	$row = new mosMedal( $database );
	$row->bind( $_POST );
	
	mosRedirect( "index2.php?option=$option&task=listmedals" );
}

function removeMedal( $cid ) {
	global $database;
	if (count( $cid )) {
		$cids = implode( ',', $cid );
		
		// Check for existing awards with a medal to be deleted:
		$checkQuery = "SELECT COUNT(*) FROM #__jawards_awards"
			."\n WHERE award IN ($cids)";
		$database->setQuery($checkQuery);
		$numberOfAwards = $database->loadResult();

		
		if ($numberOfAwards > 0){
			mosRedirect( 'index2.php?option=com_jawards',"No Medal deleted! There are still $numberOfAwards awards associated to the medals you wanted to delete. Please delete them first." );		
		}
		else{
			
		
			$query = "DELETE FROM #__jawards_medals"
			. "\n WHERE id IN ( $cids )";
			
			$database->setQuery( $query );
			if (!$database->query()) {
				echo "<script> alert('".$database->getErrorMsg()."'); window.history.go(-1); </script>\n";
			}
			mosRedirect( 'index2.php?option=com_jawards&task=listmedals','Selected Medals deleted!' );
		}
	}
	
}





?>