<?php
/**
* @version $Id: class.ebackup.php 2006-06- 05 23:00
* @package eBackup
* @copyright Copyright (C) 2006 by Mambobaer.de. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined('_VALID_MOS') or die('Restricted access');

class BackupStats{
  var $UserAgent = null;
  var $IPAddress = null;
  var $Host      = null;

  function BackupStats(){
    $this->IPAddress = $_SERVER['REMOTE_ADDR'];
    $this->Host      = $this->GetHostName($this->IPAddress);
    $this->UserAgent = $_SERVER['HTTP_USER_AGENT'];

  }

  function GetHostName($ip){
    $hostname = "Private Network";
    if (($this->IPAddress != NULL)&&($this->IPAddress != '127.0.0.1')&&(substr($this->IPAddress,0,8) != '192.168.')&&(substr($this->IPAddress,0,7) != '172.16.')&&(substr($this->IPAddress,0,7) != '172.31.')){
       $hostname = @gethostbyaddr($this->IPAddress);
       return $hostname;
    }else{
       return $hostname;
    }
  }

}

class JConfig{

  var $structure       = NULL;
  var $drop            = NULL;
  var $exists          = NULL;
  var $autoinc         = NULL;
  var $full_inserts    = NULL;
  var $gzip            = NULL;
  var $sql_compat      = NULL;
  var $comments        = NULL;
  var $tab_filter      = NULL;
  var $run_time        = NULL;
  var $delaypersession = NULL;
  var $email           = NULL;
  var $ftp_server      = NULL;
  var $ftp_user        = NULL;
  var $ftp_port        = NULL;
  var $ftp_pasv        = NULL;
  var $ftp_passwd      = NULL;
  var $ftp_path        = NULL;

  function JConfig(){
    global $structure,$drop, $exists, $autoinc, $full_inserts, $gzip, $sql_compat, $comments, $tab_filter,
           $run_time, $delaypersession, $email, $ftp_server, $ftp_user, $ftp_port, $ftp_pasv, $ftp_passwd, $ftp_path;

    $this->o_structure       = $structure;
    $this->o_drop            = $drop;
    $this->o_exists          = $exists;
    $this->o_autoinc         = $autoinc;
    $this->o_full_inserts    = $full_inserts;
    $this->o_gzip            = $gzip;
    $this->o_sql_compat      = $sql_compat;
    $this->o_comments        = $comments;
    $this->o_tab_filter      = $tab_filter;
    $this->o_run_time        = $run_time;
    $this->o_delaypersession = $delaypersession;
    $this->o_email           = $email;
    $this->o_ftp_server      = $ftp_server;
    $this->o_ftp_pasv        = $ftp_pasv;
    $this->o_ftp_port        = $ftp_port;
    $this->o_ftp_user        = $ftp_user;
    $this->o_ftp_passwd      = $ftp_passwd;
    $this->o_ftp_path        = $ftp_path;
  }

  function import(){
    global $structure,$drop, $exists, $autoinc, $full_inserts, $gzip, $sql_compat, $comments, $tab_filter,
           $run_time, $delaypersession, $email, $ftp_server, $ftp_user, $ftp_port, $ftp_pasv, $ftp_passwd, $ftp_path;

    $this->o_structure       = mosGetParam($_POST, 'frm_structure', 0);
    $this->o_drop            = mosGetParam($_POST, 'frm_drop', 0);
    $this->o_exists          = mosGetParam($_POST, 'frm_exists', 0);
    $this->o_autoinc         = mosGetParam($_POST, 'frm_autoinc', 0);
    $this->o_full_inserts    = mosGetParam($_POST, 'frm_full_inserts', 0);
    $this->o_gzip            = mosGetParam($_POST, 'frm_gzip', 0);
    $this->o_sql_compat      = mosGetParam($_POST, 'sql_compat', '');
    $this->o_comments        = mosGetParam($_POST, 'frm_comments', 0);
    $this->o_tab_filter      = mosGetParam($_POST, 'frm_tab_filter', 0);
    $this->o_run_time        = mosGetParam($_POST, 'frm_run_time', $run_time);
    $this->o_delaypersession = mosGetParam($_POST, 'frm_delaypersession', $delaypersession);
    $this->o_email           = mosGetParam($_POST, 'frm_email', '');
    $this->o_ftp_server      = mosGetParam($_POST, 'frm_ftp_server', '');
    $this->o_ftp_pasv        = mosGetParam($_POST, 'frm_ftp_pasv', 0);
    $this->o_ftp_port        = mosGetParam($_POST, 'frm_ftp_port', '');
    $this->o_ftp_user        = mosGetParam($_POST, 'frm_ftp_user', '');
    $this->o_ftp_passwd      = mosGetParam($_POST, 'frm_ftp_passwd', '');
    $this->o_ftp_path        = mosGetParam($_POST, 'frm_ftp_path', '');
  }

  function loadJobSetting(&$job){
    global $database;

    $this->o_structure    = $job->structure;
    $this->o_drop         = $job->drop;
    $this->o_exists       = $job->exists;
    $this->o_autoinc      = $job->inc;
    $this->o_full_inserts = $job->inserts;
    $this->o_sql_compat   = $job->compat;
    $this->o_gzip         = $job->gzip;
    $this->o_email        = $job->email;
  }

  function save($option){

    $configtxt = "<?php\r\n"
                ."  \$structure       = ".$this->o_structure.";\r\n"
                ."  \$drop            = ".$this->o_drop.";\r\n"
                ."  \$exists          = ".$this->o_exists.";\r\n"
                ."  \$autoinc         = ".$this->o_autoinc.";\r\n"
                ."  \$full_inserts    = ".$this->o_full_inserts.";\r\n"
                ."  \$gzip            = ".$this->o_gzip.";\r\n"
                ."  \$sql_compat      = \"".$this->o_sql_compat."\";\r\n"
                ."  \$tab_filter      = ".$this->o_tab_filter.";\r\n"
                ."  \$comments        = ".$this->o_comments.";\r\n"
                ."  \$run_time        = ".$this->o_run_time.";\r\n"
                ."  \$delaypersession = ".$this->o_delaypersession.";\r\n"
                ."  \$email           = \"".$this->o_email."\";\r\n"
                ."  \$ftp_server      = \"".$this->o_ftp_server."\";\r\n"
                ."  \$ftp_pasv        = ".$this->o_ftp_pasv.";\r\n"
                ."  \$ftp_port        = \"".$this->o_ftp_port."\";\r\n"
                ."  \$ftp_user        = \"".$this->o_ftp_user."\";\r\n"
                ."  \$ftp_passwd      = \"".$this->o_ftp_passwd."\";\r\n"
                ."  \$ftp_path        = \"".$this->o_ftp_path."\";\r\n"
                ."?>\r\n";

    $configfile = "components/".$option."/config.ebackup.php";
    clearstatcache();
    @chmod ($configfile, 0777);
    if ($fp = fopen("$configfile", "w+")) {
       fputs($fp, $configtxt, strlen($configtxt));
       fclose ($fp);
       $msg = _BBKP_CONFIG_SAVED;
    }else{
       $msg = _BBKP_NOT_CONFIG_SAVED;
    }
    return $msg;
  }

}

class Dump_File{
  var $pathname = NULL;
  var $filename = NULL;

  function Dump_File($pathname, $filename){
    $this->pathname = $pathname;
    $this->filename = $filename;
  }

  function download($inline = false){

    $user_agent = (isset($_SERVER["HTTP_USER_AGENT"]) ) ? $_SERVER["HTTP_USER_AGENT"] : $HTTP_USER_AGENT;
    while (@ob_end_clean());
    $filesize = filesize($this->pathname."/".$this->filename);
    $filename = $this->pathname."/".$this->filename;

    header("HTTP/1.1 200 OK");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("Expires: 0");
    header("Content-Length: ".$filesize);
    header("Content-Type: application/force-download");
    header("Content-Disposition: attachment; filename=".$this->filename);
    header("Content-Transfer-Encoding: binary");

    $this->readfile_chunked($filename);

  }

  function readfile_chunked($filename, $retbytes=true){
    $chunksize = 1*(1024*1024); // how many bytes per chunk
    $buffer = '';
    $cnt =0;
    $handle = fopen($filename, 'rb');
    if ($handle === false){
        return false;
    }
    while (!feof($handle)){
          $buffer = fread($handle, $chunksize);
          echo $buffer;
          if ($retbytes){
             $cnt += strlen($buffer);
          }
    }
    $status = fclose($handle);
    if ($retbytes && $status) {
       return $cnt; // return num. bytes delivered like readfile() does.
    }
    return $status;
  }

}

class JFiler{

  var $zipped   = false;
  var $filename = '';
  var $isopen   = false;
  var $fp       = 0;
  var $reopen   = false;


  function JFiler($zipped = false){
    $this->zipped = $zipped;
  }

  function compressFile($source, $level=false){
     $dest=$source.'.gz';
     $mode='wb'.$level;
     $error=false;
     if($fp_out=gzopen($dest,$mode)){
         if($fp_in=fopen($source,'rb')){
             while(!feof($fp_in))
                 gzwrite($fp_out,fread($fp_in,1024*512));
             fclose($fp_in);
             }
           else $error=true;
         gzclose($fp_out);
         }
       else $error=true;
     if($error) return false;
       else return $dest;
  }

  function createFile($filename){
    $this->filename = $filename;
    if ($this->fp = fopen($this->filename, "wb")){
       @chmod ($configfile, 0777);
       $this->isopen = true;
       return $this->filename;
    }else{
       $this->isopen = false;
       return FALSE;
    }
  }

  function openFile($filename){
    $this->filename = $filename;
    if ($this->fp = fopen($this->filename, "ab")){
       $this->isopen = true;
       return $this->filename;
    }else{
       $this->isopen = false;
       return false;
    }
  }

  function open2Read($filename){
    $this->filename = $filename;
    $path_parts = pathinfo($this->filename);
    if (strtolower($path_parts["extension"]) == "gz"){
       $this->zipped = true;
       if ($this->fp = gzopen($this->filename, "rb")) {
          $this->isopen = true;
          return true;
       }else{
          $this->isopen = false;
          return false;
       }
    }else{
       $this->zipped = false;
       if ($this->fp = fopen($this->filename, "rb")) {
          $this->isopen = true;
          return true;
       }else{
          $this->isopen = false;
          return false;
       }
    }
  }

  function readBuffer($buf_size){
    if ($this->isopen) {
       if ($this->zipped){
          return gzgets($this->fp, $buf_size);
       }else{
          return fgets($this->fp, $buf_size);
       }
    }else{
       return false;
    }
  }

  function is_EOF(){
    if ($this->isopen){
       if ($this->zipped){
          return gzeof($this->fp);
       }else{
          return feof($this->fp);
       }
    }
  }

  function seekBuffer($offset){
    if ($this->isopen){
       if ($this->zipped){
          return gzseek($this->fp, $offset);
       }else{
          return fseek($this->fp, $offset);
       }
    }
  }

  function getOffset(){
    if ($this->isopen){
       if ($this->zipped){
          return gztell($this->fp);
       }else{
          return ftell($this->fp);
       }
    }
  }

  function writeFile($data){
    fwrite($this->fp, $data);
  }

  function closeFile(){
    if ($this->zipped){
       $this->compressFile($this->filename, 9);
       fclose($this->fp);
       unlink($this->filename);
       $this->isopen = false;
    }else{
       fclose($this->fp);
       $this->isopen = false;
    }
  }

  function getFileSize(){
    $size = 0;
    if (!$this->isopen){
       if ($this->zipped){
          $size = filesize($this->filename.".gz");
       }else{
          $size = filesize($this->filename);
       }
    }
    return $size;
  }

  function getFileInfo($filename){
    $info       = "";
    $path_parts = pathinfo($filename);
    if (strtolower($path_parts["extension"]) == "gz"){
       $file = gzopen($filename, "r");
       while (!gzeof($file)){
             $buffer = trim(gzgets($file, MAX_LINE_LENGTH));
             if (strlen($buffer)== 0){
                break;
             }else{
                $info.= str_replace(' ', "&nbsp;", $buffer)."<br />";
             }
       }
       gzclose($file);
       return $info;
    }else{
       $file = fopen($filename, "r");
       while (!feof($file)){
             $buffer = trim(fgets($file, MAX_LINE_LENGTH));
             if (strlen($buffer)== 0){
                break;
             }else{
                $info.= str_replace(' ', "&nbsp;", $buffer)."<br />";
             }
       }
       fclose($file);
       return $info;
    }

  }
}

?>