<?php
/**
* @version $Id: backup.ebackup.php 2006-06-05 23:00
* @package eBackup
* @copyright Copyright (C) 2006 by Mambobaer.de. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined('_VALID_MOS') or die('Restricted access');

DEFINE ('MAX_LINE_LENGTH',65536);
DEFINE ('_BACKUP_VERSION', "1.0.0");
DEFINE ('_BACKUP_PATH', $mosConfig_absolute_path."/administrator/backups/");

  function josGetBrowser( $agent ) {
    global $mosConfig_absolute_path;

    require($mosConfig_absolute_path.'/includes/agent_browser.php');

    if (preg_match( "/msie[\/\sa-z]*([\d\.]*)/i", $agent, $m )
       && !preg_match( "/webtv/i", $agent )
       && !preg_match( "/omniweb/i", $agent )
       && !preg_match( "/opera/i", $agent )) {
       // IE
       return "MS Internet Explorer $m[1]";
    } else if (preg_match( "/netscape.?\/([\d\.]*)/i", $agent, $m )) {
       // Netscape 6.x, 7.x ...
       return "Netscape $m[1]";
    } else if ( preg_match( "/mozilla[\/\sa-z]*([\d\.]*)/i", $agent, $m )
       && !preg_match( "/gecko/i", $agent )
       && !preg_match( "/compatible/i", $agent )
       && !preg_match( "/opera/i", $agent )
       && !preg_match( "/galeon/i", $agent )
       && !preg_match( "/safari/i", $agent )) {
       // Netscape 3.x, 4.x ...
       return "Netscape $m[1]";
    } else {
       // Other
       $found = false;
       foreach ($browserSearchOrder as $key) {
               if (preg_match( "/$key.?\/([\d\.]*)/i", $agent, $m )) {
                  $name = "$browsersAlias[$key] $m[1]";
                  return $name;
                  break;
               }
       }
    }
    return 'Unknown';
  }

  function josGetOS( $agent ) {
    global $mosConfig_absolute_path;
    require($mosConfig_absolute_path.'/includes/agent_os.php');

    foreach ($osSearchOrder as $key) {
            if (preg_match( "/$key/i", $agent )) {
               return $osAlias[$key];
               break;
            }
    }

    return 'Unknown';
  }

  function ebackup_log(&$BackupStats, $id, $log){
    global $database;

    $sql = "INSERT INTO `#__ebackup_log` ( `id` , `time` , `job_id` , `ip` , `host` , `agent` , `log` ) VALUES ('', '".strftime("%Y-%m-%d %H:%M:%S", time())."', '$id', '$BackupStats->IPAddress', '$BackupStats->Host', '$BackupStats->UserAgent', '$log');";
    $database->setQuery($sql);
    $database->query();
  }

  function lock ($path, $lock, $tries){
    $lock0 = "{$path}/.{$lock}0";
    $lock1 = "{$path}/.{$lock}1";
    if (file_exists($lock0) && (filemtime($lock0) <= (time()-300))){
       unlock($path, $lock);
    }
    for ($i = 0; $i < $tries; $i++) {
        if (!is_file($lock0)){
           touch($lock0);
           if (!is_file($lock1)) {
              touch($lock1);
              return TRUE;
           }
        }
        usleep(100);
    }
    return FALSE;
  }

  function unlock ($path, $lock){
    unlink("{$path}/.{$lock}1");
    unlink("{$path}/.{$lock}0");
  }

  function checkVersions($job_id, $version_count){
    global $mosConfig_absolute_path;

    $dirname = $mosConfig_absolute_path."/administrator/backups";
    $versions = getBackupVersions($dirname, $job_id);
    if (is_array($versions)){
       if ( count($versions) >= $version_count){
          for ($i = ($version_count-1); $i < count($versions); $i++){
              @unlink($dirname."/".$versions[$i]);
          }
       }
    }
  }

  function getRemoteList($ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path, $job_id, $sort = false){
    global $mosConfig_db;

    $ret = "";
    $i   = 0;
    if ($conn_id = @ftp_connect($ftp_server, $ftp_port)){
       if ($login_result = @ftp_login($conn_id, $ftp_user, $ftp_passwd)){
          @ftp_pasv($conn_id, $ftp_pasv);
          if (!@ftp_chdir($conn_id, $ftp_path)){
             $ret = _BBKP_FTP_ERR_CHDIR;
          }
          if (!$dir = @ftp_pwd($conn_id)){
             $ret = _BBKP_FTP_ERR_PATH;
          }
          if (!$remote_files = @ftp_nlist($conn_id, "$dir")){
             $ret = _BBKP_FTP_ERR_LIST;
          }
          if (is_array($remote_files)){
             foreach ($remote_files as $remote_file){
                     if ((strstr($remote_file, "_JOBID".$job_id."_")) && (strstr($remote_file, $mosConfig_db))) $ret[] = $remote_file;
             }
          }else{
             $ret = _BBKP_NO_FILES;
          }
       }else{
          $ret = _BBKP_FTP_ERR_LOGON;
       }
    }else{
      $ret = _BBKP_FTP_ERR_CONN." &laquo;".$ftp_server."&raquo;";
    }
    if ((is_array($ret)) && ($sort)) rsort($ret);
    if (is_array($ret)){
       foreach ($ret as $file){
               $path_parts = pathinfo($file);
               $fileinfos[$i]['filename'] = $path_parts["basename"];
               $fileinfos[$i]['filesize'] = @ftp_size($conn_id, $file);
               $fileinfos[$i]['filedate'] = @ftp_mdtm($conn_id, $file);
               $i++;
       }
    }
    @ftp_close($conn_id);
    if (!is_array($ret)){
       if ($ret <> ""){
          $fileinfos = $ret;
       }else{
          $fileinfos = _BBKP_NO_FILES;
       }
    }
    return $fileinfos;
  }

  function checkFTPVersions($SQLFile, $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path, $job_id, $version_count){
    $ret = NULL;
    if ($conn_id = @ftp_connect($ftp_server, $ftp_port)){
       if ($login_result = @ftp_login($conn_id, $ftp_user, $ftp_passwd)){
          @ftp_pasv($conn_id, $ftp_pasv);
          if (!@ftp_chdir($conn_id, $ftp_path)){
             $ret = _BBKP_FTP_ERR_CHDIR;
          }
          if (!$dir = @ftp_pwd($conn_id)){
             $ret = _BBKP_FTP_ERR_PATH;
          }
          if (!$remote_files = @ftp_nlist($conn_id, "$dir")){
             $ret = _BBKP_FTP_ERR_LIST;
          }
          if (is_array($remote_files)){
             foreach ($remote_files as $remote_file){
                     if (strstr($remote_file, "_JOBID".$job_id."_")) $del_files[] = $remote_file;
             }
             if (is_array($del_files)){
                rsort($del_files);
                if (count($del_files) >= $version_count){
                   for ($i = ($version_count-1); $i < count($del_files); $i++){
                       $path_parts = pathinfo($del_files[$i]);
                       if(!@ftp_delete($conn_id, $dir."/".$path_parts['basename'])){
                         $ret = _BBKP_FTP_ERR_DELETE;
                       }
                   }
                }
             }
          }
       }else{
          $ret = _BBKP_FTP_ERR_LOGON;
       }
       @ftp_close($conn_id);
    }else{
      $ret = _BBKP_FTP_ERR_CONN;
    }
    return $ret;
  }

  function transferFTP($SQLFile, $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path){
    $ret = NULL;
    if ($conn_id = @ftp_connect($ftp_server, $ftp_port)){
       if ($login_result = @ftp_login($conn_id, $ftp_user, $ftp_passwd)){
          @ftp_pasv($conn_id, $ftp_pasv);
          if (!@ftp_chdir($conn_id, $ftp_path)){
             $ret = _BBKP_FTP_ERR_CHDIR;
          }
          $check      = false;
          $path_parts = pathinfo($SQLFile);
          if (!$dest_file  = @ftp_pwd($conn_id)."/".$path_parts['basename']){
             $ret = _BBKP_FTP_ERR_PATH;
          }
          for ($i = 0; $i < 3; $i++){
              if (!$check) $check = @ftp_put($conn_id, $dest_file, $SQLFile, FTP_BINARY);
          }
          if (!$check){
            $ret = _BBKP_FTP_ERR_TRANS;
          }
          if (function_exists("ftp_close")) @ftp_close($conn_id);
       }else{
          $ret = _BBKP_FTP_ERR_LOGON;
       }
       @ftp_close($conn_id);
    }else{
      $ret = _BBKP_FTP_ERR_CONN;
    }
    return $ret;
  }

  function deleteFTP($remote_file, $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path){
    global $mosConfig_absolute_path;

    $ret = NULL;
    if ($conn_id = @ftp_connect($ftp_server, $ftp_port)){
       if ($login_result = @ftp_login($conn_id, $ftp_user, $ftp_passwd)){
          @ftp_pasv($conn_id, $ftp_pasv);
          if (!@ftp_chdir($conn_id, $ftp_path)){
             $ret = _BBKP_FTP_ERR_CHDIR;
          }
          if (!$dir = @ftp_pwd($conn_id)){
             $ret = _BBKP_FTP_ERR_PATH;
          }
          if (!$del = @ftp_delete($conn_id, $dir."/".$remote_file)){
             $ret = _BBKP_FTP_ERR_PATH;
          }else{
             $ret = _BBKP_FTP_REMOTE_DEL;
          }
       }else{
          $ret = _BBKP_FTP_ERR_LOGON;
       }
       @ftp_close($conn_id);
    }else{
      $ret = _BBKP_FTP_ERR_CONN;
    }
    return $ret;
  }

  function downloadFTP($remote_file, $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path){
    global $mosConfig_absolute_path;

    $ret = NULL;
    if ($conn_id = @ftp_connect($ftp_server, $ftp_port)){
       if ($login_result = @ftp_login($conn_id, $ftp_user, $ftp_passwd)){
          @ftp_pasv($conn_id, $ftp_pasv);
          if (!@ftp_chdir($conn_id, $ftp_path)){
             $ret = _BBKP_FTP_ERR_CHDIR;
          }
          if (!$dir = @ftp_pwd($conn_id)){
             $ret = _BBKP_FTP_ERR_PATH;
          }
          if (!$down = @ftp_get($conn_id, $mosConfig_absolute_path."/administrator/backups/".$remote_file, $dir."/".$remote_file, FTP_BINARY)){
             $ret = _BBKP_FTP_ERR_PATH;
          }else{
             $ret = _BBKP_FTP_REMOTE_TRANS;
          }
       }else{
          $ret = _BBKP_FTP_ERR_LOGON;
       }
       @ftp_close($conn_id);
    }else{
      $ret = _BBKP_FTP_ERR_CONN;
    }
    return $ret;
  }

  function readBackupDir($dirname, $sort = false){
    $data_path = "";
    if ($dirhandle = opendir($dirname)){
       while (false !== ($dirfile = readdir($dirhandle))){
             if ($dirfile != "." && $dirfile != ".."){
                $path_parts = pathinfo($data_path."/".$dirfile);
                $file_ext = strtolower($path_parts["extension"]);
                if (($file_ext == "sql") || ($file_ext == "gz")) $filelist[] = $dirfile;
             }
       }
       if ((is_array($filelist)) && ($sort)) rsort($filelist);
       if (is_array($filelist)){
          $i = 0;
          foreach ($filelist as $file){
                  $fileinfos[$i]['filename'] = $file;
                  $fileinfos[$i]['filesize'] = filesize($dirname."/".$file);
                  $fileinfos[$i]['filedate'] = filemtime($dirname."/".$file);
                  $i++;
          }
       }
       return $fileinfos;
    }
  }

  function getBackupVersions($dirname, $job_id){
    if ($dirhandle = opendir($dirname)){
       while (false !== ($dirfile = readdir($dirhandle))){
             if ($dirfile != "." && $dirfile != ".."){
                $path_parts = pathinfo($dirname."/".$dirfile);
                $file_ext = strtolower($path_parts["extension"]);
                $file_bas = $path_parts["basename"];
                if ((($file_ext == "sql") || ($file_ext == "gz")) && (strstr($file_bas, "_JOBID".$job_id."_"))) $filelist[] = $dirfile;
             }
       }
       if (count($filelist) > 0) rsort($filelist);
       return $filelist;
    }
  }
  function mosGetMySQLVersionShort(){
    if (!function_exists("mysql_get_server_info")){
       $mysql_s=PMBP_I_NO_RES;
    }else{
       $mysql_s=@mysql_get_server_info();
    }
    $mysql_s = substr(str_replace(".", "", $mysql_s)."00000", 0, 5);
    return $mysql_s;
  }

  function mosGetSizes($size) {
    if ($size<1024)
       $size=number_format(Round($size,3), 0, ',', '.')." B";
    elseif ($size < 1048576)
       $size=number_format(Round($size/1024,3), 2, ',', '.')." KB";
    elseif ($size < 1073741824)
       $size=number_format(Round($size/1048576,3), 2, ',', '.')." MB";
    elseif (1073741824 < $size)
       $size=number_format(Round($size/1073741824,3), 2, ',', '.')." GB";
    elseif (1099511627776 < $size)
       $size=number_format(Round($size/1099511627776,3), 2, ',', '.')." TB";
    return $size;
  }

  function my_strrpos($haystack, $needle) {
    $index = strpos(strrev($haystack), strrev($needle));
    if($index === false) {
      return false;
    }
    $index = strlen($haystack) - strlen($needle) - $index;
    return $index;
  }

  function makeBody($item, $bkp_time, $tab_count, &$settings, $job_comment){

    $crlf          = "\r\n";
    $header        = "";
    $xstructure    = "";
    $xdrop         = "";
    $xexists       = "";
    $xautoinc      = "";
    $xfull_inserts = "";

    if ($settings->o_structure) $xstructure       = "x";
    if ($settings->o_drop) $xdrop                 = "x";
    if ($settings->o_exists) $xexists             = "x";
    if ($settings->o_autoinc) $xautoinc           = "x";
    if ($settings->o_full_inserts) $xfull_inserts = "x";
    $header.= "# ===============================================================$crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_HEAD_1."$crlf";
    $header.= "# http://www.mambobaer.de$crlf";
    $header.= "# "._BBKP_HEAD_4."$crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_HEAD_2." : $item $crlf";
    $header.= "# "._BBKP_HEAD_3." : ".strftime(_DATE_FORMAT_LC3, $bkp_time)."$crlf";
    $header.= "# "._BBKP_HEAD_7."           : $tab_count $crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_ENVIRONMENT."$crlf";
    $header.= "#   "._BBKP_SQL_SERVER."                : ".@mysql_get_server_info()."$crlf";
    $header.= "#   "._BBKP_SQL_CLIENT."                : ".@mysql_get_client_info()."$crlf";
    $header.= "#   "._BBKP_PHP_VERSION."                 : ".phpversion()."$crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_SETTINGS."$crlf";
    $header.= "#   "._BBKP_STRUCTURE.": [".$xstructure."]$crlf";
    $header.= "#   "._BBKP_DROP.": [".$xdrop."]$crlf";
    $header.= "#   "._BBKP_EXISTS.": [".$xexists."]$crlf";
    $header.= "#   "._BBKP_DB_AUTO_INC.": [".$xautoinc."]$crlf";
    $header.= "#   "._BBKP_DB_FULL_INSERTS.": [".$xfull_inserts."]$crlf";
    $header.= "#   "._BBKP_DB_COMP.": ".$settings->o_sql_compat."$crlf";
    if ($job_comment <> ""){
       $header.= "# $crlf";
       $header.= "# "._BBKP_COMMENTS.":$crlf";
       $header.= "#   ".wordwrap(str_replace($crlf, " ", $job_comment), 65, "\r\n#   ").$crlf;
    }
    $header.= "# $crlf";
    $header.= "# ===============================================================$crlf$crlf";
    return $header;
  }

  function makeHeaderTableDefJob($item, $bkp_time, &$SQLDump, $tab_count, $job_name, &$settings, $job_comment){

    $crlf          = "\r\n";
    $header        = "";
    $xstructure    = "";
    $xdrop         = "";
    $xexists       = "";
    $xautoinc      = "";
    $xfull_inserts = "";

    if ($settings->o_structure) $xstructure       = "x";
    if ($settings->o_drop) $xdrop                 = "x";
    if ($settings->o_exists) $xexists             = "x";
    if ($settings->o_autoinc) $xautoinc           = "x";
    if ($settings->o_full_inserts) $xfull_inserts = "x";
    $header.= "# ===============================================================$crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_HEAD_1."$crlf";
    $header.= "# http://www.mambobaer.de$crlf";
    $header.= "# "._BBKP_HEAD_4."$crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_HEAD_2." : $item $crlf";
    $header.= "# "._BBKP_HEAD_3." : ".strftime(_DATE_FORMAT_LC3, $bkp_time)."$crlf";
    $header.= "# "._BBKP_HEAD_7."           : $tab_count $crlf";
    $header.= "# "._BBKP_HEAD_8."           : $job_name $crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_ENVIRONMENT."$crlf";
    $header.= "#   "._BBKP_SQL_SERVER."                : ".@mysql_get_server_info()."$crlf";
    $header.= "#   "._BBKP_SQL_CLIENT."                : ".@mysql_get_client_info()."$crlf";
    $header.= "#   "._BBKP_PHP_VERSION."                 : ".phpversion()."$crlf";
    $header.= "# $crlf";
    $header.= "# "._BBKP_SETTINGS."$crlf";
    $header.= "#   "._BBKP_STRUCTURE.": [".$xstructure."]$crlf";
    $header.= "#   "._BBKP_DROP.": [".$xdrop."]$crlf";
    $header.= "#   "._BBKP_EXISTS.": [".$xexists."]$crlf";
    $header.= "#   "._BBKP_DB_AUTO_INC.": [".$xautoinc."]$crlf";
    $header.= "#   "._BBKP_DB_FULL_INSERTS.": [".$xfull_inserts."]$crlf";
    $header.= "#   "._BBKP_DB_COMP.": ".$settings->o_sql_compat."$crlf";
    if ($job_comment <> ""){
       $header.= "# $crlf";
       $header.= "# "._BBKP_COMMENTS.":$crlf";
       $header.= "#   ".wordwrap(str_replace($crlf, " ", $job_comment), 65, "\r\n#   ").$crlf;
    }
    $header.= "# $crlf";
    $header.= "# ===============================================================$crlf$crlf";
    $SQLDump->writeFile($header);
  }

  function makeTableDef($base, $table, &$SQLDump, &$settings){
    global $database;
    $crlf="\r\n";

    $create = "";
    if ((mosGetMySQLVersionShort() >= 40100) && ($settings->o_sql_compat != 'NONE')) {
        $database->setQuery('SET @@SESSION.SQL_MODE="'.$settings->o_sql_compat.'"');
        $database->Query();
    }

    $result = $database->setQuery("SHOW CREATE TABLE `".$table."`");
    $rows   = $database->loadrow();
    $create_query = $rows[1];

    if (strpos($create_query, "(\r\n ")) {
       $create_query = str_replace("\r\n", $crlf, $create_query);
    }elseif (strpos($create_query, "(\n ")) {
       $create_query = str_replace("\n", $crlf, $create_query);
    }elseif (strpos($create_query, "(\r ")) {
       $create_query = str_replace("\r", $crlf, $create_query);
    }

    if ($settings->o_drop != "") {
       $create = "DROP TABLE IF EXISTS `".$table."`;".$crlf;
    }else{
       $create = "";
    }
    if (!strpos($create_query, "CREATE TABLE")){
      if ($settings->o_exists != "") {
         $create.= str_replace("CREATE TABLE", "CREATE TABLE IF NOT EXISTS", $create_query);
      }else{
         $create.= $create_query;
      }
    }else{
       $create.= $create_query;
    }

    $result = $database->setQuery("SHOW TABLE STATUS FROM `".$base."` LIKE '".$table."'");
    $stats  = $database->loadObjectList();
    $stat   = $stats[0];
    $auto_inc = $stat->Auto_increment;
    if (($stat->Auto_increment != "") && ($settings->o_autoinc)){
       $create.= " AUTO_INCREMENT=".$stat->Auto_increment.";".$crlf.$crlf;
    }else{
       $create.=";".$crlf.$crlf;
    }

    $header = "# ===============================================================$crlf"
             ."# $crlf"
             ."# "._BBKP_HEAD_5." `$table` $crlf"
             ."# $crlf"
             ."# ===============================================================$crlf$crlf";
    $SQLDump->writeFile($header.$create);
  }

  function makeTableContent($table, &$rec_no, &$SQLDump, $startTime, &$settings){
    global $database;

    $crlf="\r\n";
    if ($rec_no == 0){
       $header = "# ===============================================================$crlf"
                ."# $crlf"
                ."# "._BBKP_HEAD_6." `$table $crlf"
                ."# $crlf"
                ."# ===============================================================$crlf$crlf";
       $SQLDump->writeFile($header);
    }

    $sql = "SELECT * FROM ".$table;
    $database->setQuery($sql);
    $result = $database->query();

    if ($rec_no <> 0){
        $rec_i = 1;
        while ($row = mysql_fetch_assoc($result)){
              if ($rec_i == $rec_no) break;
              $rec_i++;
        }
    }
    $num        = "";
    $time_limit = true;
    while ($row = mysql_fetch_assoc($result)){
          $rec_no++;

          if ($settings->o_full_inserts) {
             $item_list = $num."(";
             foreach ($row as $col => $value) {
                     $item_list.= "`".mysql_escape_string($col)."`, ";
             }
             $item_list = substr($item_list, 0, -2);
             $item_list.= ")";
             $insert = "INSERT INTO `$table` $item_list VALUES (";
          } else{
             $insert = "INSERT INTO `$table` VALUES (";
          }
          $data = "";
          foreach ($row as $value) {
                if (!isset($value)) {
                   $data.= " NULL,";
                } elseif ($value != "") {
                   $data.= " '".mysql_escape_string($value)."',";
                } else {
                   $data.= " '',";
                }
          }
          $insert.= ereg_replace(",$", "", $data);
          $insert.= ");".$crlf;
          $SQLDump->writeFile($insert);
          $checkTime = mosProfiler::getmicrotime();
          if (($checkTime - $startTime) >= $settings->o_run_time){
             $_SESSION['table']  = $table;
             $_SESSION['rec_no'] = $rec_no;
             $time_limit = false;
             break;
          }
    }
    if ($time_limit){
       $SQLDump->writeFile($crlf);
       $_SESSION['rec_no'] = 0;
       $rec_no             = 0;
    }
    return $time_limit;
  }

?>