<?php
/**
* @version $Id: admin.ebackup.php 2006-06-05 23:00
* @package eBackup
* @copyright Copyright (C) 2006 by Mambobaer.de. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined('_VALID_MOS') or die('Restricted access');

// ensure user has access to this function
if (!($acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'all' )| $acl->acl_check( 'administration', 'edit', 'users', $my->usertype, 'components', 'com_ebackup' ))){
   mosRedirect( 'index2.php', _NOT_AUTH );
}

require_once($mainframe->getPath('admin_html'));
require_once ($mosConfig_absolute_path."/administrator/components/com_ebackup/class.ebackup.php");
require_once ($mosConfig_absolute_path."/administrator/components/com_ebackup/backup.ebackup.php");

//Get right Language file
if (file_exists($mosConfig_absolute_path.'/administrator/components/com_ebackup/language/'.$mosConfig_lang.'.php')) {
  include($mosConfig_absolute_path.'/administrator/components/com_ebackup/language/'.$mosConfig_lang.'.php');
} else {
  include($mosConfig_absolute_path.'/administrator/components/com_ebackup/language/english.php');
}

//include configuration file
if (file_exists($mosConfig_absolute_path.'/administrator/components/com_ebackup/config.ebackup.php')) {
  include($mosConfig_absolute_path.'/administrator/components/com_ebackup/config.ebackup.php');
} else {
  die ("Error finding configuration file (".$mosConfig_absolute_path."/administrator/components/com_ebackup/config.ebackup.php)");
}

if ($task<>'') {
    $func = $task;
} elseif ($act<>'') {
    $func = $act;
} else {
  $act = mosGetParam( $_REQUEST, 'act', "" );
  if ($act<>'') {
    $func = $act;
  } else {
    $func = '';
  }
}

switch ($func) {
       case 'doBackup':
           executeBackup($option);
           break;
       case 'createBackup':
           createBackup($option);
           break;
       case 'doCheck':
           checkDatabase($option, $func);
           break;
       case 'doAnalyze':
           checkDatabase($option, $func);
           break;
       case 'doOptimize':
           checkDatabase($option, $func);
           break;
       case 'doRepair':
           checkDatabase($option, $func);
           break;
       case 'doRestore':
           doRestore($option, $func);
           break;
       case 'viewTables':
           viewTables($option);
           break;
       case 'viewRepository':
           viewRepository($option);
           break;
       case 'viewSetup':
           viewSetup($option);
           break;
       case 'saveSettings':
           saveSettings($option);
           break;
       case 'viewInfo':
           viewInfo($option);
           break;
       case 'viewScheduler':
           viewScheduler($option);
           break;
       case 'cancel':
           viewScheduler($option);
           break;
       case 'editJob':
           editJob($option, true);
           break;
       case 'newJob':
           editJob($option, false);
           break;
       case 'delJobs':
           delJobs($option);
           break;
       case 'activateJob':
           activateJob($option);
           break;
       case 'delete':
           del_file($option);
           break;
       case 'save':
           saveJob($option);
           break;
       case 'viewLog':
           viewLog($option);
           break;
       case 'deleteRemote':
           deleteRemote($option);
           break;
       case 'downloadRemote':
           downloadRemote($option);
           break;
       case 'clearLog':
           clearLog($option);
           break;
       case 'executeJob':
           executeJob($option);
           break;
       case 'downloadDump':
           downloadDump($option);
           break;
       default:
           viewRepository($option);
           break;
}

  function downloadDump($option){
    global $mosConfig_absolute_path;

    $file = mosGetParam($_REQUEST, 'file', '');

    if ($file <> ""){
       $downloader = new Dump_File($mosConfig_absolute_path."/administrator/backups", $file);
       $downloader->download();
       die;
    }
  }

  function deleteRemote($option){
    global $database,
           $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path;

    $remote_file  = mosGetParam($_REQUEST, 'file', '');
    $selected_job = mosGetParam($_REQUEST, 'filter_remote_files', '0');
    if ($selected_job <> 0){
       if ($selected_job == -1){
          $msg = deleteFTP($remote_file, $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path);
       }else{
          $sql = "SELECT * FROM `#__ebackup_scheduler` WHERE `id` = '".$selected_job."'";
          $database->setQuery($sql);
          $database ->loadObject($job);
          $msg = deleteFTP($remote_file, $job->ftp_srv, $job->ftp_pasv, $job->ftp_port, $job->ftp_user, $job->ftp_pw, $job->ftp_path);
       }
    }

    mosRedirect("index2.php?option=$option&amp;filter_remote_files=$selected_job", $msg);
  }

  function downloadRemote($option){
    global $database, $mosConfig_absolute_path,
           $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path;

    $remote_file  = mosGetParam($_REQUEST, 'file', '');
    $selected_job = mosGetParam($_REQUEST, 'filter_remote_files', '0');
    if ($selected_job <> 0){
       if ($selected_job == -1){
          $msg = downloadFTP($remote_file, $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path);
       }else{
          $sql = "SELECT * FROM `#__ebackup_scheduler` WHERE `id` = '".$selected_job."'";
          $database->setQuery($sql);
          $database ->loadObject($job);
          $msg = downloadFTP($remote_file, $job->ftp_srv, $job->ftp_pasv, $job->ftp_port, $job->ftp_user, $job->ftp_pw, $job->ftp_path);
       }
    }

    mosRedirect("index2.php?option=$option&amp;filter_remote_files=$selected_job", $msg);
  }

  function clearLog($option){
    global $database;

    if (is_array($_POST['log_list'])){
       foreach ($_POST['log_list'] as $del_log_id){
               $database->setQuery("DELETE FROM `#__ebackup_log` WHERE `id` = $del_log_id");
               $database->query();
       }
    }
    mosRedirect("index2.php?option=$option&amp;task=viewLog", "");
  }

  function executeJob($option){

    if (is_array($_POST['job_list'])){
       foreach ($_POST['job_list'] as $job_id){
               executeSchedJob($job_id);
       }
    }
    mosRedirect("index2.php?option=$option&amp;task=viewScheduler", "");
  }

  function viewLog($option){
    global $database;

    $log_entries  = "";
    $selected_job = mosGetParam($_REQUEST, 'filter_jobs', '0');
    $database->setQuery("SELECT `id` , `job_name` FROM `#__ebackup_scheduler` ORDER BY `id` ASC");
    $jobs = $database -> loadObjectList();
    $temp_jobs[] = mosHTML::makeOption(0, _BBKP_LOG_ALL);
    if (count($jobs) <> 0) {
       foreach($jobs as $job){
              $temp_jobs[] = mosHTML::makeOption($job->id, $job->job_name);
       }
    }
    $lists['jobs'] = mosHTML::selectList($temp_jobs, 'filter_jobs', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $selected_job);

    if ($selected_job <> '0'){
       $sql = "SELECT #__ebackup_log.*, #__ebackup_scheduler.job_name FROM #__ebackup_log "
             ."LEFT JOIN #__ebackup_scheduler ON #__ebackup_log.job_id=#__ebackup_scheduler.id WHERE #__ebackup_log.job_id=".$selected_job." ORDER BY #__ebackup_log.id DESC";
    }else{
       $sql = "SELECT #__ebackup_log.*, #__ebackup_scheduler.job_name FROM #__ebackup_log "
             ."LEFT JOIN #__ebackup_scheduler ON #__ebackup_log.job_id=#__ebackup_scheduler.id ORDER BY #__ebackup_log.id DESC";
    }

    $database->setQuery($sql);
    $logs = $database->loadObjectList();
    $i    = 0;
    if (count($logs) > 0){
       foreach ($logs as $log){
                $my_time = strftime(_BBKP_DATE_FORMAT_LC3, strtotime($log->time));
                $browser = josGetBrowser($log->agent);
                $os      = josGetOS($log->agent);
                $log_entries.= "<tr class=\"row0\">\n"
                              ."  <td width=\"1%\"><input type=\"checkbox\" id=\"cb".$i++."\" name=\"log_list[]\" value=\"".$log->id."\" onclick=\"isChecked(this.checked);\" /></td>\n"
                              ."  <td align=\"left\" style=\"white-space: nowrap;\">".$my_time."</td>\n"
                              ."  <td align=\"left\" style=\"white-space: nowrap;\">".$log->ip."</td>\n"
                              ."  <td align=\"left\" style=\"white-space: nowrap;\">".$log->host."</td>\n"
                              ."  <td align=\"left\" style=\"white-space: nowrap;\">".$browser."</td>\n"
                              ."  <td align=\"left\" style=\"white-space: nowrap;\">".$os."</td>\n"
                              ."  <td align=\"left\" style=\"white-space: nowrap;\">".$log->job_name."</td>\n"
                              ."  <td align=\"left\">".$log->log."</td>\n"
                              ."</tr>\n";
       }
    }else{
       $log_entries = "<tr class=\"row0\">\n"
                     ."  <td colspan=\"8\" align=\"center\">"._BBKP_NO_LOGS."</td>\n"
                     ."</tr>\n";
    }
    HTML_eBackup::showLog($option, $log_entries, &$lists, count($logs));
  }

  function activateJob($option){
    global $database;

    $job_id = mosGetParam($_REQUEST, 'id', '');

    $sql = "SELECT * FROM `#__ebackup_scheduler` WHERE `id`=".$job_id;
    $database->setQuery($sql);
    $database->loadObject($job);
    if ($job->state == 1){
       $job_state = 0;
       $msg       = _BBKP_JOB_DEACTIVATED;
    }else{
       $job_state = 1;
       $msg       = _BBKP_JOB_ACTIVATED;
    }

    $sql = "UPDATE `#__ebackup_scheduler` SET `state`= '$job_state' WHERE `id` = $job_id";
    $database->setQuery($sql);
    $database->query();

    mosRedirect("index2.php?option=$option&task=viewScheduler", $msg);
  }

  function delJobs($option){
    global $database;

    $jobs = mosGetParam($_REQUEST, 'job_list', '');
    if (count($jobs) > 0){
       foreach ($jobs as $job){
               $sql = "DELETE FROM `#__ebackup_scheduler` WHERE `id` = $job";
               $database->setQuery($sql);
               $database->query();
       }
    }
    mosRedirect("index2.php?option=$option&task=viewScheduler", "Job(s) deleted!");
  }

  function saveJob($option){
     global $database;

     $job_id          = mosGetParam($_REQUEST, 'id', '');
     $conf_tables     = mosGetParam($_REQUEST, 'tables', '');
     $conf_title      = mosGetParam($_REQUEST, 'frm_job_title', '');
     $conf_sched_type = mosGetParam($_REQUEST, 'frm_sched_type', '');
     $conf_versions   = mosGetParam($_REQUEST, 'frm_versions', '1');
     $conf_job_state  = mosGetParam($_REQUEST, 'frm_job_state', '0');
     $conf_auto_inc   = mosGetParam($_REQUEST, 'frm_autoinc', '0');
     $conf_gzip       = mosGetParam($_REQUEST, 'frm_gzip', '0');
     $conf_sql_compat = mosGetParam($_REQUEST, 'frm_sql_compat', '0');
     $conf_email      = mosGetParam($_REQUEST, 'frm_email', '');
     $conf_structure  = mosGetParam($_REQUEST, 'frm_structure', '0');
     $conf_drop       = mosGetParam($_REQUEST, 'frm_drop', '0');
     $conf_exists     = mosGetParam($_REQUEST, 'frm_exists', '0');
     $conf_fullinsert = mosGetParam($_REQUEST, 'frm_fullinserts', '0');
     $conf_ftp_server = mosGetParam($_REQUEST, 'frm_ftp_server', '');
     $conf_ftp_pasv   = mosGetParam($_REQUEST, 'frm_ftp_pasv', '0');
     $conf_ftp_port   = mosGetParam($_REQUEST, 'frm_ftp_port', '');
     $conf_ftp_user   = mosGetParam($_REQUEST, 'frm_ftp_user', '');
     $conf_ftp_passwd = mosGetParam($_REQUEST, 'frm_ftp_passwd', '');
     $conf_ftp_path   = mosGetParam($_REQUEST, 'frm_ftp_path', '');
     if (is_array($conf_tables)){
        $tables = implode(";", $conf_tables);
     }else{
        $tables = "";
     }
     if ($job_id == 0){
        $sql = "INSERT INTO `#__ebackup_scheduler` ( `id` , `job_name` , `state` , `tables` , `versions` , `schedule_type` , `last_run` , `structure` , `drop` , `exists` , `inc` , `inserts` , `compat` , `gzip` , `email` , `ftp_srv` , `ftp_pasv`, `ftp_port`, `ftp_user` , `ftp_pw` , `ftp_path` ) "
              ."VALUES ('', '$conf_title', '$conf_job_state', '$tables', '$conf_versions', '$conf_sched_type', NULL , '$conf_structure', '$conf_drop', '$conf_exists', '$conf_auto_inc', '$conf_fullinsert', '$conf_sql_compat', '$conf_gzip', '$conf_email', '$conf_ftp_server', '$conf_ftp_pasv', '$conf_ftp_port', '$conf_ftp_user', '$conf_ftp_passwd', '$conf_ftp_path');";
        $database->setQuery($sql);
        $database->query();
        mosRedirect("index2.php?option=$option&task=viewScheduler", "Job saved!");
     }else{
        $sql = "UPDATE `#__ebackup_scheduler` SET `job_name`= '$conf_title',`state`= '$conf_job_state',`tables`= '$tables',`versions`= '$conf_versions',`schedule_type`= '$conf_sched_type', `structure`= '$conf_structure', `drop`= '$conf_drop',"
              ."`exists`= '$conf_exists',`inc`='$conf_auto_inc',`inserts`= '$conf_fullinsert',`compat`= '$conf_sql_compat',`gzip`= '$conf_gzip',`email`= '$conf_email',`ftp_srv`= '$conf_ftp_server',`ftp_pasv`= '$conf_ftp_pasv',`ftp_port`= '$conf_ftp_port',`ftp_user`= '$conf_ftp_user',`ftp_pw`= '$conf_ftp_passwd',`ftp_path`= '$conf_ftp_path' WHERE `id` =$job_id";
        $database->setQuery($sql);
        $database->query();
        mosRedirect("index2.php?option=$option&task=viewScheduler", "Job saved!");
     }
  }

  function editJob($option, $edit = false){
    global $database, $tab_filter, $mosConfig_db, $mosConfig_dbprefix,
           $autoinc, $drop, $exists, $sql_compat, $gzip, $full_inserts, $tab_filter, $email,
           $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path, $structure;

    $table_list = "";
    $selected   = array();
    if ($ftp_port == "") $ftp_port = "21";
    $script_on = "document.adminForm.frm_email.readOnly = false;"
                ."document.adminForm.frm_ftp_server.readOnly = false;"
                ."document.adminForm.frm_ftp_port.readOnly = false;"
                ."document.adminForm.frm_ftp_user.readOnly = false;"
                ."document.adminForm.frm_ftp_passwd.readOnly = false;"
                ."document.adminForm.frm_ftp_path.readOnly = false;";

    $script_off= "document.adminForm.frm_email.readOnly = true;"
                ."document.adminForm.frm_ftp_server.readOnly = true;"
                ."document.adminForm.frm_ftp_port.readOnly = true;"
                ."document.adminForm.frm_ftp_user.readOnly = true;"
                ."document.adminForm.frm_ftp_passwd.readOnly = true;"
                ."document.adminForm.frm_ftp_path.readOnly = true;";

    $job_id = mosGetParam($_REQUEST, 'id', "");
    if (($job_id == "") && ($edit)){
       $job_id_a = mosGetParam($_REQUEST, 'job_list', "");
       $job_id   = $job_id_a[0];
    }

    if ($job_id <> 0){
       $sql = "SELECT * FROM `#__ebackup_scheduler` WHERE `id`=".$job_id;
       $database->setQuery($sql);
       $database->loadObject($job);
       $selected = explode(";", $job->tables);
       if ($edit){
          $structure    = $job->structure;
          $drop         = $job->drop;
          $exists       = $job->exists;
          $autoinc      = $job->inc;
          $full_inserts = $job->inserts;
          $sql_compat   = $job->compat;
          $gzip         = $job->gzip;
          $email        = $job->email;
          $ftp_server   = $job->ftp_srv;
          $ftp_pasv     = $job->ftp_pasv;
          $ftp_port     = $job->ftp_port;
          $ftp_user     = $job->ftp_user;
          $ftp_passwd   = $job->ftp_pw;
          $ftp_path     = $job->ftp_path;
          $state        = $job->state;
          $versions     = $job->versions;
          $schedule_type= $job->schedule_type;
          $job_name     = $job->job_name;
       }
    }else{
       $versions      = "0";
       $state         = "0";
       $schedule_type = "0";
       $job_name      = "";
    }

    $selections  = array ('NONE', 'ANSI', 'DB2', 'MAXDB', 'MSSQL', 'MYSQL323', 'MYSQL40', 'ORACLE', 'POSTGRESQL', 'TRADITIONAL');
    $sched_types = explode(";", _BBKP_SCHED_TYPE);

    foreach ($selections as $selection){
            $sql_comp_list[] = mosHTML::makeOption($selection , $selection);
    }
    $forms['sql_comp_list'] = mosHTML::selectList($sql_comp_list, 'frm_sql_compat', 'class="inputbox" size="1"', 'value', 'text', $sql_compat);

    $i = 0;
    foreach ($sched_types as $sched_type){
            $sched_types_tmp[] = mosHTML::makeOption($i++ , $sched_type);
    }
    $forms['sched_type'] = mosHTML::selectList($sched_types_tmp, 'frm_sched_type', 'class="inputbox" size="1"', 'value', 'text', $schedule_type);

    $forms['job_title']  = "<input type=\"text\" size=\"35\" id=\"frm_job_title\" name=\"frm_job_title\" value=\"".$job_name."\" />";
    if (!$state){
       $forms['job_state'] = "<input type=\"checkbox\" id=\"frm_job_state\" name=\"frm_job_state\" value=\"1\" />";
    }else{
       $forms['job_state'] = "<input type=\"checkbox\" id=\"frm_job_state\" name=\"frm_job_state\" value=\"1\" checked />";
    }
    $forms['versions']  = "<input type=\"text\" size=\"3\" maxlength=\"2\" id=\"frm_versions\" name=\"frm_versions\" value=\"".$versions."\" />";
    if (!$structure){
       $forms['structure'] = "<input type=\"checkbox\" id=\"frm_structure\" name=\"frm_structure\" value=\"1\" />";
    }else{
       $forms['structure'] = "<input type=\"checkbox\" id=\"frm_structure\" name=\"frm_structure\" value=\"1\" checked />";
    }
    if (!$drop){
       $forms['drop'] = "<input type=\"checkbox\" id=\"frm_drop\" name=\"frm_drop\" value=\"1\" />";
    }else{
       $forms['drop'] = "<input type=\"checkbox\" id=\"frm_drop\" name=\"frm_drop\" value=\"1\" checked />";
    }
    if (!$exists){
       $forms['exists'] = "<input type=\"checkbox\" id=\"frm_exists\" name=\"frm_exists\" value=\"1\" />";
    }else{
       $forms['exists'] = "<input type=\"checkbox\" id=\"frm_exists\" name=\"frm_exists\" value=\"1\" checked />";
    }
    if (!$autoinc){
       $forms['autoinc'] = "<input type=\"checkbox\" id=\"frm_autoinc\" name=\"frm_autoinc\" value=\"1\" />";
    }else{
       $forms['autoinc'] = "<input type=\"checkbox\" id=\"frm_autoinc\" name=\"frm_autoinc\" value=\"1\" checked />";
    }
    if (!$full_inserts){
       $forms['fullinserts'] = "<input type=\"checkbox\" id=\"frm_fullinserts\" name=\"frm_fullinserts\" value=\"1\" />";
    }else{
       $forms['fullinserts'] = "<input type=\"checkbox\" id=\"frm_fullinserts\" name=\"frm_fullinserts\" value=\"1\" checked />";
    }
    if (!$gzip){
       $forms['gzip'] = "<input type=\"checkbox\" id=\"frm_gzip\" name=\"frm_gzip\" value=\"1\" onclick=\"javascript: if(document.adminForm.frm_gzip.checked){".$script_on."}else{".$script_off."} \" />";
    }else{
       $forms['gzip'] = "<input type=\"checkbox\" id=\"frm_gzip\" name=\"frm_gzip\" value=\"1\" onclick=\"javascript: if(document.adminForm.frm_gzip.checked){".$script_on."}else{".$script_off."} \" checked />";
    }
    if (!$ftp_pasv){
       $forms['ftp_pasv'] = "<input type=\"checkbox\" id=\"frm_ftp_pasv\" name=\"frm_ftp_pasv\" value=\"1\" />";
    }else{
       $forms['ftp_pasv'] = "<input type=\"checkbox\" id=\"frm_ftp_pasv\" name=\"frm_ftp_pasv\" value=\"1\" checked />";
    }
    if (!$gzip){
       $forms['email']      = "<input type=\"text\" size=\"35\" id=\"frm_email\" name=\"frm_email\" value=\"$email\" readonly />";
       $forms['ftp_server'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_server\" name=\"frm_ftp_server\" value=\"$ftp_server\" readonly />";
       $forms['ftp_port']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_port\" name=\"frm_ftp_port\" value=\"$ftp_port\" readonly />";
       $forms['ftp_user']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_user\" name=\"frm_ftp_user\" value=\"$ftp_user\" readonly />";
       $forms['ftp_passwd'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_passwd\" name=\"frm_ftp_passwd\" value=\"$ftp_passwd\" readonly />";
       $forms['ftp_path']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_path\" name=\"frm_ftp_path\" value=\"$ftp_path\" readonly />";
    }else{
       $forms['email']      = "<input type=\"text\" size=\"35\" id=\"frm_email\" name=\"frm_email\" value=\"$email\" />";
       $forms['ftp_server'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_server\" name=\"frm_ftp_server\" value=\"$ftp_server\" />";
       $forms['ftp_port']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_port\" name=\"frm_ftp_port\" value=\"$ftp_port\" />";
       $forms['ftp_user']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_user\" name=\"frm_ftp_user\" value=\"$ftp_user\" />";
       $forms['ftp_passwd'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_passwd\" name=\"frm_ftp_passwd\" value=\"$ftp_passwd\" />";
       $forms['ftp_path']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_path\" name=\"frm_ftp_path\" value=\"$ftp_path\" />";
    }

    if ($tab_filter){
       $sql = "SHOW TABLE STATUS FROM `".$mosConfig_db."` LIKE '".$mosConfig_dbprefix."%'";
    }else{
       $sql = "SHOW TABLE STATUS FROM `".$mosConfig_db."`";
    }
    $database->setQuery($sql);
    $tables = $database->loadObjectList();

    $i = 0;
    foreach($tables as $table){
      reset($selected);
      if (!in_array($table->Name, $selected)){
         $checkbox = "<input type=\"checkbox\" id=\"cb".$i++."\" name=\"tables[]\" value=\"".$table->Name."\" onclick=\"isChecked(this.checked);\" />";
      }else{
         $checkbox = "<input type=\"checkbox\" id=\"cb".$i++."\" name=\"tables[]\" value=\"".$table->Name."\" onclick=\"isChecked(this.checked);\" checked />";
      }
      $table_list.= "<tr>\n"
                   ."  <td width=\"1%\">".$checkbox."</td>\n"
                   ."  <td>".$table->Name."</td>\n"
                   ."  <td align=\"right\" width=\"3%\" style=\"white-space: nowrap;\">".number_format($table->Rows, 0, ',', '.')."</td>\n"
                   ."  <td align=\"right\" width=\"3%\" style=\"white-space: nowrap;\">".mosGetSizes($table->Data_length)."</td>\n"
                   ."</tr>\n";
    }
    HTML_eBackup::showEditJob($option, $table_list, $i, $forms, $job_id);
  }

  function viewScheduler($option){
    global $database;

    $list = "";
    $sql  = "SELECT * FROM `#__ebackup_scheduler`";
    $database->setQuery($sql);
    $jobs = $database->loadObjectList();
    if ($jobs){
       $i = 0;
       foreach ($jobs as $job){
               $sched_types = explode(";", _BBKP_SCHED_TYPE);
               if ($job->tables <> ""){
                  $tables = explode(";", $job->tables);
                  if (is_array($tables)) $tab_count = count($tables);
               }else{
                  $tab_count = 0;
               }
               $link = "<a href=\"index2.php?option=com_ebackup&amp;task=editJob&amp;id=$job->id\">".$job->job_name."</a>\n";
               if ($job->state){
                  $activate = "<a href=\"index2.php?option=com_ebackup&amp;task=activateJob&amp;id=$job->id\"><img src=\"components/com_ebackup/images/active.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_JOB_DEACTIVATE."\" title=\""._BBKP_JOB_DEACTIVATE."\" /></a>\n";
               }else{
                  $activate = "<a href=\"index2.php?option=com_ebackup&amp;task=activateJob&amp;id=$job->id\"><img src=\"components/com_ebackup/images/inactive.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_JOB_ACTIVATE."\" title=\""._BBKP_JOB_ACTIVATE."\" /></a>\n";
               }
               if ($job->last_run != NULL){
                  $last_run = strftime(_BBKP_DATE_FORMAT_LC3, strtotime($job->last_run));
               }else{
                  $last_run = "--.--.---- --:--:--";
               }
               if ($job->structure){
                  $structure = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $structure = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               if ($job->drop){
                  $drop = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $drop = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               if ($job->exists){
                  $exists = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $exists = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               if ($job->inc){
                  $auto_inc = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $auto_inc = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               if ($job->inserts){
                  $inserts = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $inserts = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               if ($job->gzip){
                  $gzip = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $gzip = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               if ($job->email <> ""){
                  $email = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $email = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               if ($job->ftp_srv <> ""){
                  $ftp = "<img src=\"images/tick.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }else{
                  $ftp = "<img src=\"images/publish_x.png\" width=\"12\" height=\"12\" border=\"0\" alt=\"\" />\n";
               }
               $list.= "<tr class=\"row0\">\n"
                      ."  <td width=\"1%\"><input type=\"checkbox\" id=\"cb".$i++."\" name=\"job_list[]\" value=\"".$job->id."\" onclick=\"isChecked(this.checked);\" /></td>\n"
                      ."  <td align=\"center\">".$activate."</td>\n"
                      ."  <td align=\"left\" style=\"white-space: nowrap;\">".$link."</td>\n"
                      ."  <td align=\"center\" style=\"white-space: nowrap;\">".$job->compat."</td>\n"
                      ."  <td align=\"center\">".$structure."</td>\n"
                      ."  <td align=\"center\">".$drop."</td>\n"
                      ."  <td align=\"center\">".$exists."</td>\n"
                      ."  <td align=\"center\">".$auto_inc."</td>\n"
                      ."  <td align=\"center\">".$inserts."</td>\n"
                      ."  <td align=\"center\">".$gzip."</td>\n"
                      ."  <td align=\"center\">".$email."</td>\n"
                      ."  <td align=\"center\">".$ftp."</td>\n"
                      ."  <td align=\"center\">".$tab_count."</td>\n"
                      ."  <td align=\"center\">".$job->versions."</td>\n"
                      ."  <td align=\"center\">".$job->id."</td>\n"
                      ."  <td align=\"center\" style=\"white-space: nowrap;\">".$sched_types[$job->schedule_type]."</td>\n"
                      ."  <td align=\"center\" style=\"white-space: nowrap;\">".$last_run."</td>\n"
                      ."</tr>\n";
       }
    }else{
       $list = "<td align=\"center\" colspan=\"17\">"._BBKP_NO_JOBS."</td>\n";
    }
    HTML_eBackup::showScheduler($option, $list, $i);
  }

  function viewInfo($option){
    global $mosConfig_absolute_path;

    $SQLDump = new JFiler(false);

    $buffer = "";
    $info = "<div style=\"border: 1px solid #cccccc; padding: 5px; margin: 5px; font-family: COURIER NEW;\">";
    $info.= $SQLDump->getFileInfo(_BACKUP_PATH.$_REQUEST['file']);
    $info.= "</div>";

    HTML_eBackup::showInfo($option, $info);
  }

  function del_file($option){
    global $mosConfig_absolute_path;

    $data_path = $mosConfig_absolute_path."/administrator/backups/";
    $file      = mosGetParam( $_REQUEST, 'file', "" );
    unlink($data_path.$file);
    mosRedirect("index2.php?option=$option&task=viewRepository", _BBKP_TB_DELETE." "._BBKP_FTP_SUCCESS);
  }

  function viewTables($option){
    global $database, $mosConfig_db, $mosConfig_dbprefix, $tab_filter;

    $lists              = "";
    $stats_list['rows'] = 0;
    $stats_list['data'] = 0;
    $stats_list['over'] = 0;
    unset($_SESSION['tables']);
    unset($_SESSION['table']);
    unset($_SESSION['sql_file']);
    unset($_SESSION['rec_no']);
    unset($_SESSION['start_time']);

    if ($tab_filter){
       $sql = "SHOW TABLE STATUS FROM `".$mosConfig_db."` LIKE '".$mosConfig_dbprefix."%'";
    }else{
       $sql = "SHOW TABLE STATUS FROM `".$mosConfig_db."`";
    }
    $database->setQuery($sql);
    $table_lists = $database->loadObjectList();
    $i = 0;
    foreach($table_lists as $table){
       if ($table->Check_time != ""){
          $check_time = strftime(_BBKP_DATE_FORMAT_LC2, strtotime($table->Check_time));
       }else{
          $check_time = "";
       }
       $lists.= "<tr class=\"row0\">\n"
               ."<td width=\"1%\"><input type=\"checkbox\" id=\"cb".$i++."\" name=\"tables[]\" value=\"".$table->Name."\" onclick=\"isChecked(this.checked);\" /></td>\n"
               ."<td>".$table->Name."</td>\n"
               ."<td align=\"right\" style=\"white-space: nowrap;\">".number_format($table->Rows, 0, ',', '.')."</td>\n"
               ."<td align=\"right\" style=\"white-space: nowrap;\">".mosGetSizes($table->Data_length)."</td>\n"
               ."<td align=\"right\" style=\"white-space: nowrap;\">".mosGetSizes($table->Data_free)."</td>\n"
               ."<td align=\"right\">".number_format($table->Auto_increment, 0, ',', '.')."</td>\n"

               ."<td align=\"right\" style=\"white-space: nowrap;\">".strftime(_BBKP_DATE_FORMAT_LC2, strtotime($table->Create_time))."</td>\n"
               ."<td align=\"right\" style=\"white-space: nowrap;\">".$check_time."</td>\n"
               ."</tr>\n";
               $stats_list['rows'] = $stats_list['rows'] + $table->Rows;
               $stats_list['data'] = $stats_list['data'] + $table->Data_length;
               $stats_list['over'] = $stats_list['over'] + $table-> Data_free;
    }
    $stats_list['rows'] = number_format($stats_list['rows'], 0, ',', '.');
    $stats_list['data'] = mosGetSizes($stats_list['data']);
    $stats_list['over'] = mosGetSizes($stats_list['over']);
    HTML_eBackup::showTables($option, $lists, &$table_lists, $stats_list);
  }

  function viewRepository($option){
    global $database, $mosConfig_absolute_path, $mosConfig_db,
           $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path;

    $list = "";
    $sql  = "SELECT * FROM `#__ebackup_scheduler` WHERE `ftp_srv` != '' ORDER BY `id` ASC";
    $database->setQuery($sql);
    $jobs = $database->loadObjectList();

    $selected_job = mosGetParam($_REQUEST, 'filter_remote_files', '0');
    $temp_jobs[] = mosHTML::makeOption(0, _BBKP_JOB_REMOTE_LIST);
    if ($ftp_server <> ""){
       $temp_jobs[] = mosHTML::makeOption(-1, _BBKP_MANUALLY_FILE." (Remote)");
    }
    if (count($jobs) > 0) {
       foreach($jobs as $job){
              $temp_jobs[] = mosHTML::makeOption($job->id, $job->job_name);
       }
    }
    $lists['remote'] = mosHTML::selectList($temp_jobs, 'filter_remote_files', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', $selected_job);
    if ($selected_job <> 0){
       if ($selected_job == -1){
          $files = getRemoteList($ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path, 0, true);
       }else{
          $sql = "SELECT * FROM `#__ebackup_scheduler` WHERE `id` = '".$selected_job."'";
          $database->setQuery($sql);
          $database ->loadObject($job);
          $files = getRemoteList($job->ftp_srv, $job->ftp_pasv, $job->ftp_port, $job->ftp_user, $job->ftp_pw, $job->ftp_path, $job->id, true);
       }
    }else{
       $data_path = $mosConfig_absolute_path."/administrator/backups";
       $list = "";
       $files = readBackupDir($data_path, true);
    }

    if (is_array($files)){
       foreach ($files as $dirfile){
                if (strpos($dirfile['filename'], $mosConfig_db) === false){
                   $myFiles[_BBKP_UNKNOW_FILE][] = $dirfile;
                }else{
                   $last = substr($dirfile['filename'], strpos($dirfile['filename'], "_JOBID")+6);
                   $last = substr($last, 0, strpos($last, "_"));
                   if ($last == '0'){
                      $myFiles[_BBKP_MANUALLY_FILE][] = $dirfile;
                   }else{
                      $sql = "SELECT `id` , `job_name` FROM `#__ebackup_scheduler` WHERE `id`=".$last;
                      $database->setQuery($sql);
                      $res = $database->loadRow();
                      if ($res <> NULL){
                        $myFiles[$res[1]][] = $dirfile;
                      }else{
                         $myFiles[_BBKP_UNKNOW_FILE][] = $dirfile;
                      }
                   }
                }
       }

       while ($job_files = current($myFiles)){
             $list.= "<tr>\n"
                    ."  <td colspan=\"7\" style=\"background: url('components/com_ebackup/images/job_title.png');\"><b>".key($myFiles)." (".count($job_files).")</b></td>\n"
                    ."</tr>\n";
             foreach ($job_files as $job_file){
                     if ($selected_job <> 0){
                        $info_link = "<a href=\"javascript:if (confirm('Are you sure you want to download <".$job_file['filename']."> from remote FTP Server?')){ window.location.href='index2.php?option=$option&task=downloadRemote&amp;file=".$job_file['filename']."&amp;JobID=".$job->id."&amp;filter_remote_files=$selected_job';}\">\n"
                                    ."<img src=\"components/com_ebackup/images/ftp_download.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_FTP_DOWNLOAD."\" title=\""._BBKP_FTP_DOWNLOAD."\" /></a>";
                        $del_link  = "<a href=\"javascript:if (confirm('Are you sure you want to delete <".$job_file['filename']."> on remote FTP Server?')){ window.location.href='index2.php?option=$option&task=deleteRemote&amp;file=".$job_file['filename']."&amp;JobID=".$job->id."&amp;filter_remote_files=$selected_job';}\">\n"
                                    ."<img src=\"components/com_ebackup/images/delete.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_DEL."\" title=\""._BBKP_DEL."\" /></a>";
                        $download  = "<a href=\"ftp://".$job->ftp_user.":".$job->ftp_pw."@".$job->ftp_srv.":".$job->ftp_port."/".$job->ftp_path."/".$job_file['filename']."\">"
                                    ."<img src=\"images/filesave.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_DOWNLOAD."\" title=\""._BBKP_DOWNLOAD."\" /></a>";
                     }else{
                        $info_link = "<a href=\"index2.php?option=$option&amp;task=viewInfo&amp;file=".$job_file['filename']."\">"
                                    ."<img src=\"components/com_ebackup/images/info.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_SQL_INFO."\" title=\""._BBKP_SQL_INFO."\" /></a>";
                        $del_link  = "<a href=\"javascript:if (confirm('Are you sure you want to delete <".$job_file['filename']."> on Server?')){ window.location.href='index2.php?option=$option&task=delete&amp;file=".$job_file['filename']."';}\">\n"
                                    ."<img src=\"components/com_ebackup/images/delete.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_DEL."\" title=\""._BBKP_DEL."\" /></a>";
                        $download  = "<a href=\"index2.php?option=$option&amp;task=downloadDump&amp;file=".$job_file['filename']."\">"
                                    ."<img src=\"images/filesave.png\" width=\"16\" height=\"16\" border=\"0\" alt=\""._BBKP_DOWNLOAD."\" title=\""._BBKP_DOWNLOAD."\" /></a>";
                     }
                     $list.= "<tr class=\"row0\">\n"
                            ."  <td style=\"white-space: nowrap; text-align: right; padding-right: 0px;\" width=\"1%\"><input type=\"radio\" name=\"SQLFile\" value=\"".$job_file['filename']."\" onclick=\"isChecked(this.checked);\" /></td>\n"
                            ."  <td>".$job_file['filename']."</td>\n"
                            ."  <td align=\"right\" style=\"white-space: nowrap;\">".mosGetSizes($job_file['filesize'])."</td>\n"
                            ."  <td align=\"center\" style=\"white-space: nowrap;\">".strftime(_BBKP_DATE_FORMAT_LC2, $job_file['filedate'])."</td>\n"
                            ."  <td align=\"center\" style=\"white-space: nowrap;\">".$info_link."</td>\n"
                            ."  <td align=\"center\" style=\"white-space: nowrap;\">".$del_link."</td>\n"
                            ."  <td align=\"center\" style=\"white-space: nowrap;\">".$download."</td>\n"
                            ."</tr>\n";
             }
             next($myFiles);
       }
    }else{
       if ($selected_job <> 0){
          $list = "  <tr class=\"row0\"><td align=\"center\" colspan=\"8\" style=\"white-space: nowrap;\">".$files."</td></tr>\n";
       }else{
          $list = "  <tr class=\"row0\"><td align=\"center\" colspan=\"8\" style=\"white-space: nowrap;\">"._BBKP_NO_FILES."</td></tr>\n";
       }
    }
    HTML_eBackup::showRepository($option, $list, $lists);
  }

  function viewSetup($option){
    global $autoinc, $drop, $exists, $sql_compat, $gzip, $full_inserts, $tab_filter, $run_time, $delaypersession, $email,
           $ftp_server, $ftp_pasv, $ftp_port, $ftp_user, $ftp_passwd, $ftp_path, $structure, $comments;

    $selections = array ('NONE', 'ANSI', 'DB2', 'MAXDB', 'MSSQL', 'MYSQL323', 'MYSQL40', 'ORACLE', 'POSTGRESQL', 'TRADITIONAL');

    $script_on = "document.adminForm.frm_email.readOnly = false;"
                ."document.adminForm.frm_ftp_server.readOnly = false;"
                ."document.adminForm.frm_ftp_port.readOnly = false;"
                ."document.adminForm.frm_ftp_user.readOnly = false;"
                ."document.adminForm.frm_ftp_passwd.readOnly = false;"
                ."document.adminForm.frm_ftp_path.readOnly = false;";

    $script_off= "document.adminForm.frm_email.readOnly = true;"
                ."document.adminForm.frm_ftp_server.readOnly = true;"
                ."document.adminForm.frm_ftp_port.readOnly = true;"
                ."document.adminForm.frm_ftp_user.readOnly = true;"
                ."document.adminForm.frm_ftp_passwd.readOnly = true;"
                ."document.adminForm.frm_ftp_path.readOnly = true;";

    foreach ($selections as $selection){
            $sql_comp_list[] = mosHTML::makeOption($selection , $selection);
    }
    $forms['sql_comp_list'] = mosHTML::selectList($sql_comp_list, 'sql_compat', 'class="inputbox" size="1"', 'value', 'text', $sql_compat);
    if ($ftp_port == "") $ftp_port = "21";
    if (!$comments){
       $forms['comments'] = "<input type=\"checkbox\" id=\"frm_comments\" name=\"frm_comments\" value=\"1\" />";
    }else{
       $forms['comments'] = "<input type=\"checkbox\" id=\"frm_comments\" name=\"frm_comments\" value=\"1\" checked />";
    }
    if (!$structure){
       $forms['structure'] = "<input type=\"checkbox\" id=\"frm_structure\" name=\"frm_structure\" value=\"1\" />";
    }else{
       $forms['structure'] = "<input type=\"checkbox\" id=\"frm_structure\" name=\"frm_structure\" value=\"1\" checked />";
    }
    if (!$drop){
       $forms['drop'] = "<input type=\"checkbox\" id=\"frm_drop\" name=\"frm_drop\" value=\"1\" />";
    }else{
       $forms['drop'] = "<input type=\"checkbox\" id=\"frm_drop\" name=\"frm_drop\" value=\"1\" checked />";
    }
    if (!$exists){
       $forms['exists'] = "<input type=\"checkbox\" id=\"frm_exists\" name=\"frm_exists\" value=\"1\" />";
    }else{
       $forms['exists'] = "<input type=\"checkbox\" id=\"frm_exists\" name=\"frm_exists\" value=\"1\" checked />";
    }
    if (!$autoinc){
       $forms['autoinc'] = "<input type=\"checkbox\" id=\"frm_autoinc\" name=\"frm_autoinc\" value=\"1\" />";
    }else{
       $forms['autoinc'] = "<input type=\"checkbox\" id=\"frm_autoinc\" name=\"frm_autoinc\" value=\"1\" checked />";
    }
    if (!$full_inserts){
       $forms['fullinserts'] = "<input type=\"checkbox\" id=\"frm_fullinserts\" name=\"frm_fullinserts\" value=\"1\" />";
    }else{
       $forms['fullinserts'] = "<input type=\"checkbox\" id=\"frm_fullinserts\" name=\"frm_fullinserts\" value=\"1\" checked />";
    }
    if (!$gzip){
       $forms['gzip'] = "<input type=\"checkbox\" id=\"frm_gzip\" name=\"frm_gzip\" value=\"1\" onclick=\"javascript: if(document.adminForm.frm_gzip.checked){".$script_on."}else{".$script_off."} \" />";
    }else{
       $forms['gzip'] = "<input type=\"checkbox\" id=\"frm_gzip\" name=\"frm_gzip\" value=\"1\" onclick=\"javascript: if(document.adminForm.frm_gzip.checked){".$script_on."}else{".$script_off."} \" checked />";
    }
    if (!$tab_filter){
       $forms['tab_filter'] = "<input type=\"checkbox\" id=\"frm_tab_filter\" name=\"frm_tab_filter\" value=\"1\" />";
    }else{
       $forms['tab_filter'] = "<input type=\"checkbox\" id=\"frm_tab_filter\" name=\"frm_tab_filter\" value=\"1\" checked />";
    }
    $forms['run_time']   = "<input type=\"text\" size=\"5\" id=\"frm_run_time\" name=\"frm_run_time\" value=\"$run_time\" maxlength=\"2\" />";
    $forms['delay_time'] = "<input type=\"text\" size=\"5\" id=\"frm_delaypersession\" name=\"frm_delaypersession\" value=\"$delaypersession\" maxlength=\"4\" />";
    if (!$ftp_pasv){
       $forms['ftp_pasv'] = "<input type=\"checkbox\" id=\"frm_ftp_pasv\" name=\"frm_ftp_pasv\" value=\"1\" />";
    }else{
       $forms['ftp_pasv'] = "<input type=\"checkbox\" id=\"frm_ftp_pasv\" name=\"frm_ftp_pasv\" value=\"1\" checked />";
    }
    if (!$gzip){
       $forms['email']      = "<input type=\"text\" size=\"35\" id=\"frm_email\" name=\"frm_email\" value=\"$email\" readonly />";
       $forms['ftp_server'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_server\" name=\"frm_ftp_server\" value=\"$ftp_server\" readonly />";
       $forms['ftp_user']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_user\" name=\"frm_ftp_user\" value=\"$ftp_user\" readonly />";
       $forms['ftp_port']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_port\" name=\"frm_ftp_port\" value=\"$ftp_port\" readonly />";
       $forms['ftp_passwd'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_passwd\" name=\"frm_ftp_passwd\" value=\"$ftp_passwd\" readonly />";
       $forms['ftp_path']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_path\" name=\"frm_ftp_path\" value=\"$ftp_path\" readonly />";
    }else{
       $forms['email']      = "<input type=\"text\" size=\"35\" id=\"frm_email\" name=\"frm_email\" value=\"$email\" />";
       $forms['ftp_server'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_server\" name=\"frm_ftp_server\" value=\"$ftp_server\" />";
       $forms['ftp_port']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_port\" name=\"frm_ftp_port\" value=\"$ftp_port\" />";
       $forms['ftp_user']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_user\" name=\"frm_ftp_user\" value=\"$ftp_user\" />";
       $forms['ftp_passwd'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_passwd\" name=\"frm_ftp_passwd\" value=\"$ftp_passwd\" />";
       $forms['ftp_path']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_path\" name=\"frm_ftp_path\" value=\"$ftp_path\" />";
    }

    HTML_eBackup::showSetup($option, $forms);
  }

  function saveSettings($option){

    $set_config = new JConfig;
    $set_config->import();
    $msg = $set_config->save($option);
    mosRedirect("index2.php?option=$option&task=viewSetup", $msg);
  }

  function checkDatabase($option, $func){
    global $tables, $database;

    $list   = "";
    $i      = 0;
    $tables = mosGetParam($_POST, 'tables', '');
    if (is_array($tables)){
       switch ($func) {
             case 'doCheck':
                  $sql   = "CHECK TABLE ";
                  $title = "Check Results";
                  break;
             case 'doAnalyze':
                  $sql   = "ANALYZE TABLE ";
                  $title = "Analyze Results";
                  break;
             case 'doOptimize':
                  $sql   = "OPTIMIZE TABLE ";
                  $title = "Optimize Results";
                  break;
             case 'doRepair':
                  $sql   = "REPAIR TABLE ";
                  $title = "Repair Results";
                  break;
       }
       foreach ($tables as $table){
               $i++;
               if ($i != count($tables)){
                  $sql.= "`".$table."`, ";
               }else{
                  $sql.= "`".$table."`";
               }
       }
       $database->setQuery($sql);
       $result_msgs = $database->loadObjectList();
       if (is_array($result_msgs)){
          foreach ($result_msgs as $result_msg){
                  $list.= "<tr class=\"row0\">\n"
                         ."  <td align=\"left\" style=\"white-space: nowrap;\">".$result_msg->Table."</td>\n"
                         ."  <td align=\"left\" style=\"white-space: nowrap;\">".$result_msg->Op."</td>\n"
                         ."  <td align=\"left\" style=\"white-space: nowrap;\">".$result_msg->Msg_type."</td>\n"
                         ."  <td align=\"left\" style=\"white-space: nowrap;\">".$result_msg->Msg_text."</td>\n"
                         ."</tr>\n";
          }
       }else{
         $list = "<tr class=\"row0\">\n"
                ."  <td colspan=\"4\" style=\"text-align: center; white-space: nowrap;\">"._BBKP_NO_LOGS."</td>\n"
                ."</tr>\n";
       }
       HTML_eBackup::showCheckResults($list, $title);
    }
  }

  function executeBackup($option){
    global $tables, $mosConfig_absolute_path, $mosConfig_db, $database, $mosConfig_mailfrom, $mosConfig_fromname, $mosConfig_sitename;

    $set_config = new JConfig();

    if ($set_config->o_comments){
       $selections = array ('NONE', 'ANSI', 'DB2', 'MAXDB', 'MSSQL', 'MYSQL323', 'MYSQL40', 'ORACLE', 'POSTGRESQL', 'TRADITIONAL');

       $script_on = "document.adminForm.frm_email.readOnly = false;"
                   ."document.adminForm.frm_ftp_server.readOnly = false;"
                   ."document.adminForm.frm_ftp_port.readOnly = false;"
                   ."document.adminForm.frm_ftp_user.readOnly = false;"
                   ."document.adminForm.frm_ftp_passwd.readOnly = false;"
                   ."document.adminForm.frm_ftp_path.readOnly = false;";

       $script_off= "document.adminForm.frm_email.readOnly = true;"
                   ."document.adminForm.frm_ftp_server.readOnly = true;"
                   ."document.adminForm.frm_ftp_port.readOnly = true;"
                   ."document.adminForm.frm_ftp_user.readOnly = true;"
                   ."document.adminForm.frm_ftp_passwd.readOnly = true;"
                   ."document.adminForm.frm_ftp_path.readOnly = true;";

       foreach ($selections as $selection){
               $sql_comp_list[] = mosHTML::makeOption($selection , $selection);
       }
       $forms['sql_comp_list'] = mosHTML::selectList($sql_comp_list, 'sql_compat', 'class="inputbox" size="1"', 'value', 'text', $set_config->o_sql_compat);
       if ($set_config->o_ftp_port == "") $set_config->o_ftp_port = "21";
       if (!$set_config->o_structure){
          $forms['structure'] = "<input type=\"checkbox\" id=\"frm_structure\" name=\"frm_structure\" value=\"1\" />";
       }else{
          $forms['structure'] = "<input type=\"checkbox\" id=\"frm_structure\" name=\"frm_structure\" value=\"1\" checked />";
       }
       if (!$set_config->o_drop){
          $forms['drop'] = "<input type=\"checkbox\" id=\"frm_drop\" name=\"frm_drop\" value=\"1\" />";
       }else{
          $forms['drop'] = "<input type=\"checkbox\" id=\"frm_drop\" name=\"frm_drop\" value=\"1\" checked />";
       }
       if (!$set_config->o_exists){
          $forms['exists'] = "<input type=\"checkbox\" id=\"frm_exists\" name=\"frm_exists\" value=\"1\" />";
       }else{
          $forms['exists'] = "<input type=\"checkbox\" id=\"frm_exists\" name=\"frm_exists\" value=\"1\" checked />";
       }
       if (!$set_config->o_autoinc){
          $forms['autoinc'] = "<input type=\"checkbox\" id=\"frm_autoinc\" name=\"frm_autoinc\" value=\"1\" />";
       }else{
          $forms['autoinc'] = "<input type=\"checkbox\" id=\"frm_autoinc\" name=\"frm_autoinc\" value=\"1\" checked />";
       }
       if (!$set_config->o_full_inserts){
          $forms['fullinserts'] = "<input type=\"checkbox\" id=\"frm_fullinserts\" name=\"frm_fullinserts\" value=\"1\" />";
       }else{
          $forms['fullinserts'] = "<input type=\"checkbox\" id=\"frm_fullinserts\" name=\"frm_fullinserts\" value=\"1\" checked />";
       }
       if (!$set_config->o_gzip){
          $forms['gzip'] = "<input type=\"checkbox\" id=\"frm_gzip\" name=\"frm_gzip\" value=\"1\" onclick=\"javascript: if(document.adminForm.frm_gzip.checked){".$script_on."}else{".$script_off."} \" />";
       }else{
          $forms['gzip'] = "<input type=\"checkbox\" id=\"frm_gzip\" name=\"frm_gzip\" value=\"1\" onclick=\"javascript: if(document.adminForm.frm_gzip.checked){".$script_on."}else{".$script_off."} \" checked />";
       }
       if (!$set_config->o_ftp_pasv){
          $forms['ftp_pasv'] = "<input type=\"checkbox\" id=\"frm_ftp_pasv\" name=\"frm_ftp_pasv\" value=\"1\" />";
       }else{
          $forms['ftp_pasv'] = "<input type=\"checkbox\" id=\"frm_ftp_pasv\" name=\"frm_ftp_pasv\" value=\"1\" checked />";
       }
       $forms['comments'] = "<textarea name=\"frm_comments\" cols=\"35\" rows=\"8\"></textarea>";
       if (!$set_config->o_gzip){
          $forms['email']      = "<input type=\"text\" size=\"35\" id=\"frm_email\" name=\"frm_email\" value=\"$set_config->o_email\" readonly />";
          $forms['ftp_server'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_server\" name=\"frm_ftp_server\" value=\"$set_config->o_ftp_server\" readonly />";
          $forms['ftp_user']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_user\" name=\"frm_ftp_user\" value=\"$set_config->o_ftp_user\" readonly />";
          $forms['ftp_port']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_port\" name=\"frm_ftp_port\" value=\"$set_config->o_ftp_port\" readonly />";
          $forms['ftp_passwd'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_passwd\" name=\"frm_ftp_passwd\" value=\"$set_config->o_ftp_passwd\" readonly />";
          $forms['ftp_path']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_path\" name=\"frm_ftp_path\" value=\"$set_config->o_ftp_path\" readonly />";
       }else{
          $forms['email']      = "<input type=\"text\" size=\"35\" id=\"frm_email\" name=\"frm_email\" value=\"$set_config->o_email\" />";
          $forms['ftp_server'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_server\" name=\"frm_ftp_server\" value=\"$set_config->o_ftp_server\" />";
          $forms['ftp_port']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_port\" name=\"frm_ftp_port\" value=\"$set_config->o_ftp_port\" />";
          $forms['ftp_user']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_user\" name=\"frm_ftp_user\" value=\"$set_config->o_ftp_user\" />";
          $forms['ftp_passwd'] = "<input type=\"text\" size=\"35\" id=\"frm_ftp_passwd\" name=\"frm_ftp_passwd\" value=\"$set_config->o_ftp_passwd\" />";
          $forms['ftp_path']   = "<input type=\"text\" size=\"35\" id=\"frm_ftp_path\" name=\"frm_ftp_path\" value=\"$set_config->o_ftp_path\" />";
       }
       $_SESSION['tables'] = mosGetParam($_POST, 'tables', '');
       HTML_eBackup::showComment($option, $forms);
    }else{
      $_SESSION['tables'] = mosGetParam($_POST, 'tables', '');
      mosRedirect("index2.php?option=$option&task=createBackup", "");
    }
  }

  function createBackup($option){
    global $tables, $mosConfig_absolute_path, $mosConfig_db, $mosConfig_mailfrom, $mosConfig_fromname,
           $mosConfig_sitename, $database;

    $job_comment    = "";
    $tstart      = mosProfiler::getmicrotime();

    $set_config = new JConfig;
    if (mosGetParam($_POST, 'frm_comments_dlg') <> ""){
       $set_config->import();
       $job_comment = mosGetParam($_POST, 'frm_comments', '');
       $_SESSION['Settings'] = serialize($set_config);
    }else{
       if (isset($_SESSION['Settings'])) $set_config = unserialize($_SESSION['Settings']);
    }

    $SQLDump = new JFiler($set_config->o_gzip);

    if (!isset($_POST['tables'])){
       $tables = mosGetParam($_SESSION, 'tables', '');
    }else{
       $tables             = mosGetParam($_POST, 'tables', '');
       $_SESSION['tables'] = $tables;
    }

    if (!isset($_SESSION['start_time'])){
       $_SESSION['start_time'] = $tstart;
    }else{
       $tstart = $_SESSION['start_time'];
    }

    if (isset($_SESSION['table'])){
       $table = $_SESSION['table'];
       $key   = array_search($table, $tables);
    }else{
       $key = 0;
    }

    if (isset($_SESSION['rec_no'])){
       $rec_no = mosGetParam($_SESSION, 'rec_no', 0);
    }else{
       $rec_no = 0;
    }

    if (!isset($_SESSION['sql_file'])){
       $sql_time = time();
       $sql_file = $mosConfig_db."_JOBID0_".strftime("%Y%m%d_%H%M%S", $sql_time).".sql";
       $_SESSION['sql_file'] = $sql_file;
       $SQLDump->createFile($mosConfig_absolute_path."/administrator/backups/".$sql_file);
       makeHeaderTableDefJob($mosConfig_db, $sql_time, &$SQLDump, count($tables), _BBKP_MANUALLY_FILE, &$set_config, $job_comment);
    }else{
       $sql_file = mosGetParam($_SESSION, 'sql_file');
       $SQLDump->openFile($mosConfig_absolute_path."/administrator/backups/".$sql_file);
    }

    $startTime = mosProfiler::getmicrotime();
    while ($key < count($tables)){
          $checkTime = mosProfiler::getmicrotime();
          if (($checkTime - $startTime) >= $set_config->o_run_time){
             $_SESSION['table']  = $tables[$key-1];
             $_SESSION['rec_no'] = 0;
             break;
          }else{
             if (($rec_no == 0) && ($set_config->o_structure == 1)) makeTableDef($mosConfig_db, $tables[$key], &$SQLDump, &$set_config);
             if (!makeTableContent($tables[$key], &$rec_no, &$SQLDump, $startTime, &$set_config)) break;
             $key++;
          }
    }

    if ($key < count($tables)){
       HTML_eBackup::showProcess($tables[$key], $rec_no, $sql_file, $key, count($tables));
       $link = "index2.php?option=$option&task=createBackup";
       echo "<script language=\"JavaScript\" type=\"text/javascript\">window.setTimeout('location.href=\"".$link."\";',500+$set_config->o_delaypersession);</script>\n";
    }else{
       $SQLDump->closeFile();
       $bkp_filesize = mosGetSizes($SQLDump->getFileSize());
       if ($SQLDump->zipped){
          $bkp_file = $sql_file.".gz";
          $attachement = $SQLDump->filename.".gz";
       }else{
          $bkp_file = $sql_file;
          $attachement = $SQLDump->filename;
       }
       $tend        = mosProfiler::getmicrotime();
       $backup_stat = number_format(($tend - $tstart), 5, ',', '.')." "._BBKP_SECONDS;
       if (($set_config->o_email != "") && ($set_config->o_gzip)) {
          $body    = makeBody($mosConfig_db, time(), count($tables), &$set_config, $comments);
          $subject = _BBKP_SUBJECT."("._BBKP_MANUALLY_FILE." ".$mosConfig_sitename." ".$sql_file.")";
          if (!$can_send = mosMail( $mosConfig_mailfrom, $mosConfig_fromname, $set_config->o_email, $subject, $body, true, NULL, NULL, $attachement)){
             echo _BBKP_ERR_EMAIL;
          }
       }
       if (($set_config->o_ftp_server != "") && ($set_config->o_gzip)) {
          $canTrans = transferFTP($attachement, $set_config->o_ftp_server, $set_config->o_ftp_pasv, $set_config->o_ftp_port, $set_config->o_ftp_user, $set_config->o_ftp_passwd, $set_config->o_ftp_path);
          if ($canTrans <> NULL){
             echo _BBKP_ERR_FTP;
          }
       }
       unset($_SESSION['tables']);
       unset($_SESSION['table']);
       unset($_SESSION['sql_file']);
       unset($_SESSION['rec_no']);
       unset($_SESSION['start_time']);
       HTML_eBackup::showResults($bkp_filesize, $bkp_file, $backup_stat, count($tables));
    }

  }

  function executeSchedJob($job_id){
    global $database, $mosConfig_db, $mosConfig_mailfrom, $mosConfig_fromname, $mosConfig_sitename, $mosConfig_absolute_path,
           $mosConfig_cachepath;

    $tstart      = mosProfiler::getmicrotime();

    $sql = "SELECT * FROM `#__ebackup_scheduler` WHERE `id` =".$job_id;
    $database->setQuery($sql);
    $database->loadObject($job);

    $lock = lock($mosConfig_cachepath, "ebackup_job".$job->id."_", 1);
    if (!$lock){
       return;
    }
    $stats = new BackupStats();
    ebackup_log(&$stats, $job->id, 'Job "'.$job->job_name.'" '._BBKP_JOB_START);

    $set_config = new JConfig;
    $set_config->loadJobSetting($job);

    if ($job->versions > 0){
       checkVersions($job->id, $job->versions);
       if (($job->ftp_srv != "") && ($set_config->o_gzip)){
          $canCheck = checkFTPVersions($attachement, $job->ftp_srv, $job->ftp_pasv, $job->ftp_port, $job->ftp_user, $job->ftp_pw, $job->ftp_path, $job->id, $job->versions);
          if ($canCheck == NULL){
              ebackup_log(&$stats, $job->id, 'FTP Check => '._BBKP_FTP_SUCCESS);
          }else{
              ebackup_log(&$stats, $job->id, 'ERROR: FTP Check => '.$canCheck." (".$job->ftp_srv.")");
          }
       }
     }

     $SQLDump  = new JFiler($set_config->o_gzip);
     $tables   = explode(";", $job->tables);
     $sql_time = time();
     $sql_file = $mosConfig_db."_JOBID".$job->id."_".strftime("%Y%m%d_%H%M%S", $sql_time).".sql";
     $SQLDump->createFile($mosConfig_absolute_path."/administrator/backups/".$sql_file);
     makeHeaderTableDefJob($mosConfig_db, $sql_time, &$SQLDump, count($tables), $job->job_name, &$set_config, '');
     $startTime = mosProfiler::getmicrotime()+7200;
     $rec_no = 0;
     $key = 0;
     while ($key < count($tables)){
           if ($set_config->o_structure == 1) makeTableDef($mosConfig_db, $tables[$key], &$SQLDump, &$set_config);
           makeTableContent($tables[$key], &$rec_no, &$SQLDump, $startTime, &$set_config);
           $key++;
     }
     $SQLDump->closeFile();
     if ($SQLDump->zipped){
        $bkp_file = $bkp_file.".gz";
        $attachement = $SQLDump->filename.".gz";
     }else{
        $attachement = $SQLDump->filename;
     }
     $last_backup_run = strftime("%Y-%m-%d %H:%M:%S", time());
     $sql = "UPDATE `#__ebackup_scheduler` SET `last_run`= '".$last_backup_run."' WHERE `id` = ".$job->id;
     $database->setQuery($sql);
     $database->query();
     ebackup_log(&$stats, $job->id, 'SQL Dump '._BBKP_JOB_FINISH);
     if (($set_config->o_email != "") && ($set_config->o_gzip)) {
        $body     = makeBody($mosConfig_db, time(), count($tables), &$set_config, '');
        $subject  = _BBKP_SUBJECT."(".$job->job_name." ".$mosConfig_sitename." ".$sql_file.")";
        $can_send = mosMail($mosConfig_mailfrom, $mosConfig_fromname, $set_config->o_email, $subject, $body, true, NULL, NULL, $attachement);
        if (!$can_send){
           ebackup_log(&$stats, $job->id, 'ERROR: eMail Transfer => '._BBKP_JOB_TRANS_SQL.$set_config->o_email);
        }else{
           ebackup_log(&$stats, $job->id, 'eMail Transfer => '._BBKP_JOB_TRANS_SQL.$set_config->o_email);
        }
     }
     if (($job->ftp_srv != "") && ($set_config->o_gzip)){
        $canTrans = transferFTP($attachement, $job->ftp_srv, $job->ftp_pasv, $job->ftp_port, $job->ftp_user, $job->ftp_pw, $job->ftp_path);
        if($canTrans == NULL){
           ebackup_log(&$stats, $job->id, 'FTP Transfer => '._BBKP_JOB_TRANS_SQL.$job->ftp_srv);
        }else{
           ebackup_log(&$stats, $job->id, 'ERROR: FTP Transfer => '.$canTrans." (".$job->ftp_srv.")");
        }
     }
     if ($lock) unlock($mosConfig_cachepath, "ebackup_job".$job->id."_");
     ebackup_log(&$stats, $job->id, 'Job "'.$job->job_name.'" '._BBKP_JOB_FINISH);
  }

  function doRestore($option, $func){
    global $database, $mosConfig_absolute_path;

    $set_config = new JConfig;
    $startTime = mosProfiler::getmicrotime();
    if (!isset($_SESSION['start_time'])) $_SESSION['start_time'] = $startTime;

    $comments[0] = "#";
    $comments[1] = "--";
    $multiLine   = false;
    $query       = "";
    $buffer      = "";
    $linecount   = 0;
    $SQL_Lines   = 0;
    $parents     = false;
    $offset      = mosGetParam($_SESSION, 'offset', 0);
    $SQL_all     = mosGetParam($_SESSION, 'SQL_lines', 0);
    if (isset($_POST['SQLFile'])){
       $SQLFile = mosGetParam($_POST, 'SQLFile', '');
    }else{
       $SQLFile = mosGetParam($_SESSION, 'SQLFile', '');
    }

    $SQLDump = new JFiler(false);
    if ($SQLDump->open2Read($mosConfig_absolute_path."/administrator/backups/".$SQLFile)){
       $SQLDump->seekBuffer($offset);
    }else{
      mosRedirect("index2.php?option=$option", "Error opening SQL Dump file ".$SQLFile);
    }

    $offset_start = $offset;
    $checkTime    = mosProfiler::getmicrotime();
    while ((!$SQLDump->is_EOF()) && (($checkTime - $startTime) <= $set_config->o_run_time)){
          $buffer = $SQLDump->readBuffer(MAX_LINE_LENGTH);
          $buffer = trim($buffer);
          $buffer = ereg_replace("\r\n$", "\n", $buffer);
          $buffer = ereg_replace("\r$", "\n", $buffer);

          $skipline = false;
          foreach ($comments as $comment_value){
                  if (strpos($buffer, $comment_value) === 0){
                     $skipline = true;
                  }
          }
          if ((!$skipline)&&(strlen($buffer)!= 0)){
             if (!$multiLine){
                if (my_strrpos(trim($buffer), ";") == (strlen(trim($buffer))-1)){
                   $SQL_Lines++;
                   $query.= $buffer;
                   $database->setQuery($query);
                   $result = $database->query();
                   if (!$result) break;
                   $query = "";
                } else {
                   $multiLine = true;
                   $SQL_Lines++;
                   $query.= $buffer;
                }
             }else{
                if (my_strrpos(trim($buffer), ";") == (strlen(trim($buffer))-1)){
                   $multiLine = false;
                   $SQL_Lines++;
                   $query.= $buffer;
                   $database->setQuery($query);
                   $result = $database->query();
                   if (!$result) break;
                   $query = "";
                }else{
                   $query.= $buffer;
                }
             }
          }
          $linecount++;
          $checkTime = mosProfiler::getmicrotime();
    }
    $offset  = $SQLDump->getOffset();
    $SQL_all = $SQL_all + $SQL_Lines;

    if (!$SQLDump->is_EOF()){
       $_SESSION['offset']    = $offset;
       $_SESSION['SQLFile']   = $SQLFile;
       $_SESSION['SQL_lines'] = $SQL_all;
       $link                  = "index2.php?option=$option&task=doRestore";

       HTML_eBackup::showRestoreProcess($SQLFile, $offset, $SQL_all, $SQL_Lines);

       echo "<script language=\"JavaScript\" type=\"text/javascript\">window.setTimeout('location.href=\"".$link."\";',500+$set_config->o_delaypersession);</script>\n";
    }else{
       $end_time     = mosProfiler::getmicrotime();
       $restore_stat = number_format(($end_time - $_SESSION['start_time']), 5, ',', '.')." "._BBKP_SECONDS;
       HTML_eBackup::showRestoreResults($SQLFile, $restore_stat, $offset, $SQL_all);

       unset($_SESSION['offset']);
       unset($_SESSION['SQLFile']);
       unset($_SESSION['SQL_lines']);
       unset($_SESSION['start_time']);
    }
  }

?>