<?php	/* Compteur de visites par IP unique, avec fichier -- version 1.1 -- gulius44@hotmail.com*/
 function compteur_visites($fichier_compteur, $zero=0) {
 	define("REFRESH_S", 4*60*60); // Nombre de secondes o l'IP enregistre est "valide" (ici == 4 heures)
 	define("FILE", $fichier_compteur);	// Chemin du fichier du compteur
 	$file = @file_get_contents(FILE); // Retourne le contenu du fichier dans $file (comme chane de caractres)
 	
 	if (!$file) { // Si $file==FALSE, donc si le fichier FILE n'existe pas, ou que vous n'avez pas les droits en lecture sur celui-ci :
 		if (!@fopen(FILE, "w")) return -1;  /* On tente de le crer (en fait, on ouvre FILE mais comme celui-ci n'existe pas, a le crer)
 		Si vous n'avez ni les droits en lecture, ni les droits en criture sur ce fichier, ou si vous n'avez pas les droits en criture
 		sur le dossier cilbe, on retourne -1 */
 		
 		$file = "1#".$_SERVER["REMOTE_ADDR"]."@".time(); /* On crit l'IP+timestamp dans $file, qui tait alors vide, puisque le script n'a pas p lire FILE.
 		Cette entre correspond au premier visiteur enregistr (car FILE vient d'tre cr). 
 		--> Le script continue normalement! */
 	}
 	
 	$file = explode("#", $file); // On spare $file en tableau contenant : le nombre d'IPs uniques total, et les diffrents (IP+timestamp)s
 	$nbr_visites =& $file[0]; // $nbr_visites rfrence de $file[0] == 'nombre de visites' (dfini au premier lment du fichier)
 	$nbr_elem_file = count($file); /* On enregistre le nombre d'lments de $file, car ce nombre va certainement changer au cours
 	du script, et si ou utilisait directement count($file), les rsultats seraient tout simplement ronns */
 	
 	/* On parcourt le tableau du deuxime lment (d'o $i=1), jusqu'au dernier, 
 	On efface les ips enregistres depuis plus de REFRESH_S, puis on regarde si l'IP du client existe dj. */
 	for ($i=1; $i<$nbr_elem_file; $i++) {
 		$tmp = explode("@", $file[$i]); // On spare l'IP et le timestamp, de l'lment $i du tableau -> sparateur == '@'
 		/* Si l'IP est enregistre depuis plus de REFRESH_S secondes, on la supprime de $file */
 		if ( time() - $tmp[1] > REFRESH_S)
 			unset($file[$i]);

 		/* Si l'IP existe (et qu'elle a t enregistre depuis moins de REFRESH_S secondes) */
 		if ( ($tmp[0] == $_SERVER["REMOTE_ADDR"]) ) {
 			$file[$i] = $tmp[0]."@".time(); // On met  jour le timestamp associ  l'IP du client.
 			break; // On sort de la boucle, car le client ne navigue qu'avec une adresse IP, donc le reste des tests serait inutil!
 		}
 		/* Sinon, si rendu  la dernire ligne ($i == $nbr_elem_file-1), on n'a rien trouv, on ajoute l'IP du client + timestamp de son arrive ds $file */
 		else if ($i == $nbr_elem_file-1) {
 			$file[] = $_SERVER["REMOTE_ADDR"]."@".time();
 			$nbr_elem_file += 1; // On incrmente le nombre d'lments de $file de 1
 			$nbr_visites += 1; // On incrmente le nombre de visites de 1
 		}
 	}
 	
 	/* Pour finir, on efface le contenu de compteur.txt, et on le remplace par celui de $file */
 	$handle = @fopen(FILE, "w"); // On ouvre le fichier en criture (efface le contenu dj existant)
 	if (!$handle) return -1; /* Si l'ouverture du fichier provoque une erreur (probablement du fait que vous
 	n'avez pas les droits en criture sur ce fichier), la fonction renvoie -1 */
 	for ($i=0; $i<$nbr_elem_file; $i++) {
 		if (isset($file[$i])) // Si l'lment $i de $file existe (s'il n'a pas t suprim prcdement)
 			fwrite($handle, ($i?"#":NULL).$file[$i]); // On crit l'lment $file[$i] dans le fichier
 	}
 	fclose($handle); // On ferme le fichier
 		
 	/* Si $zero==1, donc si l'utilisateur veut qu'un certain nombre de 0 apparaisse avant le nombre de visites 
 		(ex: 1 234 visite(s) == 0 000 001 234 visite(s) <-- a peut faire plus zolie !!!) */
 	if ($zero) for ($i=1000000, $j=0, $zero=""; $i>$nbr_visites; $i/=10, $j+=1) { $zero .= (!($j%3)?"0 ":"0"); }
 	else unset($zero);
 	
 	return $zero.number_format($nbr_visites, 0, '', ' '); // On retourne le nombre de visites
 	
 	/* Attention: Si vous crer votre fichier texte vous mme, et que vous y crivez n'importe quoi, la valeur retourne
 	par la fonction serait probablement rrone !!! */
 }

 /* Utilisation : il vous suffit simplement d'inclure ce script dans la page voulue, puis
 d'invoquer la fonction avec au moins 1 argument (l'emplacement + le nom du fichier "compteur") 
 	-> ex: echo compteur_visites("compteur.txt")." visite(s)";
 Vous n'avez mme pas  crer le fichier compteur.txt, le script s'en charge pour vous! 

 --> Vous devez forcment avoir les droits en criture sur le dossier o le fichier texte va tre cr, et ce dossier
 doit bien videment exister. 

 --> Il est donc ais de faire un compteur de visite pour un site entier, mais aussi pour chaque page, ... */
?>
